/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.common.enums.FileGroupEnum;

public class TimeLineTemplateList
extends HRDataBaseList {
    private static final Log LOG = LogFactory.getLog(TimeLineTemplateList.class);
    protected static final String INIT_FLAG = "initflag";
    protected static final String SHOW_INFO1 = "showinfo1";
    protected static final String SHOW_INFO2 = "showinfo2";
    protected static final String SHOW_INFO3 = "showinfo3";
    protected static final String TOTAL = "total";
    protected static final String VALID = "valid";
    private static final String GRID_VIEW = "gridview";
    private static final String CARD_VIEW = "cardview";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String fromTimeline = (String)this.getView().getFormShowParameter().getCustomParam("timeline");
        String hideHelpTipsId = (String)this.getView().getFormShowParameter().getCustomParam("hideDelptips");
        String listPage = (String)this.getView().getFormShowParameter().getCustomParam("listPage");
        boolean isTimeHis = AttFileScheduleEnum.getIsTimeHisByPageId((String)listPage);
        if (HRStringUtils.isNotEmpty((String)fromTimeline)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{GRID_VIEW, "new", "edit", "baritemap", "tbexport"});
            if (!isTimeHis) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1"});
            }
            BillList billListAp = (BillList)this.getView().getControl("billlistap");
            billListAp.setMulti(false);
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.setVisible(Boolean.FALSE, new String[]{hideHelpTipsId});
                this.getView().sendFormAction(parentView);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CARD_VIEW});
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        String fromTimeline = (String)this.getView().getFormShowParameter().getCustomParam("timeline");
        if (HRStringUtils.isNotEmpty((String)fromTimeline)) {
            args.setListDataProvider((IListDataProvider)new ListDataProvider(){

                public DynamicObjectCollection getData(int start, int limit) {
                    DynamicObjectCollection rows = super.getData(start, limit);
                    for (int index = 0; index < rows.size(); ++index) {
                        int isLast = index == rows.size() - 1 ? 1 : 0;
                        ((DynamicObject)rows.get(index)).set("fseq", (Object)isLast);
                    }
                    return rows;
                }
            });
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        IDataModel model;
        super.beforePackageData(event);
        String listPage = (String)this.getView().getFormShowParameter().getCustomParam("listPage");
        if (this.getView().getParentView() != null && (model = this.getView().getParentView().getModel()).getDataEntityType().getAllFields().get(INIT_FLAG) != null) {
            int size;
            int valid;
            boolean isTimeHis = AttFileScheduleEnum.getIsTimeHisByPageId((String)listPage);
            String timeLinePageLanguageId = (String)this.getView().getFormShowParameter().getCustomParam("timelinelanguageid");
            String timeLinePageZhCn = (String)this.getView().getFormShowParameter().getCustomParam("timelinezhcn");
            Long attFileId = (Long)this.getView().getFormShowParameter().getCustomParam("attfileid");
            if (FileGroupEnum.ATT.getVersionPageId().equals(listPage) || FileGroupEnum.VA.getVersionPageId().equals(listPage)) {
                valid = this.getAttFileValidSize();
                size = this.getAttFileAllSize();
            } else {
                int[] arr = this.getAttachListSize(listPage, attFileId, isTimeHis);
                size = arr[0];
                valid = arr[1];
            }
            String showInfo = String.format(timeLinePageZhCn, size, valid);
            try {
                model.setValue(SHOW_INFO1, (Object)showInfo);
            }
            catch (Exception exception) {
                LOG.info("TimeLineTemplateList.beforePackageData error :" + exception.getMessage());
            }
        }
    }

    private int getAttFileValidSize() {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setProperties("id");
        QFilter qFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        qFilter.and(WTCHisServiceHelper.isCurrentVersion((boolean)false));
        attFileQueryParam.setqFilter(qFilter);
        Long attFileId = (Long)this.getView().getFormShowParameter().getCustomParams().get("attfileid");
        attFileQueryParam.setBoId(attFileId.longValue());
        attFileQueryParam.setAttStatus(null);
        List validList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return validList.size();
    }

    private int getAttFileAllSize() {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setProperties("id");
        HashSet stringSet = Sets.newHashSetWithExpectedSize((int)5);
        stringSet.add("0");
        stringSet.add("2");
        stringSet.add("1");
        stringSet.add("-1");
        stringSet.add("-2");
        attFileQueryParam.setqFilter(WTCHisServiceHelper.isCurrentVersion((boolean)false));
        attFileQueryParam.setHisStatus((Set)stringSet);
        Long attFileId = (Long)this.getView().getFormShowParameter().getCustomParams().get("attfileid");
        attFileQueryParam.setBoId(attFileId.longValue());
        attFileQueryParam.setAttStatus(null);
        List validList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return validList.size();
    }

    private int[] getAttachListSize(String listPage, Long attFileId, boolean isTimeHis) {
        QFilter validQFilter = new QFilter("attfileid", "=", (Object)attFileId);
        QFilter allQFilter = new QFilter("attfileid", "=", (Object)attFileId);
        List scheduleListFilter = AttFileHelper.getScheduleListFilter((boolean)false, (boolean)isTimeHis, (Object)Boolean.FALSE, null, (String)listPage, (String)this.getView().getFormShowParameter().getAppId());
        if (scheduleListFilter != null) {
            scheduleListFilter.forEach(item -> {
                validQFilter.and(item);
                allQFilter.and(item);
            });
        }
        AttFileScheduleEnum attFileScheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)listPage);
        AttFileScheduleQueryParam validAttFileScheduleQueryParam = new AttFileScheduleQueryParam();
        AttFileScheduleQueryParam allAttFileScheduleQueryParam = new AttFileScheduleQueryParam();
        validAttFileScheduleQueryParam.setFileBoIdSet(Collections.singleton(attFileId));
        validAttFileScheduleQueryParam.setqFilter(validQFilter);
        validAttFileScheduleQueryParam.setProperties("id");
        allAttFileScheduleQueryParam.setFileBoIdSet(Collections.singleton(attFileId));
        allAttFileScheduleQueryParam.setqFilter(allQFilter);
        allAttFileScheduleQueryParam.setProperties("id");
        Map validMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(attFileScheduleEnum, validAttFileScheduleQueryParam);
        if (isTimeHis) {
            HashSet histStatusSet = Sets.newHashSetWithExpectedSize((int)5);
            histStatusSet.add("0");
            histStatusSet.add("1");
            histStatusSet.add("2");
            histStatusSet.add("-1");
            histStatusSet.add("-2");
            allAttFileScheduleQueryParam.setHisStatus((Set)histStatusSet);
        } else {
            HashSet busySet = Sets.newHashSetWithExpectedSize((int)2);
            busySet.add("1");
            busySet.add("0");
            allAttFileScheduleQueryParam.setBusyStatus((Set)busySet);
        }
        Map allMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(attFileScheduleEnum, allAttFileScheduleQueryParam);
        return new int[]{allMap.get(attFileId) == null ? 0 : ((List)allMap.get(attFileId)).size(), validMap.get(attFileId) == null ? 0 : ((List)validMap.get(attFileId)).size()};
    }
}

