/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile.schedule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.container.Container;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.attfile.AttFileHelper;

public class AttFileScheduleCardEdit
extends HRDynamicFormBasePlugin {
    private static final String NONDATAFLEXAP = "nondataflexap";
    private static final String DATAFLEXAP = "dataflexap";
    private static final String TITLE = "title";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String titleName = (String)this.getView().getFormShowParameter().getCustomParam("name");
        this.getModel().setValue(TITLE, (Object)titleName);
        DynamicObject[] dys = this.queryAttFileScheduleData();
        if (this.setVisibleByDysLength(dys)) {
            return;
        }
        this.fillData(dys);
    }

    private void fillData(DynamicObject[] dys) {
        String currenRelatePage = (String)this.getView().getFormShowParameter().getCustomParam("currentRelatePage");
        ArrayList<Map<String, Object>> flexList = new ArrayList<Map<String, Object>>(dys.length);
        for (int i = 0; i < dys.length; ++i) {
            DynamicObject dy = dys[i];
            String name = dy.getString("name");
            if (AttFileScheduleEnum.MODE.getPageId().equals(currenRelatePage)) {
                List comboItems = ((ComboProp)MetadataServiceHelper.getDataEntityType((String)currenRelatePage).getProperties().get((Object)AttFileScheduleEnum.MODE.getKey())).getComboItems();
                String finalName = name;
                Optional<ValueMapItem> first = comboItems.stream().filter(comboItem -> finalName.equals(String.valueOf(comboItem.getValue()))).findFirst();
                name = first.isPresent() ? String.valueOf(first.get().getName()) : name;
            }
            String startDate = HRDateTimeUtils.format((Date)dy.getDate("startdate"), (String)"yyyy-MM-dd");
            String endDate = HRDateTimeUtils.format((Date)dy.getDate("enddate"), (String)"yyyy-MM-dd");
            String dateScope = WTCStringUtils.joinStr((String[])new String[]{startDate, "~", endDate});
            this.createFlexAp(flexList, name, dateScope, i + 1);
        }
        Container mainFlexAp = (Container)this.getView().getControl("mainflexap");
        mainFlexAp.addControls(flexList);
    }

    private boolean setVisibleByDysLength(DynamicObject[] dys) {
        if (dys == null || dys.length == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{NONDATAFLEXAP});
            this.getView().setVisible(Boolean.FALSE, new String[]{DATAFLEXAP});
            return true;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{DATAFLEXAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{NONDATAFLEXAP});
        return false;
    }

    private DynamicObject[] queryAttFileScheduleData() {
        QFilter[] authQFilters;
        Object attFileBoid = this.getView().getFormShowParameter().getCustomParam("boid");
        String pageId = (String)this.getView().getFormShowParameter().getCustomParam("currentRelatePage");
        String queryFiled = this.getQueryField(pageId);
        QFilter qFilter = this.getQFilter(attFileBoid, pageId);
        for (QFilter authQFilter : authQFilters = AttFileHelper.getAuthQFilter((String)pageId)) {
            qFilter.and(authQFilter);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(pageId);
        String startDateStr = AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId);
        startDateStr = startDateStr + " desc,modifytime desc";
        AttFileScheduleQueryParam queryParam = new AttFileScheduleQueryParam();
        queryParam.setLoad(Boolean.valueOf(true));
        queryParam.setFileBoIdSet(Collections.singleton((Long)attFileBoid));
        queryParam.setqFilter(qFilter);
        AttFileScheduleServiceImpl.getInstance().queryAttFileScheduleByList(AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)pageId), queryParam);
        return helper.queryOriginalArray(queryFiled, new QFilter[]{qFilter}, startDateStr);
    }

    private QFilter getQFilter(Object attFileBoid, String pageId) {
        boolean isTimeHis = AttFileScheduleEnum.getIsTimeHisByPageId((String)pageId);
        QFilter qFilter = new QFilter("attfileid", "=", attFileBoid);
        List scheduleCommonQFilter = AttFileHelper.getScheduleCommonQFilter((boolean)isTimeHis, (Object)Boolean.FALSE, (Object)"details", (String)pageId, (String)this.getView().getFormShowParameter().getAppId());
        for (QFilter qFilter1 : scheduleCommonQFilter) {
            qFilter.and(qFilter1);
        }
        return qFilter;
    }

    private String getQueryField(String pageId) {
        String startDateStr = WTCStringUtils.joinStr((String[])new String[]{AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId), " ", "startdate"});
        String endDateStr = WTCStringUtils.joinStr((String[])new String[]{AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)pageId), " ", "enddate"});
        String key = AttFileScheduleEnum.getScheduleKeyByPageId((String)pageId);
        String nameStr = "mode".equals(key) || "card".equals(key) ? WTCStringUtils.joinStr((String[])new String[]{key, " ", "name"}) : WTCStringUtils.joinStr((String[])new String[]{AttFileScheduleEnum.getScheduleKeyByPageId((String)pageId), ".", "name", " ", "name"});
        return WTCStringUtils.joinStr((String[])new String[]{nameStr, ",", startDateStr, ",", endDateStr});
    }

    private void createFlexAp(List<Map<String, Object>> flexList, String name, String dateScope, int i) {
        FlexPanelAp flexPanelAp = this.createFlexPanelAp(i);
        LabelAp cardNameLabelAp = this.createLabelAp(name, "cardname" + i, "40.9%", this.getStyle("16.4px", "27px"));
        flexPanelAp.getItems().add(cardNameLabelAp);
        LabelAp dateScopeLabelAp = this.createLabelAp(dateScope, "carddatescope" + i, "", this.getStyle("", "16.4px"));
        flexPanelAp.getItems().add(dateScopeLabelAp);
        flexList.add(flexPanelAp.createControl());
    }

    private LabelAp createLabelAp(String name, String key, String width, Style style) {
        LabelAp labelAp = new LabelAp();
        labelAp.setLineHeight("18px");
        labelAp.setStyle(style);
        if (HRStringUtils.isNotEmpty((String)width)) {
            labelAp.setWidth(new LocaleString(width));
        }
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(name));
        return labelAp;
    }

    private Style getStyle(String left, String right) {
        Style style = new Style();
        Margin margin = new Margin();
        if (HRStringUtils.isNotEmpty((String)left)) {
            margin.setLeft(left);
        }
        if (HRStringUtils.isNotEmpty((String)right)) {
            margin.setRight(right);
        }
        style.setMargin(margin);
        return style;
    }

    private FlexPanelAp createFlexPanelAp(int num) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("cardcontentflex" + num);
        flexPanelAp.setDirection("row");
        flexPanelAp.setAlignItems("center");
        flexPanelAp.setJustifyContent("space-between");
        flexPanelAp.setHeight(new LocaleString("24px"));
        flexPanelAp.setShrink(0);
        return flexPanelAp;
    }
}

