/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile.schedule;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.PersonHasBillVo;
import kd.wtc.wtbs.business.relate.WTCLeftRelateService;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileBusiness;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.AttOperEnum;
import kd.wtc.wtbs.common.enums.file.FileTypeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.formplugin.util.WTCBillViewUtils;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleCheckHelper;
import kd.wtc.wtp.business.attfile.schedule.AttFileSchedulePageService;
import kd.wtc.wtp.common.constants.AttFileConstants;
import kd.wtc.wtp.common.enums.FileGroupEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class AttFileScheduleEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static Log LOGGER = LogFactory.getLog(AttFileScheduleEdit.class);
    private static final Set<String> IGNOREPAGEIDLIST = Sets.newHashSet((Object[])new String[]{AttFileScheduleEnum.CARD.getPageId(), AttFileScheduleEnum.MODE.getPageId(), AttFileScheduleEnum.TZ.getPageId(), AttFileScheduleEnum.CARD.getPageId() + "_dg", AttFileScheduleEnum.MODE.getPageId() + "_dg", AttFileScheduleEnum.TZ.getPageId() + "_dg"});
    private static final Map<OperationStatus, String> OP_PERSION_MAP = new HashMap<OperationStatus, String>(){
        {
            this.put(OperationStatus.ADDNEW, "15");
            this.put(OperationStatus.EDIT, "16");
        }
    };

    public void preOpenForm(PreOpenFormEventArgs evt) {
        Long pkId;
        super.preOpenForm(evt);
        Map customParams = ((BillShowParameter)evt.getSource()).getCustomParams();
        String operation = (String)customParams.get("operation");
        if (("editrule".equals(operation) || "edit".equals(operation)) && (pkId = (Long)customParams.get("rowid")) != null) {
            StringBuilder errMsg = new StringBuilder();
            String formId = ((BillShowParameter)evt.getSource()).getFormId();
            boolean require = WTCBillViewUtils.requireMutex((String)String.valueOf(pkId), (String)formId, (String)operation, (StringBuilder)errMsg);
            if (!require) {
                String opMsg = ResManager.loadKDString((String)"\u7f16\u8f91", (String)"AttFileBaseModifyEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
                evt.setCancel(true);
                evt.setCancelMessage(errMsg.toString().replace("edit", opMsg));
            }
        }
    }

    public void pageRelease(EventObject evt) {
        Object pkId;
        super.pageRelease(evt);
        String operation = (String)this.getView().getFormShowParameter().getCustomParam("operation");
        if (("editrule".equals(operation) || "edit".equals(operation)) && (pkId = this.getView().getFormShowParameter().getCustomParam("rowid")) != null) {
            String formId = this.getView().getFormShowParameter().getFormId();
            DataMutex.create().release(String.valueOf(pkId), formId, operation);
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        String formId = this.getView().getFormShowParameter().getFormId();
        BasedataEdit attFile = (BasedataEdit)this.getControl("attfileid");
        attFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        attFile.addBeforeF7ViewDetailListener(this::showDetailAttFile);
        attFile.addAfterF7SelectListener((AfterF7SelectListener)this);
        if (IGNOREPAGEIDLIST.contains(formId)) {
            return;
        }
        String key = AttFileScheduleEnum.getScheduleKeyByPageId((String)this.getView().getFormShowParameter().getFormId());
        if (HRStringUtils.isNotEmpty((String)key)) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs args) {
        Map sourceData = args.getSourceData();
        String attFileNumber = ((JSONObject)sourceData).getJSONObject("attfileid").getString("number");
        DynamicObject attFileBo = this.getAttFileBo(attFileNumber);
        if (attFileBo != null) {
            this.getView().getFormShowParameter().setCustomParam("isAddNew", (Object)"true");
            this.getModel().setValue("org", (Object)attFileBo.getLong("org"));
        }
    }

    private DynamicObject getAttFileBo(String attFileNumber) {
        AttFileQueryParam param = new AttFileQueryParam();
        param.setSetFileNumber((Set)Sets.newHashSet((Object[])new String[]{attFileNumber}));
        param.setAttStatus(null);
        param.setBeCurrent(Boolean.TRUE);
        param.setProperties("id,number,org,name,startdate,bsled");
        List dynamicObjectList = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectList)) {
            return (DynamicObject)dynamicObjectList.get(0);
        }
        return null;
    }

    private void showDetailAttFile(BeforeF7ViewDetailEvent beforeF7ViewDetailEvent) {
        BasedataEdit source = (BasedataEdit)beforeF7ViewDetailEvent.getSource();
        if ("attfileid".equals(source.getFieldKey())) {
            beforeF7ViewDetailEvent.setCancel(true);
            AttFileBusiness.showAttFileDetailForm((IFormView)this.getView(), (IFormPlugin)this, null, (Object)beforeF7ViewDetailEvent.getPkId());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData[] changeSet;
        String name = args.getProperty().getName();
        String formId = ((FormView)this.getView()).getFormId();
        if (StringUtils.equals((CharSequence)"attfileid", (CharSequence)name) && (changeSet = args.getChangeSet()) != null && changeSet.length > 0) {
            DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
            if (newValue != null && AttFileConstants.TIME_HIS_PAGE_SET.contains(formId)) {
                this.setStartEndDate(formId, newValue.getLong("id"));
            }
            if (newValue != null) {
                this.getModel().setValue("org", newValue.get("org"));
            }
        }
        if (StringUtils.equals((CharSequence)"card", (CharSequence)name)) {
            HashMap paramCard = Maps.newHashMapWithExpectedSize((int)1);
            HashMap cardMustInput = Maps.newHashMapWithExpectedSize((int)1);
            String cardStr = this.getModel().getDataEntity().getString("card");
            if (HRStringUtils.isNotEmpty((String)cardStr)) {
                paramCard.put(cardStr, this.getModel().getDataEntity().getLong("attfileid.id"));
                cardMustInput.put(cardStr, Boolean.TRUE);
                String cardMsg = AttFileHelper.checkCardPage(null, (Map)paramCard, (Map)cardMustInput, (this.getModel().getDataEntity().getLong("id") == 0L ? 1 : 0) != 0);
                if (HRStringUtils.isNotEmpty((String)cardMsg)) {
                    this.getView().showErrorNotification(cardMsg);
                }
            }
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObject fileDy = this.getAttFileDy();
        if (fileDy != null) {
            this.getModel().setValue("org", fileDy.get("org"));
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String formId = this.getView().getFormShowParameter().getFormId();
        if (AttFileConstants.GROUP_PAGE_SET.contains(formId)) {
            if (OperationStatus.EDIT.equals((Object)status)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"attfileid"});
                this.reSetAttFileId();
            } else if (OperationStatus.ADDNEW.equals((Object)status)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bsed", "bsled"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attfileid"});
            this.reSetAttFileId();
        }
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("isHavePlan"))) {
            this.firstAddBaseSch();
            this.getModel().setDataChanged(false);
        }
    }

    private void firstAddBaseSch() {
        Long attFileBoid = (Long)this.getView().getFormShowParameter().getCustomParam("attfileid");
        DynamicObject attFileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFile("startdate", (Object)attFileBoid);
        Date startDate = attFileDy.getDate("startdate");
        this.getModel().setValue("bsed", (Object)startDate);
        this.getModel().setValue("bsled", (Object)WTCHisServiceHelper.getMaxEndDate());
        this.getView().setEnable(Boolean.FALSE, new String[]{"bsed", "bsled"});
    }

    private void reSetAttFileId() {
        DynamicObject attFileDy = AttFileSchedulePageService.queryAttFileDyByBoid((Long)((Long)this.getView().getFormShowParameter().getCustomParam("attfileid")));
        this.getModel().getDataEntity().set("attfileid", (Object)attFileDy);
        this.resetData();
        this.clearDataByAdd();
        this.getModel().setDataChanged(false);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Arrays.asList("save", "saverule").contains(actionId) && "Yes".equals(returnData = closedCallBackEvent.getReturnData())) {
            this.getView().getFormShowParameter().setCustomParam("confirmresult", (Object)"confirmresult");
            this.getView().invokeOperation(actionId);
        }
    }

    private void setStartEndDate(String formId, long attFileBoId) {
        DynamicObject attFileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFile("startdate,enddate,bsled", (Object)attFileBoId);
        Date startDate = attFileDy.getDate("startdate");
        this.getModel().setValue(AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)formId), (Object)startDate);
        this.getModel().setValue(AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)formId), (Object)WTCHisServiceHelper.getMaxEndDate());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Object confirmResult = this.getView().getFormShowParameter().getCustomParam("confirmresult");
        boolean isSaveOp = Arrays.asList("save", "saverule").contains(operateKey);
        boolean isEditOP = Arrays.asList("edit", "editrule").contains(operateKey);
        Long attFileId = this.getModel().getDataEntity().getLong("attfileid.id");
        boolean isPlanSave = Arrays.asList("saverule", "editrule").contains(operateKey);
        String formId = ((FormView)this.getView()).getFormId();
        if (this.checkPerm(args, status, isSaveOp, isEditOP, formId, isPlanSave, attFileId)) {
            return;
        }
        if (this.checkCard(args, isSaveOp)) {
            return;
        }
        DynamicObject fileDy = this.getAttFileDy();
        if (isSaveOp && !"confirmresult".equals(confirmResult) && AttFileConstants.TIME_HIS_PAGE_SET.contains(formId) && OperationStatus.ADDNEW.equals((Object)status)) {
            operate.getOption().setVariableValue("need_check_exist", "need_check_exist");
        }
        if ("save".equals(operateKey)) {
            this.setOptionVariable(operate, true);
        } else if ("saverule".equals(operateKey)) {
            this.setOptionVariable(operate, false);
            operate.getOption().setVariableValue("is_bill_save", "is_bill_save_value");
        }
        this.setEndDate(operateKey);
        if (isSaveOp) {
            long orgId = fileDy.getLong("org.id");
            LOGGER.info("AttFileSchedule OrgId {}", (Object)orgId);
            this.getModel().setValue("org", (Object)orgId);
            this.getView().getFormShowParameter().setCustomParam("confirmresult", null);
            if (!AttFileScheduleEnum.getIsTimeHisByPageId((String)formId)) {
                RefObject afterConfirm = new RefObject();
                if (!operate.getOption().tryGetVariableValue("changeWithNotSequenceAndHaveBusinessData", afterConfirm)) {
                    List<Tuple<Date, Date>> haveNonSequenceAndHaveBusinessDataList;
                    Map<Long, List<Tuple<Date, Date>>> haveNonSequenceAndHaveBusinessDataMap;
                    DynamicObject dy = this.getModel().getDataEntity();
                    Long boId = dy.getLong("boid");
                    Map scheduleBoIdHaveNonSequenceDateMap = AttFileScheduleCheckHelper.getInstance().checkFileScheduleInterruptDate(Collections.singletonList(dy), false);
                    HashMap scheduleBoIdPersonIdMap = Maps.newHashMapWithExpectedSize((int)1);
                    scheduleBoIdPersonIdMap.put(boId, fileDy.getLong("person.id"));
                    if (WTCCollections.isNotEmpty((Collection)((Collection)scheduleBoIdHaveNonSequenceDateMap.get(boId))) && WTCCollections.isNotEmpty(haveNonSequenceAndHaveBusinessDataMap = this.callBusinessInterface(scheduleBoIdHaveNonSequenceDateMap, scheduleBoIdPersonIdMap, Objects.requireNonNull(AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)formId)))) && WTCCollections.isNotEmpty(haveNonSequenceAndHaveBusinessDataList = haveNonSequenceAndHaveBusinessDataMap.get(fileDy.getLong("person.id")))) {
                        this.changeIfExistNonSequenceAndHaveBusinessDataTips(this.getView().getFormShowParameter().getFormId(), args, fileDy, haveNonSequenceAndHaveBusinessDataList);
                    }
                }
            }
        }
    }

    private Map<Long, List<Tuple<Date, Date>>> callBusinessInterface(Map<Long, List<Tuple<Date, Date>>> scheduleBoIdHaveNonSequenceDateMap, Map<Long, Long> scheduleBoIdPersonIdMap, AttFileScheduleEnum attFileScheduleEnum) {
        HashMap businessIdPersonIdMap = Maps.newHashMapWithExpectedSize((int)scheduleBoIdHaveNonSequenceDateMap.size());
        HashMap nonSequenceDateHaveBusinessDataMap = Maps.newHashMapWithExpectedSize((int)scheduleBoIdHaveNonSequenceDateMap.size());
        Map<Long, Boolean> resBooleanMap = null;
        ArrayList personHasBillVoList = Lists.newArrayListWithExpectedSize((int)scheduleBoIdHaveNonSequenceDateMap.size());
        this.initPersonHasBillVoList(scheduleBoIdHaveNonSequenceDateMap, scheduleBoIdPersonIdMap, personHasBillVoList, businessIdPersonIdMap);
        switch (attFileScheduleEnum) {
            case VP: {
                resBooleanMap = this.invokeIfHaveBusinessData(personHasBillVoList, "wtabm", "IVaApplyBillService", "personHasVaBill");
                break;
            }
            case QT: {
                resBooleanMap = this.invokeIfHaveBusinessData(personHasBillVoList, "wtabm", "IVaApplyBillService", "personHasVaBill");
                resBooleanMap.putAll(this.invokeIfHaveBusinessData(personHasBillVoList, "wtom", "IOverTimeApplyBillService", "personHasOtBill"));
                break;
            }
            case TP: {
                resBooleanMap = this.invokeIfHaveBusinessData(personHasBillVoList, "wtam", "IBusitripBillService", "personHasBtBill");
                break;
            }
            case OTP: {
                resBooleanMap = this.invokeIfHaveBusinessData(personHasBillVoList, "wtom", "IOverTimeApplyBillService", "personHasOtBill");
                break;
            }
            case EX: {
                resBooleanMap = this.invokeIfHaveBusinessData(personHasBillVoList, "wtabm", "IVaApplyBillService", "personHasVaBill");
                resBooleanMap.putAll(this.invokeIfHaveBusinessData(personHasBillVoList, "wtam", "IBusitripBillService", "personHasBtBill"));
                resBooleanMap.putAll(this.invokeIfHaveBusinessData(personHasBillVoList, "wtpm", "ISupSignService", "personHasSupBill"));
                break;
            }
            case AD: {
                resBooleanMap = this.invokeIfHaveBusinessData(personHasBillVoList, "wtpm", "ISupSignService", "personHasSupBill");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)personHasBillVoList) && !CollectionUtils.isEmpty(resBooleanMap)) {
            Map<Long, Boolean> finalResBooleanMap = resBooleanMap;
            personHasBillVoList.forEach(personHasBillVo -> {
                if (finalResBooleanMap.get(personHasBillVo.getId()) != null) {
                    List tuplesList = (List)nonSequenceDateHaveBusinessDataMap.get(personHasBillVo.getAttPersonId());
                    if (tuplesList == null) {
                        tuplesList = Lists.newArrayListWithExpectedSize((int)2);
                        Tuple tuple = new Tuple((Object)personHasBillVo.getStartDate(), (Object)personHasBillVo.getEndDate());
                        tuplesList.add(tuple);
                        nonSequenceDateHaveBusinessDataMap.put(personHasBillVo.getAttPersonId(), tuplesList);
                    } else {
                        Tuple tuple = new Tuple((Object)personHasBillVo.getStartDate(), (Object)personHasBillVo.getEndDate());
                        tuplesList.add(tuple);
                    }
                }
            });
        }
        return nonSequenceDateHaveBusinessDataMap;
    }

    private void initPersonHasBillVoList(Map<Long, List<Tuple<Date, Date>>> scheduleBoIdHaveNonSequenceDateMap, Map<Long, Long> scheduleBoIdPersonIdMap, List<PersonHasBillVo> personHasBillVoList, Map<Long, Long> businessIdPersonIdMap) {
        scheduleBoIdHaveNonSequenceDateMap.forEach((boId, nonSequenceDateList) -> {
            Long personId = (Long)scheduleBoIdPersonIdMap.get(boId);
            for (Tuple dateDateTuple : nonSequenceDateList) {
                PersonHasBillVo personHasBillVo = new PersonHasBillVo();
                personHasBillVo.setId(ID.genLongId());
                personHasBillVo.setAttPersonId(personId.longValue());
                personHasBillVo.setStartDate((Date)dateDateTuple.item1);
                personHasBillVo.setEndDate((Date)dateDateTuple.item2);
                businessIdPersonIdMap.put(personHasBillVo.getId(), personId);
                personHasBillVoList.add(personHasBillVo);
            }
        });
    }

    private Map<Long, Boolean> invokeIfHaveBusinessData(List<PersonHasBillVo> personHasBillVoList, String appId, String serviceName, String methodName) {
        return this.invokeWtcBizService(appId, serviceName, methodName, personHasBillVoList);
    }

    private Map<Long, Boolean> invokeWtcBizService(String appId, String serviceName, String methodName, List<PersonHasBillVo> personHasBillVoList) {
        return (Map)WTCServiceHelper.invokeWtcBizService((String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{personHasBillVoList});
    }

    private void changeIfExistNonSequenceAndHaveBusinessDataTips(String pageId, BeforeDoOperationEventArgs args, DynamicObject attFile, List<Tuple<Date, Date>> nonSequenceDateRangeList) {
        String date2;
        String date1;
        args.setCancel(true);
        String personName = attFile.getString("person.name");
        String number = attFile.getString("person.number");
        String date3 = null;
        String date4 = null;
        if (nonSequenceDateRangeList.size() > 1) {
            date1 = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((Date)nonSequenceDateRangeList.get((int)0).item1));
            date2 = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((Date)nonSequenceDateRangeList.get((int)0).item2));
            date3 = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((Date)nonSequenceDateRangeList.get((int)1).item1));
            date4 = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((Date)nonSequenceDateRangeList.get((int)1).item2));
        } else {
            date1 = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((Date)nonSequenceDateRangeList.get((int)0).item1));
            date2 = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((Date)nonSequenceDateRangeList.get((int)0).item2));
        }
        String scheduleName = Objects.requireNonNull(AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)pageId)).getScheduleName();
        String scheduleShortName = scheduleName.substring(0, scheduleName.length() - 2);
        String msg = AttFileScheduleEnum.EX.getPageId().equals(pageId) ? (nonSequenceDateRangeList.size() > 1 ? AttFileKDString.getExNonSequenceDateTips((Object[])new Object[]{personName, number, date1, date2, date3, date4}) : AttFileKDString.getExNonSequenceDateTips2((Object[])new Object[]{personName, number, date1, date2})) : (AttFileScheduleEnum.QT.getPageId().equals(pageId) ? (nonSequenceDateRangeList.size() > 1 ? AttFileKDString.getQtNonSequenceDateTips((Object[])new Object[]{personName, number, date1, date2, date3, date4}) : AttFileKDString.getQtNonSequenceDateTips2((Object[])new Object[]{personName, number, date1, date2})) : (nonSequenceDateRangeList.size() > 1 ? AttFileKDString.getOtpNonSequenceDateTips((Object[])new Object[]{personName, number, date1, date2, date3, date4, scheduleShortName, scheduleName, scheduleShortName}) : AttFileKDString.getOtpNonSequenceDateTips2((Object[])new Object[]{personName, number, date1, date2, scheduleShortName, scheduleName, scheduleShortName})));
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("changeWithNotSequenceAndHaveBusinessData", (IFormPlugin)this);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        WTCPageCache cache = new WTCPageCache(this.getView());
        cache.put("changeWithNotSequenceAndHaveBusinessDataOp", (Object)operateKey);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        int result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("changeWithNotSequenceAndHaveBusinessData".equals(callBackId) && (result = event.getResult().getValue()) == MessageBoxResult.Yes.getValue()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("changeWithNotSequenceAndHaveBusinessData", "true");
            WTCPageCache cache = new WTCPageCache(this.getView());
            this.getView().invokeOperation((String)cache.get("changeWithNotSequenceAndHaveBusinessDataOp", String.class), operateOption);
        }
    }

    private boolean checkPerm(BeforeDoOperationEventArgs args, OperationStatus status, boolean isSaveOp, boolean isEditOP, String formId, boolean isPlanSave, Object attFileId) {
        if (isSaveOp || isEditOP) {
            String permItemId = isSaveOp ? AttOperEnum.ATT_SCHEDULE_ADD.permItemId : "4715a0df000000ac";
            AttOperEnum attOperEnumByCode = AttOperEnum.getAttOperEnumByCode((String)OP_PERSION_MAP.get(status));
            AttFileScheduleEnum attFileScheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)formId);
            FileGroupEnum fileGroupEnum = FileGroupEnum.getEnumByAppId((String)this.getView().getFormShowParameter().getAppId());
            boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)fileGroupEnum.getAppId(), (String)formId, (String)permItemId);
            if (!hasPerm) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%3$s-%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttFileScheduleEdit_6", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), attFileScheduleEnum.getScheduleName(), attOperEnumByCode.getDescription(), fileGroupEnum.getDescription()));
                args.setCancel(true);
                return true;
            }
        }
        return false;
    }

    private boolean checkCard(BeforeDoOperationEventArgs args, boolean isSaveOp) {
        String name;
        if (isSaveOp && HRStringUtils.isNotEmpty((String)(name = this.getModel().getDataEntity().getDataEntityType().getName())) && name.startsWith(AttFileScheduleEnum.CARD.getPageId())) {
            HashMap paramCard = Maps.newHashMapWithExpectedSize((int)1);
            HashMap cardMustInput = Maps.newHashMapWithExpectedSize((int)1);
            String cardStr = this.getModel().getDataEntity().getString("card");
            if (HRStringUtils.isNotEmpty((String)cardStr)) {
                paramCard.put(cardStr, this.getModel().getDataEntity().getLong("attfileid.id"));
                cardMustInput.put(cardStr, Boolean.TRUE);
                String cardMsg = AttFileHelper.checkCardPage(null, (Map)paramCard, (Map)cardMustInput, (this.getModel().getDataEntity().getLong("id") == 0L ? 1 : 0) != 0);
                if (HRStringUtils.isNotEmpty((String)cardMsg)) {
                    this.getView().showErrorNotification(cardMsg);
                    args.setCancel(true);
                    return true;
                }
            }
        }
        return false;
    }

    private DynamicObject getAttFileDy() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attfilebase");
        Object attFileBoId = this.getView().getFormShowParameter().getCustomParam("attfileid");
        if (attFileBoId == null) {
            attFileBoId = this.getView().getModel().getDataEntity().getLong("attfileid.id");
        }
        QFilter qFilter = new QFilter("id", "=", attFileBoId);
        return helper.loadDynamicObject(qFilter);
    }

    public void setEndDate(String operateKey) {
        if (Arrays.asList("save", "saverule").contains(operateKey)) {
            String formId = this.getView().getFormShowParameter().getFormId();
            String dateStr = AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)formId);
            Date bsled = (Date)this.getModel().getValue(dateStr);
            if (bsled == null) {
                this.getModel().setValue(dateStr, (Object)"2999-12-31");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) || "saverule".equals(operateKey)) {
            String errMsg;
            AbstractOperate source;
            IFormView parentView = this.getView().getParentView();
            if (null != parentView) {
                parentView.setReturnData((Object)"op_save_success_flg");
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
            }
            if (null != (source = (AbstractOperate)args.getSource()) && null != source.getOption() && HRStringUtils.isNotEmpty((String)(errMsg = (String)source.getOption().getVariables().get("errMsg"))) && null != parentView) {
                parentView.showTipNotification(errMsg);
                this.getView().sendFormAction(parentView);
            }
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        String formId = this.getView().getFormShowParameter().getFormId();
        String scheduleKey = AttFileScheduleEnum.getScheduleKeyByPageId((String)formId);
        if (scheduleKey.equals(name)) {
            this.setF7OrgFilter(event);
        } else if ("attfileid".equals(name)) {
            this.setFileTypeFilter(event);
        }
    }

    private void setFileTypeFilter(BeforeF7SelectEvent event) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("wtabm".equals(appId)) {
            QFilter qFilter = new QFilter("type", "=", (Object)FileTypeEnum.VCFILE.getFileType());
            event.addCustomQFilter(qFilter);
        } else if ("wtam".equals(appId)) {
            event.getFormShowParameter().setCustomParam("orgEntityId", (Object)"wtp_attfilebase");
            event.getFormShowParameter().setCustomParam("orgField", (Object)"affiliateadminorg");
            QFilter qFilter = new QFilter("type", "=", (Object)FileTypeEnum.ALLFILE.getFileType());
            QFilter dataRule = HRCSMServiceImpl.getInstance().getDataRule(Long.valueOf(RequestContext.get().getCurrUserId()), "wtam", "wtp_attfilebase", "47150e89000000ac", new HashMap());
            if (dataRule != null) {
                qFilter.and(dataRule);
            }
            event.addCustomQFilter(qFilter);
        }
    }

    private void setF7OrgFilter(BeforeF7SelectEvent event) {
        Object attFileBoid = this.getView().getFormShowParameter().getCustomParam("attfileid");
        if (!HRObjectUtils.isEmpty((Object)attFileBoid)) {
            AttFileQueryServiceImpl instance = AttFileQueryServiceImpl.getInstance();
            DynamicObject dy = instance.queryOneAttFile("org.id", attFileBoid);
            if (dy != null) {
                ((ListShowParameter)event.getFormShowParameter()).setUseOrgId(dy.getLong("org.id"));
            }
        } else if (WTCLeftRelateService.isShowTopCommonSearch((IFormView)this.getView()) && attFileBoid == null) {
            DynamicObject attFileIdDy = this.getView().getModel().getDataEntity().getDynamicObject("attfileid");
            if (attFileIdDy == null) {
                String formId = (String)this.getView().getParentView().getFormShowParameter().getCustomParams().get("formId");
                if (FileGroupEnum.VA.getPageId().equals(formId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6863\u6848\u201d\u3002", (String)"AttFileScheduleEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                } else if (FileGroupEnum.ATT.getPageId().equals(formId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6863\u6848\u201d\u3002", (String)"AttFileScheduleEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                }
                event.setCancel(true);
                return;
            }
            ((ListShowParameter)event.getFormShowParameter()).setUseOrgId(attFileIdDy.getLong("org.id"));
        }
    }

    private void resetData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!customParams.containsKey("rowid")) {
            return;
        }
        Object rowId = customParams.get("rowid");
        String formId = this.getView().getFormShowParameter().getFormId();
        String key = AttFileScheduleEnum.getScheduleKeyByPageId((String)formId);
        boolean isTimeHis = AttFileScheduleEnum.getIsTimeHisByPageId((String)formId);
        if (isTimeHis) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(formId);
            DynamicObject queryDy = helper.loadSingle(rowId);
            if (queryDy == null) {
                return;
            }
            this.getModel().setValue(key, queryDy.get(key));
            for (String name : AttFileConstants.STR_ARRAY_TIMEHIS_QUERYFIELD) {
                this.getModel().setValue(name, queryDy.get(name));
            }
        }
    }

    private void clearDataByAdd() {
        if (!OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            return;
        }
        String pageId = this.getView().getFormShowParameter().getFormId();
        if (!pageId.endsWith("time")) {
            String key = AttFileScheduleEnum.getScheduleKeyByPageId((String)pageId);
            String startDateStr = AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId);
            String endDateStr = AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)pageId);
            this.getModel().setValue(key, null);
            this.getModel().setValue(startDateStr, null);
            this.getModel().setValue(endDateStr, null);
            this.getModel().setValue("description", null);
        }
    }

    private void setOptionVariable(FormOperate operate, boolean isBase) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        operate.getOption().setVariableValue("isAddNew", (String)parameter.getCustomParam("isAddNew"));
        if (isBase) {
            operate.getOption().setVariableValue("isBaseSche", (String)parameter.getCustomParam("isBaseSche"));
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        DynamicObject fileDy = this.getModel().getDataEntity().getDynamicObject("attfileid");
        if (fileDy != null) {
            String formId = ((FormView)this.getView()).getFormId();
            long fileBoId = fileDy.getLong("boid");
            if (AttFileConstants.TIME_HIS_PAGE_SET.contains(formId)) {
                this.setStartEndDate(formId, fileBoId);
            }
            this.getModel().setValue("attfileid", (Object)fileBoId);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDataEntityType().getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get(i);
            String name = iDataEntityProperty.getName();
            if (!HRStringUtils.isNotEmpty((String)name) || !name.equals("attfilevid_id")) continue;
            dataEntityState.setBizChanged(i, false);
        }
    }
}

