/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile.schedule;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.impt.common.plugin.AfterInitContextArgs;
import kd.hr.impt.common.plugin.AfterLoadEntityEventArgs;
import kd.hr.impt.common.plugin.AfterLoadStartPageEventArgs;
import kd.hr.impt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.impt.common.plugin.BeforeValidateEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.attfile.AttFileHelper;

public class AttFileScheduleImportUpdatePlugin
extends HRDataBaseList
implements HRImportPlugin {
    private static final Log LOG = LogFactory.getLog(AttFileScheduleImportUpdatePlugin.class);
    private static final String FILE_SCHEDULE_CALL_OP_STAND_EXPENSE = "file_schedule_callopstandexpense";
    private static final String FILE_SCHEDULE_CUS_VALIDATE_BATCH_SIZE = "file_schedule_cusvalidatebatchsize";
    private static final String FILE_SCHEDULE_ENABLE_SEQUENCE_INSTORE = "file_schedule_enablesequenceinstore";
    private static final String FILE_SCHEDULE_CUS_QUEUE_SIZ = "file_schedule_cus_queue_siz";

    public void beforeValidate(BeforeValidateEventArgs args) {
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFileScheduleImportUpdatePlugin.beforeValidate start ...");
        }
        AttFileHelper.resetImportOpAndScheduleOrgID((List)args.getBillDatas());
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFileScheduleImportUpdatePlugin.beforeValidate end ...");
        }
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFileScheduleImportUpdatePlugin.beforeCallOperation start ...");
        }
        Map submitOPs = args.getSubmitOPs();
        AttFileHelper.resetSubmitOPs((Map)submitOPs, (String)"_dg");
        AttFileHelper.resetBaseScheduleDate((Object[])args.getDynamicObjects());
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFileScheduleImportUpdatePlugin.beforeCallOperation end ...");
        }
    }

    public void afterLoadEntity(AfterLoadEntityEventArgs args) {
        Iterator iterator = args.getListDys().iterator();
        while (iterator.hasNext()) {
            AttFileScheduleEnum[] values;
            DynamicObject[] dys = (DynamicObject[])iterator.next();
            if (dys == null || dys.length <= 0) continue;
            String mainEntityId = dys[0].getDataEntityType().getName();
            for (AttFileScheduleEnum value : values = AttFileScheduleEnum.values()) {
                if (value.isTimeHis() || !(value.getPageId() + "_dg").equals(mainEntityId)) continue;
                iterator.remove();
            }
        }
    }

    public void afterQueryRefBd(AfterQueryRefBdEventArgs args) {
        args.setDatas(AttFileHelper.filterAuditedBaseData((DynamicObject[])args.getDatas()));
    }

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        List headerWriterFormats = args.getHeaderWriterFormats();
        AttFileHelper.resetExportFields((List)headerWriterFormats, (String)"_dg");
    }

    public void afterLoadStartPage(AfterLoadStartPageEventArgs args) {
        args.setEnableSelectModelView(false);
        args.setEnableSelectModelItem(false);
    }

    public void afterInitContext(AfterInitContextArgs args) {
        String stringCusQueueSize;
        String stringCusValidateBatchSize;
        Boolean booleanEnableSequenceInStore;
        int callOpStandExpenseValue = WTCAppContextHelper.getProjectParams().getIntValue(FILE_SCHEDULE_CALL_OP_STAND_EXPENSE, 30000);
        if (callOpStandExpenseValue != 0) {
            args.setCallopStandExpense(Integer.valueOf(callOpStandExpenseValue));
        }
        if ((booleanEnableSequenceInStore = WTCAppContextHelper.getProjectParams().getBoolean(FILE_SCHEDULE_ENABLE_SEQUENCE_INSTORE, Boolean.TRUE)) != null) {
            args.setEnableSequenceInstore(booleanEnableSequenceInStore.booleanValue());
        }
        if (WTCStringUtils.isNotEmpty((String)(stringCusValidateBatchSize = WTCAppContextHelper.getProjectParams().getString(FILE_SCHEDULE_CUS_VALIDATE_BATCH_SIZE, "1/2")))) {
            args.setCusValidateBatchSize(stringCusValidateBatchSize);
        }
        if (WTCStringUtils.isNotEmpty((String)(stringCusQueueSize = WTCAppContextHelper.getProjectParams().getString(FILE_SCHEDULE_CUS_QUEUE_SIZ, "1000")))) {
            args.setCusQueueSize(stringCusQueueSize);
        }
    }
}

