/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile.schedule;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.business.web.DataBaseEditService;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attfile.schedule.AttFileSchedulePageService;

public class AttFileScheduleTabEdit
extends HRDynamicFormBasePlugin
implements TabSelectListener {
    private static final String ATTFILE_BASE_TARGETKEY = "tabpageap";
    private static final String SPLIT_STR = "_";
    private static final String TABAP = "tabap";
    private static final String BASEPLANLISTVECTORAP = "baseplanlistvectorap";
    private static final String BASEPLANCARDVECTORAP = "baseplancardvectorap";
    private static final String BASELISTFLEXAP = "baselistflexap";
    private static final String BASECARDFLEXAP = "basecardflexap";
    private static final String RULELISTFLEXAP = "rulelistflexap";
    private static final String RULECARDFLEXAP = "rulecardflexap";
    private static final String BASETABAP = "basetabap";
    private static final String RULETABAP = "ruletabap";
    private static final String TABPAGEAP = "tabpageap1";
    private static final String ADD_PERMITEMID = "0=KX5+RHU1BB";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BASEPLANLISTVECTORAP, BASEPLANCARDVECTORAP});
        Tab tab = (Tab)this.getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"advconbaritemap1"});
    }

    public void beforeBindData(EventObject evt) {
        String errTips;
        super.beforeBindData(evt);
        this.genAttFileBase(this.getView());
        String currentTab = this.getCurrentTab();
        ArrayList<AttFileScheduleEnum> attFileScheduleEnumList = new ArrayList<AttFileScheduleEnum>(Arrays.asList(this.getAttFileScheduleEnumsByTab(currentTab)));
        if (!WTCGrayscaleUtils.isFormulaOpen().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{AttFileScheduleEnum.FM.getOutFlexKey(), AttFileScheduleEnum.FM.getCardFlexKey()});
            attFileScheduleEnumList.removeIf(currentEnum -> AttFileScheduleEnum.FM == currentEnum);
        }
        AttFileScheduleEnum[] enums = attFileScheduleEnumList.toArray(new AttFileScheduleEnum[0]);
        if (this.getPageCache().get(JSON.toJSONString((Object)enums)) != null) {
            AttFileSchedulePageService.genShowScheduleDetails((IFormView)this.getView(), (AttFileScheduleEnum[])enums);
        }
        if (TABPAGEAP.equals(currentTab)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listorcardflexap"});
        }
        if (WTCStringUtils.isNotEmpty((String)(errTips = AttFileHelper.checkIsDiscard((IFormView)this.getView()))) && HRStringUtils.isNotEmpty((String)errTips)) {
            List<String> list = Arrays.stream(AttFileScheduleEnum.values()).map(AttFileScheduleEnum::getKey).collect(Collectors.toList());
            this.getView().setVisible(Boolean.FALSE, list.toArray(new String[0]));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Vector)evt.getSource()).getKey();
        String currentTab = this.getCurrentTab();
        if (BASEPLANLISTVECTORAP.equals(key)) {
            this.setFlexApVisible(currentTab, true, false);
            VectorAp ap = new VectorAp();
            ap.setKey(BASEPLANLISTVECTORAP);
            ap.setForeColor("themeColor");
            VectorAp carAp = new VectorAp();
            carAp.setKey(BASEPLANCARDVECTORAP);
            carAp.setForeColor("#666666");
            this.getView().updateControlMetadata(ap.getKey(), ap.createControl());
            this.getView().updateControlMetadata(carAp.getKey(), carAp.createControl());
        } else if (BASEPLANCARDVECTORAP.equals(key)) {
            this.setFlexApVisible(currentTab, false, true);
            VectorAp ap = new VectorAp();
            ap.setKey(BASEPLANLISTVECTORAP);
            ap.setForeColor("#666666");
            VectorAp carAp = new VectorAp();
            carAp.setKey(BASEPLANCARDVECTORAP);
            carAp.setForeColor("themeColor");
            this.getView().updateControlMetadata(ap.getKey(), ap.createControl());
            this.getView().updateControlMetadata(carAp.getKey(), carAp.createControl());
            this.getView().invokeOperation("refresh");
        }
    }

    private void setFlexApVisible(String currentTab, boolean b1, boolean b2) {
        if (BASETABAP.equals(currentTab)) {
            this.getView().setVisible(Boolean.valueOf(b1), new String[]{BASELISTFLEXAP});
            this.getView().setVisible(Boolean.valueOf(b2), new String[]{BASECARDFLEXAP});
        } else if (RULETABAP.equals(currentTab)) {
            this.getView().setVisible(Boolean.valueOf(b1), new String[]{RULELISTFLEXAP});
            this.getView().setVisible(Boolean.valueOf(b2), new String[]{RULECARDFLEXAP});
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        boolean isAttFileDetailsTabPageAp;
        String currentTab = this.getCurrentTab();
        AttFileScheduleEnum[] enums = this.getAttFileScheduleEnumsByTab(currentTab);
        if (this.getPageCache().get(JSON.toJSONString((Object)enums)) == null) {
            AttFileSchedulePageService.genShowScheduleDetails((IFormView)this.getView(), (AttFileScheduleEnum[])enums);
        }
        if (!(isAttFileDetailsTabPageAp = TABPAGEAP.equals(currentTab))) {
            ((Vector)this.getControl(BASEPLANLISTVECTORAP)).click();
        }
        this.getView().setVisible(Boolean.valueOf(!isAttFileDetailsTabPageAp), new String[]{"listorcardflexap"});
    }

    private String getCurrentTab() {
        Tab tab = (Tab)this.getControl(TABAP);
        return tab.getCurrentTab();
    }

    private void genAttFileBase(IFormView view) {
        FormShowParameter detailFormShowParameter = view.getFormShowParameter();
        Map customParams = detailFormShowParameter.getCustomParams();
        BillShowParameter formShowParameter = DataBaseEditService.getBillShowParameter((String)"wtp_attfilemodifybase", (ShowType)ShowType.InContainer, customParams.get("boid"));
        formShowParameter.getOpenStyle().setTargetKey(ATTFILE_BASE_TARGETKEY);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setBillStatus(BillOperationStatus.VIEW);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setHasRight(true);
        view.showForm((FormShowParameter)formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String tips;
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String[] strs = operateKey.split(SPLIT_STR);
        String appId = "";
        if (strs.length > 1) {
            appId = strs[0];
            operateKey = strs[1];
        }
        if (WTCStringUtils.isNotEmpty((String)operateKey) && (operateKey.equals("add") || operateKey.equals("addrule")) && WTCStringUtils.isNotEmpty((String)(tips = AttFileHelper.checkIsDiscard((IFormView)this.getView())))) {
            this.getView().showErrorNotification(tips);
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)appId)) {
            AttFileScheduleEnum attFileScheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByKey((String)appId);
            boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)attFileScheduleEnum.getPageId(), (String)ADD_PERMITEMID);
            if (!hasPerm) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u52e4\u6863\u6848-%1$s\u201d\u7684\u201c\u6dfb\u52a0\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttFileScheduleTabEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), attFileScheduleEnum.getScheduleName()));
                args.setCancel(true);
                return;
            }
            long attFileId = (Long)this.getView().getFormShowParameter().getCustomParams().get("attfileid");
            boolean noPermission = WTCPermUtils.noDataPermission((long)attFileId, (String)"wtp_attfilebase", (String)"wtam", (IFormView)this.getView(), null);
            if (noPermission) {
                return;
            }
            String pageId = this.getView().getPageCache().get(attFileScheduleEnum.getPageId());
            IFormView listView = SessionManager.getCurrent().getView(pageId);
            if (listView == null) {
                args.setCancel(true);
                return;
            }
            listView.invokeOperation(operateKey);
            this.getView().sendFormAction(listView);
        }
    }

    private AttFileScheduleEnum[] getAttFileScheduleEnumsByTab(String currentTab) {
        AttFileScheduleEnum[] values = new AttFileScheduleEnum[]{};
        if (BASETABAP.equals(currentTab)) {
            values = (AttFileScheduleEnum[])Arrays.stream(AttFileScheduleEnum.values()).filter(AttFileScheduleEnum::isTimeHis).toArray(AttFileScheduleEnum[]::new);
        } else if (RULETABAP.equals(currentTab)) {
            values = (AttFileScheduleEnum[])Arrays.stream(AttFileScheduleEnum.values()).filter(value -> !value.isTimeHis()).toArray(AttFileScheduleEnum[]::new);
        }
        return values;
    }
}

