/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile.stopattendance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileCheckService;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.common.enums.FileCheckBusDataEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class AttFileStopAttendanceDlgPlugin
extends HRDynamicFormBasePlugin {
    private static final List<String> billCheckBusDataTypes = Arrays.asList(FileCheckBusDataEnum.OT.getKey(), FileCheckBusDataEnum.BATCH_VA.getKey(), FileCheckBusDataEnum.VA.getKey(), FileCheckBusDataEnum.BUS.getKey(), FileCheckBusDataEnum.SUP.getKey(), FileCheckBusDataEnum.SWS.getKey());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"refresh", "btnok"});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.initTopTips(customParams);
        this.initEntryData(customParams, false);
    }

    private void initTopTips(Map<String, Object> customParams) {
        Label label = (Label)this.getControl("tips");
        String tips = String.valueOf(customParams.get("stopatttips"));
        label.setText(tips);
    }

    private void initEntryData(Map<String, Object> customParams, boolean isRefresh) {
        Map allDataMap;
        Long boId = (Long)JSON.parseObject((String)String.valueOf(customParams.get("boid")), Long.class);
        Date startDate = (Date)JSON.parseObject((String)String.valueOf(customParams.get("startdate")), Date.class);
        Date endDate = (Date)JSON.parseObject((String)String.valueOf(customParams.get("enddate")), Date.class);
        if (isRefresh) {
            allDataMap = AttFileHelper.getCheckMap((Map)AttFileCheckService.getInstance().getStopAttCheckDataMap(Collections.singletonList(boId), false, startDate, endDate), (boolean)true);
            boolean isNoData = WTCCollections.isEmpty((Map)allDataMap);
            this.getView().setVisible(Boolean.valueOf(isNoData), new String[]{"btnok"});
            this.getView().setVisible(Boolean.valueOf(!isNoData), new String[]{"btncancel"});
        } else {
            Object object = customParams.get("businessData");
            if (object == null) {
                return;
            }
            allDataMap = (Map)JSON.parseObject((String)String.valueOf(object), LinkedHashMap.class);
        }
        Map stopAttCheckDataMap = AttFileCheckService.getInstance().getStopAttCheckDataMap(Collections.singletonList(boId), true, startDate, endDate);
        Map hasAuthDataMap = AttFileHelper.getCheckMap((Map)stopAttCheckDataMap, (boolean)true);
        this.cacheBillNoMap(stopAttCheckDataMap);
        this.refreshEntryData(allDataMap, hasAuthDataMap);
    }

    private void cacheBillNoMap(Map<String, List<DynamicObject>> stopAttCheckDataMap) {
        HashMap stopAttCheckDataBillNoMap = Maps.newHashMapWithExpectedSize((int)stopAttCheckDataMap.size());
        for (Map.Entry<String, List<DynamicObject>> mapEntry : stopAttCheckDataMap.entrySet()) {
            if (!billCheckBusDataTypes.contains(mapEntry.getKey())) continue;
            List<DynamicObject> dyList = mapEntry.getValue();
            List billNoList = dyList.stream().filter(Objects::nonNull).map(dy -> dy.getString("billno")).collect(Collectors.toList());
            stopAttCheckDataBillNoMap.put(mapEntry.getKey(), billNoList);
        }
        this.getPageCache().put("businessBillNumberData", JSONArray.toJSONString((Object)stopAttCheckDataBillNoMap));
    }

    private void refreshEntryData(Map<String, Integer> allDataMap, Map<String, Integer> hasAuthDataMap) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        entryEntity.clear();
        int index = entryEntity.size();
        for (Map.Entry<String, Integer> mapEntry : allDataMap.entrySet()) {
            FileCheckBusDataEnum busDataEnum = FileCheckBusDataEnum.getEnumByCode((String)mapEntry.getKey());
            if (busDataEnum == null) continue;
            DynamicObject entryDy = entryEntity.addNew();
            entryDy.set("checkbustype", (Object)busDataEnum.getKey());
            entryDy.set("businessdatatype", (Object)busDataEnum.getDescription());
            entryDy.set("tobeprocessednum", (Object)mapEntry.getValue());
            Integer integer = hasAuthDataMap.get(busDataEnum.getKey());
            if (integer == null) {
                entryDy.set("processablenum", (Object)0);
            } else {
                entryDy.set("processablenum", (Object)integer);
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            if (FileCheckBusDataEnum.SIGN_CARD == busDataEnum) {
                entryGrid.hideOperateItems("operatecolunm", index, Arrays.asList("changebill", "changebatchbill"));
            } else {
                entryGrid.hideOperateItems("operatecolunm", index, Collections.singletonList("failuredata"));
                if (billCheckBusDataTypes.contains(busDataEnum.getKey()) && FileCheckBusDataEnum.VA != busDataEnum) {
                    entryGrid.hideOperateItems("operatecolunm", index, Collections.singletonList("changebatchbill"));
                }
            }
            ++index;
        }
        this.getView().updateView("entryentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            String operateKey;
            switch (operateKey = args.getOperateKey()) {
                case "failuredata": 
                case "changebill": 
                case "changebatchbill": {
                    int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                    if (entryRowEntity == null) break;
                    List billNoList = Lists.newArrayListWithExpectedSize((int)0);
                    String checkBusType = entryRowEntity.getString("checkbustype");
                    FileCheckBusDataEnum busDataEnum = FileCheckBusDataEnum.getEnumByCode((String)checkBusType);
                    if (FileCheckBusDataEnum.SIGN_CARD != busDataEnum && FileCheckBusDataEnum.ATT_PUSH != busDataEnum) {
                        String str;
                        if (billCheckBusDataTypes.contains(checkBusType) && HRStringUtils.isNotEmpty((String)(str = this.getPageCache().get("businessBillNumberData")))) {
                            Map map = (Map)JSONObject.parseObject((String)str, Map.class);
                            billNoList = FileCheckBusDataEnum.VA.getKey().equals(checkBusType) && "changebatchbill".equals(operateKey) ? (List)map.get(FileCheckBusDataEnum.BATCH_VA.getKey()) : (List)map.get(checkBusType);
                        }
                        if (WTCCollections.isEmpty((Collection)billNoList)) {
                            this.getView().showTipNotification(AttFileKDString.getNotNeedJumpTips((String)busDataEnum.getDescription()));
                            return;
                        }
                    }
                    Map customParams = this.getView().getFormShowParameter().getCustomParams();
                    Long boId = (Long)JSON.parseObject((String)String.valueOf(customParams.get("boid")), Long.class);
                    Date startDate = (Date)JSON.parseObject((String)String.valueOf(customParams.get("startdate")), Date.class);
                    Date endDate = (Date)JSON.parseObject((String)String.valueOf(customParams.get("enddate")), Date.class);
                    AttFileHelper.jumpToCheckDataPage((String)entryRowEntity.getString("checkbustype"), Collections.singletonList(boId), (Date)startDate, (Date)endDate, (List)billNoList, (IFormView)this.getView(), (String)operateKey);
                    break;
                }
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label) {
            String key2 = ((Label)source).getKey();
            if ("refresh".equals(key2)) {
                this.initEntryData(this.getView().getFormShowParameter().getCustomParams(), true);
            }
        } else if (source instanceof Button && "btnok".equals(key = ((Button)source).getKey())) {
            this.getView().returnDataToParent((Object)MessageBoxResult.OK);
            this.getView().close();
        }
    }
}

