/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile.stopattendance;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtp.business.attfile.AttFileCheckService;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class AttFileStopAttendanceEdit
extends HRDataBaseEdit {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey) && AttFileHelper.isStopAttendance((DynamicObject)this.getModel().getDataEntity())) {
            if ("true".equals(this.getPageCache().get("stopAttendanceConfirm"))) {
                this.getPageCache().remove("stopAttendanceConfirm");
                return;
            }
            args.setCancel(true);
            DynamicObject pageDy = this.getModel().getDataEntity();
            long boId = this.getModel().getDataEntity().getLong("boid");
            Date startDate = pageDy.getDate("bsed");
            Date endDate = pageDy.getDate("bsled");
            Map allDataMap = AttFileHelper.getCheckMap((Map)AttFileCheckService.getInstance().getStopAttCheckDataMap(Collections.singletonList(boId), false, startDate, endDate), (boolean)true);
            if (WTCCollections.isNotEmpty((Map)allDataMap)) {
                this.genShowStopAttendanceConfirmDlg(allDataMap);
            } else {
                this.getView().showConfirm(this.getStopAttendanceTips(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("stopAttendance", (IFormPlugin)this));
            }
        }
    }

    private String getStopAttendanceTips() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String name = dataEntity.getString("name");
        String number = dataEntity.getString("number");
        String startDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)dataEntity.getDate("bsed"));
        String endDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)dataEntity.getDate("bsled"));
        return AttFileKDString.getStopAttendanceTips((String)name, (String)number, (String)startDateStr, (String)endDateStr);
    }

    private void genShowStopAttendanceConfirmDlg(Map<String, Integer> checkDataMap) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wtp_stopattconfirmdlg");
        parameter.setCustomParam("businessData", (Object)JSON.toJSONString(checkDataMap));
        parameter.setCustomParam("stopatttips", (Object)this.getStopAttendanceTips());
        DynamicObject dataEntity = this.getModel().getDataEntity();
        parameter.setCustomParam("boid", (Object)dataEntity.getLong("boid"));
        parameter.setCustomParam("startdate", (Object)JSON.toJSONString((Object)dataEntity.getDate("bsed")));
        parameter.setCustomParam("enddate", (Object)JSON.toJSONString((Object)dataEntity.getDate("bsled")));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "stopAttendance"));
        int entrySize = checkDataMap.size();
        AttFileStopAttendanceEdit.resetBusiFormSize(entrySize, parameter);
        this.getView().showForm(parameter);
    }

    private static void resetBusiFormSize(int entrySize, FormShowParameter parameter) {
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        int highBase = 350;
        cssValue.setWidth("643px");
        cssValue.setHeight((highBase += 35 * entrySize) + "px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("stopAttendance".equals(callBackId) && MessageBoxResult.Yes == event.getResult()) {
            this.getPageCache().put("stopAttendanceConfirm", "true");
            this.getView().invokeOperation("save");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String callBackId = closedCallBackEvent.getActionId();
        if ("stopAttendance".equals(callBackId) && MessageBoxResult.OK == closedCallBackEvent.getReturnData()) {
            this.getPageCache().put("stopAttendanceConfirm", "true");
            this.getView().invokeOperation("save");
        }
    }
}

