/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attperiod;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.attperiod.AttPeriodService;
import kd.wtc.wtp.common.constants.attperiod.AttPeriodConstants;

public class AttPeriodBatchAddPlugin
extends HRDynamicFormBasePlugin
implements AttPeriodConstants,
BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(AttPeriodBatchAddPlugin.class);
    private static final String STATUS_A = "A";
    private static final String STATUS_B = "B";
    private static final String STATUS_C = "C";
    private static final String YYYY_MM_DD_FORMAT = "yyyy/MM/dd";
    private static final String YEAR_MONTH = "yearMonth";
    private static final String KEY_OK = "ok";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        super.afterBindData(evt);
        Map dataMap = this.getView().getFormShowParameter().getCustomParams();
        Map data = (Map)dataMap.get("data");
        if (data != null && !data.isEmpty()) {
            long ruleId = (Long)data.get("defaultmhsa");
            this.getModel().setValue("mhsa", (Object)ruleId);
            String loopType = (String)data.get("looptype");
            this.getModel().setValue("looptype", (Object)loopType);
            this.getModel().setValue("createorg", data.get("createorg"));
            switch (loopType) {
                case "A": {
                    String periodDate = (String)data.get("perioddate");
                    this.getModel().setValue("perioddate", (Object)periodDate);
                    break;
                }
                case "B": {
                    String firstPeriodDate = (String)data.get("firstperioddate");
                    String secondPeriodDate = (String)data.get("secondperioddate");
                    this.getModel().setValue("firstperioddate", (Object)firstPeriodDate);
                    this.getModel().setValue("secondperioddate", (Object)secondPeriodDate);
                    break;
                }
                case "C": {
                    String loopBeginDate = (String)data.get("loopbegindate");
                    this.getModel().setValue("loopbegindate", (Object)loopBeginDate);
                    break;
                }
            }
            int periodNumber = (Integer)data.get("perioddays");
            this.getModel().setValue("perioddays", (Object)periodNumber);
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("mhsa");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        QFilter qFilter = new QFilter("status", "=", (Object)STATUS_C);
        evt.addCustomQFilter(qFilter);
        String name = evt.getProperty().getName();
        if ("mhsa".equals(name)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Date begindate = dataEntity.getDate("periodbegindate");
            if (null == begindate) {
                return;
            }
            QFilter filter = new QFilter("firstbsed", "<=", (Object)begindate);
            evt.addCustomQFilter(filter);
        }
    }

    public void setParentDate(Map<String, Object> data, DynamicObject dynamicObject) {
        long mhsaId = dynamicObject.getLong("mhsa.id");
        data.put("defaultmhsa", mhsaId);
        String loopType = dynamicObject.getString("looptype");
        data.put("looptype", loopType);
        switch (loopType) {
            case "A": {
                String periodDate = dynamicObject.getString("perioddate");
                data.put("perioddate", periodDate);
                break;
            }
            case "B": {
                String firstPeriodDate = dynamicObject.getString("firstperioddate");
                String secondPeriodDate = dynamicObject.getString("secondperioddate");
                data.put("firstperioddate", firstPeriodDate);
                data.put("secondperioddate", secondPeriodDate);
                break;
            }
            case "C": {
                Date loopBeginDate = dynamicObject.getDate("loopbegindate");
                data.put("loopbegindate", loopBeginDate);
                break;
            }
        }
        int periodNumber = dynamicObject.getInt("perioddays");
        data.put("perioddays", periodNumber);
        Date periodBeginDate = dynamicObject.getDate("periodbegindate");
        data.put("periodbegindate", periodBeginDate);
        int number = dynamicObject.getInt("number");
        data.put("number", number);
        String timeRule = dynamicObject.getString("timerule");
        data.put("timerule", timeRule);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (key.equals("donothing-batch-add")) {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            Date periodBeginDate = dynamicObject.getDate("periodbegindate");
            int number = dynamicObject.getInt("number");
            if (number <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u671f\u95f4\u6570\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\u3002", (String)"AttPeriodBatchAddPlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            Map dataMap = this.getView().getFormShowParameter().getCustomParams();
            Map data = (Map)dataMap.get("data");
            data.put("number", number);
            data.put("timerule", dynamicObject.getString("timerule"));
            String loopType = dynamicObject.getString("looptype");
            SimpleDateFormat dayFormat = new SimpleDateFormat("d");
            String day = dayFormat.format(periodBeginDate);
            String checkMhsa = this.checkMhsa(dynamicObject, periodBeginDate);
            if (WTCStringUtils.isNotEmpty((String)checkMhsa)) {
                this.getView().showErrorNotification(checkMhsa);
                args.setCancel(true);
            }
            switch (loopType) {
                case "A": {
                    String periodDate = dynamicObject.getString("perioddate");
                    periodDate = this.isLastDayOfMonth(periodBeginDate, periodDate);
                    if (day.equals(periodDate)) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u671f\u95f4\u5f00\u59cb\u751f\u6210\u65e5\u671f\u4e0e\u671f\u95f4\u8d77\u59cb\u65e5\u4e0d\u7b26\u3002", (String)"AttPeriodBatchAddPlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                case "B": {
                    String firstPeriodDate = dynamicObject.getString("firstperioddate");
                    String secondPeriodDate = dynamicObject.getString("secondperioddate");
                    firstPeriodDate = this.isLastDayOfMonth(periodBeginDate, firstPeriodDate);
                    secondPeriodDate = this.isLastDayOfMonth(periodBeginDate, secondPeriodDate);
                    if (day.equals(firstPeriodDate) || day.equals(secondPeriodDate)) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u586b\u5199\u671f\u95f4\u5f00\u59cb\u751f\u6210\u65e5\u671f\uff0c\u5e94\u4e0e\u9996\u671f\u95f4\u8d77\u59cb\u65e5\u6216\u6b21\u671f\u95f4\u8d77\u59cb\u65e5\u4e00\u81f4\u3002", (String)"AttPeriodBatchAddPlugin_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                case "C": {
                    Date loopBeginDate = dynamicObject.getDate("loopbegindate");
                    int periodNumber = dynamicObject.getInt("perioddays");
                    int days = AttPeriodService.calculateTotalDays((Date)loopBeginDate, (Date)periodBeginDate);
                    if (days % periodNumber == 0) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u586b\u5199\u201c\u671f\u95f4\u5f00\u59cb\u751f\u6210\u65e5\u671f\u201d\uff0c\u5b83\u5e94\u8be5\u662f\u201c\u5faa\u73af\u57fa\u51c6\u8d77\u59cb\u65e5\u671f\u201d\u52a0\u4e0a\u201c\u671f\u95f4\u5929\u6570\u201d\u7684N\u500d\uff08N\u4e3a0\u6216\u6b63\u6574\u6570\uff09\u3002", (String)"AttPeriodBatchAddPlugin_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
            }
            if (args.isCancel()) {
                return;
            }
            HashMap<String, List<String>> msgMap = new HashMap<String, List<String>>(16);
            boolean flag = this.isDiscontinuityPeriod(data, periodBeginDate, msgMap);
            this.generateBatchAddTipsView(msgMap, flag, data, periodBeginDate, args);
        }
    }

    private String checkMhsa(DynamicObject dynamicObject, Date periodBeginDate) {
        Date firstbsed;
        DynamicObject mhsa = dynamicObject.getDynamicObject("mhsa");
        if (null != mhsa && null != (firstbsed = mhsa.getDate("firstbsed")) && firstbsed.after(periodBeginDate)) {
            return ResManager.loadKDString((String)"\u201c\u671f\u95f4\u5f00\u59cb\u751f\u6210\u65e5\u671f\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u201c\u65e5\u671f\u5f52\u5c5e\u89c4\u5219\u201d\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u3002", (String)"AttPeriodPlugin_18", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void generateBatchAddTipsView(Map<String, List<String>> msgMap, boolean flag, Map<String, Object> data, Date periodBeginDate, BeforeDoOperationEventArgs args) {
        String failurReason;
        HashMap<String, Object> customMap = new HashMap<String, Object>(16);
        Date periodEndDate = (Date)data.get("periodEndDate");
        if (flag) {
            flag = AttPeriodBatchAddPlugin.validateBeginEndDateSection(data, periodBeginDate, periodEndDate, msgMap);
            if (!flag) {
                failurReason = ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a\u5206\u5f55\u5217\u8868\u4e2d\u7684\u8003\u52e4\u671f\u95f4\u4e0e\u6279\u91cf\u751f\u6210\u7684\u8003\u52e4\u671f\u95f4\u4e0d\u8fde\u7eed\u3002", (String)"AttPeriodBatchAddPlugin_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
                customMap.put("failurReason", failurReason);
            }
        } else {
            failurReason = ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a\u5206\u5f55\u5217\u8868\u4e2d\u7684\u8003\u52e4\u671f\u95f4\u4e0e\u6279\u91cf\u751f\u6210\u7684\u8003\u52e4\u671f\u95f4\u4e0d\u8fde\u7eed\u3002", (String)"AttPeriodBatchAddPlugin_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            customMap.put("failurReason", failurReason);
        }
        String periodBeginDateStr = ResManager.loadKDString((String)"\u751f\u6210\u671f\u95f4\u5f00\u59cb\u65e5\u671f\uff1a%s", (String)"AttPeriodBatchAddPlugin_6", (String)"wtc-wtp-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)periodBeginDate, (String)YYYY_MM_DD_FORMAT)});
        customMap.put("periodBeginDate", periodBeginDateStr);
        String numStr = ResManager.loadKDString((String)"\u751f\u6210\u671f\u95f4\u6570\u91cf\uff1a%s", (String)"AttPeriodBatchAddPlugin_7", (String)"wtc-wtp-formplugin", (Object[])new Object[]{data.get("number")});
        customMap.put("numStr", numStr);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("wtp_attperiodbatchaddtips");
        customMap.put("msgMap", msgMap);
        showParameter.setCustomParam("successTag", (Object)flag);
        showParameter.setCustomParam("data", customMap);
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("417px");
        String heightCs = flag ? "429px" : "450px";
        cssValue.setHeight(heightCs);
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(style);
        String title = ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25", (String)"AttPeriodBatchAddPlugin_8", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        if (flag) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_OK));
            title = ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f", (String)"AttPeriodBatchAddPlugin_9", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        }
        customMap.put("title", title);
        this.getView().showForm(showParameter);
        args.setCancel(true);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (KEY_OK.equals(key)) {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            this.setParentDate(data, dynamicObject);
            IFormView view = this.getView();
            IFormView parentView = view.getParentView();
            if (parentView == null) {
                return;
            }
            view.returnDataToParent(data);
            view.sendFormAction(parentView);
            view.close();
        }
    }

    private boolean isDiscontinuityPeriod(Map<String, Object> data, Date periodBeginDate, Map<String, List<String>> msgMap) {
        Date beginDate = new Date();
        Date endDate = new Date();
        int number = (Integer)data.get("number");
        String loopType = (String)data.get("looptype");
        Calendar endCalendar = Calendar.getInstance();
        String periodDate = (String)data.get("perioddate");
        String beginTempStr = "";
        String endTempStr = "";
        Date beginTemp = null;
        Date endTemp = null;
        try {
            if (data.get("begindate") != null) {
                beginTemp = HRDateTimeUtils.parseDate((String)((String)data.get("begindate")));
                beginTempStr = HRDateTimeUtils.format((Date)beginTemp, (String)YYYY_MM_DD_FORMAT);
            }
            if (data.get("enddate") != null) {
                endTemp = HRDateTimeUtils.parseDate((String)((String)data.get("enddate")));
                endTempStr = HRDateTimeUtils.format((Date)endTemp, (String)YYYY_MM_DD_FORMAT);
            }
        }
        catch (Exception ex) {
            log.error("AttPeriodBatchAddPlugin isDiscontinuityPeriod is error", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
        JSONArray dynamicObjectCollection = (JSONArray)data.get("attperiodentry");
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(periodBeginDate);
        data.put(YEAR_MONTH, "");
        data.put("seq", 0);
        for (int i = 0; i < number; ++i) {
            String periodCode;
            switch (loopType) {
                case "A": {
                    beginDate = AttPeriodService.cycleMonth((Calendar)beginCalendar, (Calendar)endCalendar, (boolean)"31".equals(periodDate));
                    endDate = endCalendar.getTime();
                    break;
                }
                case "B": {
                    beginDate = AttPeriodService.cycleHalfMonth(data, (Calendar)beginCalendar);
                    endDate = AttPeriodService.getYesterday((Date)beginCalendar.getTime());
                    break;
                }
                case "C": {
                    beginDate = beginCalendar.getTime();
                    int periodNumber = (Integer)data.get("perioddays");
                    beginCalendar.add(5, periodNumber);
                    endDate = AttPeriodService.getYesterday((Date)beginCalendar.getTime());
                    break;
                }
            }
            String beginStr = HRDateTimeUtils.format((Date)beginDate, (String)YYYY_MM_DD_FORMAT);
            String endStr = HRDateTimeUtils.format((Date)endDate, (String)YYYY_MM_DD_FORMAT);
            String currentPeriodCode = this.getPeriodCode(data, beginDate, endDate);
            if (i == 0) {
                Date beginYesterday = AttPeriodService.getYesterday((Date)beginDate);
                if (endTemp != null && endTemp.getTime() < beginYesterday.getTime()) {
                    Date perBegin = dynamicObjectCollection.getJSONObject(dynamicObjectCollection.size() - 1).getDate("begindate");
                    periodCode = dynamicObjectCollection.getJSONObject(dynamicObjectCollection.size() - 1).getString("periodcode");
                    String perBeginStr = HRDateTimeUtils.format((Date)perBegin, (String)YYYY_MM_DD_FORMAT);
                    this.generateDiscontinuityMsg(periodCode, currentPeriodCode, perBeginStr, beginStr, endTempStr, endStr, msgMap);
                    return false;
                }
                ArrayList<String> successMsgs = new ArrayList<String>(2);
                String successFirstStr = String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684\u9996\u4e2a\u8003\u52e4\u671f\u95f4\uff1a<br/>%1$s,%2$s-%3$s", (String)"AttPeriodBatchAddPlugin_15", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), currentPeriodCode, beginStr, endStr);
                successMsgs.add(successFirstStr);
                msgMap.put("successList", successMsgs);
            }
            if (i != number - 1) continue;
            Date nextDay = AttPeriodService.getTomorrow((Date)endDate);
            if (beginTemp != null && nextDay.getTime() < beginTemp.getTime()) {
                Date nextEndDate = dynamicObjectCollection.getJSONObject(0).getDate("enddate");
                periodCode = dynamicObjectCollection.getJSONObject(0).getString("periodcode");
                String nextEndStr = HRDateTimeUtils.format((Date)nextEndDate, (String)YYYY_MM_DD_FORMAT);
                this.generateDiscontinuityMsg(currentPeriodCode, periodCode, beginStr, beginTempStr, endStr, nextEndStr, msgMap);
                return false;
            }
            String successSecondStr = String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684\u6700\u540e\u4e00\u4e2a\u8003\u52e4\u671f\u95f4\uff1a<br/>%1$s,%2$s-%3$s", (String)"AttPeriodBatchAddPlugin_16", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), currentPeriodCode, beginStr, endStr);
            msgMap.get("successList").add(successSecondStr);
        }
        data.put("periodEndDate", endDate);
        return true;
    }

    private void generateDiscontinuityMsg(String firstCode, String secondCode, String firstBegin, String secondBegin, String firstEnd, String secondEnd, Map<String, List<String>> msgMap) {
        ArrayList<String> msgs = new ArrayList<String>(2);
        String firstStr = String.format(ResManager.loadKDString((String)"\u4e0d\u8fde\u7eed\u7684\u9996\u8003\u52e4\u671f\u95f4\uff1a<br/>%1$s,%2$s-%3$s\u3002", (String)"AttPeriodBatchAddPlugin_17", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), firstCode, firstBegin, firstEnd);
        String secondStr = String.format(ResManager.loadKDString((String)"\u4e0d\u8fde\u7eed\u7684\u6b21\u8003\u52e4\u671f\u95f4\uff1a<br/>%1$s,%2$s-%3$s\u3002", (String)"AttPeriodBatchAddPlugin_18", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), secondCode, secondBegin, secondEnd);
        msgs.add(firstStr);
        msgs.add(secondStr);
        msgMap.put("failList", msgs);
    }

    private String getPeriodCode(Map<String, Object> data, Date beginDate, Date endDate) {
        String namePrefix = (String)data.get("nameprefix");
        String nameMain = (String)data.get("namemain");
        String namePostfix = (String)data.get("namepostfix");
        int serialNumber = (Integer)data.get("serialnumber");
        String timeRule = (String)data.get("timerule");
        String yearMonth = (String)data.get(YEAR_MONTH);
        int seq = (Integer)data.get("seq");
        Calendar calendar = Calendar.getInstance();
        switch (timeRule) {
            case "A": {
                calendar.setTime(beginDate);
                break;
            }
            case "B": {
                calendar.setTime(endDate);
                break;
            }
        }
        SimpleDateFormat year = new SimpleDateFormat("yyyy");
        SimpleDateFormat month = new SimpleDateFormat("MM");
        String yearStr = year.format(calendar.getTime());
        String monthStr = month.format(calendar.getTime());
        String tempYearMonth = yearStr + monthStr;
        if (yearMonth.equals(tempYearMonth)) {
            ++seq;
        } else {
            data.put(YEAR_MONTH, tempYearMonth);
            seq = 0;
        }
        data.put("seq", seq);
        return AttPeriodService.generatePeriodCode((String)namePrefix, (String)nameMain, (String)namePostfix, (int)serialNumber, (int)seq, nameStr -> {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            switch (nameStr) {
                case "A": {
                    nameStr = tempYearMonth;
                    break;
                }
                case "B": {
                    nameStr = sdf.format(beginDate);
                    break;
                }
                case "C": {
                    nameStr = sdf.format(endDate);
                    break;
                }
            }
            return nameStr;
        });
    }

    public static boolean validateBeginEndDateSection(Map<String, Object> data, Date periodBeginDate, Date periodEndDate, Map<String, List<String>> msgMap) {
        JSONArray entrys = (JSONArray)data.get("attperiodentry");
        if (data.get("begindate") == null || data.get("enddate") == null || entrys == null) {
            return true;
        }
        try {
            Date beginTemp = HRDateTimeUtils.parseDate((String)((String)data.get("begindate")));
            Date endTemp = HRDateTimeUtils.parseDate((String)((String)data.get("enddate")));
            ArrayList msgs = new ArrayList(entrys.size());
            msgMap.put("failList", msgs);
            if (periodBeginDate.getTime() <= beginTemp.getTime() && periodEndDate.getTime() >= beginTemp.getTime()) {
                for (int i = 0; i < entrys.size(); ++i) {
                    JSONObject dynamicObject = entrys.getJSONObject(i);
                    Date entryBeginDate = dynamicObject.getDate("begindate");
                    Date entryEndDate = dynamicObject.getDate("enddate");
                    String periodCode = dynamicObject.getString("periodcode");
                    String entryBeginDateStr = HRDateTimeUtils.format((Date)entryBeginDate, (String)YYYY_MM_DD_FORMAT);
                    String entryEndDateDateStr = HRDateTimeUtils.format((Date)entryEndDate, (String)YYYY_MM_DD_FORMAT);
                    if (entryBeginDate.getTime() > periodEndDate.getTime()) break;
                    String entryStr = String.format(ResManager.loadKDString((String)"\u91cd\u53e0\u7684\u8003\u52e4\u671f\u95f4\uff1a<br/>%1$s,%2$s-%3$s", (String)"AttPeriodBatchAddPlugin_19", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), periodCode, entryBeginDateStr, entryEndDateDateStr);
                    msgMap.get("failList").add(entryStr);
                }
                return false;
            }
            if (periodBeginDate.getTime() >= beginTemp.getTime() && periodBeginDate.getTime() <= endTemp.getTime() && periodEndDate.getTime() >= endTemp.getTime()) {
                for (int index = entrys.size() - 1; index >= 0; --index) {
                    JSONObject dynamicObject = entrys.getJSONObject(index);
                    Date entryBeginDate = dynamicObject.getDate("begindate");
                    Date entryEndDate = dynamicObject.getDate("enddate");
                    String periodCode = dynamicObject.getString("periodcode");
                    String entryBeginDateStr = HRDateTimeUtils.format((Date)entryBeginDate, (String)YYYY_MM_DD_FORMAT);
                    String entryEndDateDateStr = HRDateTimeUtils.format((Date)entryEndDate, (String)YYYY_MM_DD_FORMAT);
                    if (entryEndDate.getTime() < periodBeginDate.getTime()) break;
                    String entryStr = String.format(ResManager.loadKDString((String)"\u91cd\u53e0\u7684\u8003\u52e4\u671f\u95f4\uff1a<br/>%1$s,%2$s-%3$s", (String)"AttPeriodBatchAddPlugin_19", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), periodCode, entryBeginDateStr, entryEndDateDateStr);
                    msgMap.get("failList").add(entryStr);
                }
                Collections.reverse(msgMap.get("failList"));
                return false;
            }
            if (periodBeginDate.getTime() >= beginTemp.getTime() && periodEndDate.getTime() <= endTemp.getTime()) {
                AttPeriodBatchAddPlugin.findConflictInterval(0, entrys.size() - 1, periodBeginDate, periodEndDate, msgMap.get("failList"), entrys);
                return false;
            }
        }
        catch (Exception ex) {
            log.error("AttPeriodBatchAddPlugin validateBeginEndDateSection is error", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
        return true;
    }

    private static void findConflictInterval(int left, int right, Date periodBeginDate, Date periodEndDate, List<String> msgrStr, JSONArray entrys) {
        if (left == right) {
            JSONObject dynamicObject = entrys.getJSONObject(left);
            Date entryBeginDate = dynamicObject.getDate("begindate");
            Date entryEndDate = dynamicObject.getDate("enddate");
            String periodCode = dynamicObject.getString("periodcode");
            String entryBeginDateStr = HRDateTimeUtils.format((Date)entryBeginDate, (String)YYYY_MM_DD_FORMAT);
            String entryEndDateDateStr = HRDateTimeUtils.format((Date)entryEndDate, (String)YYYY_MM_DD_FORMAT);
            String entryStr = String.format(ResManager.loadKDString((String)"\u91cd\u53e0\u7684\u8003\u52e4\u671f\u95f4\uff1a<br/>%1$s,%2$s-%3$s", (String)"AttPeriodBatchAddPlugin_19", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), periodCode, entryBeginDateStr, entryEndDateDateStr);
            msgrStr.add(entryStr);
            return;
        }
        int split = (left + right) / 2;
        JSONObject leftObject = entrys.getJSONObject(split);
        Date leftEndDate = leftObject.getDate("enddate");
        JSONObject rightObject = entrys.getJSONObject(split + 1);
        Date rightBeginDate = rightObject.getDate("begindate");
        if (periodBeginDate.getTime() <= leftEndDate.getTime()) {
            AttPeriodBatchAddPlugin.findConflictInterval(left, split, periodBeginDate, periodEndDate, msgrStr, entrys);
        }
        if (rightBeginDate.getTime() <= periodEndDate.getTime()) {
            AttPeriodBatchAddPlugin.findConflictInterval(split + 1, right, periodBeginDate, periodEndDate, msgrStr, entrys);
        }
    }

    private String isLastDayOfMonth(Date periodBeginDate, String secondPeriodDate) {
        if ("31".equals(secondPeriodDate)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(periodBeginDate);
            int actualMaximum = cal.getActualMaximum(5);
            secondPeriodDate = String.valueOf(actualMaximum);
        }
        return secondPeriodDate;
    }
}

