/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attperiod;

import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.enums.AttOperEnum;
import kd.wtc.wtbs.common.enums.DataEnable;
import kd.wtc.wtbs.common.enums.DataStatus;

public class AttPeriodList
extends HRDataBaseList {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("wtp_attperiod");

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            List qFilters = setFilterEvent.getQFilters();
            QFilter qFilter = new QFilter("status", "=", (Object)"C");
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilters.add(qFilter);
        }
        setFilterEvent.setOrderBy("modifytime desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if ("period-maintenance".equals(key)) {
            boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"wtp", (String)"wtp_attperiod", (String)AttOperEnum.ATT_SCHEDULE_EDIT.permItemId);
            if (!hasPerm) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u52e4\u5468\u671f\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttPeriodList_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRowCollection listSelectedRows = args.getListSelectedData();
            if (listSelectedRows != null && listSelectedRows.size() > 0) {
                ListSelectedRow listSelectedRow = listSelectedRows.get(0);
                DynamicObject dynamicObject = HELPER.loadSingle(listSelectedRow.getPrimaryKeyValue());
                String status = dynamicObject.getString("status");
                String enable = dynamicObject.getString("enable");
                if (DataEnable.DISABLED.getCode().equals(enable)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u7ef4\u62a4\u671f\u95f4\u6570\u636e\u3002", (String)"AttPeriodList_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (DataEnable.ENABLED.getCode().equals(enable)) {
                    BillShowParameter showParameter = new BillShowParameter();
                    String pkId = listSelectedRow.getPrimaryKeyValue().toString();
                    String pageId = this.getView().getPageCache().get(pkId);
                    if (!HRStringUtils.isEmpty((String)pageId)) {
                        showParameter.setPageId(pageId);
                    } else {
                        this.getView().getPageCache().put(pkId, showParameter.getPageId());
                    }
                    showParameter.setPkId(listSelectedRow.getPrimaryKeyValue());
                    showParameter.setFormId("wtp_attperiod");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setShowTitle(true);
                    String caption = ResManager.loadKDString((String)"\u8003\u52e4\u5468\u671f", (String)"AttPeriodList_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
                    showParameter.setCaption(caption);
                    HashMap<String, String> map = new HashMap<String, String>(2);
                    showParameter.setBillStatus(WTCHisService.transStatusToBillStaus((String)status));
                    showParameter.setStatus(OperationStatus.EDIT);
                    if (DataStatus.AUDIT.getCode().equals(status)) {
                        map.put("isShowMaintenance", "true");
                        showParameter.setCustomParams(map);
                    }
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        }
        if ("delete".equals(key)) {
            FormOperate formOperate = (FormOperate)args.getSource();
            formOperate.getOption().setVariableValue("ignorerefentityids", "wtp_attperiodentry,wtss_attperiodentryperson");
        }
    }
}

