/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attperiod;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridSetRowDataEvent;
import kd.bos.form.control.events.EntryGridSetRowDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.enums.DataEnable;
import kd.wtc.wtbs.common.enums.DataStatus;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.web.WTCSnapPlugin;
import kd.wtc.wtp.business.attperiod.AttPeriodService;
import kd.wtc.wtp.common.constants.attperiod.AttPeriodConstants;

public class AttPeriodPlugin
extends WTCSnapPlugin
implements HyperLinkClickListener,
EntryGridSetRowDataListener,
AttPeriodConstants,
EntryGridBindDataListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(AttPeriodPlugin.class);
    private static final String STATUS_A = "A";
    private static final String STATUS_B = "B";
    private static final String STATUS_C = "C";
    private static final String MHSA_ID = "mhsa.id";
    private static final String ADD_NEWENTRY = "newentry";
    private static final String CONFIRM = "confirm";
    private static final String OPERAT = "operat";
    private static final String SETROWDATA = "setRowData";
    private static final Set<String> NAMES = Sets.newHashSet((Object[])new String[]{"number", "nameprefix", "namemain", "namepostfix", "serialnumber"});

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"advcontoolbarap2"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("attperiodentry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addSetRowDataListener((EntryGridSetRowDataListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("mhsa");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        String enable = (String)this.getModel().getValue("enable");
        if (StringUtils.equals((CharSequence)"0", (CharSequence)enable)) {
            this.setEntryFieldEnableByStatus(false);
        } else {
            IPageCache pageCache = this.getPageCache();
            String enterWay = pageCache.get("attperiodentry");
            String status = this.getModel().getDataEntity().getString("status");
            if (!DataStatus.SAVE.getCode().equals(status) && SETROWDATA.equals(enterWay)) {
                this.setEntryFieldEnableByStatus(false);
            }
        }
    }

    public void entryGridSetRowData(EntryGridSetRowDataEvent e) {
        this.getPageCache().put("attperiodentry", SETROWDATA);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs afterDeleteRowEventArgs) {
        int entryRowCount = this.getModel().getEntryRowCount("attperiodentry");
        String status = this.getModel().getDataEntity().getString("status");
        if (entryRowCount == 0 && DataStatus.SAVE.getCode().equals(status)) {
            this.setLoopEnable(true);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs eventArgs) {
        int insertRow = eventArgs.getInsertRow();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("attperiodentry");
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dataEntity;
            if (insertRow <= i || (dataEntity = (DynamicObject)dynamicObjectCollection.get(i)) == null || !"1".equals(dataEntity.get("quotestatus"))) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5728\u5df2\u7ecf\u201c\u9501\u5b9a\u201d\u7684\u8003\u52e4\u671f\u95f4\u524d\u9762\u65b0\u589e\u8003\u52e4\u671f\u95f4\u3002", (String)"AttPeriodPlugin_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            this.getModel().deleteEntryRow("attperiodentry", insertRow);
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key = args.getProperty().getName();
        if (NAMES.contains(key)) {
            AttPeriodService.generatePeriodNameOrCode((String)key, (IDataModel)this.getModel());
        }
        if ("nameprefix".equals(key) || "namepostfix".equals(key)) {
            String msgPerfix = "namepostfix".equals(key) ? ResManager.loadKDString((String)"\u201c\u7f16\u7801\u540e\u7f00\u201d\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u53ca\u5305\u62ec\u201c@#$%^&*[]-_.\u201d\u5728\u5185\u7684\u7279\u6b8a\u5b57\u7b26\u3002", (String)"AttPeriodPlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u7f16\u7801\u524d\u7f00\u201d\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u53ca\u5305\u62ec\u201c@#$%^&*[]-_.\u201d\u5728\u5185\u7684\u7279\u6b8a\u5b57\u7b26\u3002", (String)"AttPeriodPlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            String string = this.getModel().getDataEntity().getString(key);
            if (!AttPeriodService.validateCodeOrName((String)string)) {
                this.getView().showErrorNotification(msgPerfix);
                string = "";
            }
            this.getModel().setValue(key, (Object)string);
        }
        if ("periodcode".equals(key) || "periodname".equals(key)) {
            this.validateDuplicateNameOrCode(args);
        }
        if ("looptype".equals(key)) {
            AttPeriodService.setLoopTypeMustInput((IFormView)this.getView(), (IDataModel)this.getModel());
        }
        if ("ascriptionyearview".equals(key)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("attperiodentry");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("attperiodentry").get(entryCurrentRowIndex);
            Date date = dynamicObject.getDate("ascriptionyearview");
            if (date == null) {
                this.getModel().setValue("ascriptionyear", null, entryCurrentRowIndex);
                return;
            }
            String yearStr = HRDateTimeUtils.format((Date)date, (String)"yyyy");
            this.getModel().setValue("ascriptionyear", (Object)yearStr, entryCurrentRowIndex);
        }
        if ("perioddays".equals(key)) {
            this.checkPerioddays();
        }
        this.validateEntryInfo(args);
    }

    private void validateEntryInfo(PropertyChangedArgs args) {
        String errorStatus;
        String key = args.getProperty().getName();
        if ("periodcode".equals(key)) {
            this.checkCode(args);
        }
        if (!("mhsa".equals(key) || "begindate".equals(key) || "enddate".equals(key) || "ascriptionyear".equals(key) || "ascriptionmonth".equals(key))) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("attperiodentry");
        AtomicBoolean temp = new AtomicBoolean(true);
        dynamicObjectCollection.forEach(dynamicObject -> {
            Date beginDate = dynamicObject.getDate("begindate");
            Date endDate = dynamicObject.getDate("enddate");
            if (beginDate == null || endDate == null) {
                temp.set(false);
                return;
            }
            int totalDays = AttPeriodService.calculateTotalDays((Date)beginDate, (Date)endDate) + 1;
            if (totalDays <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u586b\u5199,\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"AttPeriodPlugin_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            } else {
                dynamicObject.set("totaldays", (Object)totalDays);
            }
        });
        this.getView().updateView("attperiodentry");
        if (temp.get() && dynamicObjectCollection.size() > 1) {
            this.validateDate(dynamicObjectCollection);
        }
        if (("begindate".equals(key) || "enddate".equals(key) || "ascriptionyear".equals(key) || "ascriptionmonth".equals(key)) && StringUtils.isNotEmpty((CharSequence)(errorStatus = AttPeriodService.checkYearMouthExist((DynamicObjectCollection)dynamicObjectCollection)))) {
            this.getView().showErrorNotification(errorStatus);
        }
        if (("mhsa".contentEquals(key) || "begindate".equals(key)) && StringUtils.isNotEmpty((CharSequence)(errorStatus = AttPeriodService.checkDateAttributionRules((DynamicObjectCollection)dynamicObjectCollection)))) {
            this.getView().showErrorNotification(errorStatus);
        }
    }

    private void validateDuplicateNameOrCode(PropertyChangedArgs args) {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("attperiodentry");
        String attPeriodCode = this.getModel().getDataEntity().getString("number");
        String key = args.getProperty().getName();
        String value = (String)WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).map(ChangeData::getNewValue).orElse("");
        List seqList = dynamicObjectCollection.stream().filter(dynamic -> {
            String preValue = !"periodcode".equals(key) ? dynamic.getString("periodname") : dynamic.getString("periodcode");
            return StringUtils.isNotEmpty((CharSequence)preValue) && preValue.equals(value);
        }).map(dy -> dy.getString("seq")).collect(Collectors.toList());
        if (seqList.size() > 1) {
            String seqStr = String.join((CharSequence)",", seqList);
            if ("periodcode".equals(key)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8003\u52e4\u671f\u95f4\u7b2c%2$s\u884c\u671f\u95f4\u7f16\u7801\u91cd\u590d\"%3$s\"\u3002", (String)"AttPeriodPlugin_14", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), attPeriodCode, seqStr, value));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8003\u52e4\u671f\u95f4\u7b2c%2$s\u884c\u671f\u95f4\u540d\u5b57\u91cd\u590d\"%3$s\"\u3002", (String)"AttPeriodPlugin_15", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), attPeriodCode, seqStr, value));
            }
        }
    }

    private void checkCode(PropertyChangedArgs args) {
        String key = args.getProperty().getName();
        String value = (String)WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).map(ChangeData::getNewValue).orElse("");
        boolean tag = AttPeriodService.validateCodeOrName((String)value);
        if (!tag && "periodcode".equals(key)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u671f\u95f4\u7f16\u7801\u201d\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u53ca\u5305\u62ec\u201c@#$%^&*[]-_.\u201d\u5728\u5185\u7684\u7279\u6b8a\u5b57\u7b26\u3002", (String)"AttPeriodPlugin_7", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkPerioddays() {
        boolean flag;
        long periodDays = this.getModel().getDataEntity().getLong("perioddays");
        boolean bl = flag = periodDays < 1L || periodDays > 999L;
        if (flag) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u671f\u95f4\u5929\u6570\u8bf7\u8f93\u51651-999\u7684\u6b63\u6574\u6570\u3002", (String)"AttPeriodPlugin_8", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("perioddays", (Object)"");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals("maintain")) {
            String formId = this.getView().getEntityId();
            boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"wtp", (String)formId, (String)"4715a0df000000ac");
            if (!hasPerm) {
                return;
            }
            this.setMaintainButtonEnable(false);
            EntryAp ap = new EntryAp();
            ap.setKey("attperiodentry");
            ap.setHasOperateIcon(true);
            ap.setShowSeq(true);
            this.getView().updateControlMetadata(ap.getKey(), ap.createControl());
            this.getView().getFormShowParameter().getCustomParams().put("isShowMaintenance", "true");
            this.getView().updateView();
        } else if (key.equals("batchgenerate")) {
            boolean validate = AttPeriodService.validateBeforeBatchAdd((IFormView)this.getView(), (IDataModel)this.getModel());
            if (!validate) {
                return;
            }
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("attperiodentry");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                dynamicObjectCollection = new DynamicObjectCollection();
            }
            if (!(validate = this.validateDate(dynamicObjectCollection))) {
                return;
            }
            Map data = AttPeriodService.setDataBeforeBatchAdd((DynamicObject)this.getModel().getDataEntity(), (DynamicObjectCollection)((DynamicObjectCollection)dynamicObjectCollection.clone()));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setFormId("wtp_attperiodbatchadd");
            showParameter.setCustomParam("data", (Object)data);
            OpenStyle style = new OpenStyle();
            StyleCss cssValue = new StyleCss();
            cssValue.setWidth("859px");
            cssValue.setHeight("367px");
            style.setInlineStyleCss(cssValue);
            style.setShowType(ShowType.Modal);
            showParameter.setOpenStyle(style);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "data"));
            this.getView().showForm(showParameter);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("mhsa".equals(name)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("wtp_attperiod");
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("attperiodentry");
            DynamicObject object = (DynamicObject)dynamicObjectCollection.get(rowIndex);
            Date begindate = object.getDate("begindate");
            if (null == begindate) {
                return;
            }
            QFilter filter = new QFilter("firstbsed", "<=", (Object)begindate);
            evt.addCustomQFilter(filter);
        }
    }

    public void beforeBindData(EventObject evt) {
        DynamicObjectCollection dynamicObjectCollection;
        super.beforeBindData(evt);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        String status = this.getModel().getDataEntity().getString("status");
        boolean tag = DataStatus.AUDIT.getCode().equals(status) && !OperationStatus.ADDNEW.equals((Object)opStatus);
        this.setCollapse(tag);
        AttPeriodService.setLoopTypeMustInput((IFormView)this.getView(), (IDataModel)this.getModel());
        this.setMustInput("ascriptionyearview", Boolean.TRUE);
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String loopType = dynamicObject.getString("looptype");
        String useorgId = (String)this.getView().getFormShowParameter().getCustomParam("useorgId");
        if (StringUtils.isEmpty((CharSequence)useorgId) && null != this.getModel().getValue("useorg")) {
            String useOrgID = ((DynamicObject)this.getModel().getValue("useorg")).getPkValue().toString();
            this.getView().getFormShowParameter().setCustomParam("useorgId", (Object)useOrgID);
        }
        if (STATUS_A.equals(loopType)) {
            String periodDate = dynamicObject.getString("firstperioddate");
            dynamicObject.set("perioddate", (Object)periodDate);
        }
        if (!CollectionUtils.isEmpty((Collection)(dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("attperiodentry")))) {
            boolean flag = OperationStatus.ADDNEW.equals((Object)opStatus);
            this.setLoopEnable(flag);
            dynamicObjectCollection.sort(Comparator.comparing(ao -> ao.getDate("begindate"), Comparator.reverseOrder()));
            int index = 0;
            for (DynamicObject entry : dynamicObjectCollection) {
                try {
                    if (!OperationStatus.ADDNEW.equals((Object)opStatus)) {
                        this.setEntryEntityCodeEnable(dynamicObject, index);
                    }
                    ++index;
                    this.getView().getControl("attperiodentry");
                    String dateStr = entry.getString("ascriptionyear");
                    if (StringUtils.isEmpty((CharSequence)dateStr)) continue;
                    Date date = HRDateTimeUtils.parseDate((String)dateStr, (String)"yyyy");
                    entry.set("ascriptionyearview", (Object)date);
                }
                catch (ParseException parseException) {
                    logger.info(parseException.getMessage());
                    throw new KDBizException((Throwable)parseException, new ErrorCode("", parseException.getMessage()), new Object[0]);
                }
            }
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        String status = this.getModel().getDataEntity().getString("status");
        Map map = this.getView().getFormShowParameter().getCustomParams();
        boolean isSysPreset = this.getModel().getDataEntity().getBoolean("issyspreset");
        if (DataStatus.SAVE.getCode().equals(status) || OperationStatus.ADDNEW.equals((Object)opStatus) || "true".equals(map.get("isShowMaintenance"))) {
            this.setMaintainButtonEnable(false);
            this.setEntryFieldEnableByStatus(true);
            EntryAp ap = new EntryAp();
            ap.setKey("attperiodentry");
            ap.setHasOperateIcon(true);
            ap.setShowSeq(true);
            this.getView().updateControlMetadata(ap.getKey(), ap.createControl());
            this.getView().getFormShowParameter().getCustomParams().put("isShowMaintenance", "true");
        } else {
            this.setMaintainButtonEnable(true);
            this.setEntryFieldEnableByStatus(false);
            EntryAp ap = new EntryAp();
            ap.setKey("attperiodentry");
            ap.setShowSeq(true);
            ap.setHasOperateIcon(false);
            this.getView().updateControlMetadata(ap.getKey(), ap.createControl());
        }
        if (DataStatus.SAVE.getCode().equals(status) || DataStatus.SUBMIT.getCode().equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrysave"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrycancel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"maintain"});
        }
        this.getView().setEnable(Boolean.valueOf(!isSysPreset), new String[]{"maintain"});
        AttPeriodService.generatePeriodNameOrCode(null, (IDataModel)this.getModel());
        this.getModel().setDataChanged(false);
    }

    private void setCollapse(boolean flag) {
        Container infoContainer = (Container)this.getView().getControl("fieldsetpanelap1");
        infoContainer.setCollapse(flag);
        Container ruleContainer = (Container)this.getView().getControl("fieldsetpanelap");
        ruleContainer.setCollapse(flag);
    }

    public void setMaintainButtonEnable(boolean flag) {
        String enable = this.getModel().getDataEntity().getString("enable");
        if (DataEnable.DISABLED.getCode().equals(enable)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"maintain"});
            flag = true;
        } else {
            this.getView().setVisible(Boolean.valueOf(flag), new String[]{"maintain"});
        }
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{"batchgenerate"});
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{"addline"});
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{"deleteline"});
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{"entrysave"});
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{"entrycancel"});
    }

    private void setMustInput(String controlStr, Boolean mustInput) {
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(controlStr);
        fieldEdit.setMustInput(mustInput.booleanValue());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        int entryRowCount;
        Map data;
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        if (key.equals("data") && (data = (Map)closedCallBackEvent.getReturnData()) != null) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter table = new TableValueSetter(new String[0]);
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getEntryEntity("attperiodentry").clone();
            this.generateEntry(data, table, dynamicObjectCollection);
            dataModel.batchCreateNewEntryRow("attperiodentry", table);
            dataModel.updateCache();
            DynamicObjectCollection dynamicObjectCollection1 = this.getModel().getEntryEntity("attperiodentry");
            dynamicObjectCollection1.sort(Comparator.comparing(ao -> ao.getDate("begindate"), Comparator.reverseOrder()));
            if (dynamicObjectCollection != null) {
                int index = 0;
                for (DynamicObject dy : dynamicObjectCollection1) {
                    this.setEntryEntityCodeEnable(dy, index);
                    ++index;
                }
            }
            this.getModel().updateEntryCache(dynamicObjectCollection1);
            this.getView().updateView("attperiodentry");
            model.endInit();
        }
        if ((entryRowCount = this.getModel().getEntryRowCount("attperiodentry")) != 0) {
            this.setLoopEnable(false);
        }
    }

    private void generateEntry(Map<String, Object> data, TableValueSetter table, DynamicObjectCollection dynamicObjectCollection) {
        String yearMonth = "";
        int seq = 0;
        int number = (Integer)data.get("number");
        long mhsaId = (Long)data.get("defaultmhsa");
        String loopType = (String)data.get("looptype");
        Date beginDate = new Date();
        Date endDate = new Date();
        String periodDate = this.getModel().getDataEntity().getString("perioddate");
        Calendar endCalendar = Calendar.getInstance();
        Date periodBeginDate = (Date)data.get("periodbegindate");
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(periodBeginDate);
        Date beginTemp = null;
        Date endTemp = null;
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            dynamicObjectCollection.sort(Comparator.comparing(ao -> ao.getDate("begindate")));
            beginTemp = ((DynamicObject)dynamicObjectCollection.get(0)).getDate("begindate");
            endTemp = ((DynamicObject)dynamicObjectCollection.get(dynamicObjectCollection.size() - 1)).getDate("enddate");
        }
        int pos = 0;
        for (int i = 0; i < number; ++i) {
            switch (loopType) {
                case "A": {
                    beginDate = AttPeriodService.cycleMonth((Calendar)beginCalendar, (Calendar)endCalendar, (boolean)"31".equals(periodDate));
                    endDate = endCalendar.getTime();
                    break;
                }
                case "B": {
                    beginDate = AttPeriodService.cycleHalfMonth(data, (Calendar)beginCalendar);
                    endDate = AttPeriodService.getYesterday((Date)beginCalendar.getTime());
                    break;
                }
                case "C": {
                    beginDate = beginCalendar.getTime();
                    int periodNumber = (Integer)data.get("perioddays");
                    beginCalendar.add(5, periodNumber);
                    endDate = AttPeriodService.getYesterday((Date)beginCalendar.getTime());
                    break;
                }
            }
            if (!AttPeriodService.validateBeginEndDateSection((Date)beginTemp, (Date)endTemp, (Date)beginDate, (Date)endDate)) {
                ++pos;
                continue;
            }
            if (!this.validateQuoteStatus(dynamicObjectCollection, endDate)) {
                return;
            }
            TableValueSetter tableValueSetter = table.addRow(new Object[0]);
            tableValueSetter.set("mhsa", (Object)mhsaId, i - pos);
            tableValueSetter.set("begindate", (Object)beginDate, i - pos);
            tableValueSetter.set("enddate", (Object)endDate, i - pos);
            int totalDays = AttPeriodService.calculateTotalDays((Date)beginDate, (Date)endDate) + 1;
            tableValueSetter.set("totaldays", (Object)totalDays, i - pos);
            this.setAscriptionYearMonth(beginDate, endDate, data, tableValueSetter, i - pos);
            StringBuilder sb = new StringBuilder();
            sb.append(tableValueSetter.get("ascriptionyear", i - pos));
            sb.append(tableValueSetter.get("ascriptionmonth", i - pos));
            String tempYearMonth = sb.toString();
            if (yearMonth.equals(tempYearMonth)) {
                ++seq;
            } else {
                yearMonth = tempYearMonth;
                seq = 0;
            }
            this.setPeriodCodeAndName(beginDate, endDate, tableValueSetter, i - pos, seq);
        }
    }

    private boolean validateQuoteStatus(DynamicObjectCollection dynamicObjectCollection, Date endDate) {
        DynamicObject lastQuoteData;
        Date existEndDate;
        Optional<DynamicObject> quoteStatusOptional;
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection) && (quoteStatusOptional = dynamicObjectCollection.stream().filter(dy -> "1".equals(dy.get("quotestatus"))).max(Comparator.comparing(ee -> ee.getDate("enddate")))).isPresent() && !endDate.after(existEndDate = (lastQuoteData = quoteStatusOptional.get()).getDate("enddate"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5728\u5df2\u7ecf\u201c\u9501\u5b9a\u201d\u7684\u8003\u52e4\u671f\u95f4\u524d\u9762\u65b0\u589e\u8003\u52e4\u671f\u95f4\u3002", (String)"AttPeriodPlugin_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void setLoopEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"looptype"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"defaultmhsa"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"perioddate"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"firstperioddate"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"secondperioddate"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"loopbegindate"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"perioddays"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"nameprefix"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"namepostfix"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"namemain"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"serialnumber"});
    }

    public boolean validateDate(DynamicObjectCollection dynamicObjectCollection) {
        String errorStatus;
        ArrayList<Integer> emptyEntry = new ArrayList<Integer>(dynamicObjectCollection.size());
        for (DynamicObject entity : dynamicObjectCollection) {
            if (AttPeriodService.isEmptyEntry((DynamicObject)entity)) {
                emptyEntry.add(dynamicObjectCollection.indexOf((Object)entity));
                continue;
            }
            if (entity.get("begindate") != null && entity.get("enddate") != null) continue;
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u5df2\u6dfb\u52a0\u671f\u95f4\u7684\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4", (String)"AttPeriodPlugin_9", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!CollectionUtils.isEmpty(emptyEntry)) {
            Integer[] row = new Integer[emptyEntry.size()];
            emptyEntry.toArray(row);
            this.getModel().deleteEntryRows("attperiodentry", ArrayUtils.toPrimitive((Integer[])row));
        }
        if (null != (errorStatus = AttPeriodService.calculateDateConflict((DynamicObjectCollection)dynamicObjectCollection))) {
            this.getView().showErrorNotification(errorStatus);
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        int entryRowCount;
        String operateKey = ((FormOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "donothing-maintain": {
                    BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
                    if (!BillOperationStatus.EDIT.equals((Object)billStatus)) {
                        this.getView().setStatus(OperationStatus.EDIT);
                    }
                    this.setEntryFieldEnableByStatus(true);
                    break;
                }
                case "entrysave": 
                case "save": {
                    this.getView().getFormShowParameter().getCustomParams().put("isShowMaintenance", "false");
                    this.setMaintainButtonEnable(true);
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "submit": 
                case "audit": 
                case "submiteffect": 
                case "unsubmit": 
                case "unaudit": 
                case "disable": 
                case "enable": {
                    this.getView().updateView();
                    break;
                }
            }
            super.afterDoOperation(afterDoOperationEventArgs);
        }
        if ("deleteentry".equals(operateKey) && (entryRowCount = this.getModel().getEntryRowCount("attperiodentry")) == 0) {
            this.setLoopEnable(true);
        }
    }

    public void setAscriptionYearMonth(Date beginDate, Date endDate, Map<String, Object> data, TableValueSetter tableValueSetter, int index) {
        String timeRule = (String)data.get("timerule");
        Calendar calendar = Calendar.getInstance();
        switch (timeRule) {
            case "A": {
                calendar.setTime(beginDate);
                break;
            }
            case "B": {
                calendar.setTime(endDate);
                break;
            }
        }
        SimpleDateFormat year = new SimpleDateFormat("yyyy");
        SimpleDateFormat month = new SimpleDateFormat("MM");
        tableValueSetter.set("ascriptionyear", (Object)year.format(calendar.getTime()), index);
        tableValueSetter.set("ascriptionyearview", (Object)calendar.getTime(), index);
        tableValueSetter.set("ascriptionmonth", (Object)month.format(calendar.getTime()), index);
    }

    public void setPeriodCodeAndName(Date beginDate, Date endDate, TableValueSetter tableValueSetter, int index, int seq) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String namePrefix = dynamicObject.getString("nameprefix");
        String nameMain = dynamicObject.getString("namemain");
        String namePostfix = dynamicObject.getString("namepostfix");
        int serialNumber = dynamicObject.getInt("serialnumber");
        String name = AttPeriodService.generatePeriodCode((String)namePrefix, (String)nameMain, (String)namePostfix, (int)serialNumber, (int)seq, nameMainStr -> {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            switch (nameMainStr) {
                case "A": {
                    String year = (String)tableValueSetter.get("ascriptionyear", index);
                    String month = (String)tableValueSetter.get("ascriptionmonth", index);
                    nameMainStr = year + month;
                    break;
                }
                case "B": {
                    nameMainStr = sdf.format(beginDate);
                    break;
                }
                case "C": {
                    nameMainStr = sdf.format(endDate);
                    break;
                }
            }
            return nameMainStr;
        });
        tableValueSetter.set("periodname", (Object)name, index);
        tableValueSetter.set("periodcode", (Object)name, index);
    }

    private void setEntryFieldEnableByStatus(boolean flag) {
        int entryRowCount = this.getModel().getEntryRowCount("attperiodentry");
        for (int index = 0; index < entryRowCount; ++index) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("attperiodentry", index);
            if (flag && dynamicObject.getBoolean("quotestatus")) {
                this.setEntryEntityFieldEnable(Boolean.FALSE, index);
                continue;
            }
            this.setEntryEntityFieldEnable(flag, index);
        }
    }

    private void setEntryEntityFieldEnable(Boolean flag, int index) {
        this.getView().setEnable(flag, index, new String[]{"periodname", "begindate", "enddate", "mhsa", "ascriptionyear", "ascriptionyearview", "ascriptionmonth"});
    }

    private void setEntryEntityCodeEnable(DynamicObject entry, int index) {
        if (entry.getLong("id") != 0L) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"periodcode"});
        } else {
            this.getView().setEnable(Boolean.TRUE, index, new String[]{"periodcode"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int rowCont;
        boolean hasPerm;
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String formId = this.getView().getEntityId();
        this.getPageCache().put("attperiodentry", OPERAT);
        if ("delete".equals(operateKey)) {
            formOperate.getOption().setVariableValue("ignorerefentityids", "wtp_attperiodentry,wtss_attperiodentryperson");
        }
        if ("entrysave".equals(operateKey) && !(hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"wtp", (String)formId, (String)"4715a0df000000ac"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u52e4\u5468\u671f\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttPeriodPlugin_10", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            boolean validate = AttPeriodService.validateBeforeBatchAdd((IFormView)this.getView(), (IDataModel)this.getModel());
            if (!validate) {
                args.setCancel(true);
                return;
            }
            if ("save".equals(operateKey)) {
                this.getModel().setDataChanged(true);
                OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
                String permItemId = OperationStatus.ADDNEW.equals((Object)opStatus) ? "47156aff000000ac" : "4715a0df000000ac";
                boolean hasPerm2 = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"wtp", (String)formId, (String)permItemId);
                if (!hasPerm2) {
                    String msg = OperationStatus.ADDNEW.equals((Object)opStatus) ? ResManager.loadKDString((String)"\u65e0\u201c\u8003\u52e4\u5468\u671f\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttPeriodPlugin_11", (String)"wtc-wtp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65e0\u201c\u8003\u52e4\u5468\u671f\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttPeriodPlugin_10", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(msg);
                    args.setCancel(true);
                    return;
                }
            }
        }
        AttPeriodService.checkPeriodDays((BeforeDoOperationEventArgs)args, (String)operateKey, (IFormView)this.getView());
        super.beforeDoOperation(args);
        if ("refresh".equals(operateKey)) {
            EntryAp ap = new EntryAp();
            ap.setKey("attperiodentry");
            ap.setHasOperateIcon(true);
            ap.setShowSeq(true);
            this.getView().updateControlMetadata(ap.getKey(), ap.createControl());
            this.getView().getFormShowParameter().getCustomParams().put("isShowMaintenance", "false");
            this.getView().updateView();
        }
        if ((rowCont = this.getModel().getEntryRowCount("attperiodentry")) > 0 && ADD_NEWENTRY.equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("attperiodentry");
            entryGrid.setPageIndex(1);
            this.getModel().createNewEntryRow("attperiodentry", 0, null);
            this.getModel().updateCache();
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("attperiodentry");
            for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
                this.setEntryEntityCodeEnable((DynamicObject)dynamicObjectCollection.get(index), index);
            }
            args.setCancel(true);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs args) {
        String confirm;
        EntryProp entryProp = args.getEntryProp();
        String name = "";
        if (null != entryProp) {
            name = entryProp.getName();
        }
        if (!"true".equals(confirm = (String)this.getView().getFormShowParameter().getCustomParam(CONFIRM)) && "attperiodentry".equals(name)) {
            int[] rowIndexs = args.getRowIndexs();
            boolean checkTag = this.checkEmptyEntry(rowIndexs);
            args.setCancel(checkTag);
            if (!this.checkPerAttPeriod(rowIndexs)) {
                return;
            }
            if (!this.checkQuoteStatus(rowIndexs)) {
                return;
            }
            if (checkTag && !"false".equals(confirm)) {
                String msg = ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u62e9%s\u6761\u8bb0\u5f55\uff0c\u5220\u9664\u540e\u4e0d\u53ef\u6062\u590d\uff0c\u786e\u5b9a\u7ee7\u7eed?", (String)"AttPeriodPlugin_12", (String)"wtc-wtp-formplugin", (Object[])new Object[]{args.getRowIndexs().length});
                String selRowStr = SerializationUtils.toJsonString((Object)args.getRowIndexs());
                this.getPageCache().put("selRows", selRowStr);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("deleteentry", (IFormPlugin)this));
            }
        }
    }

    private boolean checkPerAttPeriod(int[] rowIndexs) {
        DynamicObjectCollection entryDys = this.getModel().getDataEntity().getDynamicObjectCollection("attperiodentry");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_perattperiod");
        List selectDys = Arrays.stream(rowIndexs).mapToObj(arg_0 -> entryDys.get(arg_0)).collect(Collectors.toList());
        Map<Object, String> map = selectDys.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy.getString("periodname"), (a, b) -> b));
        DynamicObject[] perPeriodDys = helper.queryOriginalArray("periodentry", new QFilter[]{new QFilter("periodentry", "in", map.keySet())});
        if (perPeriodDys != null && perPeriodDys.length > 0) {
            List existsPeriodEntryIdList = Arrays.stream(perPeriodDys).map(perPeriodDy -> perPeriodDy.getLong("periodentry")).distinct().collect(Collectors.toList());
            StringJoiner joiner = new StringJoiner("\u3001");
            int size = existsPeriodEntryIdList.size();
            for (int i = 0; i < size && i != 3; ++i) {
                Long existsPeriodEntryId = (Long)existsPeriodEntryIdList.get(i);
                joiner.add(WTCStringUtils.joinStr((String[])new String[]{"\u201c", map.get(existsPeriodEntryId), "\u201d"}));
            }
            String joinTips = joiner.toString();
            if (existsPeriodEntryIdList.size() <= 3) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8003\u52e4\u671f\u95f4%s\u5df2\u88ab\u4eba\u5458\u8003\u52e4\u671f\u95f4\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AttPeriodPlugin_16", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), joinTips));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8003\u52e4\u671f\u95f4%s\u7b49\u5df2\u88ab\u4eba\u5458\u8003\u52e4\u671f\u95f4\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AttPeriodPlugin_17", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), joinTips));
            }
            return false;
        }
        return true;
    }

    private boolean checkQuoteStatus(int[] indexs) {
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getEntryEntity("attperiodentry").clone();
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return false;
        }
        for (int value : indexs) {
            DynamicObject entity = (DynamicObject)dynamicObjectCollection.get(value);
            if (!entity.getBoolean("quotestatus")) continue;
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u5df2\u7ecf\u88ab\u9501\u5b9a\u7684\u8003\u52e4\u671f\u95f4\u3002", (String)"AttPeriodPlugin_13", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkEmptyEntry(int[] indexs) {
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getEntryEntity("attperiodentry").clone();
        for (int value : indexs) {
            DynamicObject entity = (DynamicObject)dynamicObjectCollection.get(value);
            if (AttPeriodService.isEmptyEntry((DynamicObject)entity)) continue;
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)"deleteentry", (String)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                String selRowStr = this.getPageCache().get("selRows");
                List selRows = SerializationUtils.fromJsonStringToList((String)selRowStr, Integer.class);
                this.getView().getFormShowParameter().setCustomParam(CONFIRM, (Object)"true");
                this.getModel().deleteEntryRows("attperiodentry", selRows.stream().mapToInt(Integer::intValue).toArray());
                int entryRowCount = this.getModel().getEntryRowCount("attperiodentry");
                String status = this.getModel().getDataEntity().getString("status");
                if (entryRowCount == 0 && DataStatus.SAVE.getCode().equals(status)) {
                    this.setLoopEnable(true);
                }
            } else if (MessageBoxResult.Cancel.equals((Object)result)) {
                HRPageCache pageCache = new HRPageCache(this.getView());
                pageCache.put("isCancel", (Object)Boolean.TRUE);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if ("mhsa".equals(hyperLinkClickEvent.getFieldName())) {
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getEntryEntity("attperiodentry").clone();
            DynamicObject entity = (DynamicObject)dynamicObjectCollection.get(hyperLinkClickEvent.getRowIndex());
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)entity.getLong(MHSA_ID));
            showParameter.setFormId("wtp_mhsascription");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowTitle(true);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

