/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attperiod;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attperiod.PeriodSyncFormService;
import kd.wtc.wtp.business.attperiod.task.model.PeriodTaskRepVo;
import kd.wtc.wtp.constants.attperiod.PerAttPeriodKDString;

public class AttPeriodSyncPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Object fromNumber = formShowParameter.getCustomParam("customHREntityNumber");
        if (fromNumber == null || WTCStringUtils.isEmpty((String)String.valueOf(fromNumber))) {
            formShowParameter.setCustomParam("customHREntityNumber", (Object)"wtp_perattperiod");
            formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"attfilevid.affiliateadminorg");
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit baseDataEdit = (BasedataEdit)this.getControl("attfilevid");
        baseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit orgEdit = (OrgEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean isSuccess;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        boolean bl = isSuccess = args.getOperationResult() != null && args.getOperationResult().isSuccess();
        if (isSuccess && "confirm".equals(operateKey)) {
            PeriodTaskRepVo periodTaskRepVo = this.getPerPeriodTaskRepVo();
            WTCTaskForm wtcTaskForm = this.genWTCTaskForm(periodTaskRepVo);
            WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)wtcTaskForm.getCloseCallBack(), (String)wtcTaskForm.getCaption(), (String)"wtp_period", (Object)wtcTaskForm);
        }
    }

    private WTCTaskForm genWTCTaskForm(PeriodTaskRepVo periodTaskRepVo) {
        WTCTaskForm taskForm = new WTCTaskForm();
        taskForm.setType("wtp_period");
        taskForm.setCaption(WTCStringUtils.joinStr((String[])new String[]{PerAttPeriodKDString.periodSynTaskName(), "-", periodTaskRepVo.getVersion()}));
        taskForm.setCanStop(true);
        taskForm.setCanBackground(true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "task");
        taskForm.setCloseCallBack(closeCallBack);
        taskForm.setClickClassName("kd.wtc.wtp.formplugin.web.attperiod.PeriodTaskClick");
        HashMap params = Maps.newHashMapWithExpectedSize((int)10);
        params.put("PerPeriodTaskRepVo", SerializationUtils.serializeToBase64((Object)periodTaskRepVo));
        taskForm.setCustomParams((Map)params);
        return taskForm;
    }

    private PeriodTaskRepVo getPerPeriodTaskRepVo() {
        DynamicObject pageDy = this.getModel().getDataEntity();
        Set attFileVidSet = pageDy.getDynamicObjectCollection("attfilevid").stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toSet());
        PeriodTaskRepVo periodTaskRepVo = new PeriodTaskRepVo();
        periodTaskRepVo.setAttFileVidSet(attFileVidSet);
        periodTaskRepVo.setDescription(pageDy.getString("description"));
        periodTaskRepVo.setOrgId(Long.valueOf(pageDy.getLong("org.id")));
        String number = CodeRuleServiceHelper.getNumber((String)"wtp_periodtask", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"wtp_periodtask"), null);
        periodTaskRepVo.setVersion(number);
        long taskId = DB.genGlobalLongId();
        periodTaskRepVo.setTaskId(Long.valueOf(taskId));
        this.getPageCache().put("taskId", String.valueOf(taskId));
        return periodTaskRepVo;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        HasPermOrgResult allPermOrgs;
        String propertyName = event.getProperty().getName();
        if ("attfilevid".equals(propertyName)) {
            long orgId = this.getModel().getDataEntity().getLong("org.id");
            QFilter qFilter = new QFilter("org", "=", (Object)orgId);
            ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
        } else if ("org".equals(propertyName) && !(allPermOrgs = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs("wtam", "wtp_perattperiod")).hasAllOrgPerm()) {
            QFilter qFilter = new QFilter("id", "in", (Object)allPermOrgs.getHasPermOrgs());
            ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("task".equals(actionId)) {
            PeriodSyncFormService.getInstance().periodTaskEndCloseBack(this.getPageCache(), this.getView(), (IFormPlugin)this, false);
        } else if ("showdetailcallback".equals(actionId)) {
            Object returnData = event.getReturnData();
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

