/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attperiod;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileBusiness;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attperiod.PeriodServiceHelper;
import kd.wtc.wtp.business.attperiod.PeriodSyncFormService;
import kd.wtc.wtp.constants.attperiod.PerAttPeriodKDString;

public class PerAttPeriodList
extends HRDataBaseList {
    private static final String SELECT_FIELD_NAME = "attfilevid_name";
    private static final String SELECT_PERIOD_NAME = "period_name";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("attfileid.id".equals(fieldName)) {
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"attfilevid.affiliateadminorg");
            this.getView().cacheFormShowParameter();
            List qfilters = args.getQfilters();
            QFilter qFilter = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(UserServiceHelper.getCurrentUserId()), "wtam", "wtp_perattperiod", "attfilevid", "47150e89000000ac", null);
            qfilters.add(qFilter);
            QFilter orgQFilter = AttFileHelper.getAttFileF7OrgFilter((String)"wtam", (String)"wtp_perattperiod");
            qfilters.add(orgQFilter);
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        setFilterEvent.setOrderBy("number desc");
        List qFilters = setFilterEvent.getQFilters();
        if (qFilters != null) {
            for (QFilter qFilter : qFilters) {
                DynamicObject fileDy;
                List dynamicObjects;
                if (qFilter == null || !"attfileid.id".equals(qFilter.getProperty())) continue;
                Object value = qFilter.getValue();
                if (value instanceof List && !CollectionUtils.isEmpty((Collection)((List)value)) && !CollectionUtils.isEmpty((Collection)(dynamicObjects = AttFileQueryServiceImpl.getInstance().queryAttFileByIds("boid", (List)value)))) {
                    List collect = dynamicObjects.stream().map(d -> d.getLong("boid")).collect(Collectors.toList());
                    qFilter.__setValue(collect);
                }
                if (!(value instanceof Long) || 0L == (Long)value || (fileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFile("boid", value)) == null) continue;
                qFilter.__setValue((Object)fileDy.getLong("boid"));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate && "delete".equals(operateKey = ((FormOperate)args.getSource()).getOperateKey()) && !this.deleteValidate()) {
            args.setCancel(true);
        }
    }

    private boolean deleteValidate() {
        if (this.checkPerPeriodStateInfo()) {
            return false;
        }
        if (this.existReferences()) {
            return false;
        }
        return !this.checkPerPeriodContinuity();
    }

    private boolean existReferences() {
        List<DynamicObject> perAttPeriodDys = this.queryListData(new PerAttPeriodQueryParam(), String.join((CharSequence)",", "id", "attperson.name", "periodentry.name"));
        Map<Object, DynamicObject> perPeriodMap = perAttPeriodDys.stream().collect(Collectors.toMap(dy -> dy.get("id"), dy -> dy, (a, b) -> a));
        List list = PeriodServiceHelper.getInstance().checkPerAttPeriodReferences(this.getSelectedRows().getPrimaryKeyValues(), true);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (Object object : list) {
                DynamicObject perPeriodDy = perPeriodMap.get(object);
                if (perPeriodDy == null) continue;
                String errorTips = String.format(PerAttPeriodKDString.perPeriodHasBeenReference(), perPeriodDy.getString("attperson.name"), perPeriodDy.getString("periodentry.name"));
                this.getView().showErrorNotification(errorTips);
                return true;
            }
        }
        return false;
    }

    private boolean checkPerPeriodStateInfo() {
        this.getSelectedRows().getEntryPrimaryKeyValues();
        List<DynamicObject> perAttPeriodDys = this.queryListData(new PerAttPeriodQueryParam(), String.join((CharSequence)",", "id", "attfileid", "startdate", "enddate", "attperson.name", "periodentry.name"));
        List fileBoIds = perAttPeriodDys.stream().map(dy -> dy.getLong("attfileid")).collect(Collectors.toList());
        Map wtteInfoMap = (Map)WTCServiceHelper.invokeBizService((String)"wtc", (String)"wtp", (String)"IAttStateInfoService", (String)"queryAttStateInfoByFileBoId", (Object[])new Object[]{fileBoIds});
        for (DynamicObject dy2 : perAttPeriodDys) {
            long attFileId = dy2.getLong("attfileid");
            Map map = (Map)wtteInfoMap.get(attFileId);
            Date perPeriodStartDate = dy2.getDate("startdate");
            Date perPeriodEndDate = dy2.getDate("enddate");
            if (perPeriodStartDate == null || perPeriodEndDate == null) continue;
            String errorTips = String.format(PerAttPeriodKDString.perPeriodHasBeenSettled(), dy2.getString("attperson.name"), dy2.getString("periodentry.name"));
            Date frozenStartDate = (Date)map.get("frozenstartdate");
            Date frozenEndDate = (Date)map.get("frozenenddate");
            if (frozenStartDate != null && frozenEndDate != null && perPeriodStartDate.compareTo(frozenEndDate) < 0 && perPeriodEndDate.compareTo(frozenStartDate) > 0) {
                this.getView().showErrorNotification(errorTips);
                return true;
            }
            Date lockToDate = (Date)map.get("lockto");
            if (lockToDate != null && perPeriodStartDate.compareTo(lockToDate) < 0) {
                this.getView().showErrorNotification(errorTips);
                return true;
            }
            Date storageToDate = (Date)map.get("storageto");
            if (storageToDate == null || perPeriodStartDate.compareTo(storageToDate) >= 0) continue;
            this.getView().showErrorNotification(errorTips);
            return true;
        }
        return false;
    }

    private boolean checkPerPeriodContinuity() {
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        List<DynamicObject> perAttPeriodDys = this.queryListData(queryParam, String.join((CharSequence)",", "id", "attfileid", "startdate", "enddate"));
        Set attFileIdSet = perAttPeriodDys.stream().map(perAttPeriodDy -> perAttPeriodDy.getLong("attfileid")).collect(Collectors.toSet());
        queryParam.setExtendQFilter(null);
        queryParam.setAttFileBoIdSet(attFileIdSet);
        List allPerAttPeriodDys = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodDy(queryParam);
        Map<Long, List<DynamicObject>> allFilePerPeriodMap = allPerAttPeriodDys.stream().collect(Collectors.groupingBy(dy -> dy.getLong("attfileid")));
        HashMap fileMaxDateMap = Maps.newHashMapWithExpectedSize((int)allFilePerPeriodMap.size());
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : allFilePerPeriodMap.entrySet()) {
            List<DynamicObject> list = mapEntry.getValue();
            list.sort(Comparator.comparing(dy -> dy.getDate("startdate")));
            long maxDateId = list.get(list.size() - 1).getLong("id");
            fileMaxDateMap.put(mapEntry.getKey(), maxDateId);
        }
        Map<Long, List<DynamicObject>> filePerPeriodMap = perAttPeriodDys.stream().collect(Collectors.groupingBy(perAttPeriodDy -> perAttPeriodDy.getLong("attfileid")));
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : filePerPeriodMap.entrySet()) {
            List<DynamicObject> list = mapEntry.getValue();
            if (CollectionUtils.isEmpty(list)) continue;
            list.sort(Comparator.comparing(dy -> dy.getDate("startdate")));
            long currentMaxDateId = list.get(list.size() - 1).getLong("id");
            if (currentMaxDateId != (Long)fileMaxDateMap.get(mapEntry.getKey())) {
                this.getView().showErrorNotification(PerAttPeriodKDString.onlyDeleteLasePerPeriod());
                return true;
            }
            for (int i = 1; i < list.size(); ++i) {
                Date preEndDate = list.get(i - 1).getDate("enddate");
                Date currentStartDate = list.get(i).getDate("startdate");
                if (WTCDateUtils.daysBetween((Date)currentStartDate, (Date)preEndDate) == -1) continue;
                this.getView().showErrorNotification(PerAttPeriodKDString.onlyDeleteLasePerPeriod());
                return true;
            }
        }
        return false;
    }

    private List<DynamicObject> queryListData(PerAttPeriodQueryParam queryParam, String join) {
        queryParam.setExtendQFilter(new QFilter("id", "in", (Object)this.getSelectedRows().getPrimaryKeyValues()));
        queryParam.setProperties(join);
        return PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodDy(queryParam);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "synattperiod": {
                this.showAttPeriodSynForm();
                break;
            }
            case "periodsynlog": {
                this.showPeriodSynResult();
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String orgIdStr = (String)this.getView().getFormShowParameter().getCustomParam("perAttPeriodListDefaultOrg");
        for (FilterColumn commonFilterColumn : args.getCommonFilterColumns()) {
            String fieldName;
            switch (fieldName = commonFilterColumn.getFieldName()) {
                case "attfilevid.org.name": {
                    if (!WTCStringUtils.isNotEmpty((String)orgIdStr)) break;
                    commonFilterColumn.setDefaultValue(orgIdStr);
                    break;
                }
                case "busistatus": {
                    String usableStatus = (String)this.getView().getFormShowParameter().getCustomParam("usablestatus");
                    if ("-1".equals(usableStatus)) {
                        commonFilterColumn.setDefaultValues(new Object[]{"0", "1"});
                        break;
                    }
                    commonFilterColumn.setDefaultValue("1");
                    break;
                }
                case "startdate": {
                    String startDateStr = (String)this.getView().getFormShowParameter().getCustomParam("startDateStr");
                    String endDateStr = (String)this.getView().getFormShowParameter().getCustomParam("endDateStr");
                    if (!HRStringUtils.isNotEmpty((String)startDateStr) || !HRStringUtils.isNotEmpty((String)endDateStr)) break;
                    commonFilterColumn.setDefaultValues(new Object[]{startDateStr, endDateStr});
                    break;
                }
                case "attfileid.name": {
                    Object customParam = this.getView().getFormShowParameter().getCustomParam("attfile");
                    if (Objects.isNull(customParam)) break;
                    List list = JSONArray.parseArray((String)((String)this.getView().getFormShowParameter().getCustomParam("attfile")), Object.class);
                    list = list.stream().map(String::valueOf).collect(Collectors.toList());
                    commonFilterColumn.setDefaultValues(list);
                    break;
                }
            }
        }
    }

    private void showPeriodSynResult() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("wtp_periodsynresult");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setPageId(WTCStringUtils.joinStr((String[])new String[]{this.getView().getPageId(), "wtp_periodsynresult"}));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showAttPeriodSynForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wtp_attperiodsyn");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showdetailcallback"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("showdetailcallback".equals(actionId)) {
            Object returnData = event.getReturnData();
            if (returnData != null) {
                String queryFields = String.join((CharSequence)",", "periodsyntask.id", "periodsyntask.taskstatus", "number", "id");
                DynamicObject resultDy = PeriodServiceHelper.getInstance().getPeriodSynTask(new QFilter("periodsyntask", "=", returnData), queryFields);
                PeriodSyncFormService.getInstance().showTaskDetail(resultDy, "periodsyntask_runattperson", this.getView());
            }
            ((IListView)this.getView()).refresh();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if (SELECT_FIELD_NAME.equals(fieldName)) {
            DynamicObject dynamicObject = this.fillRowPkIdAndGetDyObject(args, "attfilevid.id");
            AttFileBusiness.showAttFileDetailForm((IFormView)this.getView(), (IFormPlugin)this, null, (Object)dynamicObject.getLong("attfilevid.id"));
        } else if (SELECT_PERIOD_NAME.equals(fieldName)) {
            DynamicObject dy = this.fillRowPkIdAndGetDyObject(args, "period.id");
            if (null == dy) {
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)dy.getLong("period.id"));
            showParameter.setFormId("wtp_attperiod");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowTitle(true);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private DynamicObject fillRowPkIdAndGetDyObject(HyperLinkClickArgs args, String filedName) {
        args.setCancel(true);
        IListView listView = (IListView)this.getView();
        Object focusRowPkId = listView.getFocusRowPkId();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_perattperiod");
        return hrBaseServiceHelper.queryOne(filedName, focusRowPkId);
    }
}

