/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attperiod;

import com.alibaba.fastjson.JSONArray;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskEntity;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;
import kd.wtc.wtp.business.attperiod.PeriodServiceHelper;
import kd.wtc.wtp.business.attperiod.PeriodSyncFormService;
import kd.wtc.wtp.business.attperiod.task.PeriodSyncTaskParamService;
import kd.wtc.wtp.common.constants.attperiod.PerAttPeriodConstants;
import kd.wtc.wtp.constants.attperiod.PerAttPeriodKDString;

public class PerAttPeriodSynDetailPlugin
extends HRDataBaseEdit
implements TabSelectListener,
PerAttPeriodConstants {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        tabAp.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        this.initPageData();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("task");
        if (null == taskId) {
            taskId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("taskStr"));
        }
        String version = this.getModel().getDataEntity().getString("periodsynresult.number");
        String exportName = PerAttPeriodKDString.periodSynName() + "_" + version + "_" + LocalDate.now();
        ListShowParameter param = new ListShowParameter();
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(tabKey);
        param.setCustomParam("task", (Object)taskId);
        param.setCustomParam("tabKey", (Object)tabKey);
        param.setCustomParam("exportName", (Object)exportName);
        param.setShowTitle(false);
        param.setBillFormId("wtp_pertaskdetailquery");
        param.setFormId("wtbs_rimlesslist");
        this.getView().getPageCache().put("pageId", param.getPageId());
        this.getView().showForm((FormShowParameter)param);
        this.getView().updateView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "rerunall": 
            case "rerunselect": 
            case "export": 
            case "exportdetails": 
            case "viewperattperiod": {
                IFormView tabView = this.getView().getView(this.getView().getPageCache().get("pageId"));
                boolean isAuthChanged = WTCPermUtils.isViewAuthChanged((IFormView)tabView, (IFormView)this.getView());
                if (!isAuthChanged) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            List ids = (List)this.getCache().get("idset", List.class);
            switch (operateKey) {
                case "rerunall": {
                    this.executeTask(null, true);
                    break;
                }
                case "rerunselect": {
                    if (CollectionUtils.isEmpty((Collection)ids)) {
                        this.getView().showTipNotification(PerAttPeriodKDString.selectOneMore());
                        return;
                    }
                    this.executeTask(ids, false);
                    break;
                }
                case "export": {
                    IFormView pageView = this.getView().getView(this.getView().getPageCache().get("pageId"));
                    pageView.invokeOperation("exportlist");
                    this.getView().sendFormAction(pageView);
                    break;
                }
                case "exportdetails": {
                    IFormView detailPage = this.getView().getView(this.getView().getPageCache().get("pageId"));
                    detailPage.getFormShowParameter().setAppId("wtam");
                    detailPage.invokeOperation("exportdetails");
                    this.getView().sendFormAction(detailPage);
                    break;
                }
                case "viewperattperiod": {
                    if (CollectionUtils.isEmpty((Collection)ids)) {
                        this.getView().showTipNotification(PerAttPeriodKDString.selectOneMore());
                        return;
                    }
                    this.showPerAttPeriod(ids);
                    break;
                }
            }
        }
    }

    private void showPerAttPeriod(List<Long> ids) {
        DynamicObject periodSynResultDy = this.getModel().getDataEntity().getDynamicObject("periodsynresult");
        if (periodSynResultDy == null) {
            return;
        }
        long taskId = this.getModel().getDataEntity().getLong("task.id");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_periodtaskdetail");
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId).and(new QFilter("id", "in", ids));
        DynamicObject[] taskDetails = helper.query("attfileboid.id", new QFilter[]{qFilter});
        if (taskDetails.length < 1) {
            this.getView().showErrorNotification(PerAttPeriodKDString.noExistAttFile());
            return;
        }
        Set attFileBoIds = Arrays.stream(taskDetails).map(dy -> dy.getLong("attfileboid.id")).collect(Collectors.toSet());
        long orgId = periodSynResultDy.getLong("org.id");
        String pageId = this.getView().getPageId() + "wtp_perattperiod" + orgId;
        Date startDate = periodSynResultDy.getDate("startdate");
        Date endDate = periodSynResultDy.getDate("enddate");
        HashMap subCustomParams = Maps.newHashMapWithExpectedSize((int)16);
        if (null != startDate) {
            subCustomParams.put("startDateStr", startDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate().toString());
        }
        if (null != endDate) {
            subCustomParams.put("endDateStr", endDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate().toString());
        }
        subCustomParams.put("attfile", JSONArray.toJSONString(attFileBoIds));
        this.getView().showForm((FormShowParameter)PerAttPeriodDataService.getInstance().showPerAttPeriod(pageId, (Map)subCustomParams, Collections.emptySet()));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("task".equals(actionId)) {
            PeriodSyncFormService.getInstance().periodTaskEndCloseBack(this.getPageCache(), this.getView(), (IFormPlugin)this, false);
        } else if ("showdetailcallback".equals(actionId)) {
            Object returnData = event.getReturnData();
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            }
            if (returnData != null) {
                String queryFields = String.join((CharSequence)",", "periodsyntask.id", "periodsyntask.taskstatus", "number", "id");
                DynamicObject resultDy = PeriodServiceHelper.getInstance().getPeriodSynTask(new QFilter("periodsyntask", "=", returnData), queryFields);
                PeriodSyncFormService.getInstance().showTaskDetail(resultDy, "periodsyntask_runattperson", this.getView());
            }
            this.getView().close();
        }
    }

    private void executeTask(List<Long> ids, boolean isAll) {
        Set reRunFileVidSet;
        long taskId = this.getModel().getDataEntity().getLong("task.id");
        Date startDate = this.getModel().getDataEntity().getDate("periodsynresult.startdate");
        Date endDate = this.getModel().getDataEntity().getDate("periodsynresult.enddate");
        long orgId = this.getModel().getDataEntity().getLong("periodsynresult.org.id");
        String version = this.getModel().getDataEntity().getString("periodsynresult.number");
        WTCTaskRepository tieTaskRepository = WTCTaskInstanceHelper.getRepository((String)"wtp_period");
        WTCTaskEntity wtcTaskEntity = tieTaskRepository.loadTaskByTaskId(taskId, WTCTaskRepository.NO_CUSTOM_CONDITION);
        long creatorId = wtcTaskEntity.getCreatorId();
        long currUserId = RequestContext.get().getCurrUserId();
        if (creatorId == 0L || creatorId != currUserId) {
            this.getView().showTipNotification(PerAttPeriodKDString.onlyRunOwnTask());
            return;
        }
        if (isAll) {
            reRunFileVidSet = PeriodServiceHelper.getInstance().getReRunFileVidByTaskId((Object)taskId, null);
        } else {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_periodtaskdetail");
            QFilter qFilter = new QFilter("taskid", "=", (Object)taskId).and(new QFilter("id", "in", ids));
            DynamicObject[] taskDetails = helper.query("attfileboid.id", new QFilter[]{qFilter});
            if (taskDetails.length < 1) {
                this.getView().showErrorNotification(PerAttPeriodKDString.noExistAttFile());
                return;
            }
            Set attFileBoIds = Arrays.stream(taskDetails).map(dy -> dy.getLong("attfileboid.id")).collect(Collectors.toSet());
            reRunFileVidSet = PeriodServiceHelper.getInstance().getReRunFileVidByTaskId((Object)taskId, attFileBoIds);
        }
        if (reRunFileVidSet == null || reRunFileVidSet.size() == 0) {
            this.getView().showErrorNotification(PerAttPeriodKDString.allFileDoNotHavePermissionTips());
            return;
        }
        String desc = PerAttPeriodKDString.reRun() + version;
        WTCTaskForm taskForm = PeriodSyncTaskParamService.getInstance().genWTCTaskForm(reRunFileVidSet, startDate, endDate, desc, Long.valueOf(orgId), (IFormPlugin)this);
        WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)taskForm.getCloseCallBack(), (String)taskForm.getCaption(), (String)"wtp_period", (Object)taskForm);
    }

    private void initPageData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String tabKey = (String)parameter.getCustomParam("tabKey");
        Tab tab = (Tab)this.getView().getControl("tabap");
        Long taskId = (Long)parameter.getCustomParam("task");
        if (null == taskId) {
            taskId = Long.valueOf((String)parameter.getCustomParam("taskStr"));
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_periodtask");
        DynamicObject task = helper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        TabPage joinPage = (TabPage)tab.getItems().get(0);
        String text = PerAttPeriodKDString.runAttFileCaption();
        joinPage.setText(new LocaleString(text + "\uff08" + task.getLong("runattfile") + "\uff09"));
        TabPage successPage = (TabPage)tab.getItems().get(1);
        String successText = PerAttPeriodKDString.successCaption();
        successPage.setText(new LocaleString(successText + "\uff08" + task.getLong("succeedattfile") + "\uff09"));
        TabPage failPage = (TabPage)tab.getItems().get(2);
        String failText = PerAttPeriodKDString.failCaption();
        failPage.setText(new LocaleString(failText + "\uff08" + task.getLong("failedattfile") + "\uff09"));
        TabPage noRunPage = (TabPage)tab.getItems().get(3);
        String noRunText = PerAttPeriodKDString.noRunAttFileCaption();
        noRunPage.setText(new LocaleString(noRunText + "\uff08" + task.getLong("notrunattfile") + "\uff09"));
        if (HRStringUtils.isNotEmpty((String)tabKey)) {
            tab.activeTab(tabKey);
        } else {
            tab.activeTab("runtab");
        }
        HRBaseServiceHelper resultHelper = new HRBaseServiceHelper("wtp_periodsynresult");
        DynamicObject result = resultHelper.loadDynamicObject(new QFilter[]{new QFilter("periodsyntask.id", "=", (Object)taskId)});
        this.getModel().setValue("periodsynresult", result.get("id"));
        this.getModel().setValue("task", (Object)taskId);
    }

    private HRPageCache getCache() {
        return new HRPageCache(this.getPageCache());
    }
}

