/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attperiod;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtp.business.attperiod.PeriodServiceHelper;
import kd.wtc.wtp.business.attperiod.PeriodSyncFormService;
import kd.wtc.wtp.business.attperiod.task.PeriodSyncTaskParamService;
import kd.wtc.wtp.common.constants.attperiod.PerAttPeriodConstants;
import kd.wtc.wtp.constants.attperiod.PerAttPeriodKDString;
import kd.wtc.wtp.utils.PerAttPeriodUtils;

public class PerAttPeriodSynResultList
extends HRDataBaseList
implements PerAttPeriodConstants {
    public void setFilter(SetFilterEvent event) {
        event.setOrderBy("periodsyntask.startdate desc, number desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows == null || rows.isEmpty()) {
                    return rows;
                }
                DynamicSimpleProperty prop = new DynamicSimpleProperty();
                prop.setName("costtime");
                ((DynamicObject)rows.get(0)).getDataEntityType().getProperties().add((Object)prop);
                rows.forEach(row -> {
                    long cost = row.getLong("periodsyntask.timecost");
                    String timeStr = PerAttPeriodUtils.msFormat((long)cost);
                    row.set("costtime", (Object)timeStr);
                });
                return rows;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            String operateKey;
            switch (operateKey = args.getOperateKey()) {
                case "taskdetail": {
                    this.genShowPeriodSynTaskDetail();
                    break;
                }
                case "rerun": {
                    this.reGenPeriodTaskSynTask();
                    break;
                }
                case "terminate": {
                    this.stopPeriodTaskSynTask();
                    break;
                }
            }
        }
    }

    private void stopPeriodTaskSynTask() {
        if (this.checkSelectedRows()) {
            return;
        }
        if (PeriodSyncFormService.getInstance().reRunAndStopValidate(this.getFocusRowPkId(), this.getView(), Collections.singletonList(WTCTaskStatus.RUNNING.getCode()), PerAttPeriodKDString.onlyStopRunningTaskTips(), false)) {
            return;
        }
        DynamicObject taskDy = PeriodServiceHelper.getInstance().getPeriodSynTaskByTaskId(this.getFocusRowPkId(), "periodsyntask.id");
        if (taskDy != null) {
            WTCDistributeTaskHelper.terminateTask((long)taskDy.getLong("periodsyntask.id"), (String)"wtp_period");
            this.getView().showMessage(PerAttPeriodKDString.terminatingSuccessTips());
            ((IListView)this.getView()).refresh();
        }
    }

    private void reGenPeriodTaskSynTask() {
        if (this.checkSelectedRows()) {
            return;
        }
        List<String> statusList = Arrays.asList(WTCTaskStatus.ALL_FINISHED.getCode(), WTCTaskStatus.TERMINATED.getCode());
        if (PeriodSyncFormService.getInstance().reRunAndStopValidate(this.getFocusRowPkId(), this.getView(), statusList, PerAttPeriodKDString.onlyReRunFinishedAndTerminatedTaskTips(), true)) {
            return;
        }
        String queryFields = String.join((CharSequence)",", "number", "periodsyntask.id", "org.id");
        DynamicObject taskDy = PeriodServiceHelper.getInstance().getPeriodSynTaskByTaskId(this.getFocusRowPkId(), queryFields);
        Set reRunFileVidSet = PeriodServiceHelper.getInstance().getReRunFileVidByTaskId(taskDy.get("periodsyntask.id"), null);
        if (reRunFileVidSet == null || reRunFileVidSet.size() == 0) {
            this.getView().showErrorNotification(PerAttPeriodKDString.allFileDoNotHavePermissionTips());
            return;
        }
        String description = String.format(PerAttPeriodKDString.reRunSuccessDescription(), taskDy.getString("number"));
        WTCTaskForm wtcTaskForm = PeriodSyncTaskParamService.getInstance().genWTCTaskForm(reRunFileVidSet, null, null, description, Long.valueOf(taskDy.getLong("org.id")), (IFormPlugin)this);
        WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)wtcTaskForm.getCloseCallBack(), (String)wtcTaskForm.getCaption(), (String)"wtp_period", (Object)wtcTaskForm);
    }

    private boolean checkSelectedRows() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(PerAttPeriodKDString.selectRowMoreThanOneTips());
            return true;
        }
        return false;
    }

    public void genShowPeriodSynTaskDetail() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_periodsynresult");
        DynamicObject resultDy = helper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", this.getFocusRowPkId())});
        if (resultDy != null) {
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setCaption(PerAttPeriodKDString.taskCaption() + resultDy.getString("number"));
            parameter.setPageId(this.getView().getPageId() + "wtp_periodsynresult" + resultDy.getString("id"));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("wtp_periodtask");
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setPkId((Object)resultDy.getLong("periodsyntask.id"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fieldName = args.getFieldName();
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long rowId = (Long)clickEvent.getCurrentRow().getPrimaryKeyValue();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_periodsynresult");
        DynamicObject resultDy = helper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)rowId)});
        if (resultDy != null) {
            PeriodSyncFormService.getInstance().showTaskDetail(resultDy, fieldName, this.getView());
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("task".equals(actionId)) {
            PeriodSyncFormService.getInstance().periodTaskEndCloseBack(this.getPageCache(), this.getView(), (IFormPlugin)this, true);
        } else if ("showdetailcallback".equals(actionId)) {
            Object returnData = event.getReturnData();
            if (returnData != null) {
                String queryFields = String.join((CharSequence)",", "periodsyntask.id", "periodsyntask.taskstatus", "number", "id");
                DynamicObject resultDy = PeriodServiceHelper.getInstance().getPeriodSynTask(new QFilter("periodsyntask", "=", returnData), queryFields);
                PeriodSyncFormService.getInstance().showTaskDetail(resultDy, "periodsyntask_runattperson", this.getView());
            }
            ((IListView)this.getView()).refresh();
        }
    }
}

