/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.busitrip;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class TripBaseSetEdit
extends HRDataBaseEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initApplySpanComboEdit();
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String name;
        switch (name = evt.getProperty().getName()) {
            case "advanceunit": 
            case "advancenumber": {
                this.updateval("advancenumber", "advanceunit");
                break;
            }
            case "lateadvanceunit": 
            case "lateadvancenumber": {
                this.updateval("lateadvancenumber", "lateadvanceunit");
                break;
            }
            case "afterunit": 
            case "afternumber": {
                this.updateval("afternumber", "afterunit");
                break;
            }
            case "unit": {
                this.getModel().setValue("applyspan", null);
                this.initApplySpanComboEdit();
            }
        }
    }

    private void initApplySpanComboEdit() {
        String unit = this.getModel().getDataEntity().getString("unit");
        ComboEdit applySpan = (ComboEdit)this.getControl("applyspan");
        if ("A".equals(unit)) {
            ComboEdit applySpanItems = (ComboEdit)this.getControl("applyspanday");
            ComboProp comboProp = (ComboProp)applySpanItems.getProperty();
            applySpan.setComboItems(this.parseMapToComboItem(comboProp.getComboItems()));
        } else if ("B".equals(unit)) {
            ComboEdit applySpanItems = (ComboEdit)this.getControl("applyspanhour");
            ComboProp comboProp = (ComboProp)applySpanItems.getProperty();
            applySpan.setComboItems(this.parseMapToComboItem(comboProp.getComboItems()));
        }
    }

    private List<ComboItem> parseMapToComboItem(List<ValueMapItem> valueMapItems) {
        ArrayList propertyItems = Lists.newArrayListWithExpectedSize((int)valueMapItems.size());
        for (ValueMapItem valueMapItem : valueMapItems) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(valueMapItem.getValue());
            comboItem.setCaption(valueMapItem.getName());
            propertyItems.add(comboItem);
        }
        return propertyItems;
    }

    private void updateval(String name, String fieldAdvanceOrAfterUnit) {
        BigDecimal afterOrAdvanceNum = this.getModel().getDataEntity().getBigDecimal(name);
        String targetVal = this.getModel().getDataEntity().getString(fieldAdvanceOrAfterUnit);
        if (!HRStringUtils.equals((String)"C", (String)targetVal) && afterOrAdvanceNum != null && afterOrAdvanceNum.compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue(name, null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5728\u8003\u52e4\u671f\u95f4\u6761\u4ef6\u4e0b\uff0c\u53ef\u5c06\u6700\u5927\u671f\u9650\u6570\u8bbe\u7f6e\u4e3a0\u3002", (String)"TripBaseSetEdit_01", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Object obj = dataEntity.get("travelminnumber");
        if (obj == null) {
            dataEntity.set("travelminnumber", (Object)0);
        }
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "saveandnew": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                Object max = dataEntity.get("travelmaxnumber");
                if (max != null && obj != null) {
                    BigDecimal minBigDecimal = dataEntity.getBigDecimal("travelminnumber");
                    BigDecimal maxBigDecimal = dataEntity.getBigDecimal("travelmaxnumber");
                    if (maxBigDecimal.compareTo(BigDecimal.ZERO) != 0 && minBigDecimal.compareTo(maxBigDecimal) > 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6700\u5927{0}\u65f6\u957f\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u6700\u5c0f{1}\u65f6\u957f\u201d\u3002", (String)"TripBaseSetEdit_02", (String)"wtc-wtp-formplugin", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName(), BillTypeEnum.EVECTIONBILL.getBillName()}));
                        args.setCancel(true);
                        return;
                    }
                }
                if (max == null) {
                    dataEntity.set("travelmaxnumber", (Object)0);
                }
                this.setDefault(dataEntity, "advancenumber");
                this.setDefault(dataEntity, "lateadvancenumber");
                this.setDefault(dataEntity, "afternumber");
                break;
            }
        }
    }

    private void setDefault(DynamicObject dataEntity, String key) {
        Object value = dataEntity.get(key);
        if (value == null) {
            dataEntity.set(key, (Object)0);
        }
    }
}

