/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.busitrip;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.web.attitem.AttItemFilterHelper;
import kd.wtc.wtbs.common.enums.WTCCommonMessages;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.predata.wtbd.PreDataAttItem;
import kd.wtc.wtbs.common.predata.wtbd.PreDataOtTimeSource;
import kd.wtc.wtbs.common.predata.wtbd.PreDataTravelType;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtbs.formplugin.web.WTCDateRangeNohisEdit;
import kd.wtc.wtbs.wtbd.common.attitem.AttItemItemType;
import kd.wtc.wtbs.wtbd.common.attitem.AttItmeDataTypeEnum;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.business.ruleenging.RulePreviewUtil;
import kd.wtc.wtp.formplugin.utils.WTPMultiLangUtils;

public class TripRuleCalRulePlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final Map<Long, Map<String, Long>> TRAVEL_TYPE_MAPPING = Maps.newHashMapWithExpectedSize((int)2);

    public void beforeBindData(EventObject e) {
        JSONObject model;
        super.beforeBindData(e);
        String createOrgId = (String)this.getView().getFormShowParameter().getCustomParam("createorg");
        if (StringUtils.isNotBlank((CharSequence)createOrgId)) {
            this.getModel().setValue("createorg", (Object)Long.valueOf(createOrgId));
        }
        if (Objects.nonNull(model = (JSONObject)this.getView().getFormShowParameter().getCustomParam("model"))) {
            this.getModel().setValue("createorg", model.get((Object)"createorg"));
            this.getModel().setValue("traveltype", (Object)this.getBaseDataId(model, "traveltype"));
            this.getModel().setValue("travelmeter", (Object)this.getBaseDataId(model, "travelmeter"));
            this.getModel().setValue("travelchange", (Object)this.getBaseDataId(model, "travelchange"));
            this.getModel().setValue("travelsystem", (Object)this.getBaseDataId(model, "travelsystem"));
            TargetCondition dateRangeTargetCondition = (TargetCondition)this.getView().getControl("daterangtargetconditionap");
            dateRangeTargetCondition.setValue(model.getString("daterangecondition"));
            this.getModel().setValue("calculdes", model.get((Object)"calculdes"));
            this.getModel().setValue("limitscope", model.get((Object)"limitscope"));
            this.getModel().setValue("originalprj", (Object)this.getBaseDataId(model, "originalatt"));
            this.getModel().setValue("tripsource", (Object)this.getBaseDataId(model, "tripsource"));
            this.getModel().setValue("bfroundingrule", (Object)this.getBaseDataId(model, "roundrule"));
            this.getModel().setValue("resultprj", (Object)this.getBaseDataId(model, "roundatt"));
            TargetCondition targetCondition = (TargetCondition)this.getView().getControl("targetconditionap");
            targetCondition.setValue((String)this.getModel().getValue("limitscope"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        if ("save".equals(((AbstractOperate)evt.getSource()).getOperateKey())) {
            boolean validConditionResult;
            Object editIndexObj;
            boolean haveSame = false;
            Object tpType = this.getModel().getValue("traveltype");
            if (tpType == null) {
                evt.setCancel(true);
                return;
            }
            long travelTypeId = ((DynamicObject)this.getModel().getValue("traveltype")).getLong("id");
            if (!"editrow".equals(this.getView().getFormShowParameter().getCloseCallBack().getActionId())) {
                Long[] chosenIds = WTCFormUtils.getChosenIds((IFormView)this.getView().getParentView(), (String)"traveltype");
                if (Arrays.stream(chosenIds).anyMatch(id -> id == travelTypeId)) {
                    haveSame = true;
                }
            } else if ("editrow".equals(this.getView().getFormShowParameter().getCloseCallBack().getActionId()) && (editIndexObj = this.getView().getFormShowParameter().getCustomParam("editIndex")) != null) {
                ArrayList list = Lists.newArrayListWithExpectedSize((int)4);
                Integer entryCurrentRowIndex = null;
                if (editIndexObj instanceof Integer) {
                    entryCurrentRowIndex = (Integer)editIndexObj;
                } else if (editIndexObj instanceof String) {
                    entryCurrentRowIndex = Integer.parseInt((String)editIndexObj);
                }
                IFormView parentView = this.getView().getParentView();
                if (parentView != null && entryCurrentRowIndex != null) {
                    DynamicObjectCollection entryEntity = parentView.getModel().getEntryEntity("entryentity");
                    for (int index = 0; index < entryEntity.size(); ++index) {
                        if (index == entryCurrentRowIndex) continue;
                        list.add(((DynamicObject)entryEntity.get(index)).getDynamicObject("traveltype").getLong("id"));
                    }
                    if (list.contains(travelTypeId)) {
                        haveSame = true;
                    }
                }
            }
            if (haveSame) {
                evt.setCancel(true);
                this.getView().showTipNotification(WTPMultiLangUtils.loadKDString("\u5df2\u5b58\u5728\u8be5{0}\u7c7b\u578b\u7684\u89c4\u5219\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", "TravelRuleEdit_3", BillTypeEnum.EVECTIONBILL.getBillName()));
                return;
            }
            TargetCondition dateCondition = (TargetCondition)this.getView().getControl("daterangtargetconditionap");
            String dateRangeJson = dateCondition.getValue();
            if (dateRangeJson != null) {
                if (dateRangeJson.length() > 2000) {
                    this.getView().showTipNotification(WTPMultiLangUtils.loadKDString("\u5b57\u6bb5\u201c\u65e5\u671f\u8303\u56f4\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,2000]\u3002", "TravelRuleEdit_5"));
                    evt.setCancel(true);
                    return;
                }
                if (dateRangeJson.contains("is_or_isSub")) {
                    this.getView().showTipNotification(ExKDStringHelper.gradeDateError());
                    evt.setCancel(true);
                    return;
                }
            }
            if (!(validConditionResult = WTCDateRangeNohisEdit.validCondition((IFormView)this.getView(), (BeforeDoOperationEventArgs)evt, (String)dateRangeJson))) {
                return;
            }
            this.getModel().setValue("calculname", (Object)RulePreviewUtil.getConditionPreviewStr((String)dateRangeJson));
            this.getModel().setValue("daterangecondition", (Object)dateRangeJson);
            String value = ((TargetCondition)this.getView().getControl("targetconditionap")).getValue();
            if (!HRStringUtils.isEmpty((String)value)) {
                if (value.length() > 2000) {
                    this.getView().showTipNotification(WTPMultiLangUtils.loadKDString("\u5b57\u6bb5\u201c\u9650\u5b9a\u6761\u4ef6\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,2000]\u3002", "TravelRuleEdit_6"));
                    evt.setCancel(true);
                    return;
                }
                if (value.contains("is_or_isSub")) {
                    this.getView().showTipNotification(ExKDStringHelper.gradeLimitError());
                    evt.setCancel(true);
                    return;
                }
                RuleValidateInfo info = RuleValidateUtil.validCondition((String)value, (boolean)true);
                if (info.isSuccess()) {
                    String conditionPreviewStr = RulePreviewUtil.getConditionPreviewStr((String)value);
                    this.getModel().setValue("calculdes", (Object)conditionPreviewStr);
                    this.getModel().setValue("limitscope", (Object)value);
                } else {
                    evt.setCancel(true);
                    this.getView().showTipNotification(String.join((CharSequence)",", info.getMsgList()));
                }
            } else {
                this.getModel().setValue("calculdes", (Object)"");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "save".equals(operateKey)) {
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((BasedataEdit)this.getControl("travelmeter")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("travelchange")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("travelsystem")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("originalprj")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("resultprj")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit tripSource = (BasedataEdit)this.getView().getControl("tripsource");
        if (tripSource != null) {
            tripSource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((Control)event.getSource()).getKey();
        if (HRStringUtils.equals((String)"tripsource", (String)key)) {
            ArrayList<Long> ids = new ArrayList<Long>(2);
            ids.add(PreDataOtTimeSource.PD_1010_S);
            ids.add(PreDataOtTimeSource.PD_1020_S);
            QFilter qFilter = new QFilter("id", "in", ids);
            event.addCustomQFilter(qFilter);
            return;
        }
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"originalprj", "resultprj"})) {
            DynamicObject orgAttItem = this.getModel().getDataEntity().getDynamicObject("originalprj");
            DynamicObject resAttItem = this.getModel().getDataEntity().getDynamicObject("resultprj");
            ArrayList<Long> ids = new ArrayList<Long>(4);
            if (Objects.nonNull(orgAttItem)) {
                ids.add((Long)orgAttItem.getPkValue());
            }
            if (Objects.nonNull(resAttItem)) {
                ids.add((Long)resAttItem.getPkValue());
            }
            event.addCustomQFilter(new QFilter("id", "not in", ids));
            QFilter qFilter = StringUtils.equals((CharSequence)key, (CharSequence)"originalprj") ? AttItemFilterHelper.dataTypeFilter(Collections.singletonList(AttItmeDataTypeEnum.DUTATION.typeVal)).and(AttItemFilterHelper.issaveQFilter((boolean)true).and(AttItemFilterHelper.itemtypeQFilter((String[])new String[]{AttItemItemType.DETAIL_ITEM.type, AttItemItemType.DETAIL_SUM_ITEM.type})).or(AttItemFilterHelper.issaveQFilter((boolean)false))) : AttItemFilterHelper.dataTypeFilter(Collections.singletonList(AttItmeDataTypeEnum.DUTATION.typeVal)).and(AttItemFilterHelper.issaveQFilter((boolean)true)).and(AttItemFilterHelper.itemtypeQFilter((String[])new String[]{AttItemItemType.DETAIL_ITEM.type, AttItemItemType.DETAIL_SUM_ITEM.type}));
            event.addCustomQFilter(qFilter);
        }
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"travelmeter", "travelchange", "originalprj", "resultprj"})) {
            Date date = WTCDateUtils.str2Date((String)((String)this.getView().getFormShowParameter().getCustomParam("bsed")), null);
            if (date == null) {
                this.getView().showTipNotification(WTCCommonMessages.BSED_EMPTY.load());
                event.setCancel(true);
                return;
            }
            List<QFilter> filters = Arrays.asList(new QFilter("id", "!=", (Object)this.getBaseDataId(this.getModel(), key)), new QFilter("firstbsed", "<=", (Object)date));
            event.setCustomQFilters(filters);
        } else if ("travelsystem".equals(key)) {
            List<QFilter> filters = Collections.singletonList(new QFilter("type", "=", (Object)"TP"));
            event.setCustomQFilters(filters);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Date ruleDate;
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if ("ruledate".equals(name) && (ruleDate = (Date)this.getModel().getValue("ruledate")) != null) {
            ((TargetCondition)this.getView().getControl("targetconditionap")).setDate(HRDateTimeUtils.format((Date)ruleDate, (String)"yyyy-MM-dd"));
            this.getModel().setValue("ruledate", null);
        }
        if ("traveltype".equals(name)) {
            this.handleChangeType(args);
        }
    }

    private void handleChangeType(PropertyChangedArgs args) {
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        DynamicObject newValue = (DynamicObject)args.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            return;
        }
        Long type = newValue.getLong("id");
        if (PreDataTravelType.PRESET_ARR.contains(type)) {
            Map<String, Long> attendItem = TRAVEL_TYPE_MAPPING.get(type);
            this.getModel().setValue("originalprj", (Object)attendItem.get("originalprj"));
            this.getModel().setValue("resultprj", (Object)attendItem.get("resultprj"));
        }
    }

    private Long getBaseDataId(JSONObject model, String key) {
        JSONObject object = model.getJSONObject(key);
        return object == null ? null : object.getLong("id");
    }

    private Long getBaseDataId(IDataModel model, String key) {
        DynamicObject object = model.getDataEntity().getDynamicObject(key);
        return object == null ? null : Long.valueOf(object.getLong("id"));
    }

    static {
        HashMap<String, Long> inCountry = new HashMap<String, Long>(16);
        inCountry.put("originalprj", PreDataAttItem.PD_BT_1010_S);
        inCountry.put("resultprj", PreDataAttItem.PD_BT_1020_S);
        HashMap<String, Long> outCountry = new HashMap<String, Long>(16);
        outCountry.put("originalprj", PreDataAttItem.PD_BT_1030_S);
        outCountry.put("resultprj", PreDataAttItem.PD_BT_1040_S);
        TRAVEL_TYPE_MAPPING.put(PreDataTravelType.PD_1010_S, inCountry);
        TRAVEL_TYPE_MAPPING.put(PreDataTravelType.PD_1020_S, outCountry);
    }
}

