/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.busitrip;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.formplugin.utils.WTPMultiLangUtils;
import kd.wtc.wtp.formplugin.web.filter.WTPValidate;

public class TripRuleEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private final Set<String> SET_UN_CHANGE_FIELD = Sets.newHashSet((Object[])new String[]{"daterangecondition", "limitscope"});

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long boId = (Long)customParams.get("boid");
        this.getModel().setDataChanged(false);
        String hisAction = (String)customParams.get("his_action");
        boolean isNewVersion = HRStringUtils.equals((String)"open_insert_new_data_page", (String)hisAction);
        if (isNewVersion) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData("entryentity");
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (WTPValidate.validateSave(operateKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (entryEntity.stream().anyMatch(this::isNullRow) || entryEntity.isEmpty()) {
                this.getView().showTipNotification(WTPMultiLangUtils.loadKDString("\u8ba1\u7b97\u89c4\u5219\u4e2d\u81f3\u5c11\u9700\u8981\u6dfb\u52a0\u4e00\u884c\u6570\u636e\u3002", "TravelRuleEdit_1"));
                args.setCancel(true);
                return;
            }
            Date ruleBsEd = (Date)this.getModel().getValue("bsed");
            for (DynamicObject dynamicObject : entryEntity) {
                boolean bsedFlag = this.judgeBsEd(ruleBsEd, dynamicObject, "originalatt", args);
                if (!bsedFlag) {
                    return;
                }
                bsedFlag = this.judgeBsEd(ruleBsEd, dynamicObject, "roundatt", args);
                if (!bsedFlag) {
                    return;
                }
                bsedFlag = this.judgeBsEd(ruleBsEd, dynamicObject, "travelmeter", args);
                if (!bsedFlag) {
                    return;
                }
                bsedFlag = this.judgeBsEd(ruleBsEd, dynamicObject, "travelchange", args);
                if (bsedFlag) continue;
                return;
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"addrow")) {
            args.setCancel(true);
            Date date = this.getModel().getDataEntity().getDate("bsed");
            if (date == null) {
                this.getView().showTipNotification(WTPMultiLangUtils.loadKDString("\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", "TravelRuleEdit_2"));
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setFormId("wtp_tripcalculrule");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addrow"));
            formShowParameter.setCustomParam("bsed", (Object)date);
            String orgId = String.valueOf(this.getModel().getDataEntity().getDynamicObject("createorg").getPkValue());
            formShowParameter.setCustomParam("createorg", (Object)orgId);
            this.getView().showForm(formShowParameter);
        } else if (HRStringUtils.equals((String)operateKey, (String)"copyrow")) {
            args.setCancel(true);
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
            if (ObjectUtils.isEmpty((Object)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TravelRuleEdit_09", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectedRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"TravelRuleEdit_10", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                return;
            }
            int entryCurrentRowIndex = selectedRows[0];
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(entryCurrentRowIndex);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setFormId("wtp_tripcalculrule");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addrow"));
            formShowParameter.setCustomParam("model", (Object)dynamicObject);
            formShowParameter.setCustomParam("bsed", (Object)this.getModel().getDataEntity().getDate("bsed"));
            this.getView().showForm(formShowParameter);
        } else if (HRStringUtils.equals((String)operateKey, (String)"editrow")) {
            args.setCancel(true);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(entryCurrentRowIndex);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.setFormId("wtp_tripcalculrule");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editrow"));
            formShowParameter.setCustomParam("model", (Object)dynamicObject);
            formShowParameter.setCustomParam("bsed", (Object)this.getModel().getDataEntity().getDate("bsed"));
            formShowParameter.setCustomParam("editIndex", (Object)entryCurrentRowIndex);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        DynamicObject returnData = (DynamicObject)evt.getReturnData();
        String actionId = evt.getActionId();
        if (("addrow".equals(actionId) || "editrow".equals(actionId)) && returnData != null) {
            int row = "addrow".equals(actionId) ? this.getModel().createNewEntryRow("entryentity") : this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("traveltype", returnData.get("traveltype"), row);
            this.getModel().setValue("calculname", returnData.get("calculname"), row);
            this.getModel().setValue("daterangecondition", returnData.get("daterangecondition"), row);
            this.getModel().setValue("calculdes", returnData.get("calculdes"), row);
            this.getModel().setValue("limitscope", returnData.get("limitscope"), row);
            this.getModel().setValue("travelmeter", returnData.get("travelmeter"), row);
            this.getModel().setValue("travelchange", returnData.get("travelchange"), row);
            this.getModel().setValue("travelsystem", returnData.get("travelsystem"), row);
            this.getModel().setValue("originalatt", returnData.get("originalprj"), row);
            this.getModel().setValue("tripsource", returnData.get("tripsource"), row);
            this.getModel().setValue("roundrule", returnData.get("bfroundingrule"), row);
            this.getModel().setValue("roundatt", returnData.get("resultprj"), row);
        }
    }

    private boolean judgeBsEd(Date ruleBsEd, DynamicObject entry, String key, BeforeDoOperationEventArgs args) {
        Date firstEffDate;
        DynamicObject hisDy = entry.getDynamicObject(key);
        if (hisDy != null && ruleBsEd != null && (firstEffDate = hisDy.getDate("firstbsed")) != null && firstEffDate.after(ruleBsEd)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"{0}\u89c4\u5219\u5173\u8054\u914d\u7f6e\u70b9\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u8be5\u89c4\u5219\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TravelRuleEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean isNullRow(DynamicObject dynamicObject) {
        return this.isNull(dynamicObject.get("daterangecondition"));
    }

    private boolean isNull(Object ... obj) {
        for (Object o : obj) {
            if (!Objects.isNull(o)) continue;
            return true;
        }
        return false;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBeforeF7("originalatt", "roundatt");
        EntryGrid formulaEntryGrid = (EntryGrid)this.getView().getControl("entryentity");
        formulaEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void addBeforeF7(String ... signs) {
        for (String sign : signs) {
            BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl(sign);
            if (!Objects.nonNull(fieldEdit)) continue;
            fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        listShowParameter.setMultiSelect(false);
        Date startDate = this.getModel().getDataEntity().getDate("bsed");
        if (Objects.isNull(startDate)) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"AttendPlanEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        } else {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("firstbsed", "<", (Object)startDate).or("firstbsed", "=", (Object)startDate));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("traveltype".equals(fieldName)) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(hyperLinkClickEvent.getRowIndex());
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setFormId("wtp_tripcalculrule");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewrow"));
            formShowParameter.setCustomParam("model", (Object)dynamicObject);
            this.getView().showForm(formShowParameter);
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        beforeClosedEvent.setSkipNoField(true);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        List collectionProperties = properties.getCollectionProperties(false);
        for (ICollectionProperty collectionProperty : collectionProperties) {
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(collectionProperty.getName());
            DataEntityPropertyCollection treeEntryProperties = entryColl.getDynamicObjectType().getProperties();
            for (String propKey : this.SET_UN_CHANGE_FIELD) {
                IDataEntityProperty property = (IDataEntityProperty)treeEntryProperties.get((Object)propKey);
                if (property == null) continue;
                entryColl.forEach(entry -> entry.getDataEntityState().setBizChanged(property.getOrdinal(), false));
            }
        }
    }
}

