/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.coordination;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.RuleCondition;
import kd.bos.ext.hr.ruleengine.controls.RuleResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.ruleenging.RuleEngingService;

public class CoordinationRuleEngingPlugin
extends HRDynamicFormBasePlugin {
    private RuleCondition getRuleCondition() {
        return (RuleCondition)this.getControl("ruleconditionap");
    }

    private RuleResult getRuleResult() {
        return (RuleResult)this.getControl("ruleresultap");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String sceneId = (String)parameter.getCustomParam("sceneId");
        this.getRuleCondition().setScene(sceneId);
        this.getRuleResult().setScene(sceneId);
        Map customParams = parameter.getCustomParams();
        if (customParams.containsKey("edit")) {
            this.getRuleCondition().setValue((String)parameter.getCustomParam("condition"));
            this.getRuleResult().setValue((String)parameter.getCustomParam("result"));
            this.getModel().setValue("name", parameter.getCustomParam("name"));
            this.getModel().setValue("number", parameter.getCustomParam("number"));
        } else {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"wtp_coordinationconf");
            dynamicObject.set("createtime", (Object)WTCDateUtils.getMaxEndDate());
            String code = CodeRuleServiceHelper.getNumber((String)"wtp_coordinationconf", (DynamicObject)dynamicObject, null);
            this.getModel().setValue("name", (Object)code);
            this.getModel().setValue("number", (Object)code);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object customParam = this.getView().getFormShowParameter().getCustomParam("status");
        String pageState = customParam == null ? "EDIT" : customParam.toString().toUpperCase().trim();
        this.getRuleCondition().setPageState(pageState);
        this.getRuleResult().setPageState(pageState);
        if ("EDIT".equals(pageState)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"close"});
        } else if ("VIEW".equals(pageState)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"confirm", "cancel"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "confirm".equals(operateKey = (op = (AbstractOperate)args.getSource()).getOperateKey())) {
            this.validSave(args);
            this.getModel().setDataChanged(false);
        }
    }

    private void validSave(BeforeDoOperationEventArgs args) {
        String conditionJson = this.getRuleCondition().getValue();
        this.getModel().setValue("conditions", (Object)conditionJson);
        if (!RuleEngingService.validCondition((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)conditionJson)) {
            args.setCancel(true);
            return;
        }
        String resultJson = this.getRuleResult().getValue();
        this.getModel().setValue("results", (Object)resultJson);
        if (!RuleEngingService.validRuleResult((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)resultJson)) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("confirm".equals(operateKey) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            DynamicObject pageDy = this.getModel().getDataEntity();
            String conditions = pageDy.getString("conditions");
            String results = pageDy.getString("results");
            HashMap map = Maps.newHashMapWithExpectedSize((int)4);
            map.put("condition", conditions);
            map.put("result", results);
            map.put("name", pageDy.getString("name"));
            map.put("number", pageDy.getString("number"));
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (HRStringUtils.equals((String)"ruledate", (String)key)) {
            Date newData = WTCCollectionIndexUtil.getEleFromArr((Object[])e.getChangeSet(), (int)0).map(ChangeData::getNewValue).orElse(null);
            if (null == newData) {
                return;
            }
            String dateFormat = this.getView().getPageCache().get("ruleDateFormat");
            if (dateFormat == null) {
                dateFormat = "yyyy-MM-dd";
            }
            String data = HRDateTimeUtils.format((Date)newData, (String)dateFormat);
            this.getRuleCondition().setDate(data);
            this.getRuleResult().setDate(data);
            this.getModel().setValue("ruledate", null);
        }
    }
}

