/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.ex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.business.web.attitem.AttItemFilterHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtbd.common.attitem.AttItemItemType;
import kd.wtc.wtbs.wtbd.common.attitem.AttItmeDataTypeEnum;
import kd.wtc.wtp.business.ex.ExConditionFilterService;
import kd.wtc.wtp.business.ex.ExConfigService;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.formplugin.web.ex.common.ExCommonViewService;
import kd.wtc.wtp.formplugin.web.ex.common.ExConfigViewService;

public class ExConfigureDetailPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final String BUTTON_CLOSE = "close";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_SURE = "sure";
    private static final String LABELAP_LABELAP21 = "labelap21";
    private static final String FLEX_CONFITIONFLEX = "confitionflex";
    private static final String LAP_ROUNDRULELAP = "roundrulelap";

    public void beforeBindData(EventObject evt) {
        IFormView parentView;
        super.beforeBindData(evt);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        boolean isView = OperationStatus.VIEW == status;
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{BUTTON_CLOSE});
        this.getView().setVisible(Boolean.valueOf(!isView), new String[]{BUTTON_CANCEL, BUTTON_SURE});
        String dealType = (String)this.getView().getFormShowParameter().getCustomParam("dealtypeshow");
        this.getModel().setValue("dealtype", (Object)dealType);
        this.getView().setEnable(Boolean.FALSE, new String[]{"originalitem"});
        boolean showCondition = (Boolean)this.getView().getFormShowParameter().getCustomParam("showcondition");
        this.getView().setVisible(Boolean.valueOf(showCondition), new String[]{FLEX_CONFITIONFLEX});
        this.getModel().setValue("showcondition", (Object)showCondition);
        ExConfigViewService.dealWithCondition(this.getView(), "conditionfilter");
        JSONObject customObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("exconfigdetail");
        if (customObject != null) {
            this.customObject(customObject, dealType);
        } else {
            Object obj = this.getView().getFormShowParameter().getCustomParam("exAttributeId");
            long exAttributeId = 0L;
            if (obj instanceof Integer) {
                exAttributeId = ((Integer)obj).longValue();
            } else if (obj instanceof Long) {
                exAttributeId = (Long)obj;
            }
            if (exAttributeId != 0L) {
                ExConfigViewService.setOrgItemShow(exAttributeId, this.getModel());
                ExConfigViewService.setResultItemShow(exAttributeId, this.getModel());
            }
            if (HRStringUtils.equals((String)"B", (String)dealType)) {
                this.dealWithDealMethod("A", null);
            }
        }
        String oriItemIdStr = (String)this.getView().getFormShowParameter().getCustomParam("originalitemshowtwo");
        if (HRStringUtils.isNotEmpty((String)oriItemIdStr)) {
            this.getModel().setValue("originalitem", (Object)Long.valueOf(oriItemIdStr));
        }
        if ((parentView = this.getView().getParentView()) == null) {
            return;
        }
        if (HRStringUtils.equals((String)"wtp_exconfig", (String)parentView.getFormShowParameter().getFormId())) {
            this.getModel().setValue("createorg", this.getView().getParentView().getModel().getValue("createorg"));
        } else if (HRStringUtils.equals((String)"wtp_exshiftset", (String)parentView.getFormShowParameter().getFormId())) {
            this.getModel().setValue("createorg", this.getView().getParentView().getParentView().getModel().getValue("createorg"));
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        TargetCondition control = (TargetCondition)this.getView().getControl("conditionfilter");
        if (HRStringUtils.equals((String)"wtp_exconfig", (String)parentView.getFormShowParameter().getFormId())) {
            if (WTCHisService.isLock((IFormView)parentView)) {
                ExConfigViewService.setFormStatus(control);
            }
        } else if (HRStringUtils.equals((String)"wtp_exshiftset", (String)parentView.getFormShowParameter().getFormId()) && WTCHisService.isLock((IFormView)parentView.getParentView())) {
            ExConfigViewService.setFormStatus(control);
        }
        String dealMethod = (String)this.getModel().getValue("dealmethod");
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)dealMethod, (String)"A")), new String[]{"roundrule", LAP_ROUNDRULELAP});
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        Container conFlex = (Container)this.getView().getControl(FLEX_CONFITIONFLEX);
        if (conFlex != null) {
            JSONObject customObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("exconfigdetail");
            boolean isCollapse = true;
            if (customObject != null) {
                String condition = customObject.getString("conditionfilter");
                boolean haveCondition = HRStringUtils.isNotEmpty((String)condition) && !HRStringUtils.equals((String)condition, (String)ExConditionFilterService.getUnLimitStr());
                isCollapse = !haveCondition;
            }
            conFlex.setCollapse(isCollapse);
        }
    }

    private void customObject(JSONObject customObject, String dealType) {
        boolean haveCondition;
        JSONObject roundRule = customObject.getJSONObject("roundrule");
        JSONObject orgItem = customObject.getJSONObject("originalitem");
        JSONArray attItems = customObject.getJSONArray("attitems");
        String condition = customObject.getString("conditionfilter");
        boolean bl = haveCondition = HRStringUtils.isNotEmpty((String)condition) && !HRStringUtils.equals((String)condition, (String)ExConditionFilterService.getUnLimitStr());
        if (haveCondition) {
            TargetCondition control = (TargetCondition)this.getView().getControl("conditionfilter");
            control.setValue(condition);
        }
        this.getModel().setValue("are", (Object)customObject.getString("are"));
        this.getModel().setValue("culvalue", (Object)customObject.getInteger("culvalue"));
        this.getModel().setValue("culunit", (Object)customObject.getString("culunit"));
        this.getModel().setValue("bre", (Object)customObject.getString("bre"));
        Integer maxValue = customObject.getInteger("maxvalue");
        if (maxValue != null && maxValue.compareTo(86400) > 0) {
            this.getModel().setValue("maxvalue", null);
        } else {
            this.getModel().setValue("maxvalue", (Object)maxValue);
        }
        this.getModel().setValue("maxunit", (Object)customObject.getString("maxunit"));
        this.getModel().setValue("roundrule", roundRule != null ? roundRule.getLong("id") : null);
        String dealMethod = customObject.getString("dealmethod");
        this.getModel().setValue("dealmethod", (Object)dealMethod);
        if (StringUtils.isEmpty((CharSequence)dealType)) {
            dealType = customObject.getString("dealtype");
            this.getModel().setValue("dealtype", (Object)dealType);
        }
        String appointUnit = customObject.getString("appointunit");
        this.getModel().setValue("appointunit", (Object)appointUnit);
        if (HRStringUtils.equals((String)"B", (String)dealType)) {
            this.dealWithDealMethod(dealMethod, appointUnit);
        }
        if (!HRStringUtils.equals((String)"A", (String)dealMethod)) {
            if (HRStringUtils.equals((String)"day", (String)appointUnit)) {
                this.getModel().setValue("dayappointvalue", (Object)new BigDecimal(customObject.getString("appointvalue")));
            } else if (HRStringUtils.equals((String)"hour", (String)appointUnit)) {
                this.getModel().setValue("hourappointvalue", (Object)customObject.getInteger("appointvalue"));
            } else {
                this.getModel().setValue("minuteappointvalue", (Object)customObject.getInteger("appointvalue"));
            }
        }
        this.getModel().setValue("originalitem", (Object)(orgItem != null ? orgItem.getLong("id") : 0L));
        ExConfigViewService.setResultItem(attItems, this.getModel());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String changeKey = args.getProperty().getName();
        if (HRStringUtils.equals((String)"dealmethod", (String)changeKey) || HRStringUtils.equals((String)"appointunit", (String)changeKey)) {
            String dealMethod = String.valueOf(this.getModel().getValue("dealmethod"));
            String appointUnit = String.valueOf(this.getModel().getValue("appointunit"));
            this.dealWithDealMethod(dealMethod, appointUnit);
            this.handleRound(dealMethod);
        }
    }

    private void handleRound(String dealMethod) {
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)dealMethod, (String)"A")), new String[]{"roundrule", LAP_ROUNDRULELAP});
    }

    private void dealWithDealMethod(String dealMethod, String appointUnit) {
        boolean show = HRStringUtils.equals((String)"A", (String)dealMethod);
        this.getView().setVisible(Boolean.valueOf(!show), new String[]{LABELAP_LABELAP21, "appointunit", "dayappointvalue", "hourappointvalue", "minuteappointvalue"});
        if (HRStringUtils.equals((String)"day", (String)appointUnit)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"dayappointvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"hourappointvalue", "minuteappointvalue"});
        } else if (HRStringUtils.equals((String)"hour", (String)appointUnit)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"hourappointvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"dayappointvalue", "minuteappointvalue"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"minuteappointvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"hourappointvalue", "dayappointvalue"});
        }
        if (show) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dayappointvalue", "hourappointvalue", "minuteappointvalue"});
        }
    }

    public void registerListener(EventObject evt) {
        MulBasedataEdit mulBasedataEdit;
        BasedataEdit periodFilter;
        super.registerListener(evt);
        Button button = (Button)this.getView().getControl(BUTTON_SURE);
        if (button != null) {
            button.addClickListener((ClickListener)this);
        }
        if ((periodFilter = (BasedataEdit)this.getView().getControl("originalitem")) != null) {
            periodFilter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((mulBasedataEdit = (MulBasedataEdit)this.getView().getControl("attitems")) != null) {
            mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((Control)beforeF7SelectEvent.getSource()).getKey();
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"attitems", "originalitem"})) {
            Date beSd;
            IFormView parentView;
            if (HRStringUtils.equals((String)"wtp_exconfig", (String)this.getView().getParentView().getFormShowParameter().getFormId())) {
                parentView = this.getView().getParentView();
                beSd = parentView.getModel().getDataEntity().getDate("bsed");
            } else if (HRStringUtils.equals((String)"wtp_exshiftset", (String)this.getView().getParentView().getFormShowParameter().getFormId())) {
                parentView = this.getView().getParentView().getParentView();
                beSd = parentView.getModel().getDataEntity().getDate("bsed");
            } else {
                return;
            }
            boolean checkResult = ExCommonViewService.checkBeSdBeforeF7Select(beSd, this.getView(), beforeF7SelectEvent);
            if (!checkResult) {
                return;
            }
            QFilter qFilter = AttItemFilterHelper.dataTypeFilter(Collections.singletonList(AttItmeDataTypeEnum.DUTATION.typeVal)).and(AttItemFilterHelper.issaveQFilter((boolean)true)).and(AttItemFilterHelper.itemtypeQFilter((String[])new String[]{AttItemItemType.DETAIL_ITEM.type, AttItemItemType.DETAIL_SUM_ITEM.type}));
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BUTTON_SURE)) {
            boolean conditionCheck;
            TargetCondition control;
            String dealMethod;
            boolean isAppoint;
            boolean noStep;
            Object maxValueObj = this.getModel().getValue("maxvalue");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            boolean checkResult = this.check(dataEntity, noStep = HRStringUtils.equals((String)"A", (String)dataEntity.getString("dealtype")), isAppoint = HRStringUtils.equals((String)"B", (String)(dealMethod = dataEntity.getString("dealmethod"))));
            if (!checkResult) {
                this.getModel().setValue("maxvalue", maxValueObj);
                return;
            }
            boolean showCondition = dataEntity.getBoolean("showcondition");
            String conditionFilter = null;
            boolean emptyJudge = true;
            if (showCondition && (emptyJudge = ExConditionFilterService.emptyConditionJsonDeal((String)(conditionFilter = (control = (TargetCondition)this.getView().getControl("conditionfilter")).getValue()))) && !(conditionCheck = ExConditionFilterService.checkConditionJson((String)conditionFilter, (IFormView)this.getView(), (String)ExKDStringHelper.sceneConditionDtoError(), (String)ExKDStringHelper.gradeSceneError()))) {
                this.getModel().setValue("maxvalue", maxValueObj);
                return;
            }
            this.returnData(dataEntity, noStep, isAppoint, emptyJudge, conditionFilter);
        }
    }

    private void returnData(DynamicObject dataEntity, boolean noStep, boolean isAppoint, boolean emptyJudge, String conditionFilter) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        if (!noStep && isAppoint) {
            map.put("appointvalue", dataEntity.get("appointvalue"));
        } else {
            map.put("appointvalue", BigDecimal.ZERO);
            map.put("appointunit", "minute");
        }
        if (emptyJudge) {
            map.put("conditionfiltershow", ExConditionFilterService.getStrOfSettingCondition((String)conditionFilter));
            map.put("conditionfilter", conditionFilter);
        } else {
            map.put("conditionfiltershow", ExConditionFilterService.getUnLimitStr());
            map.put("conditionfilter", null);
        }
        String dealMethod = String.valueOf(this.getModel().getValue("dealmethod"));
        if (!HRStringUtils.equals((String)dealMethod, (String)"A")) {
            this.getModel().setValue("roundrule", null);
        }
        map.put("are", this.getModel().getValue("are"));
        map.put("culvalue", this.getModel().getValue("culvalue"));
        map.put("culunit", this.getModel().getValue("culunit"));
        map.put("bre", this.getModel().getValue("bre"));
        map.put("maxvalue", this.getModel().getValue("maxvalue"));
        map.put("maxunit", this.getModel().getValue("maxunit"));
        map.put("roundrule", this.getModel().getValue("roundrule"));
        map.put("dealmethod", this.getModel().getValue("dealmethod"));
        map.put("appointunit", this.getModel().getValue("appointunit"));
        map.put("originalitem", this.getModel().getValue("originalitem"));
        map.put("dealtype", this.getModel().getValue("dealtype"));
        map.put("attitems", this.getModel().getValue("attitems"));
        map.put("aruleshow", ExConfigService.getNoStepRuleStr((DynamicObject)dataEntity));
        map.put("aresultshow", ExConfigService.getNoStepResultStr((DynamicObject)dataEntity));
        map.put("bruleshow", ExConfigService.getStepRuleStr((DynamicObject)dataEntity));
        map.put("bresultshow", ExConfigService.getStepResultStr((DynamicObject)dataEntity));
        this.getView().returnDataToParent((Object)map);
        this.getView().close();
    }

    private boolean check(DynamicObject dataEntity, boolean noStep, boolean isAppoint) {
        List<String> keyList = this.getCheckColumnList(dataEntity, noStep, isAppoint);
        if (!ExConfigViewService.check(keyList, dataEntity, this.getView())) {
            return false;
        }
        if (!this.checkCurValue(dataEntity)) {
            return false;
        }
        if (!noStep && isAppoint && !this.dealWithAppointValue(dataEntity)) {
            return false;
        }
        return this.dealWithMaxValue(dataEntity, noStep);
    }

    private boolean dealWithAppointValue(DynamicObject dataEntity) {
        BigDecimal appointValue;
        String appointUnit = dataEntity.getString("appointunit");
        if (HRStringUtils.equals((String)"day", (String)appointUnit)) {
            appointValue = dataEntity.getBigDecimal("dayappointvalue");
            if (appointValue.compareTo(BigDecimal.ZERO) <= 0 || appointValue.compareTo(BigDecimal.ONE) > 0) {
                this.getView().showTipNotification(ExKDStringHelper.checkDayTimeValue());
                return false;
            }
        } else if (HRStringUtils.equals((String)"hour", (String)appointUnit)) {
            int hour = dataEntity.getInt("hourappointvalue");
            if (hour < 1 || hour > 24) {
                this.getView().showTipNotification(ExKDStringHelper.checkHourTimeValue());
                return false;
            }
            appointValue = new BigDecimal(String.valueOf(hour));
        } else {
            int minute = dataEntity.getInt("minuteappointvalue");
            if (minute < 0 || minute > 1440) {
                this.getView().showTipNotification(ExKDStringHelper.checkMinuteTimeValue());
                return false;
            }
            appointValue = new BigDecimal(String.valueOf(minute));
        }
        dataEntity.set("appointvalue", (Object)appointValue);
        return true;
    }

    private boolean dealWithMaxValue(DynamicObject dataEntity, boolean noStep) {
        if (!noStep) {
            Object maxValueObj = dataEntity.get("maxvalue");
            if (maxValueObj == null) {
                dataEntity.set("maxvalue", (Object)86401);
                dataEntity.set("maxunit", (Object)dataEntity.getString("culunit"));
            } else {
                int maxValue = dataEntity.getInt("maxvalue");
                if (maxValue == 0) {
                    this.getView().showTipNotification(ExKDStringHelper.maxValueCheck());
                    return false;
                }
                if (maxValue < 0 || maxValue > 86400) {
                    this.getView().showTipNotification(ExKDStringHelper.checkMaxValue());
                    return false;
                }
                boolean comPareValue = ExConfigService.checkValue((IFormView)this.getView(), (DynamicObject)dataEntity, (boolean)false);
                if (!comPareValue) {
                    this.getView().showTipNotification(ExKDStringHelper.compareValue());
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkCurValue(DynamicObject dataEntity) {
        boolean are = HRStringUtils.equals((String)">=", (String)dataEntity.getString("are"));
        int curValue = dataEntity.getInt("culvalue");
        if (are && curValue == 0) {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setSuccess(false);
            fieldTip.setTip(ExKDStringHelper.curValueCheck());
            fieldTip.setFieldKey("culvalue");
            fieldTip.setTipsType(FieldTip.FieldTipsTypes.scope);
            fieldTip.setLevel(FieldTip.FieldTipsLevel.Error);
            ArrayList tipsList = Lists.newArrayList((Object[])new FieldTip[]{fieldTip});
            this.getView().showFieldTips((List)tipsList);
            return false;
        }
        if (curValue < 0 || curValue > 86400) {
            this.getView().showTipNotification(ExKDStringHelper.checkCurValue());
            return false;
        }
        return true;
    }

    private List<String> getCheckColumnList(DynamicObject dataEntity, boolean noStep, boolean isAppoint) {
        ArrayList keyList = Lists.newArrayListWithCapacity((int)16);
        keyList.add("are");
        Object obj = dataEntity.get("culvalue");
        if (obj == null) {
            keyList.add("culvalue");
        }
        keyList.add("culunit");
        keyList.add("originalitem");
        keyList.add("attitems");
        if (!noStep) {
            keyList.add("bre");
            keyList.add("dealmethod");
        }
        if (!noStep && isAppoint) {
            String appointUnit = dataEntity.getString("appointunit");
            if (HRStringUtils.equals((String)"day", (String)appointUnit)) {
                keyList.add("dayappointvalue");
            } else if (HRStringUtils.equals((String)"hour", (String)appointUnit)) {
                keyList.add("hourappointvalue");
            } else {
                keyList.add("minuteappointvalue");
            }
        }
        return keyList;
    }
}

