/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.ex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.model.ex.ExAtteItemVo;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtbd.common.attitem.AttItemItemType;
import kd.wtc.wtp.business.ex.ExRuleService;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.formplugin.web.ex.common.ExCommonViewService;
import kd.wtc.wtp.formplugin.web.ex.common.ExConfigViewService;

public class ExRuleDetailPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final String BUTTON_CLOSE = "close";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_SURE = "sure";
    private static final String SUMLABELAP = "sumlabelap";
    private static final String LABELAP = "labelap";
    private static final String APPOINTLABELAP = "appointlabelap";
    private static final String APPOINTUNIT = "appointunit";

    public void afterCreateNewData(EventObject ee) {
        super.afterCreateNewData(ee);
        String createOrgId = (String)this.getView().getFormShowParameter().getCustomParam("createorg");
        this.getModel().setValue("createorg", (Object)Long.valueOf(createOrgId));
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        boolean lock = WTCHisService.isLock((IFormView)this.getView().getParentView());
        this.getView().setVisible(Boolean.valueOf(lock), new String[]{BUTTON_CLOSE});
        this.getView().setVisible(Boolean.valueOf(!lock), new String[]{BUTTON_CANCEL, BUTTON_SURE});
        JSONObject customObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("exruledetailview");
        if (customObject != null) {
            this.customObject(customObject);
        } else {
            this.dealLabel(0);
            this.dealType("B", null);
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("attitemlabelap", "attitem");
        map.put("valueslabelap", "values");
        ExConfigViewService.setTips(map, this.getView(), "wtp_exrule");
        HashMap typeMap = Maps.newHashMapWithExpectedSize((int)1);
        typeMap.put("dealtypelabelap", "dealmethod");
        ExConfigViewService.setTips(typeMap, this.getView());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String changeKey = args.getProperty().getName();
        if (HRStringUtils.equals((String)"dealtype", (String)changeKey) || HRStringUtils.equals((String)APPOINTUNIT, (String)changeKey)) {
            String dealType = String.valueOf(this.getModel().getValue("dealtype"));
            String appointUnit = String.valueOf(this.getModel().getValue(APPOINTUNIT));
            this.dealType(dealType, appointUnit);
            if (StringUtils.equals((CharSequence)dealType, (CharSequence)"A")) {
                this.getModel().setValue("appointvalue", (Object)0);
            }
        } else if (HRStringUtils.equals((String)"attitem", (String)changeKey)) {
            this.propertyChangedOfAttItem();
        }
    }

    public void registerListener(EventObject evt) {
        BasedataEdit periodFilter;
        Button button;
        MulBasedataEdit mulBasedataEdit2;
        super.registerListener(evt);
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getView().getControl("attitem");
        if (mulBasedataEdit != null) {
            mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((mulBasedataEdit2 = (MulBasedataEdit)this.getView().getControl("attitem1")) != null) {
            mulBasedataEdit2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((button = (Button)this.getView().getControl(BUTTON_SURE)) != null) {
            button.addClickListener((ClickListener)this);
        }
        if ((periodFilter = (BasedataEdit)this.getView().getControl("resattitem")) != null) {
            periodFilter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((Control)beforeF7SelectEvent.getSource()).getKey();
        if (HRStringUtils.equals((String)"attitem", (String)key) || HRStringUtils.equals((String)"attitem1", (String)key)) {
            String sourceMethod = beforeF7SelectEvent.getSourceMethod();
            boolean check = ExCommonViewService.checkBeSdBeforeF7SelectWithSubPage(this.getView(), beforeF7SelectEvent);
            if (!check) {
                return;
            }
            QFilter qFilter = this.getItemQFilter();
            if (HRStringUtils.equals((String)"getLookUpList", (String)sourceMethod)) {
                beforeF7SelectEvent.addCustomQFilter(qFilter);
                return;
            }
            List<ExAtteItemVo> paramList = this.resourceExAttItem();
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("attItems", paramList);
            Date bsed = (Date)this.getView().getParentView().getModel().getValue("bsed");
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("bsed", (Object)bsed);
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        } else if (HRStringUtils.equals((String)"resattitem", (String)key)) {
            boolean check = ExCommonViewService.checkBeSdBeforeF7SelectWithSubPage(this.getView(), beforeF7SelectEvent);
            if (!check) {
                return;
            }
            beforeF7SelectEvent.addCustomQFilter(new QFilter("datatype", "!=", (Object)"0"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String callBack = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"callBackEvent", (CharSequence)callBack)) {
            ListSelectedRowCollection response = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.dealWithResultItem(response);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BUTTON_SURE)) {
            String dealType;
            boolean isAppoint;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            List<String> keyList = this.getCheckColumnList(dataEntity, isAppoint = HRStringUtils.equals((String)"B", (String)(dealType = dataEntity.getString("dealtype"))));
            if (!ExConfigViewService.check(keyList, dataEntity, this.getView())) {
                return;
            }
            BigDecimal maxBigDecimal = new BigDecimal(String.valueOf(86400));
            BigDecimal cur = dataEntity.getBigDecimal("value");
            if (!this.checkCurValue(dataEntity, cur, maxBigDecimal)) {
                return;
            }
            if (this.hasSameAttitem()) {
                return;
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            if (isAppoint) {
                if (!this.dealWithAppointValue(dataEntity)) {
                    return;
                }
                map.put("appointvalue", dataEntity.get("appointvalue"));
            } else {
                map.put("appointvalue", BigDecimal.ZERO);
                map.put(APPOINTUNIT, "minute");
            }
            if (!this.dealWithMaxValue(dataEntity, cur, maxBigDecimal)) {
                return;
            }
            map.put("ruleshow", ExRuleService.getRuleShow((DynamicObject)dataEntity));
            map.put("resultshow", ExRuleService.getResultShow((DynamicObject)dataEntity));
            map.put("attitem", dataEntity.get("attitem"));
            map.put("rela", dataEntity.get("rela"));
            map.put("value", dataEntity.getInt("value"));
            map.put("vunit", dataEntity.get("vunit"));
            map.put("relas", dataEntity.get("relas"));
            map.put("values", dataEntity.get("values"));
            map.put("vunits", dataEntity.get("vunits"));
            map.put("dealtype", dataEntity.get("dealtype"));
            map.put(APPOINTUNIT, dataEntity.get(APPOINTUNIT));
            map.put("exattribute", dataEntity.get("exattribute"));
            map.put("resattitem", dataEntity.get("resattitem"));
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        }
    }

    private void dealWithResultItem(ListSelectedRowCollection response) {
        if (response != null) {
            DynamicObject[] itemData;
            Object[] array = response.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
            HashSet unitSet = Sets.newHashSetWithExpectedSize((int)response.size());
            ArrayList itemIdList = Lists.newArrayListWithExpectedSize((int)response.size());
            for (ListSelectedRow row : response) {
                itemIdList.add((Long)row.getPrimaryKeyValue());
            }
            HRBaseServiceHelper itemHelper = new HRBaseServiceHelper("wtbd_attitem_ex");
            for (DynamicObject dy : itemData = itemHelper.query("unit", new QFilter[]{new QFilter("id", "in", (Object)itemIdList)})) {
                unitSet.add(dy.getString("unit"));
            }
            if (unitSet.size() > 1) {
                this.getView().showTipNotification(ExKDStringHelper.unitError());
                return;
            }
            this.getModel().setValue("attitem", (Object)array);
            this.dealLabel(array.length);
            String unit = (String)unitSet.iterator().next();
            if (HRStringUtils.equals((String)"day", (String)unit)) {
                unit = "minute";
            }
            this.getModel().setValue("vunit", (Object)unit);
            this.getModel().setValue("vunits", (Object)unit);
        }
    }

    private List<ExAtteItemVo> resourceExAttItem() {
        IDataModel model = this.getView().getParentView().getModel();
        DynamicObjectCollection ruleCollection = model.getEntryEntity("ruleentryentity");
        ArrayList list = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject rule : ruleCollection) {
            ExRuleService.makeExAtteItemVoListByEntryCollection((List)list, (DynamicObject)rule);
        }
        return list;
    }

    private QFilter getItemQFilter() {
        ArrayList itemTypeList = Lists.newArrayListWithExpectedSize((int)2);
        itemTypeList.add("1");
        itemTypeList.add("2");
        QFilter qFilter = new QFilter("itemtype", "in", (Object)itemTypeList);
        qFilter.and(new QFilter("datatype", "=", (Object)"1"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("unit", "not in", (Object)"time"));
        qFilter.and(new QFilter("issave", "=", (Object)Boolean.TRUE).and("itemtype", "in", (Object)new String[]{AttItemItemType.DETAIL_ITEM.type, AttItemItemType.DETAIL_SUM_ITEM.type}).and("isorginattitem", "=", (Object)Boolean.FALSE));
        Date beSd = (Date)this.getView().getParentView().getModel().getValue("bsed");
        qFilter.and(new QFilter("firstbsed", "<=", (Object)beSd));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        return qFilter;
    }

    private void customObject(JSONObject customObject) {
        JSONArray attItems = customObject.getJSONArray("attitem");
        boolean more = false;
        if (attItems != null) {
            Object[] ids = new Object[attItems.size()];
            more = attItems.size() > 1;
            for (int j = 0; j < attItems.size(); ++j) {
                Object id;
                JSONObject object = attItems.getJSONObject(j);
                ids[j] = id = object.getJSONObject("fbasedataid").get((Object)"id");
            }
            this.getModel().setValue("attitem", (Object)ids);
        }
        this.getView().setVisible(Boolean.valueOf(more), new String[]{SUMLABELAP});
        this.getView().setVisible(Boolean.valueOf(!more), new String[]{LABELAP});
        this.getModel().setValue("rela", (Object)customObject.getString("rela"));
        this.getModel().setValue("value", (Object)customObject.getString("value"));
        this.getModel().setValue("vunit", (Object)customObject.getString("vunit"));
        this.getModel().setValue("relas", (Object)customObject.getString("relas"));
        String max = customObject.getString("values");
        if (max != null) {
            if (HRStringUtils.equals((String)String.valueOf(86401), (String)max)) {
                this.getModel().setValue("values", null);
            } else {
                this.getModel().setValue("values", (Object)max);
            }
        }
        this.getModel().setValue("vunits", (Object)customObject.getString("vunits"));
        String dealType = customObject.getString("dealtype");
        this.getModel().setValue("dealtype", (Object)dealType);
        String appointUnit = customObject.getString(APPOINTUNIT);
        this.getModel().setValue(APPOINTUNIT, (Object)customObject.getString(APPOINTUNIT));
        if (HRStringUtils.equals((String)"day", (String)appointUnit)) {
            this.getModel().setValue("dayappointvalue", (Object)new BigDecimal(customObject.getString("appointvalue")));
        } else if (HRStringUtils.equals((String)"hour", (String)appointUnit)) {
            this.getModel().setValue("hourappointvalue", (Object)customObject.getInteger("appointvalue"));
        } else {
            this.getModel().setValue("minuteappointvalue", (Object)customObject.getInteger("appointvalue"));
        }
        this.dealType(dealType, appointUnit);
        JSONObject exAttribute = customObject.getJSONObject("exattribute");
        this.getModel().setValue("exattribute", exAttribute != null ? exAttribute.getLong("id") : null);
        JSONObject reAttItem = customObject.getJSONObject("resattitem");
        this.getModel().setValue("resattitem", (Object)(reAttItem != null ? reAttItem.getLong("id") : 0L));
    }

    private void dealType(String dealType, String appointUnit) {
        boolean isShow = HRStringUtils.equals((String)"B", (String)dealType);
        if (isShow) {
            this.getView().setVisible(Boolean.TRUE, new String[]{APPOINTLABELAP, APPOINTUNIT});
            if (HRStringUtils.equals((String)"day", (String)appointUnit)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"dayappointvalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"hourappointvalue", "minuteappointvalue"});
            } else if (HRStringUtils.equals((String)"hour", (String)appointUnit)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"hourappointvalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"dayappointvalue", "minuteappointvalue"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"minuteappointvalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"hourappointvalue", "dayappointvalue"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{APPOINTLABELAP, APPOINTUNIT, "dayappointvalue", "hourappointvalue", "minuteappointvalue"});
        }
    }

    private void dealLabel(int number) {
        boolean one = number < 2;
        this.getView().setVisible(Boolean.valueOf(one), new String[]{LABELAP});
        this.getView().setVisible(Boolean.valueOf(!one), new String[]{SUMLABELAP});
    }

    private boolean dealWithAppointValue(DynamicObject dataEntity) {
        BigDecimal appointValue;
        String appointUnit = dataEntity.getString(APPOINTUNIT);
        if (HRStringUtils.equals((String)"day", (String)appointUnit)) {
            appointValue = dataEntity.getBigDecimal("dayappointvalue");
            if (appointValue.compareTo(BigDecimal.ZERO) <= 0 || appointValue.compareTo(BigDecimal.ONE) > 0) {
                this.getView().showTipNotification(ExKDStringHelper.checkDayTimeValue());
                return false;
            }
        } else if (HRStringUtils.equals((String)"hour", (String)appointUnit)) {
            int hour = dataEntity.getInt("hourappointvalue");
            if (hour < 1 || hour > 24) {
                this.getView().showTipNotification(ExKDStringHelper.checkHourTimeValue());
                return false;
            }
            appointValue = new BigDecimal(String.valueOf(hour));
        } else {
            int minute = dataEntity.getInt("minuteappointvalue");
            if (minute < 0 || minute > 1440) {
                this.getView().showTipNotification(ExKDStringHelper.checkMinuteTimeValue());
                return false;
            }
            appointValue = new BigDecimal(String.valueOf(minute));
        }
        dataEntity.set("appointvalue", (Object)appointValue);
        return true;
    }

    private boolean dealWithMaxValue(DynamicObject dataEntity, BigDecimal cur, BigDecimal maxBigDecimal) {
        Object maxObj = dataEntity.get("values");
        if (maxObj == null) {
            dataEntity.set("values", (Object)86401);
            dataEntity.set("vunits", dataEntity.get("vunit"));
        } else {
            BigDecimal values = dataEntity.getBigDecimal("values");
            if (values.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ExKDStringHelper.maxValueCheck());
                return false;
            }
            if (values.compareTo(maxBigDecimal) > 0 || values.compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(ExKDStringHelper.checkMaxValue());
                return false;
            }
            BigDecimal min = ExRuleService.getUnitValue((BigDecimal)cur, (String)dataEntity.getString("vunit"));
            BigDecimal max = ExRuleService.getUnitValue((BigDecimal)values, (String)dataEntity.getString("vunits"));
            if (max.compareTo(BigDecimal.ZERO) > 0 && min.compareTo(max) >= 0) {
                this.getView().showTipNotification(ExKDStringHelper.compareValue());
                return false;
            }
        }
        return true;
    }

    private boolean checkCurValue(DynamicObject dataEntity, BigDecimal cur, BigDecimal maxBigDecimal) {
        boolean are = HRStringUtils.equals((String)">=", (String)dataEntity.getString("rela"));
        int curValue = dataEntity.getInt("value");
        if (are && curValue == 0) {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setSuccess(false);
            fieldTip.setTip(ExKDStringHelper.curValueCheck());
            fieldTip.setTipsType(FieldTip.FieldTipsTypes.scope);
            fieldTip.setFieldKey("value");
            fieldTip.setLevel(FieldTip.FieldTipsLevel.Error);
            ArrayList tipsList = Lists.newArrayList((Object[])new FieldTip[]{fieldTip});
            this.getView().showFieldTips((List)tipsList);
            return false;
        }
        if (cur.compareTo(maxBigDecimal) > 0 || cur.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showTipNotification(ExKDStringHelper.checkCurValue());
            return false;
        }
        return true;
    }

    private List<String> getCheckColumnList(DynamicObject dataEntity, boolean isAppoint) {
        ArrayList keyList = Lists.newArrayListWithCapacity((int)16);
        keyList.add("attitem");
        keyList.add("rela");
        Object value = dataEntity.get("value");
        if (value == null) {
            keyList.add("value");
        }
        keyList.add("vunit");
        keyList.add("relas");
        keyList.add("vunits");
        keyList.add("dealtype");
        if (isAppoint) {
            String appointUnit = dataEntity.getString(APPOINTUNIT);
            if (HRStringUtils.equals((String)"day", (String)appointUnit)) {
                keyList.add("dayappointvalue");
            } else if (HRStringUtils.equals((String)"hour", (String)appointUnit)) {
                keyList.add("hourappointvalue");
            } else {
                keyList.add("minuteappointvalue");
            }
        }
        keyList.add("exattribute");
        keyList.add("resattitem");
        return keyList;
    }

    private void propertyChangedOfAttItem() {
        DynamicObjectCollection itemCollect = this.getModel().getDataEntity().getDynamicObjectCollection("attitem");
        if (itemCollect != null && !itemCollect.isEmpty()) {
            HashSet unitSet = Sets.newHashSetWithExpectedSize((int)itemCollect.size());
            for (DynamicObject dy : itemCollect) {
                unitSet.add(dy.getString("fbasedataid.unit"));
            }
            if (unitSet.size() > 1) {
                this.getView().showTipNotification(ExKDStringHelper.unitError());
                return;
            }
            this.dealLabel(itemCollect.size());
            String unit = (String)unitSet.iterator().next();
            if (HRStringUtils.equals((String)"day", (String)unit)) {
                unit = "minute";
            }
            this.getModel().setValue("vunit", (Object)unit);
            this.getModel().setValue("vunits", (Object)unit);
        }
    }

    private boolean hasSameAttitem() {
        HashSet<Long> attitems = new HashSet<Long>();
        DynamicObjectCollection itemCollect = this.getModel().getDataEntity().getDynamicObjectCollection("attitem");
        for (DynamicObject dy : itemCollect) {
            attitems.add(dy.getLong("fbasedataid.id"));
        }
        DynamicObject resattitem = this.getModel().getDataEntity().getDynamicObject("resattitem");
        if (attitems.size() == 1 && resattitem != null) {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setSuccess(false);
            fieldTip.setTip(ExKDStringHelper.hasSameAttitem());
            fieldTip.setTipsType(FieldTip.FieldTipsTypes.scope);
            fieldTip.setFieldKey("resattitem");
            fieldTip.setLevel(FieldTip.FieldTipsLevel.Error);
            ArrayList tipsList = Lists.newArrayList((Object[])new FieldTip[]{fieldTip});
            this.getView().showFieldTips((List)tipsList);
            return attitems.contains(resattitem.getLong("id"));
        }
        return false;
    }
}

