/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.ex;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.NumberUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.ex.ExRuleService;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.common.ex.rule.ExRuleConstants;
import kd.wtc.wtp.formplugin.web.ex.common.ExCommonViewService;
import kd.wtc.wtp.utils.WTCSheetUtil;

public class ExRuleEdit
extends HRDataBaseEdit
implements ExRuleConstants,
BeforeF7SelectListener {
    public void beforeBindData(EventObject ee) {
        super.beforeBindData(ee);
        this.dealWithOperationColumn();
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String hisAction = (String)customParams.get("his_action");
        boolean isNewVersion = HRStringUtils.equals((String)"open_insert_new_data_page", (String)hisAction);
        if (isNewVersion) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData("ruleentryentity");
            model.deleteEntryData("entryentity");
            model.endInit();
            this.getView().updateView("ruleentryentity");
            this.getView().updateView("entryentity");
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection exConvertEntry = model.getEntryEntity("entryentity");
        model.beginInit();
        DynamicObjectCollection exConfigEntryEntity = model.getEntryEntity("ruleentryentity");
        Object[] pkIds = exConfigEntryEntity.stream().map(ee -> ee.getLong("exconfigid.id")).toArray();
        model.setValue("exconfig", (Object)pkIds);
        for (int index = 0; index < exConvertEntry.size(); ++index) {
            DynamicObject dy = (DynamicObject)exConvertEntry.get(index);
            model.setValue("ruleshow", (Object)ExRuleService.getRuleShow((DynamicObject)dy), index);
            model.setValue("resultshow", (Object)ExRuleService.getResultShow((DynamicObject)dy), index);
        }
        model.endInit();
        this.getView().updateView("exconfig");
        this.getView().updateView("entryentity");
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        MulBasedataEdit exConfig = (MulBasedataEdit)this.getView().getControl("exconfig");
        exConfig.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("exattribute".equals(actionId)) {
            ListSelectedRowCollection response = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (Objects.nonNull(response)) {
                this.getModel().setValue("exattribute", response.get(0).getPrimaryKeyValue(), Integer.parseInt(this.getPageCache().get("row")));
            }
        } else if (HRStringUtils.equals((String)"exruledetail_add", (String)actionId)) {
            Map returnData2 = (Map)closedCallBackEvent.getReturnData();
            if (returnData2 != null && !returnData2.isEmpty()) {
                ExRuleService.addDetailClosedCallBack((Map)returnData2, (IDataModel)this.getModel(), (IFormView)this.getView());
                this.checkExConfigAndExConvert(false);
                this.checkConversionAttItems(false);
            }
        } else if (ExRuleService.editEntryIndex((String)actionId) >= 0 && (returnData = (Map)closedCallBackEvent.getReturnData()) != null && !returnData.isEmpty()) {
            int row = ExRuleService.editEntryIndex((String)actionId);
            ExRuleService.editDetailClosedCallBack((Map)returnData, (IDataModel)this.getModel(), (IFormView)this.getView(), (int)row);
            this.checkExConfigAndExConvert(false);
            this.checkConversionAttItems(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"exconfigid"})) {
            this.checkExConfigAndExConvert(false);
        } else if (HRStringUtils.equals((String)"exconfig", (String)name)) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData("ruleentryentity");
            DynamicObjectCollection exConfig = model.getDataEntity().getDynamicObjectCollection("exconfig");
            model.batchCreateNewEntryRow("ruleentryentity", exConfig.size());
            for (int ii = 0; ii < exConfig.size(); ++ii) {
                model.setValue("exconfigid", ((DynamicObject)exConfig.get(ii)).get("fbasedataid.id"), ii);
            }
            model.endInit();
            this.getView().updateView("ruleentryentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "save": 
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                boolean checkResult = this.checkExConfig();
                boolean bl = checkResult = checkResult && this.checkExConfigAndExConvert(true) && this.checkConversionAttItems(true);
                if (checkResult) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        switch (operateKey = evt.getOperateKey()) {
            case "deleteentry": 
            case "moveentryup": 
            case "nextentry1": {
                IDataModel model = this.getModel();
                DynamicObjectCollection exConfigEntryEntity = model.getEntryEntity("ruleentryentity");
                Object[] pkIds = exConfigEntryEntity.stream().map(ee -> ee.getLong("exconfigid.id")).toArray();
                model.beginInit();
                model.setValue("exconfig", (Object)pkIds);
                model.endInit();
                this.getView().updateView("exconfig");
                break;
            }
            case "addentry": {
                if (!ExCommonViewService.checkBeSd(this.getView())) {
                    return;
                }
                MulBasedataEdit exConfig = (MulBasedataEdit)this.getView().getControl("exconfig");
                exConfig.click();
                break;
            }
            case "add": {
                if (!ExCommonViewService.checkBeSd(this.getView())) {
                    return;
                }
                FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.Modal, null, (String)"wtp_exruledetail", (CloseCallBack)new CloseCallBack((IFormPlugin)this, "exruledetail_add"), null, (OperationStatus)this.getView().getFormShowParameter().getStatus());
                long createOrgId = this.getView().getModel().getDataEntity().getLong("createorg.id");
                parameter.setCustomParam("createorg", (Object)String.valueOf(createOrgId));
                this.getView().showForm(parameter);
                break;
            }
            case "modifyentry": 
            case "see": {
                if (!ExCommonViewService.checkBeSd(this.getView())) {
                    return;
                }
                this.exRuleView(operateKey);
                break;
            }
            case "save": 
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": 
            case "unsubmit": {
                this.dealWithOperationColumn();
                break;
            }
            case "deentry": {
                int row = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().deleteEntryRow("entryentity", row);
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        String status = this.getView().getModel().getDataEntity().getString("status");
        if (HRStringUtils.isEmpty((String)status)) {
            evt.setCheckDataChange(false);
            return;
        }
        boolean lock = WTCHisService.isLock((IFormView)this.getView());
        if (lock) {
            evt.setCheckDataChange(false);
        }
    }

    private void dealWithOperationColumn() {
        boolean lock = WTCHisService.isLock((IFormView)this.getView());
        this.getView().setVisible(Boolean.valueOf(lock), new String[]{"operationcolumnapsee"});
        this.getView().setVisible(Boolean.valueOf(!lock), new String[]{"operationcolumnap"});
    }

    private boolean checkExConfigAndExConvert(boolean isBeforeSave) {
        DynamicObjectCollection exConfigEntryEntity = this.getModel().getEntryEntity("ruleentryentity");
        HashMap attItemRuleMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap map = Maps.newHashMapWithExpectedSize((int)exConfigEntryEntity.size());
        for (DynamicObject rule : exConfigEntryEntity) {
            long exAttributeId = rule.getLong("exconfigid.exattribute.id");
            DynamicObjectCollection entry = rule.getDynamicObjectCollection("exconfigid.entryentity");
            boolean success = this.dealConfigAttItems(attItemRuleMap, entry, (Long)exAttributeId);
            if (!success) {
                return false;
            }
            List idList = (List)map.get(exAttributeId);
            if (idList == null) {
                idList = Lists.newArrayListWithExpectedSize((int)exConfigEntryEntity.size());
            }
            idList.add(rule.getLong("exconfigid.id"));
            map.put(exAttributeId, idList);
        }
        boolean checkResult = ExRuleService.timeCheck((Map)map);
        if (!checkResult) {
            this.getView().showTipNotification(ExKDStringHelper.repeatExDate());
            return false;
        }
        DynamicObjectCollection exConvertEntry = this.getModel().getEntryEntity("entryentity");
        return this.dealConversionAttItems(attItemRuleMap, exConvertEntry, isBeforeSave);
    }

    private boolean dealConfigAttItems(Map<String, Long> attItemRuleMap, DynamicObjectCollection exConfigEntryEntity, Long exAttributeId) {
        if (CollectionUtils.isEmpty((Collection)exConfigEntryEntity)) {
            return true;
        }
        for (DynamicObject exConfigDy : exConfigEntryEntity) {
            if (this.dealConfigAttItems(exConfigDy, attItemRuleMap, exAttributeId)) continue;
            return false;
        }
        return true;
    }

    private boolean dealConfigAttItems(DynamicObject exConfigDy, Map<String, Long> attItemRuleMap, Long exAttributeId) {
        Long attributeId;
        String oriItemId = exConfigDy.getString("originalitem.id");
        if (StringUtils.isNotEmpty((CharSequence)oriItemId) && (attributeId = attItemRuleMap.getOrDefault(oriItemId, 0L)) != 0L && (long)NumberUtils.compare((long)attributeId, (long)exAttributeId) != 0L) {
            this.getView().showTipNotification(ExKDStringHelper.repeatExAtt());
            return false;
        }
        DynamicObjectCollection resultItemsCollection = exConfigDy.getDynamicObjectCollection("attitems");
        if (!CollectionUtils.isEmpty((Collection)resultItemsCollection)) {
            for (DynamicObject attItems : resultItemsCollection) {
                String attItemsId = attItems.getDynamicObject("fbasedataid").getPkValue().toString();
                Long attributeId2 = attItemRuleMap.getOrDefault(attItemsId, 0L);
                if (attributeId2 != 0L && (long)NumberUtils.compare((long)attributeId2, (long)exAttributeId) != 0L) {
                    this.getView().showTipNotification(ExKDStringHelper.repeatExAtt());
                    return false;
                }
                attItemRuleMap.put(attItemsId, exAttributeId);
            }
        }
        attItemRuleMap.put(oriItemId, exAttributeId);
        return true;
    }

    private boolean dealConversionAttItems(Map<String, Long> attItemRuleMap, DynamicObjectCollection exConvertEntry, boolean isBeforeSave) {
        Date beSd = this.getModel().getDataEntity().getDate("bsed");
        for (DynamicObject exConvertEntity : exConvertEntry) {
            long exAttributeId = exConvertEntity.getLong("exattribute.id");
            long resultItemId = exConvertEntity.getLong("resattitem.id");
            if (resultItemId == 0L || exAttributeId == 0L) continue;
            Long attributeId = attItemRuleMap.getOrDefault(String.valueOf(resultItemId), 0L);
            if (null != attributeId && attributeId != 0L && NumberUtils.compare((long)attributeId, (long)exAttributeId) != 0) {
                this.getView().showTipNotification(ExKDStringHelper.repeatExAtt());
                return false;
            }
            attItemRuleMap.put(String.valueOf(resultItemId), exAttributeId);
            if (!isBeforeSave) continue;
            DynamicObjectCollection attItemColl = exConvertEntity.getDynamicObjectCollection("attitem");
            boolean validate = ExCommonViewService.validateBeSdBeforeSave(this.getView(), beSd, attItemColl, 3);
            if (!validate) {
                return false;
            }
            DynamicObject dy = exConvertEntity.getDynamicObject("resattitem");
            boolean result = ExCommonViewService.validateBeSd(this.getView(), beSd, 3, dy);
            if (result) continue;
            return false;
        }
        return true;
    }

    private boolean checkConversionAttItems(boolean isBeforeSave) {
        DynamicObjectCollection exConvertEntry = this.getModel().getEntryEntity("entryentity");
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject exConvertEntity : exConvertEntry) {
            BigDecimal curValue = ExRuleService.getUnitValue((BigDecimal)exConvertEntity.getBigDecimal("value"), (String)exConvertEntity.getString("vunit"));
            BigDecimal maxValue = ExRuleService.getUnitValue((BigDecimal)exConvertEntity.getBigDecimal("values"), (String)exConvertEntity.getString("vunits"));
            if (curValue != null && maxValue != null && maxValue.compareTo(BigDecimal.ZERO) > 0 && curValue.compareTo(maxValue) >= 0) {
                this.getView().showTipNotification(ExKDStringHelper.compareValue());
                return false;
            }
            boolean result = ExRuleService.checkAttItems((IFormView)this.getView(), (DynamicObject)exConvertEntity, (Map)map, (boolean)isBeforeSave);
            if (result) continue;
            return false;
        }
        return true;
    }

    private void exRuleView(String opKey) {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject dy = (DynamicObject)entryEntity.get(row);
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        long createOrgId = this.getView().getModel().getDataEntity().getLong("createorg.id");
        map.put("createorg", String.valueOf(createOrgId));
        map.put("exruledetailview", dy);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (HRStringUtils.equals((String)opKey, (String)"see")) {
            status = OperationStatus.VIEW;
        }
        FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.Modal, null, (String)"wtp_exruledetail", (CloseCallBack)new CloseCallBack((IFormPlugin)this, "exruledetail_edit" + row), (HashMap)map, (OperationStatus)status);
        this.getView().showForm(parameter);
    }

    private boolean checkExConfig() {
        DynamicObjectCollection exConfigEntryEntity = this.getModel().getEntryEntity("ruleentryentity");
        Date beSd = this.getModel().getDataEntity().getDate("bsed");
        if (exConfigEntryEntity == null || exConfigEntryEntity.isEmpty()) {
            this.getView().showTipNotification(ExKDStringHelper.exConfigListError());
            return false;
        }
        for (DynamicObject dy : exConfigEntryEntity) {
            Long exConfigId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"exconfigid");
            if (exConfigId == null || exConfigId == 0L) {
                this.getView().showTipNotification(ExKDStringHelper.exConfigListError());
                return false;
            }
            DynamicObject exConfigDy = dy.getDynamicObject("exconfigid");
            boolean validate = ExCommonViewService.validateBeSd(this.getView(), beSd, 3, exConfigDy);
            if (validate) continue;
            return false;
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        boolean checkResult;
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"exconfig") && (checkResult = ExCommonViewService.checkBeSdBeforeF7Select(this.getView(), beforeF7SelectEvent))) {
            DynamicObjectCollection exConfigEntryEntity = this.getModel().getEntryEntity("ruleentryentity");
            Object[] objectArray = exConfigEntryEntity.stream().map(ee -> ee.getLong("exconfigid.id")).toArray();
        }
    }
}

