/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.ex.common;

import java.util.Date;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;

public class ExCommonViewService {
    public static boolean checkBeSd(IFormView view) {
        Date beSd = (Date)view.getModel().getValue("bsed");
        if (beSd == null) {
            view.showTipNotification(ExKDStringHelper.beSdCheck());
            return false;
        }
        return true;
    }

    public static boolean checkBeSdBeforeF7Select(IFormView view, BeforeF7SelectEvent beforeF7SelectEvent) {
        Date beSd = (Date)view.getModel().getValue("bsed");
        return ExCommonViewService.checkBeSdBeforeF7Select(beSd, view, beforeF7SelectEvent);
    }

    public static boolean checkBeSdBeforeF7SelectWithSubPage(IFormView view, BeforeF7SelectEvent beforeF7SelectEvent) {
        Date beSd = (Date)view.getParentView().getModel().getValue("bsed");
        return ExCommonViewService.checkBeSdBeforeF7Select(beSd, view, beforeF7SelectEvent);
    }

    public static boolean checkBeSdBeforeF7Select(Date beSd, IFormView view, BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beSd == null) {
            view.showTipNotification(ExKDStringHelper.beSdCheck());
            beforeF7SelectEvent.setCancel(true);
            return false;
        }
        beforeF7SelectEvent.addCustomQFilter(new QFilter("firstbsed", "<=", (Object)beSd));
        return true;
    }

    public static boolean validateBeSd(IFormView view, String key) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        Date beSd = dataEntity.getDate("bsed");
        if (beSd == null) {
            view.showTipNotification(ExKDStringHelper.beSdCheck());
            return false;
        }
        DynamicObject validateDy = dataEntity.getDynamicObject(key);
        if (validateDy != null) {
            String exName = validateDy.getString("name");
            String errorMsg = ExKDStringHelper.schemeDeSdCheck();
            Date beSdDate = validateDy.getDate("firstbsed");
            if (beSdDate.after(beSd)) {
                view.showErrorNotification(String.format(Locale.ROOT, errorMsg, exName));
                return false;
            }
        }
        return true;
    }

    public static boolean validateBeSd(IFormView view, Date beSd, int type, DynamicObject dy) {
        if (dy != null) {
            Date beSdDate;
            String exName = dy.getString("name");
            String errorMsg = "";
            if (type == 3) {
                errorMsg = ExKDStringHelper.ruleDeSdCheck();
            } else if (type == 4) {
                errorMsg = ExKDStringHelper.configDeSdCheck();
            }
            Date date = beSdDate = dy.containsProperty("firstbsed") ? dy.getDate("firstbsed") : dy.getDate("bsed");
            if (beSdDate.after(beSd)) {
                view.showErrorNotification(String.format(Locale.ROOT, errorMsg, exName));
                return false;
            }
        }
        return true;
    }

    public static boolean validateBeSdBeforeSave(IFormView view, Date beSd, DynamicObjectCollection collection, int type) {
        if (collection != null && !collection.isEmpty()) {
            String errorMsg = "";
            if (type == 3) {
                errorMsg = ExKDStringHelper.ruleDeSdCheck();
            } else if (type == 2) {
                errorMsg = ExKDStringHelper.processDeSdCheck();
            } else if (type == 4) {
                errorMsg = ExKDStringHelper.configDeSdCheck();
            }
            for (DynamicObject dy : collection) {
                String exName = ((OrmLocaleValue)dy.get("fbasedataid.name")).getLocaleValue();
                Date beSdDate = (Date)dy.get("fbasedataid.firstbsed");
                if (!beSdDate.after(beSd)) continue;
                view.showErrorNotification(String.format(Locale.ROOT, errorMsg, exName));
                return false;
            }
        }
        return true;
    }
}

