/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.ex.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.utils.TypeOperatorsUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.TipsSupport;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.common.predata.wtbd.PreDataPunchCardPair;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtp.business.ex.ExConditionFilterService;
import kd.wtc.wtp.business.ex.ExConfigService;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.business.ex.helper.ExRefConfigHelper;
import kd.wtc.wtp.utils.WTCSheetUtil;

public class ExConfigViewService {
    private ExConfigViewService() {
        throw new IllegalStateException("Utility class");
    }

    public static void dealWithConditionShow(IFormView view) {
        boolean enableExcept = ExConditionFilterService.showCondition();
        if (!enableExcept) {
            view.setVisible(Boolean.FALSE, new String[]{"conditionfiltershow"});
        }
    }

    public static void setOrgItemShow(long exAttributeId, IDataModel model) {
        if (exAttributeId == 0L) {
            return;
        }
        model.setValue("originalitem", (Object)ExRefConfigHelper.getOriItemId((long)exAttributeId));
    }

    public static void setResultItemShow(long exAttributeId, IDataModel model) {
        if (exAttributeId == 0L) {
            return;
        }
        Long resultItemId = ExRefConfigHelper.getResultItemId((long)exAttributeId);
        if (resultItemId == null || resultItemId == 0L) {
            return;
        }
        Object[] itemDataArr = new Object[]{resultItemId};
        model.setValue("attitems", (Object)itemDataArr);
    }

    public static void dealWithAdd(IDataModel model, IFormView view, BeforeDoOperationEventArgs args, IFormPlugin plugin) {
        DynamicObjectCollection entryData = model.getEntryEntity("entryentity");
        for (DynamicObject dy : entryData) {
            String conditionShow = dy.getString("conditionfiltershow");
            if (!HRStringUtils.equals((String)conditionShow, (String)ExConditionFilterService.getUnLimitStr())) continue;
            view.showTipNotification(ExKDStringHelper.conditionPareError());
            args.setCancel(true);
            return;
        }
        ExConfigViewService.addExConfigDetail(plugin, model, view);
    }

    public static void addExConfigDetail(IFormPlugin plugin, IDataModel model, IFormView view) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("exAttributeId", ExConfigViewService.getExAttId(model, view));
        map.put("dealtypeshow", model.getValue("dealtypeshow"));
        boolean showCondition = ExConfigViewService.judgeShowCondition(model);
        map.put("showcondition", showCondition);
        DynamicObject oriDy = (DynamicObject)model.getValue("originalitemshowtwo");
        if (oriDy == null) {
            view.showTipNotification(ExKDStringHelper.oriItem());
            return;
        }
        map.put("originalitemshowtwo", String.valueOf(oriDy.getLong("id")));
        String formId = showCondition ? "wtp_exconfiguredetail" : "wtp_exconfigdetailnocon";
        FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.Modal, null, (String)formId, (CloseCallBack)new CloseCallBack(plugin, "wtp_exconfiguredetail"), map, (OperationStatus)view.getFormShowParameter().getStatus());
        parameter.setCaption(ResManager.loadKDString((String)"\u5f02\u5e38\u9879\u76ee\u8bbe\u7f6e", (String)"PageWtpExConfigDetailCaption", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        view.showForm(parameter);
    }

    private static long getExAttId(IDataModel model, IFormView view) {
        long exAttributeId = ExConfigService.getExAttributeId((IDataModel)model);
        if (exAttributeId != 0L) {
            return exAttributeId;
        }
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return exAttributeId;
        }
        if (HRStringUtils.equals((String)"wtp_exconfig", (String)parentView.getFormShowParameter().getFormId())) {
            exAttributeId = ExConfigService.getExAttributeId((IDataModel)parentView.getModel());
        }
        return exAttributeId;
    }

    private static boolean judgeShowCondition(IDataModel model) {
        DynamicObject exAttribute = model.getDataEntity().getDynamicObject("exattribute");
        boolean isShow = ExConditionFilterService.showCondition();
        if (exAttribute == null) {
            return isShow;
        }
        return ExConfigService.isCategoryA((Long)exAttribute.getLong("id")) && isShow;
    }

    public static void editExConfigDetail(IFormPlugin plugin, IDataModel model, IFormView view, String opKey) {
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        DynamicObject dy = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        String dealTypeShow = (String)model.getValue("dealtypeshow");
        boolean isNotStep = HRStringUtils.equals((String)"A", (String)dealTypeShow);
        if (isNotStep && dy.getString("aruleshow") == null) {
            dy.set("culvalue", null);
            dy.set("maxvalue", null);
            dy.set("dealmethod", (Object)"B");
            dy.set("appointvalue", null);
            dy.set("roundrule", null);
        }
        if (!isNotStep && dy.getString("bruleshow") == null) {
            dy.set("culvalue", null);
            dy.set("maxvalue", null);
            dy.set("roundrule", null);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("exconfigdetail", dy);
        map.put("dealtypeshow", model.getValue("dealtypeshow"));
        DynamicObject oriDy = (DynamicObject)model.getValue("originalitemshowtwo");
        if (oriDy == null) {
            view.showTipNotification(ExKDStringHelper.oriItem());
            return;
        }
        map.put("originalitemshowtwo", String.valueOf(oriDy.getLong("id")));
        boolean showCondition = ExConfigViewService.judgeShowCondition(model);
        map.put("showcondition", showCondition);
        String formId = showCondition ? "wtp_exconfiguredetail" : "wtp_exconfigdetailnocon";
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (HRStringUtils.equals((String)opKey, (String)"see")) {
            status = OperationStatus.VIEW;
        }
        FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.Modal, null, (String)formId, (CloseCallBack)new CloseCallBack(plugin, ExConfigService.getEditActionId((int)entryCurrentRowIndex)), map, (OperationStatus)status);
        parameter.setCaption(ResManager.loadKDString((String)"\u5f02\u5e38\u9879\u76ee\u8bbe\u7f6e", (String)"PageWtpExConfigDetailCaption", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        view.showForm(parameter);
    }

    public static void dealTypeChange(String dealTypeShow, boolean categoryB, IDataModel model) {
        boolean isStep = HRStringUtils.equals((String)dealTypeShow, (String)"B");
        if (isStep) {
            return;
        }
        if (!categoryB && ExConditionFilterService.showCondition()) {
            return;
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        for (int row = 0; row < entryEntity.size(); ++row) {
            if (row == 0) continue;
            model.deleteEntryRow("entryentity", row);
        }
    }

    public static void detailClosedCallBack(Map<String, Object> returnData, IDataModel model, IFormView view) {
        if (returnData == null) {
            return;
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        int row = 0;
        if (entryEntity != null) {
            row = entryEntity.size();
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", 1);
        ExConfigViewService.setValue(returnData, model, row);
        model.endInit();
        view.updateView("entryentity");
    }

    public static void editDetailClosedCallBack(Map<String, Object> returnData, IDataModel model, IFormView view, int row) {
        if (returnData == null) {
            return;
        }
        model.beginInit();
        ExConfigViewService.setValue(returnData, model, row);
        model.endInit();
        view.updateView("entryentity");
    }

    public static void setEntryByList(List<Map<String, Object>> list, IDataModel model) {
        if (list.isEmpty()) {
            return;
        }
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", list.size());
        int row = 0;
        for (Map<String, Object> map : list) {
            if (row == 0) {
                model.setValue("punchcardshow", map.get("punchcard"));
                model.setValue("dealtypeshow", map.get("dealtype"));
                model.setValue("originalitemshowtwo", map.get("originalitem"));
            }
            ExConfigViewService.setValue(map, model, row);
            ++row;
        }
    }

    private static void setValue(Map<String, Object> returnData, IDataModel model, int row) {
        model.setValue("conditionfiltershow", returnData.get("conditionfiltershow"), row);
        model.setValue("conditionfilter", returnData.get("conditionfilter"), row);
        model.setValue("are", returnData.get("are"), row);
        model.setValue("culvalue", returnData.get("culvalue"), row);
        model.setValue("culunit", returnData.get("culunit"), row);
        model.setValue("bre", returnData.get("bre"), row);
        model.setValue("maxvalue", returnData.get("maxvalue"), row);
        model.setValue("maxunit", returnData.get("maxunit"), row);
        model.setValue("roundrule", returnData.get("roundrule"), row);
        model.setValue("appointvalue", returnData.get("appointvalue"), row);
        model.setValue("appointunit", returnData.get("appointunit"), row);
        model.setValue("dealmethod", returnData.get("dealmethod"), row);
        model.setValue("originalitem", returnData.get("originalitem"), row);
        model.setValue("dealtype", returnData.get("dealtype"), row);
        model.setValue("attitems", returnData.get("attitems"), row);
        model.setValue("aruleshow", returnData.get("aruleshow"), row);
        model.setValue("aresultshow", returnData.get("aresultshow"), row);
        model.setValue("bruleshow", returnData.get("bruleshow"), row);
        model.setValue("bresultshow", returnData.get("bresultshow"), row);
    }

    public static List<Map<String, Object>> getListByEntry(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        Object punchCardShow = model.getValue("punchcardshow");
        Object dealTypeShow = model.getValue("dealtypeshow");
        ArrayList list = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
        for (DynamicObject dy : entryEntity) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("conditionfiltershow", dy.get("conditionfiltershow"));
            map.put("conditionfilter", dy.get("conditionfilter"));
            map.put("are", dy.get("are"));
            map.put("culvalue", dy.get("culvalue"));
            map.put("culunit", dy.get("culunit"));
            map.put("bre", dy.get("bre"));
            map.put("maxvalue", dy.get("maxvalue"));
            map.put("maxunit", dy.get("maxunit"));
            map.put("roundrule", dy.get("roundrule"));
            map.put("dealmethod", dy.get("dealmethod"));
            map.put("appointvalue", dy.get("appointvalue"));
            map.put("appointunit", dy.get("appointunit"));
            map.put("punchcard", punchCardShow);
            map.put("originalitem", dy.get("originalitem"));
            map.put("attitems", dy.get("attitems"));
            map.put("dealtype", dealTypeShow);
            map.put("aruleshow", dy.get("aruleshow"));
            map.put("aresultshow", dy.get("aresultshow"));
            map.put("bruleshow", dy.get("bruleshow"));
            map.put("bresultshow", dy.get("bresultshow"));
            list.add(map);
        }
        return list;
    }

    public static Map<String, Object> getMapOfAbs(IFormView view) {
        IDataModel model = view.getModel();
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put("punchcardshow", model.getValue("punchcardshow"));
        map.put("originalitem", model.getValue("originalitem"));
        map.put("attitems", model.getValue("attitems"));
        return map;
    }

    public static void setAbsValue(Map<String, Object> map, IDataModel model) {
        model.setValue("punchcardshow", map.get("punchcardshow"));
        model.setValue("originalitem", map.get("originalitem"));
        model.setValue("attitems", map.get("attitems"));
    }

    public static void setAbsValueOfView(Map<String, Object> map, IDataModel model) {
        model.setValue("punchcardshow", ((JSONObject)map.get("punchcardshow")).get((Object)"id"));
        model.setValue("originalitem", ((JSONObject)map.get("originalitem")).get((Object)"id"));
        JSONArray attItems = (JSONArray)map.get("attitems");
        ExConfigViewService.setResultItem(attItems, model);
    }

    public static void setResultItem(JSONArray attItems, IDataModel model) {
        if (attItems != null) {
            Object[] ids = new Object[attItems.size()];
            for (int j = 0; j < attItems.size(); ++j) {
                Object id;
                JSONObject object = attItems.getJSONObject(j);
                ids[j] = id = object.getJSONObject("fbasedataid").get((Object)"id");
            }
            model.setValue("attitems", (Object)ids);
        }
    }

    public static void setResultItem(JSONArray attItems, IDataModel model, int row) {
        if (attItems != null) {
            Object[] ids = new Object[attItems.size()];
            for (int j = 0; j < attItems.size(); ++j) {
                Object id;
                JSONObject object = attItems.getJSONObject(j);
                ids[j] = id = object.getJSONObject("fbasedataid").get((Object)"id");
            }
            model.setValue("attitems", (Object)ids, row);
        }
    }

    public static void dealWithCondition(IFormView view, String controlKey) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)1);
        Map comparisonOperatorsMap = TypeOperatorsUtil.getComparisonOperatorsMap();
        HashMap newMap = Maps.newHashMapWithExpectedSize((int)16);
        Set entries = comparisonOperatorsMap.entrySet();
        for (Map.Entry next : entries) {
            newMap.put(next.getKey(), next.getValue());
        }
        List list = (List)newMap.get("enum");
        if (list != null) {
            ArrayList needList = Lists.newArrayListWithCapacity((int)2);
            for (Map map : list) {
                String value = (String)map.get("value");
                if (!HRStringUtils.equals((String)RuleOperatorEnum.EQUAL.getValue(), (String)value) && !HRStringUtils.equals((String)RuleOperatorEnum.NOT_EQUAL.getValue(), (String)value) && !HRStringUtils.equals((String)RuleOperatorEnum.IN.getValue(), (String)value) && !HRStringUtils.equals((String)RuleOperatorEnum.NOT_IN.getValue(), (String)value)) continue;
                needList.add(map);
            }
            newMap.put("enum", needList);
        }
        data.put("comparisonOpt", newMap);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.invokeControlMethod(controlKey, "updateData", new Object[]{data});
    }

    public static void setOpColumnShow(IFormView view, IFormView opView) {
        boolean isView = false;
        if (view != null) {
            isView = WTCHisService.isLock((IFormView)view);
        }
        opView.setVisible(Boolean.valueOf(isView), new String[]{"operationcolumnapsee"});
        opView.setVisible(Boolean.valueOf(!isView), new String[]{"operationcolumnap"});
    }

    public static void clearEntryData(IFormView view) {
        IDataModel model = view.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        model.endInit();
        view.updateView("entryentity");
    }

    public static void setFormStatus(TargetCondition control) {
        if (control == null) {
            return;
        }
        control.setPageState("VIEW");
    }

    public static void setFormStatusOfEdit(TargetCondition control) {
        if (control == null) {
            return;
        }
        control.setPageState("EDIT");
    }

    public static boolean check(List<String> keyList, DynamicObject dataEntity, IFormView view) {
        ArrayList errorKeyList = Lists.newArrayListWithCapacity((int)keyList.size());
        for (String key2 : keyList) {
            Object obj = dataEntity.get(key2);
            ExConfigViewService.judeErrorList(obj, key2, errorKeyList);
        }
        if (errorKeyList.isEmpty()) {
            return true;
        }
        List tipsList = errorKeyList.stream().map(key -> {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setSuccess(false);
            fieldTip.setTip(ExKDStringHelper.fillInError());
            fieldTip.setFieldKey(key);
            fieldTip.setTipsType(FieldTip.FieldTipsTypes.scope);
            fieldTip.setLevel(FieldTip.FieldTipsLevel.Error);
            return fieldTip;
        }).collect(Collectors.toList());
        view.showFieldTips(tipsList);
        return false;
    }

    private static void judeErrorList(Object obj, String key, List<String> errorKeyList) {
        if (obj == null) {
            errorKeyList.add(key);
        } else if (obj instanceof String) {
            if (HRStringUtils.equals((String)"", (String)((String)obj))) {
                errorKeyList.add(key);
            }
        } else if (obj instanceof DynamicObject) {
            if (((DynamicObject)obj).getLong("id") == 0L) {
                errorKeyList.add(key);
            }
        } else if (obj instanceof DynamicObjectCollection && ((DynamicObjectCollection)obj).isEmpty()) {
            errorKeyList.add(key);
        } else if (obj instanceof Integer && (Integer)obj == 0) {
            errorKeyList.add(key);
        } else if (obj instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)obj) == 0) {
            errorKeyList.add(key);
        }
    }

    public static void setTips(Map<String, String> map, IFormView view) {
        ExConfigViewService.setTips(map, view, "wtp_exconfig");
    }

    public static void setTips(Map<String, String> map, IFormView view, String pageNumber) {
        if (map == null || map.isEmpty()) {
            return;
        }
        Map<String, String> promptMap = ExConfigViewService.getPromptMap(view, pageNumber);
        WTCFormUtils.setTips((IFormView)view, promptMap);
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> next : entries) {
            String key = next.getKey();
            String value = next.getValue();
            Control control = view.getControl(key);
            if (!(control instanceof TipsSupport) || value == null || promptMap.get(value) == null) continue;
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(promptMap.get(value)));
            if (control instanceof AdvContainer) {
                WTCFormUtils.setAdvContainerTips((IFormView)view, (String)key, (Tips)tips);
                continue;
            }
            ((TipsSupport)control).addTips(tips);
        }
    }

    public static Map<String, String> getPromptMap(IFormView view, String pageNumber) {
        Map controlMap = WTCFormUtils.createControlMap((String[])new String[]{pageNumber});
        return WTCFormUtils.getPromptMap((IFormView)view, (Map)controlMap, null, null, null, (Boolean)Boolean.TRUE);
    }

    public static void setDefaultCard(IDataModel model) {
        Object value = model.getValue("punchcardshow");
        if (value == null) {
            model.setValue("punchcardshow", (Object)PreDataPunchCardPair.PD_1010_S);
        }
    }

    public static void updateRuleShow(IFormView view) {
        IDataModel model = view.getModel();
        Object ori = model.getValue("originalitemshowtwo");
        if (ori == null) {
            return;
        }
        DynamicObjectCollection entryData = model.getEntryEntity("entryentity");
        for (int index = 0; index < entryData.size(); ++index) {
            DynamicObject eachDy = (DynamicObject)entryData.get(index);
            eachDy.set("originalitem", ori);
            model.setValue("aruleshow", (Object)ExConfigService.getNoStepRuleStr((DynamicObject)eachDy), index);
            model.setValue("bruleshow", (Object)ExConfigService.getStepRuleStr((DynamicObject)eachDy), index);
        }
        view.updateView("entryentity");
    }
}

