/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.formula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.util.accountplan.AccountPlanUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtp.business.formula.FormulaRuleService;
import kd.wtc.wtp.constants.formula.FormulaRuleConstants;

public class FormulaRuleEdit
extends HRDataBaseEdit
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String SELECTED_ROW = "selectedRowIndex";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : collection) {
            DynamicObject accountStep = dynamicObject.getDynamicObject("accstep");
            if (null != accountStep) {
                int execOrder = dynamicObject.getInt("execorder");
                dynamicObject.set("execordertext", (Object)String.format("%s-%d", accountStep.getString("name"), execOrder));
                continue;
            }
            dynamicObject.set("execorder", (Object)0);
            dynamicObject.set("execordertext", null);
        }
        this.getModel().getDataEntity(true).set("entryentity", (Object)collection);
        this.getModel().getDataEntity().set("entryentity", (Object)collection);
        this.getView().updateView("entryentity");
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
    }

    public void afterCreateNewData(EventObject event) {
        super.afterCreateNewData(event);
        if (this.getView().getModel().getValue("accountplan") == null) {
            this.getView().getModel().setValue("accountplan", (Object)AccountPlanUtil.queryDefaultPlanId());
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit accountPlanEdit = (BasedataEdit)this.getControl("accountplan");
        accountPlanEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit formulaConfigEdit = (BasedataEdit)this.getControl("formulaconfig");
        formulaConfigEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit formulaConfigF7 = (MulBasedataEdit)this.getControl("formulaconfigf7");
        formulaConfigF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountStepEdit = (BasedataEdit)this.getControl("accstep");
        accountStepEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        BasedataEdit edit = (BasedataEdit)event.getSource();
        String key = edit.getKey();
        if (HRStringUtils.equals((String)"accountplan", (String)key)) {
            FormulaRuleService ruleService = new FormulaRuleService();
            Date startDate = this.checkEffDateAndSetUseOrg(event);
            if (startDate == null) {
                return;
            }
            List evaPlanFilter = ruleService.getAccountPlanFilter(startDate, "1");
            event.setCustomQFilters(evaPlanFilter);
        } else if (HRStringUtils.equals((String)"accstep", (String)key)) {
            FormulaRuleService ruleService = new FormulaRuleService();
            Date startDate = this.checkEffDateAndSetUseOrg(event);
            if (startDate == null) {
                return;
            }
            List evaPlanFilter = ruleService.getAccountStepF7Filter(startDate, null, "1");
            event.setCustomQFilters(evaPlanFilter);
        } else if (HRStringUtils.equals((String)"formulaconfig", (String)key) || HRStringUtils.equals((String)"formulaconfigf7", (String)key)) {
            FormulaRuleService ruleService = new FormulaRuleService();
            Date startDate = this.checkEffDateAndSetUseOrg(event);
            if (startDate == null) {
                return;
            }
            List evaPlanFilter = ruleService.getFormulaConfigFilter(startDate);
            event.setCustomQFilters(evaPlanFilter);
            if (HRStringUtils.equals((String)"formulaconfigf7", (String)key)) {
                event.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            }
        }
    }

    private Date checkEffDateAndSetUseOrg(BeforeF7SelectEvent event) {
        Date startDate = this.getModel().getDataEntity().getDate("bsed");
        if (startDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"FormulaRuleEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return null;
        }
        Long org = (Long)this.getView().getModel().getDataEntity().getDynamicObject("createorg").getPkValue();
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setUseOrgId(org.longValue());
        return startDate;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String hyName = event.getFieldName();
        if (HRStringUtils.equals((String)"formulaconfig", (String)hyName)) {
            Object id = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(event.getRowIndex())).getDynamicObject("formulaconfig").getPkValue();
            WTCFormUtils.showDetailView((IFormView)this.getView(), (String)"wtp_formulaset", (Object)id);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String evtKey = args.getProperty().getName();
        if (HRStringUtils.equals((String)"accstep", (String)evtKey)) {
            this.adjustExecSortAutomatically();
        } else if (HRStringUtils.equals((String)evtKey, (String)"bsed") || HRStringUtils.equals((String)evtKey, (String)"bsled")) {
            DynamicObject dy = this.getModel().getDataEntity();
            Date bsed = dy.getDate("bsed");
            if (bsed == null) {
                return;
            }
            Date bsled = dy.getDate("bsled") == null ? WTCDateUtils.getMaxEndDate() : dy.getDate("bsled");
            DynamicObject accountPlanDy = dy.getDynamicObject("accountplan");
            if (null == accountPlanDy) {
                return;
            }
            Date startDate = accountPlanDy.getDate("firstbsed");
            Date endDate = accountPlanDy.getDate("bsled");
            if (startDate.compareTo(bsed) > 0 || endDate.compareTo(bsled) < 0) {
                dy.set("accountplan", null);
                this.getView().updateView("accountplan");
            }
        }
    }

    private void adjustExecSortAutomatically() {
        HashMap<String, Integer> existedExecOrders = new HashMap<String, Integer>(16);
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject accountStep = ((DynamicObject)collection.get(i)).getDynamicObject("accstep");
            if (null != accountStep) {
                String stepId = accountStep.getString("id");
                int existedExecOrder = existedExecOrders.getOrDefault(stepId, 0) + 1;
                existedExecOrders.put(stepId, existedExecOrder);
                ((DynamicObject)collection.get(i)).set("execorder", (Object)existedExecOrder);
                ((DynamicObject)collection.get(i)).set("execordertext", (Object)String.format("%s-%d", accountStep.getString("name"), existedExecOrder));
                continue;
            }
            ((DynamicObject)collection.get(i)).set("execorder", (Object)0);
            ((DynamicObject)collection.get(i)).set("execordertext", null);
        }
        this.getModel().getDataEntity(true).set("entryentity", (Object)collection);
        this.getModel().getDataEntity().set("entryentity", (Object)collection);
        this.getView().updateView("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        AbstractOperate op = (AbstractOperate)event.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "addentry": {
                BasedataEdit formulaConfig = (BasedataEdit)this.getView().getControl("formulaconfigf7");
                formulaConfig.click();
                break;
            }
            case "sort": {
                this.getView().showForm(this.getSortFormParameter());
                break;
            }
            case "deleteentry": {
                if (this.checkSelectedNoData()) {
                    return;
                }
                int[] selectRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u79fb\u9664{0}\u6761\u5206\u5f55\uff1f", (String)"FormulaRuleEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[]{selectRows.length}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("PAGE_CALL_BACK_FROM_CONFIRMDELETE", (IFormPlugin)this));
                break;
            }
            case "moveentryup": {
                if (this.checkSelectedNoData() || this.checkSelectedFirstOrLastLine(true)) {
                    return;
                }
                this.doExecuteEntryMoveOp(true);
                break;
            }
            case "moveentrydown": {
                if (this.checkSelectedNoData() || this.checkSelectedFirstOrLastLine(false)) {
                    return;
                }
                this.doExecuteEntryMoveOp(false);
                break;
            }
            case "moveto": {
                if (this.checkSelectedNoData()) {
                    return;
                }
                int[] selectedRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
                if (selectedRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u540c\u65f6\u5bf9\u591a\u884c\u5206\u5f55\u4f7f\u7528\u201c\u79fb\u52a8\u81f3\u201d\u3002\u8bf7\u4ec5\u9009\u62e9\u4e00\u884c\u5206\u5f55\u3002", (String)"FormulaRuleEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showForm(this.getExecOrderMoveToFormParameter(selectedRows[0]));
                break;
            }
        }
    }

    private boolean checkSelectedNoData() {
        int[] selectedRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
        if (selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"FormulaRuleEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkSelectedFirstOrLastLine(boolean moveUp) {
        int[] selectedRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
        int rows = this.getModel().getEntryRowCount("entryentity");
        ArrayList<Integer> selectedRowList = new ArrayList<Integer>(selectedRows.length);
        for (int selectedRow : selectedRows) {
            selectedRowList.add(selectedRow);
        }
        if (selectedRowList.contains(0) && moveUp) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u9996\u884c\uff0c\u65e0\u6cd5\u4e0a\u79fb\u3002", (String)"FormulaRuleEdit_8", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (selectedRowList.contains(rows - 1) && !moveUp) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u672b\u884c\uff0c\u65e0\u6cd5\u4e0b\u79fb\u3002", (String)"FormulaRuleEdit_9", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private FormShowParameter getExecOrderMoveToFormParameter(int selectedRowIndex) {
        int rows = this.getModel().getEntryRowCount("entryentity");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(SELECTED_ROW, selectedRowIndex);
        params.put("formType", "adjustSeq");
        params.put("minSeq", rows > 0 ? 1 : 0);
        params.put("maxSeq", rows);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtp_formulaexecseq");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParams(params);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "moveto"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u987a\u5e8f\u8c03\u6574", (String)"FormulaRuleEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        return formShowParameter;
    }

    private FormShowParameter getSortFormParameter() {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("formType", "msg");
        params.put("msg", ResManager.loadKDString((String)"\u516c\u5f0f\u914d\u7f6e\u6267\u884c\u540e\uff0c\u76f8\u540c\u201c\u5173\u8054\u6838\u7b97\u6b65\u9aa4\u201d\u7684\u914d\u7f6e\u5c06\u4e00\u5e76\u5c55\u793a\uff0c\u65b9\u4fbf\u9605\u89c8\u548c\u7ef4\u62a4\u3002\u6392\u5e8f\u4f18\u5316\u540e\uff0c\u201c\u6b65\u9aa4\u5185\u6267\u884c\u987a\u5e8f\u201d\u4e0d\u4f1a\u6539\u53d8\uff0c\u4e5f\u4e0d\u4f1a\u5f71\u54cd\u516c\u5f0f\u7684\u6267\u884c\u987a\u5e8f\u3002\u786e\u8ba4\u6267\u884c\uff1f", (String)"FormulaRuleEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtp_formulaexecseq");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCustomParams(params);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sort"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6392\u5e8f\u4f18\u5316", (String)"FormulaRuleEdit_7", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        return formShowParameter;
    }

    private void doExecuteSortOp() {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (collection.isEmpty()) {
            return;
        }
        collection.sort((xDy, yDy) -> {
            DynamicObject xStep = xDy.getDynamicObject("accstep");
            DynamicObject yStep = yDy.getDynamicObject("accstep");
            int compare = (xStep != null ? xStep.getString("number") : "").compareTo(yStep != null ? yStep.getString("number") : "");
            return compare != 0 ? compare : Integer.compare(xDy.getInt("execorder"), yDy.getInt("execorder"));
        });
        this.getModel().getDataEntity(true).set("entryentity", (Object)collection);
        this.getModel().getDataEntity().set("entryentity", (Object)collection);
        this.getView().updateView("entryentity");
    }

    private void doExecuteEntryMoveOp(boolean moveUp) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (collection.isEmpty()) {
            return;
        }
        int[] selectedRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
        if (selectedRows.length == 0) {
            return;
        }
        if (!moveUp) {
            int[] selectedRowsCopy = new int[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                selectedRowsCopy[i] = selectedRows[selectedRows.length - i - 1];
            }
            selectedRows = selectedRowsCopy;
        }
        for (int selectedRowIndex : selectedRows) {
            this.doExecuteEntryMoveOpByLine(selectedRowIndex, collection, moveUp);
        }
        this.getView().updateView("entryentity");
        this.resetSelectedRowsState(selectedRows, collection.size(), moveUp);
    }

    private void resetSelectedRowsState(int[] selectedRowIndexArr, int entrySize, boolean moveUp) {
        int i;
        int[] resetSelectedRowIndexArr = new int[selectedRowIndexArr.length];
        if (moveUp) {
            for (i = 0; i < selectedRowIndexArr.length; ++i) {
                resetSelectedRowIndexArr[i] = selectedRowIndexArr[i] == 0 ? 0 : selectedRowIndexArr[i] - 1;
            }
        } else {
            for (i = 0; i < selectedRowIndexArr.length; ++i) {
                resetSelectedRowIndexArr[i] = selectedRowIndexArr[i] == entrySize - 1 ? entrySize - 1 : selectedRowIndexArr[i] + 1;
            }
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.selectRows(resetSelectedRowIndexArr, resetSelectedRowIndexArr[0]);
    }

    private void doExecuteEntryMoveOpByLine(int selectedRowIndex, DynamicObjectCollection collection, boolean moveUp) {
        DynamicObject curData;
        if (moveUp && selectedRowIndex > 0) {
            curData = (DynamicObject)collection.get(selectedRowIndex);
            DynamicObject upData = (DynamicObject)collection.get(selectedRowIndex - 1);
            DynamicObject curStep = curData.getDynamicObject("accstep");
            DynamicObject upStep = upData.getDynamicObject("accstep");
            if (null != curStep && null != upStep && HRStringUtils.equals((String)curStep.getString("id"), (String)upStep.getString("id"))) {
                int curOrder = curData.getInt("execorder");
                int upOrder = upData.getInt("execorder");
                curData.set("execorder", (Object)upOrder);
                curData.set("execordertext", (Object)String.format("%s-%d", upStep.getString("name"), upOrder));
                upData.set("execorder", (Object)curOrder);
                upData.set("execordertext", (Object)String.format("%s-%d", curStep.getString("name"), curOrder));
            }
            this.getModel().moveEntryRowUp("entryentity", selectedRowIndex);
        } else if (!moveUp && selectedRowIndex < collection.size() - 1) {
            curData = (DynamicObject)collection.get(selectedRowIndex);
            DynamicObject downData = (DynamicObject)collection.get(selectedRowIndex + 1);
            DynamicObject curStep = curData.getDynamicObject("accstep");
            DynamicObject downStep = downData.getDynamicObject("accstep");
            if (null != curStep && null != downStep && HRStringUtils.equals((String)curStep.getString("id"), (String)downStep.getString("id"))) {
                int curOrder = curData.getInt("execorder");
                int downOrder = downData.getInt("execorder");
                curData.set("execorder", (Object)downOrder);
                curData.set("execordertext", (Object)String.format("%s-%d", downStep.getString("name"), downOrder));
                downData.set("execorder", (Object)curOrder);
                downData.set("execordertext", (Object)String.format("%s-%d", curStep.getString("name"), curOrder));
            }
            this.getModel().moveEntryRowDown("entryentity", selectedRowIndex);
        }
        DynamicObjectCollection newCollections = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList entries = new ArrayList(newCollections);
        collection.clear();
        collection.addAll(entries);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs args) {
        EntryProp entryProp = args.getEntryProp();
        String confirm = (String)this.getView().getFormShowParameter().getCustomParam("confirm");
        if (!"true".equals(confirm) && null != entryProp && WTCStringUtils.equals((String)"entryentity", (String)entryProp.getName())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u79fb\u9664{0}\u6761\u5206\u5f55\uff1f", (String)"FormulaRuleEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[]{1}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("PAGE_CALL_BACK_FROM_CONFIRMDELETE", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs event) {
        RowDataEntity[] dataEntities;
        super.afterAddRow(event);
        for (RowDataEntity dataEntity : dataEntities = event.getRowDataEntities()) {
            this.getModel().setValue("accstep", (Object)FormulaRuleConstants.PD_DAFO_1010_S, dataEntity.getRowIndex());
        }
        this.adjustExecSortAutomatically();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes.equals((Object)event.getResult()) && "PAGE_CALL_BACK_FROM_CONFIRMDELETE".equals(event.getCallBackId())) {
            int[] selectedRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
            this.getView().getFormShowParameter().setCustomParam("confirm", (Object)"true");
            this.getView().getModel().deleteEntryRows("entryentity", selectedRows);
            this.adjustExecSortAutomatically();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (HRStringUtils.equals((String)"moveto", (String)actionId)) {
            this.doMoveToCloseCallback(event);
        } else if (HRStringUtils.equals((String)"sort", (String)actionId)) {
            Map returnData = (Map)event.getReturnData();
            if (null != returnData) {
                this.doExecuteSortOp();
            }
        } else if (HRStringUtils.equals((String)"formulaconfigf7", (String)event.getActionId())) {
            this.doFormulaConfigCloseCallback(event);
        }
    }

    private void doMoveToCloseCallback(ClosedCallBackEvent event) {
        int i;
        Map returnData = (Map)event.getReturnData();
        if (null == returnData) {
            return;
        }
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        int selectedRowIndex = (Integer)returnData.get(SELECTED_ROW);
        int curRowIndex = selectedRowIndex + 1;
        int moveRowIndex = (Integer)returnData.get("movetoseq");
        if (moveRowIndex <= 0 || moveRowIndex > collection.size() || moveRowIndex == curRowIndex) {
            return;
        }
        if (moveRowIndex < curRowIndex) {
            for (i = curRowIndex; i > moveRowIndex; --i) {
                this.doExecuteEntryMoveOpByLine(i - 1, collection, true);
            }
        } else {
            for (i = curRowIndex; i < moveRowIndex; ++i) {
                this.doExecuteEntryMoveOpByLine(i - 1, collection, false);
            }
        }
        this.getView().updateView("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.selectRows(moveRowIndex - 1);
    }

    private void doFormulaConfigCloseCallback(ClosedCallBackEvent event) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
        if (CollectionUtils.isEmpty((Collection)returnData)) {
            return;
        }
        for (ListSelectedRow returnDatum : returnData) {
            int entryRow = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("formulaconfig", returnDatum.getPrimaryKeyValue(), entryRow);
        }
        this.getView().updateView("entryentity");
        this.getModel().setValue("formulaconfigf7", null);
    }
}

