/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.incrdecrrules;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtp.constants.incdec.IncDecConfigConstants;

public class IncDecConfCondCusPlugin
extends HRDynamicFormBasePlugin
implements IncDecConfigConstants {
    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.initCustomControl();
    }

    private void initCustomControl() {
        DynamicObjectCollection entryEntity;
        IFormView parentView = this.getView().getParentView();
        boolean isLock = false;
        if (parentView != null) {
            isLock = WTCHisService.isLock((IFormView)parentView);
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String showType = isLock ? "1" : "0";
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String conditionType = (String)formShowParameter.getCustomParam("logictype");
        conditionType = HRStringUtils.isEmpty((String)conditionType) ? "0" : conditionType;
        String condition = (String)formShowParameter.getCustomParam("logicstr");
        if (HRStringUtils.isEmpty((String)condition) && (entryEntity = this.getModel().getEntryEntity("condsubentryentity")).size() == 1 && ((DynamicObject)entryEntity.get(0)).getDynamicObjectCollection("condattitem").isEmpty()) {
            condition = "T01";
        }
        HashMap<String, Object> args = new HashMap<String, Object>(16);
        args.put("showType", Integer.parseInt(showType));
        args.put("conditionType", Integer.parseInt(conditionType));
        args.put("data", condition);
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("args", args);
        IncDecConfCondCusPlugin.setCustomCtrlReturnData(this.getView(), returnData);
    }

    public void customEvent(CustomEventArgs evt) {
        super.customEvent(evt);
        String args = evt.getEventArgs();
        String eventName = evt.getEventName();
        if ("getData".equals(eventName)) {
            JSONObject jsonObj = (JSONObject)JSONObject.parse((String)args);
            Object data = jsonObj.get((Object)"data");
            Object conditionType = jsonObj.get((Object)"conditionType");
            this.getModel().setValue("logicstr", data);
            this.getModel().setValue("logictype", conditionType);
            String operateKey = jsonObj.get((Object)"opType").toString();
            if (operateKey == null) {
                return;
            }
            this.getPageCache().put("IS_SYN", "IS_SYN");
            this.getView().invokeOperation(operateKey);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        super.afterAddRow(evt);
        String entryName = evt.getEntryProp().getName();
        if ("condsubentryentity".equals(entryName)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("condsubentryentity");
            String newIndex = this.getNextLimitIndex();
            this.getModel().setValue("limitno", (Object)newIndex, entryEntity.size() - 1);
            this.sendConditionChangeEvent(Collections.singletonList(newIndex));
        }
    }

    private String getNextLimitIndex() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("condsubentryentity");
        if (entryEntity.size() == 1) {
            return "T01";
        }
        DynamicObject lastRow = (DynamicObject)entryEntity.get(entryEntity.size() - 2);
        Integer lastIndex = Integer.parseInt(lastRow.getString("limitno").substring(1));
        Integer newIndex = lastIndex + 1;
        String newIndexStr = newIndex.toString();
        if (newIndex < 10) {
            newIndexStr = "0" + newIndexStr;
        }
        return "T" + newIndexStr;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs evt) {
        String entryName = evt.getEntryProp().getName();
        if ("condsubentryentity".equals(entryName)) {
            int[] deleteRows = evt.getRowIndexs();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("condsubentryentity");
            ArrayList<String> list = new ArrayList<String>(deleteRows.length);
            for (int row : deleteRows) {
                list.add(((DynamicObject)entryEntity.get(row)).getString("limitno"));
            }
            this.sendConditionChangeEvent(list);
            if (deleteRows.length == 0 || deleteRows.length == entryEntity.size()) {
                return;
            }
            HashSet<Integer> scrappedIndex = new HashSet<Integer>(deleteRows.length);
            for (int deleteRow : deleteRows) {
                scrappedIndex.add(deleteRow);
            }
            Integer lastIndex = 0;
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (scrappedIndex.contains(i)) {
                    this.getModel().setValue("limitno", null, i);
                    continue;
                }
                if (HRStringUtils.isEmpty((String)((DynamicObject)entryEntity.get(i)).getString("limitno"))) continue;
                Integer newIndex = lastIndex + 1;
                String newIndexStr = 'T' + newIndex.toString();
                if (newIndex < 10) {
                    newIndexStr = "T0" + newIndex;
                }
                this.getModel().setValue("limitno", (Object)newIndexStr, i);
                Integer n = lastIndex;
                Integer n2 = lastIndex = Integer.valueOf(lastIndex + 1);
            }
        }
    }

    private void sendConditionChangeEvent(List<String> changeData) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("event", "conditionChange");
        returnData.put("args", changeData);
        returnData.put("nanoTime", System.nanoTime());
        IncDecConfCondCusPlugin.setCustomCtrlReturnData(this.getView(), returnData);
    }

    static void sendGetDataEvent(IFormView view, String opType) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("event", "getData");
        returnData.put("args", opType);
        returnData.put("nanoTime", System.nanoTime());
        IncDecConfCondCusPlugin.setCustomCtrlReturnData(view, returnData);
    }

    static void setCustomCtrlReturnData(IFormView view, Map<String, Object> returnData) {
        CustomControl control = (CustomControl)view.getControl("conditionlogic");
        control.setData(returnData);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"sure"})) {
            this.initCustomControl();
        }
    }
}

