/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.incrdecrrules;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.common.enums.WTCCommonMessages;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtbs.wtbd.common.attitem.AttItemItemType;
import kd.wtc.wtbs.wtp.constants.incdec.IncDecConfigConstants;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfCommonService;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfCondService;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfKDStringHelper;
import kd.wtc.wtp.formplugin.web.incrdecrrules.IncDecConfCondCusPlugin;

public class IncDecConfCondPlugin
extends HRDynamicFormBasePlugin
implements IncDecConfigConstants,
BeforeF7SelectListener {
    private static final String[] IS_TRIGGER_ITEM_EMPTY_FIELDS = new String[]{"curattitem", "battitem", "indecrrel", "indecrvalue", "triggercomp", "triggerval", "triggeritem", "triggersign", "triggerresult"};
    private static final String[] IS_NOT_TRIGGER_ITEM_EMPTY_FIELDS = new String[]{"curattitem", "battitem", "indecrrel", "indecrvalue"};
    private final IncDecConfCommonService COMMON_SERVICE = IncDecConfCommonService.getInstance();
    private final IncDecConfCondService COND_SERVICE = IncDecConfCondService.getInstance();
    private static final String BUTTON_CLOSE = "close";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_SURE = "sure";
    private static final String CONDFLEX = "condflex";
    private static final String DETAILFLEX = "detailflex";
    private static final String PARENTFLEX = "parentflex";
    private static final String ADDFLEX = "addflex";
    private static final String SERIALLIMITPANEL = "seriallimitpanel";
    private static final String TRIGGERPANEL = "triggerpanel";
    private static final String ISTRIGGERITEM = "istriggeritem";
    private static final String ISTRIGGERITEMPANEL = "istriggeritempanel";

    public void beforeBindData(EventObject ee) {
        super.beforeBindData(ee);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String createOrg = (String)formShowParameter.getCustomParam("createorg");
        if (HRStringUtils.isNotEmpty((String)createOrg)) {
            this.getModel().setValue("createorg", (Object)Long.parseLong(createOrg));
        }
        boolean lock = false;
        if (this.getView().getParentView() != null) {
            lock = WTCHisService.isLock((IFormView)this.getView().getParentView());
        }
        this.getView().setVisible(Boolean.valueOf(lock), new String[]{BUTTON_CLOSE});
        this.getView().setVisible(Boolean.valueOf(!lock), new String[]{BUTTON_CANCEL, BUTTON_SURE, "advconbaritemap", "advconbaritemap1"});
        String triggerType = (String)formShowParameter.getCustomParam("triggertype");
        this.getModel().setValue("triggertype", (Object)triggerType);
        Boolean isAdd = (Boolean)formShowParameter.getCustomParam("isAdd");
        if (isAdd != null && isAdd.booleanValue()) {
            this.COND_SERVICE.openResultPage(this.getView(), true, (IFormPlugin)this, null);
        } else {
            this.setValue(triggerType, createOrg);
        }
        if (HRStringUtils.equals((String)"D", (String)triggerType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONDFLEX, DETAILFLEX, TRIGGERPANEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{PARENTFLEX, ADDFLEX});
        } else {
            Boolean serialLimitCus = (Boolean)formShowParameter.getCustomParam("seriallimit");
            boolean serialLimit = serialLimitCus != null && serialLimitCus != false;
            this.serialLimitShow(serialLimit);
            this.isTriggerItemShow();
        }
        if (lock) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ADDFLEX});
            this.getView().setEnable(Boolean.FALSE, new String[]{"condattitem", "condrel", "condvalue"});
        }
    }

    private void setValue(String triggerType, String createOrg) {
        IDataModel model = this.getModel();
        model.beginInit();
        JSONArray jsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("load_cond_sub_view");
        if (jsonArray != null) {
            model.deleteEntryData("condsubentryentity");
            model.batchCreateNewEntryRow("condsubentryentity", jsonArray.size());
            for (int index = 0; index < jsonArray.size(); ++index) {
                JSONObject jsonObject = jsonArray.getJSONObject(index);
                model.setValue("limitno", jsonObject.get((Object)"limitno"), index);
                model.setValue("condrel", jsonObject.get((Object)"condrel"), index);
                model.setValue("condvalue", jsonObject.get((Object)"condvalue"), index);
                JSONArray itemArr = jsonObject.getJSONArray("condattitem");
                this.setItem(itemArr, index, model);
            }
        }
        this.setValueOfSerialLimit(model);
        this.setValueOfResult(triggerType, createOrg);
        model.endInit();
    }

    private void setItem(JSONArray itemArr, int index, IDataModel model) {
        if (itemArr != null) {
            Object[] idArr = new Object[itemArr.size()];
            for (int ii = 0; ii < itemArr.size(); ++ii) {
                JSONObject each = itemArr.getJSONObject(ii);
                JSONObject fbasedataid = each.getJSONObject("fbasedataid");
                if (fbasedataid == null) continue;
                if (ii == 0) {
                    model.setValue("datatype", fbasedataid.get((Object)"datatype"), index);
                    model.setValue("unit", fbasedataid.get((Object)"unit"), index);
                }
                idArr[ii] = fbasedataid.getLong("id");
            }
            model.setValue("condattitem", (Object)idArr, index);
        }
    }

    private void setValueOfSerialLimit(IDataModel model) {
        JSONObject json = (JSONObject)this.getView().getFormShowParameter().getCustomParam("load_item_sub_view");
        if (json != null) {
            model.setValue("seriallimit", json.get((Object)"seriallimit"));
            model.setValue("serialperiod", (Object)json.getString("serialperiod"));
            model.setValue("shifttype", json.get((Object)"shifttype"));
            JSONObject curItem = json.getJSONObject("curattitem");
            if (curItem != null) {
                model.setValue("curattitem", curItem.get((Object)"id"));
            }
            model.setValue("daytype", json.get((Object)"daytype"));
            JSONObject bItem = json.getJSONObject("battitem");
            if (bItem != null) {
                model.setValue("battitem", bItem.get((Object)"id"));
            }
            model.setValue("indecrrel", json.get((Object)"indecrrel"));
            model.setValue("indecrvalue", json.get((Object)"indecrvalue"));
            model.setValue(ISTRIGGERITEM, json.get((Object)ISTRIGGERITEM));
            model.setValue("triggercomp", json.get((Object)"triggercomp"));
            model.setValue("triggerval", json.get((Object)"triggerval"));
            model.setValue("triggeritem", Optional.ofNullable(json.getJSONObject("triggeritem")).map(item -> item.get((Object)"id")).orElseGet(() -> null));
            model.setValue("triggersign", json.get((Object)"triggersign"));
            model.setValue("triggerresult", json.get((Object)"triggerresult"));
        }
    }

    private void setValueOfResult(String triggerType, String createOrg) {
        JSONArray resultArr = (JSONArray)this.getView().getFormShowParameter().getCustomParam("load_result_sub_view");
        if (resultArr != null) {
            for (int index = 0; index < resultArr.size(); ++index) {
                JSONObject jsonObject = resultArr.getJSONObject(index);
                HashMap resultMap = Maps.newHashMapWithExpectedSize((int)4);
                JSONObject item = jsonObject.getJSONObject("resultitem");
                resultMap.put("resultitem", item.get((Object)"id"));
                resultMap.put("resultrel", jsonObject.get((Object)"resultrel"));
                resultMap.put("resultvalue", jsonObject.get((Object)"resultvalue"));
                resultMap.put("unit", item.get((Object)"unit"));
                resultMap.put("triggertype", triggerType);
                resultMap.put("createorg", createOrg);
                this.COND_SERVICE.openResultPage(this.getView(), index == 0, (IFormPlugin)this, (Map)resultMap);
            }
        }
    }

    private void serialLimitShow(boolean serialLimit) {
        if (serialLimit) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SERIALLIMITPANEL, DETAILFLEX, TRIGGERPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{PARENTFLEX, ADDFLEX});
            this.setFieldsMustInput(true, "seriallimit", "shifttype", "daytype", "serialperiod");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{PARENTFLEX, ADDFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{SERIALLIMITPANEL, DETAILFLEX, TRIGGERPANEL});
            this.setFieldsMustInput(true, "seriallimit");
            this.setFieldsMustInput(false, "shifttype", "daytype", "serialperiod");
        }
    }

    private void isTriggerItemShow() {
        IDataModel model = this.getModel();
        boolean isTriggerItem = model.getDataEntity().getBoolean(ISTRIGGERITEM);
        this.getView().setVisible(Boolean.valueOf(isTriggerItem), new String[]{ISTRIGGERITEMPANEL});
        this.setFieldsMustInput(isTriggerItem, "triggercomp", "triggerval", "triggeritem", "triggersign", "triggerresult");
        if (!isTriggerItem) {
            Map fields = model.getDataEntityType().getFields();
            model.beginInit();
            Stream.of("triggercomp", "triggerval", "triggeritem", "triggersign", "triggerresult").forEach(key -> {
                IDataEntityProperty prop = (IDataEntityProperty)fields.get(key);
                Object defaultVal = prop instanceof FieldProp ? ((FieldProp)prop).getDefValue() : null;
                model.setValue(key, defaultVal);
            });
            model.endInit();
            this.getView().updateView(ISTRIGGERITEMPANEL);
        }
    }

    private void setFieldsMustInput(boolean flag, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            ((FieldEdit)this.getControl(fieldName)).setMustInput(flag);
        }
    }

    public void propertyChanged(PropertyChangedArgs ee) {
        super.propertyChanged(ee);
        String key = ee.getProperty().getName();
        if (HRStringUtils.equals((String)"seriallimit", (String)key)) {
            boolean serialLimit = this.getModel().getDataEntity().getBoolean("seriallimit");
            if (serialLimit) {
                this.COMMON_SERVICE.clearCache(this.getView(), "resultcache", "resultaddflex");
            } else {
                this.COND_SERVICE.openResultPage(this.getView(), true, (IFormPlugin)this, null);
            }
            this.serialLimitShow(serialLimit);
            this.isTriggerItemShow();
        } else if (HRStringUtils.equals((String)"condattitem", (String)key)) {
            this.propertyChangedOfConfItem();
        } else if (HRStringUtils.equals((String)"curattitem", (String)key)) {
            this.getModel().setValue("battitem", this.getModel().getValue("curattitem"));
        } else if (HRStringUtils.equals((String)ISTRIGGERITEM, (String)key)) {
            this.isTriggerItemShow();
        } else if (Arrays.asList(IS_TRIGGER_ITEM_EMPTY_FIELDS).contains(key) && this.getModel().getValue(key) != null) {
            WTCFormUtils.hideFieldTips((IFormView)this.getView(), (String[])new String[]{key});
        }
    }

    private void propertyChangedOfConfItem() {
        int row;
        DynamicObject each;
        DynamicObjectCollection item;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("condsubentryentity");
        if (entryEntity != null && !entryEntity.isEmpty() && (item = (each = (DynamicObject)entryEntity.get(row = this.getModel().getEntryCurrentRowIndex("condsubentryentity"))).getDynamicObjectCollection("condattitem")) != null && !item.isEmpty()) {
            Set set;
            if (item.size() > 5) {
                this.getView().showErrorNotification(IncDecConfKDStringHelper.maxItem());
            }
            if ((set = item.stream().map(dd -> dd.getString("fbasedataid.unit")).collect(Collectors.toSet())).size() > 1) {
                this.getView().showErrorNotification(IncDecConfKDStringHelper.sameUnit());
            }
            this.getModel().setValue("datatype", ((DynamicObject)item.get(0)).get("fbasedataid.datatype"), row);
            this.getModel().setValue("unit", ((DynamicObject)item.get(0)).get("fbasedataid.unit"), row);
        }
    }

    public void registerListener(EventObject eventobject) {
        Button button;
        MulBasedataEdit mulBasedataEdit;
        super.registerListener(eventobject);
        BasedataEdit attItem = (BasedataEdit)this.getView().getControl("curattitem");
        if (attItem != null) {
            attItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((mulBasedataEdit = (MulBasedataEdit)this.getView().getControl("condattitem")) != null) {
            mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((button = (Button)this.getView().getControl(BUTTON_SURE)) != null) {
            button.addClickListener((ClickListener)this);
        }
        ((BasedataEdit)this.getControl("triggeritem")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeBindData((EventObject)beforeF7SelectEvent);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        Date beSd = (Date)parentView.getModel().getValue("bsed");
        if (beSd == null) {
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (HRStringUtils.equals((String)"curattitem", (String)key)) {
            beforeF7SelectEvent.addCustomQFilter(this.COMMON_SERVICE.getQFilter(Collections.singletonList(AttItemItemType.DETAIL_ITEM.type), beSd));
            List ignoreItems = dataEntity.getDynamicObjectCollection("condsubentryentity").stream().flatMap(entry -> entry.getDynamicObjectCollection("condattitem").stream()).map(entry -> entry.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            Optional.ofNullable(dataEntity.getDynamicObject("triggeritem")).map(DataEntityBase::getPkValue).ifPresent(ignoreItems::add);
            if (CollectionUtils.isNotEmpty(ignoreItems)) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", ignoreItems));
            }
        } else if (HRStringUtils.equals((String)"condattitem", (String)key)) {
            String triggerType = (String)this.getModel().getValue("triggertype");
            boolean isProid = HRStringUtils.equals((String)"D", (String)triggerType);
            beforeF7SelectEvent.addCustomQFilter(this.COMMON_SERVICE.getQFilterOfCond(isProid, beSd));
            List ignoreItems = Lists.newArrayList((Object[])new DynamicObject[]{dataEntity.getDynamicObject("curattitem"), dataEntity.getDynamicObject("triggeritem")}).stream().filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ignoreItems)) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", ignoreItems));
            }
        } else if (HRStringUtils.equals((String)"triggeritem", (String)key)) {
            beforeF7SelectEvent.addCustomQFilter(this.COMMON_SERVICE.getQFilter((List)Lists.newArrayList((Object[])new String[]{AttItemItemType.DETAIL_ITEM.type, AttItemItemType.DETAIL_SUM_ITEM.type}), beSd));
            List ignoreItems = dataEntity.getDynamicObjectCollection("condsubentryentity").stream().flatMap(entry -> entry.getDynamicObjectCollection("condattitem").stream()).map(entry -> entry.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            Optional.ofNullable(dataEntity.getDynamicObject("curattitem")).map(DataEntityBase::getPkValue).ifPresent(ignoreItems::add);
            if (CollectionUtils.isNotEmpty(ignoreItems)) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", ignoreItems));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        String operateKey = ((FormOperate)source).getOperateKey();
        if (HRStringUtils.equals((String)BUTTON_SURE, (String)operateKey)) {
            this.beforeDoOperationOfSure(args);
        } else if (HRStringUtils.equals((String)"newentry", (String)operateKey)) {
            DynamicObjectCollection cond = this.getModel().getDataEntity(true).getDynamicObjectCollection("condsubentryentity");
            if (cond != null && cond.size() >= 10) {
                this.getView().showTipNotification(IncDecConfKDStringHelper.condMax());
                args.setCancel(true);
            }
        } else if (HRStringUtils.equals((String)"addresult", (String)operateKey)) {
            WTCPageCache pageCache = new WTCPageCache(this.getView());
            Map regularTimeCache = (Map)pageCache.get("resultcache", Map.class);
            if (regularTimeCache != null && regularTimeCache.size() >= 10) {
                this.getView().showTipNotification(IncDecConfKDStringHelper.resultMax());
                args.setCancel(true);
                return;
            }
            this.COND_SERVICE.openResultPage(this.getView(), false, (IFormPlugin)this, null);
        }
    }

    private void beforeDoOperationOfSure(BeforeDoOperationEventArgs args) {
        String isSyn = this.getPageCache().get("IS_SYN");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (isSyn == null) {
            IncDecConfCondCusPlugin.sendGetDataEvent(this.getView(), BUTTON_SURE);
            args.setCancel(true);
            return;
        }
        this.getPageCache().put("IS_SYN", null);
        DynamicObjectCollection limitCollect = this.getModel().getEntryEntity("condsubentryentity");
        boolean validCondition = this.COND_SERVICE.isValidCondition(this.getView(), limitCollect, dataEntity.getString("logicstr"));
        if (!validCondition) {
            args.setCancel(true);
            return;
        }
        if (!this.checkSure(dataEntity)) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)BUTTON_SURE, (String)operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Map<String, Object> resultMap = this.returnData(dataEntity);
            this.getView().returnDataToParent(resultMap);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        HashMap resultMap = (HashMap)closedCallBackEvent.getReturnData();
        if (resultMap == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.startsWith("resultactionid")) {
            String opKey = (String)resultMap.get("op");
            if (HRStringUtils.equals((String)"delete", (String)opKey)) {
                this.COMMON_SERVICE.closeOneSubView(this.getView(), "resultcache", actionId, "resultaddflex");
            } else if (HRStringUtils.equals((String)"copy", (String)opKey)) {
                this.COND_SERVICE.moveData(this.getView(), actionId, (IFormPlugin)this);
            }
        }
    }

    public Map<String, Object> returnData(DynamicObject dataEntity) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection limitCollect = dataEntity.getDynamicObjectCollection("condsubentryentity");
        resultMap.put("conditionstr", this.COND_SERVICE.condShow(limitCollect, dataEntity.getString("logicstr"), dataEntity.getString("logictype")));
        resultMap.put("logictype", dataEntity.get("logictype"));
        resultMap.put("logicstr", dataEntity.get("logicstr"));
        resultMap.put("conddata", limitCollect);
        String triggerType = dataEntity.getString("triggertype");
        resultMap.put("triggertype", triggerType);
        if (HRStringUtils.equals((String)"D", (String)triggerType)) {
            this.getResult(resultMap);
            resultMap.put("resultstr", this.COND_SERVICE.resultShow(this.getView()));
        } else {
            boolean serialLimit = dataEntity.getBoolean("seriallimit");
            resultMap.put("seriallimit", serialLimit);
            if (serialLimit) {
                Stream.of("serialperiod", "shifttype", "curattitem", "daytype", "battitem", "indecrrel", "indecrvalue", ISTRIGGERITEM, "triggercomp", "triggerval", "triggeritem", "triggersign", "triggerresult").forEach(key -> resultMap.put(key, dataEntity.get(key)));
                resultMap.put("resultstr", this.COND_SERVICE.resultShow(dataEntity));
            } else {
                this.getResult(resultMap);
                resultMap.put("resultstr", this.COND_SERVICE.resultShow(this.getView()));
            }
        }
        boolean isTriggerItem = dataEntity.getBoolean(ISTRIGGERITEM);
        if (!isTriggerItem) {
            DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
            Stream.of("triggercomp", "triggerval", "triggeritem", "triggersign", "triggerresult").forEach(key -> {
                IDataEntityProperty prop = (IDataEntityProperty)properties.get(key);
                if (null != prop) {
                    Object defaultVal = prop instanceof FieldProp ? ((FieldProp)prop).getDefValue() : null;
                    resultMap.put(key, defaultVal);
                }
            });
        }
        return resultMap;
    }

    private void getResult(Map<String, Object> resultMap) {
        List cacheList = this.COMMON_SERVICE.getCacheList(this.getView(), "resultcache");
        ArrayList resultList = Lists.newArrayListWithCapacity((int)cacheList.size());
        for (String pageId : cacheList) {
            IFormView subView = this.getView().getView(pageId);
            if (subView == null) continue;
            DynamicObject result = subView.getModel().getDataEntity();
            resultList.add(result);
        }
        resultMap.put("resultdata", resultList);
    }

    private boolean checkResult() {
        List cacheList = this.COMMON_SERVICE.getCacheList(this.getView(), "resultcache");
        if (cacheList == null || cacheList.isEmpty()) {
            this.getView().showErrorNotification(IncDecConfKDStringHelper.result());
            return false;
        }
        for (String pageId : cacheList) {
            IFormView subView = this.getView().getView(pageId);
            if (subView == null) continue;
            DynamicObject result = subView.getModel().getDataEntity();
            DynamicObject item = result.getDynamicObject("resultitem");
            if (HRObjectUtils.isEmpty((Object)item)) {
                this.getView().showErrorNotification(IncDecConfKDStringHelper.resultItem());
                return false;
            }
            String rel = result.getString("resultrel");
            if (HRStringUtils.isEmpty((String)rel)) {
                this.getView().showErrorNotification(IncDecConfKDStringHelper.rel());
                return false;
            }
            BigDecimal value = result.getBigDecimal("resultvalue");
            if (value == null) {
                this.getView().showErrorNotification(IncDecConfKDStringHelper.value());
                return false;
            }
            if (value.compareTo(BigDecimal.ZERO) >= 0 && value.compareTo(new BigDecimal("9999999999.99")) <= 0) continue;
            this.getView().showErrorNotification(IncDecConfKDStringHelper.incValue());
            return false;
        }
        return true;
    }

    private boolean checkSure(DynamicObject dataEntity) {
        DynamicObjectCollection limitCollect = this.getModel().getEntryEntity("condsubentryentity");
        if (limitCollect == null || limitCollect.isEmpty()) {
            this.getView().showErrorNotification(IncDecConfKDStringHelper.cond());
            return false;
        }
        for (DynamicObject dy : limitCollect) {
            DynamicObjectCollection condItem = dy.getDynamicObjectCollection("condattitem");
            if (condItem == null || condItem.isEmpty()) {
                this.getView().showErrorNotification(IncDecConfKDStringHelper.item());
                return false;
            }
            String condRef = dy.getString("condrel");
            if (HRStringUtils.isEmpty((String)condRef)) {
                this.getView().showErrorNotification(IncDecConfKDStringHelper.rel());
                return false;
            }
            BigDecimal condValue = dy.getBigDecimal("condvalue");
            if (condValue == null) {
                this.getView().showErrorNotification(IncDecConfKDStringHelper.value());
                return false;
            }
            if (condItem.size() > 5) {
                this.getView().showErrorNotification(IncDecConfKDStringHelper.maxItem());
                return false;
            }
            Set set = condItem.stream().map(dd -> dd.getString("fbasedataid.unit")).collect(Collectors.toSet());
            if (set.size() <= 1) continue;
            this.getView().showErrorNotification(IncDecConfKDStringHelper.sameUnit());
            return false;
        }
        String triggerType = dataEntity.getString("triggertype");
        if (HRStringUtils.equals((String)"D", (String)triggerType)) {
            return this.checkResult();
        }
        boolean serialLimit = dataEntity.getBoolean("seriallimit");
        if (serialLimit) {
            boolean isTriggerItem = dataEntity.getBoolean(ISTRIGGERITEM);
            Object[] emptyFields = isTriggerItem ? IS_TRIGGER_ITEM_EMPTY_FIELDS : IS_NOT_TRIGGER_ITEM_EMPTY_FIELDS;
            emptyFields = (String[])Arrays.stream(emptyFields).filter(field -> {
                Object val = dataEntity.get(field);
                return HRObjectUtils.isEmpty((Object)val) || val instanceof Integer && Objects.equals(val, 0);
            }).toArray(String[]::new);
            Map fields = this.getModel().getDataEntityType().getFields();
            if (ArrayUtils.isNotEmpty((Object[])emptyFields)) {
                WTCFormUtils.showFieldTips((IFormView)this.getView(), (String)WTCCommonMessages.NON_NULL.load(), (String[])emptyFields);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199{0}\u3002", (String)"IncDecConfKDStringHelper_76", (String)"wtc-wtp-business", (Object[])new Object[]{Arrays.stream(emptyFields).map(field -> "\u3010" + ((IDataEntityProperty)fields.get(field)).getDisplayName().getLocaleValue() + "\u3011").collect(Collectors.joining("\u3001"))}));
                return false;
            }
            BigDecimal inDecrValue = dataEntity.getBigDecimal("indecrvalue");
            if (inDecrValue.compareTo(BigDecimal.ZERO) <= 0 || inDecrValue.compareTo(new BigDecimal("9999999999.99")) > 0) {
                this.getView().showErrorNotification(IncDecConfKDStringHelper.incValue());
                return false;
            }
            if (isTriggerItem && inDecrValue.compareTo(dataEntity.getBigDecimal("triggerval")) > 0) {
                this.getView().showErrorNotification(IncDecConfKDStringHelper.triggerVal((int)dataEntity.getInt("triggerval"), (BigDecimal)inDecrValue));
                return false;
            }
            BigDecimal triggerResult = dataEntity.getBigDecimal("triggerresult");
            if (triggerResult.compareTo(BigDecimal.ZERO) <= 0 || triggerResult.compareTo(new BigDecimal("9999999999.99")) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c{0}\u201d\u5141\u8bb8\u8c03\u6574\u7684\u8303\u56f4\u4e3a(0,9999999999.99]\u3002", (String)"IncDecConfKDStringHelper_77", (String)"wtc-wtp-business", (Object[])new Object[]{((IDataEntityProperty)fields.get("triggerresult")).getDisplayName().getLocaleValue()}));
                return false;
            }
        } else {
            return this.checkResult();
        }
        return true;
    }
}

