/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.incrdecrrules;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.wtp.constants.incdec.IncDecConfigConstants;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfCommonService;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfKDStringHelper;
import kd.wtc.wtp.business.incrdecrrules.IncDecConfService;

public class IncDecConfEdit
extends HRDataBaseEdit
implements IncDecConfigConstants {
    private final IncDecConfService SERVICE = IncDecConfService.getInstance();
    private final IncDecConfCommonService COMMON_SERVICE = IncDecConfCommonService.getInstance();
    private boolean isNeed;

    public void beforeBindData(EventObject evt) {
        HRBaseServiceHelper helper;
        DynamicObject confDy;
        Long boId;
        super.beforeBindData(evt);
        TargetCondition control = (TargetCondition)this.getView().getControl("targetconditionap");
        control.setValue(this.getModel().getDataEntity().getString("conditionjson"));
        String addVision = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
        boolean isAddVision = HRStringUtils.equals((String)"open_insert_new_data_page", (String)addVision);
        if (isAddVision && (boId = (Long)this.getView().getFormShowParameter().getCustomParam("boid")) != null && boId != 0L && !HRObjectUtils.isEmpty((Object)(confDy = (helper = new HRBaseServiceHelper("wtp_incdecconf")).queryOne((Object)boId)))) {
            this.getModel().setValue("suittype", (Object)confDy.getString("suittype"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"suittype"});
        }
        String hisAction = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
        boolean isFormCopy = HRStringUtils.equals((String)"open_copy_his_data_page", (String)hisAction);
        boolean isEdit = HRStringUtils.equals((String)"open_insert_data_page", (String)hisAction);
        if (isFormCopy || isEdit) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"suittype"});
        }
        if (isAddVision || isFormCopy || isEdit) {
            this.isNeed = true;
        }
        this.SERVICE.setInitValue(this.getModel().getDataEntity());
        this.SERVICE.replaceResultStrAndCondStr(this.getModel().getDataEntity());
    }

    public void afterBindData(EventObject evt) {
        long boId;
        boolean haveSerialLimit;
        super.afterBindData(evt);
        this.addVersionDataClearEntry();
        this.showPage(false);
        this.SERVICE.setFormStatus(this.getView());
        this.SERVICE.setOpColumnShow(this.getView());
        String suitType = this.getModel().getDataEntity().getString("suittype");
        if (this.isNeed && HRStringUtils.equals((String)"1", (String)suitType) && (haveSerialLimit = this.SERVICE.serialLimit(boId = this.getModel().getDataEntity().getLong("boid")))) {
            this.getView().showTipNotification(IncDecConfKDStringHelper.haveRefRule(), Integer.valueOf(5000));
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String propName;
        super.propertyChanged(evt);
        switch (propName = evt.getProperty().getName()) {
            case "suittype": 
            case "triggertypeshow": {
                this.showPage(true);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        String operateKey = ((FormOperate)source).getOperateKey();
        if (source instanceof SaveAndNew) {
            SaveAndNew opSource = (SaveAndNew)source;
            operateKey = opSource.getOriOperateKey();
        }
        switch (operateKey) {
            case "save": 
            case "saveandnew": 
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                if (args.isCancel()) {
                    return;
                }
                boolean checkResult = this.checkAndSave();
                if (checkResult) break;
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                this.SERVICE.setFormStatus(this.getView());
                boolean isView = WTCHisService.isLock((IFormView)this.getView());
                if (isView) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"regulartimeaddresultflex", "notaddresultflex", "advcontoolbarap"});
                }
                this.refreshSubView();
                this.SERVICE.setOpColumnShow(this.getView());
                break;
            }
            case "unsubmit": {
                this.SERVICE.setFormStatusOfEdit(this.getView());
                this.SERVICE.setOpColumnShow(this.getView());
                String suitType = this.getModel().getDataEntity().getString("suittype");
                String triggerType = this.getModel().getDataEntity().getString("triggertypeshow");
                if (this.isNoCond(suitType, triggerType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"notaddresultflex"});
                    this.SERVICE.refreshSubView(this.getView(), "notcondcache", false);
                    break;
                }
                if (this.isTime(suitType, triggerType)) {
                    this.SERVICE.refreshSubView(this.getView(), "regulartimecache", true);
                    this.getView().setVisible(Boolean.TRUE, new String[]{"regulartimeaddresultflex"});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"advcontoolbarap"});
                break;
            }
            case "add": {
                Object value = this.getModel().getValue("bsed");
                if (value == null) {
                    this.getView().showErrorNotification(IncDecConfKDStringHelper.bsed());
                    return;
                }
                this.SERVICE.openItemPage(this.getView(), true, operateKey);
                break;
            }
            case "edit": 
            case "condsee": {
                Object bsed = this.getModel().getValue("bsed");
                if (bsed == null) {
                    this.getView().showErrorNotification(IncDecConfKDStringHelper.bsed());
                    return;
                }
                this.SERVICE.openItemPage(this.getView(), false, operateKey);
                break;
            }
            case "regulartimeadd": {
                this.SERVICE.openRegularTimePage(this.getView(), false);
                break;
            }
            case "notcondadd": {
                this.SERVICE.openNotCondPage(this.getView(), false);
                break;
            }
        }
    }

    private void refreshSubView() {
        String triggerType;
        String suitType = this.getModel().getDataEntity().getString("suittype");
        if (this.isNoCond(suitType, triggerType = this.getModel().getDataEntity().getString("triggertypeshow"))) {
            this.SERVICE.refreshSubView(this.getView(), "notcondcache", false);
        } else if (this.isTime(suitType, triggerType)) {
            this.SERVICE.refreshSubView(this.getView(), "regulartimecache", true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map resultMap = (Map)closedCallBackEvent.getReturnData();
        if (resultMap == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"wtp_incdeccond", (String)actionId)) {
            this.SERVICE.closedCallBackOfAdd(resultMap, this.getModel(), this.getView());
        } else if (actionId.startsWith("wtp_incdeccond")) {
            this.SERVICE.closedCallBackOfEdit(resultMap, this.getModel(), this.getView(), actionId);
        } else if (actionId.startsWith("regulartimeactionid")) {
            String opKey = (String)resultMap.get("op");
            if (HRStringUtils.equals((String)"delete", (String)opKey)) {
                this.COMMON_SERVICE.closeOneSubView(this.getView(), "regulartimecache", actionId, "regulartimeaddflex");
            } else if (HRStringUtils.equals((String)"copy", (String)opKey)) {
                this.SERVICE.moveData(this.getView(), actionId, (IFormPlugin)this, "regulartimeactionid", "regulartimecache", "regulartimeaddflex", "wtp_incdecconftime", true);
            }
        } else if (actionId.startsWith("notcondactionid")) {
            String opKey = (String)resultMap.get("op");
            if (HRStringUtils.equals((String)"delete", (String)opKey)) {
                this.COMMON_SERVICE.closeOneSubView(this.getView(), "notcondcache", actionId, "notaddflex");
            } else if (HRStringUtils.equals((String)"copy", (String)opKey)) {
                this.SERVICE.moveData(this.getView(), actionId, (IFormPlugin)this, "notcondactionid", "notcondcache", "notaddflex", "wtp_incdecconfno", false);
            }
        }
    }

    private boolean checkAndSave() {
        String suitType = this.getModel().getDataEntity().getString("suittype");
        boolean checkResult = false;
        String conditionFilter = " ";
        if (this.isNotStep(suitType)) {
            checkResult = this.checkEntry();
            if (!checkResult) {
                return false;
            }
            this.getModel().setValue("triggertype", (Object)"D");
            checkResult = true;
        } else {
            TargetCondition control = (TargetCondition)this.getView().getControl("targetconditionap");
            conditionFilter = control.getValue();
            boolean timeCheck = this.SERVICE.checkDataTime(this.getView(), conditionFilter);
            if (!timeCheck) {
                return false;
            }
            checkResult = this.checkDay(suitType, conditionFilter);
        }
        if (!checkResult) {
            return false;
        }
        this.getModel().setValue("conditionjson", (Object)conditionFilter);
        this.getView().updateView("conditionjson");
        return true;
    }

    private boolean checkDay(String suitType, String conditionFilter) {
        boolean checkResult = true;
        String triggerType = this.getModel().getDataEntity().getString("triggertypeshow");
        this.getModel().setValue("triggertype", (Object)triggerType);
        if (this.isNoCond(suitType, triggerType)) {
            checkResult = this.SERVICE.checkAndSave(this.getView(), "notcondcache", false);
        } else if (this.isTime(suitType, triggerType)) {
            checkResult = this.SERVICE.checkAndSave(this.getView(), "regulartimecache", true);
        } else {
            checkResult = this.checkEntry();
            if (!checkResult) {
                return false;
            }
            boolean haveValue = this.SERVICE.haveDataTime(conditionFilter);
            if (haveValue) {
                DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                for (DynamicObject dy : entry) {
                    boolean serialLimit = dy.getBoolean("seriallimit");
                    if (!serialLimit) continue;
                    checkResult = false;
                    this.getView().showErrorNotification(IncDecConfKDStringHelper.dateRange());
                    break;
                }
            }
        }
        return checkResult;
    }

    private boolean checkEntry() {
        DynamicObjectCollection entryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (entryColl == null || entryColl.isEmpty()) {
            this.getView().showErrorNotification(IncDecConfKDStringHelper.emptyEntry());
            return false;
        }
        Date beSd = this.getModel().getDataEntity(true).getDate("bsed");
        for (DynamicObject entry : entryColl) {
            Object beSdDate;
            DynamicObject curItem;
            boolean serialLimit = entry.getBoolean("seriallimit");
            if (serialLimit && !HRObjectUtils.isEmpty((Object)(curItem = entry.getDynamicObject("curattitem")))) {
                Object object = beSdDate = curItem.containsProperty("firstbsed") ? curItem.getDate("firstbsed") : curItem.getDate("bsed");
                if (((Date)beSdDate).after(beSd)) {
                    this.getView().showErrorNotification(IncDecConfKDStringHelper.itemBsEd((String)curItem.getString("name")));
                    return false;
                }
            }
            DynamicObjectCollection condColl = entry.getDynamicObjectCollection("condsubentryentity");
            beSdDate = condColl.iterator();
            while (beSdDate.hasNext()) {
                DynamicObject cond = (DynamicObject)beSdDate.next();
                DynamicObjectCollection conItemColl = cond.getDynamicObjectCollection("condattitem");
                for (DynamicObject item : conItemColl) {
                    Date beSdDate2 = item.getDate("fbasedataid.firstbsed");
                    if (!beSdDate2.after(beSd)) continue;
                    this.getView().showErrorNotification(IncDecConfKDStringHelper.itemBsEd((String)item.getString("fbasedataid.name")));
                    return false;
                }
            }
            DynamicObjectCollection resultColl = entry.getDynamicObjectCollection("resultsubentryentity");
            for (DynamicObject result : resultColl) {
                Date beSdDate3;
                DynamicObject resultItem = result.getDynamicObject("resultitem");
                if (HRObjectUtils.isEmpty((Object)resultItem) || !(beSdDate3 = resultItem.containsProperty("firstbsed") ? resultItem.getDate("firstbsed") : resultItem.getDate("bsed")).after(beSd)) continue;
                this.getView().showErrorNotification(IncDecConfKDStringHelper.itemBsEd((String)resultItem.getString("name")));
                return false;
            }
        }
        return true;
    }

    private void updateTriggerTypeShow(String triggerType) {
        this.getModel().beginInit();
        this.getModel().setValue("triggertypeshow", (Object)triggerType);
        this.getView().updateView("triggertypeshow");
        this.getModel().endInit();
    }

    private void showPage(boolean isChange) {
        String triggerType;
        String suitType = this.getModel().getDataEntity().getString("suittype");
        if (isChange) {
            triggerType = this.getModel().getDataEntity().getString("triggertypeshow");
            if (triggerType == null) {
                triggerType = "A";
                this.updateTriggerTypeShow(triggerType);
            }
        } else {
            triggerType = this.getModel().getDataEntity().getString("triggertype");
            if (HRStringUtils.equals((String)"1", (String)suitType)) {
                this.updateTriggerTypeShow(triggerType);
            }
        }
        if (this.isNotStep(suitType)) {
            this.isNotStep(isChange);
        } else if (this.isNoCond(suitType, triggerType)) {
            this.isNoCond(isChange);
        } else if (this.isTime(suitType, triggerType)) {
            this.isTime(isChange);
        } else if (this.isItem(suitType, triggerType)) {
            this.isItem(isChange);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"triggerflex"});
            this.triggerType(false);
        }
    }

    private void isNotStep(boolean isChange) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"basicflex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"triggerflex", "regulartimeflex", "notflex", "rangedateflex"});
        this.triggerType(false);
        if (isChange) {
            TargetCondition control = (TargetCondition)this.getView().getControl("targetconditionap");
            control.setValue(null);
            this.clear();
        } else {
            this.setVisibleOfHis("advcontoolbarap");
        }
    }

    private void isNoCond(boolean isChange) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"triggerflex", "notflex", "rangedateflex", "notaddresultflex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"basicflex", "regulartimeflex"});
        if (isChange) {
            this.SERVICE.clearRegularTimeCache(this.getView(), "regulartimecache", "notaddflex");
            this.SERVICE.openNotCondPage(this.getView(), true);
        } else {
            this.SERVICE.loadNotCondSub((IFormPlugin)this, this.getView());
            this.setVisibleOfHis("notaddresultflex");
        }
        this.triggerType(true);
    }

    private void isTime(boolean isChange) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"regulartimeflex", "triggerflex", "rangedateflex", "regulartimeaddresultflex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"basicflex", "notflex"});
        if (isChange) {
            this.SERVICE.clearRegularTimeCache(this.getView(), "notcondcache", "regulartimeaddflex");
            this.SERVICE.openRegularTimePage(this.getView(), true);
        } else {
            this.SERVICE.loadTimeSub((IFormPlugin)this, this.getView());
            this.setVisibleOfHis("regulartimeaddresultflex");
        }
        this.triggerType(true);
    }

    private void isItem(boolean isChange) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"triggerflex", "basicflex", "rangedateflex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"notflex", "regulartimeflex"});
        this.triggerType(true);
        if (isChange) {
            this.clear();
        }
        this.setVisibleOfHis("advcontoolbarap");
    }

    private void clear() {
        this.SERVICE.clearRegularTimeCache(this.getView(), "regulartimecache", "notaddflex");
        this.SERVICE.clearRegularTimeCache(this.getView(), "notcondcache", "regulartimeaddflex");
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void setVisibleOfHis(String ... var2) {
        boolean isLock = WTCHisService.isLock((IFormView)this.getView());
        this.getView().setVisible(Boolean.valueOf(!isLock), var2);
    }

    private boolean isNotStep(String suitType) {
        return HRStringUtils.equals((String)"2", (String)suitType);
    }

    private boolean isNoCond(String suitType, String triggerType) {
        return HRStringUtils.equals((String)"1", (String)suitType) && HRStringUtils.equals((String)"C", (String)triggerType);
    }

    private boolean isItem(String suitType, String triggerType) {
        return HRStringUtils.equals((String)"1", (String)suitType) && HRStringUtils.equals((String)"A", (String)triggerType);
    }

    private boolean isTime(String suitType, String triggerType) {
        return HRStringUtils.equals((String)"1", (String)suitType) && HRStringUtils.equals((String)"B", (String)triggerType);
    }

    private void triggerType(boolean mustInput) {
        ((FieldEdit)this.getControl("triggertypeshow")).setMustInput(mustInput);
    }

    private void addVersionDataClearEntry() {
        boolean isNewVersion;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object hasAction = customParams.get("his_action");
        boolean bl = isNewVersion = null != hasAction && HRStringUtils.equals((String)"open_insert_new_data_page", (String)hasAction.toString());
        if (isNewVersion) {
            this.getModel().deleteEntryData("entryentity");
        }
    }
}

