/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.mobile.scheme;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtp.business.mobile.MobileSchemaHelper;
import kd.wtc.wtp.constants.mobile.MobileConfConstants;

public class MobileRuleEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String F7_CLOSE_CALLBACK = "mobile_rule_callback";
    private static final String PAGE_CACHE_F_WORKSPACE = "page_cache_f_workspace";
    private MobileSchemaHelper serviceHelper = MobileSchemaHelper.getInstance();

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        MulBasedataEdit control = (MulBasedataEdit)this.getControl("attcommproblem");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit control2 = (BasedataEdit)this.getControl("persumconfig");
        control2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit control3 = (BasedataEdit)this.getControl("dailydetconfig");
        control3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit quotaconfig = (BasedataEdit)this.getControl("quotaconfig");
        quotaconfig.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.isShowProblem();
        this.serviceHelper.setSelectBillToData(this.getView());
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String workSpace = dataEntity.getString("workspace");
        if (workSpace == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"typepanelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"problempanelap"});
        } else if ("A".equals(workSpace)) {
            this.workSpaceVisible(Boolean.FALSE);
        } else if ("B".equals(workSpace)) {
            this.workSpaceVisible(Boolean.TRUE);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String proName = evt.getProperty().getName();
        if (ArrayUtils.contains((Object[])MobileConfConstants.SELECT_BILLS, (Object)proName)) {
            this.serviceHelper.setDataToSelectBill(this.getView());
            this.getModel().setDataChanged(false);
        } else if (HRStringUtils.equals((String)proName, (String)"showproblem")) {
            this.isShowProblem();
        }
        if (HRStringUtils.equals((String)proName, (String)"workspace")) {
            if (this.checkWorkspace()) {
                ChangeData[] changeSet = evt.getChangeSet();
                if (changeSet != null && changeSet.length != 0) {
                    this.getView().getPageCache().put(PAGE_CACHE_F_WORKSPACE, "1");
                    this.getModel().setValue("workspace", changeSet[0].getOldValue());
                }
                return;
            }
            if ("1".equals(this.getView().getPageCache().get(PAGE_CACHE_F_WORKSPACE))) {
                this.getView().getPageCache().remove(PAGE_CACHE_F_WORKSPACE);
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String workSpace = dataEntity.getString("workspace");
            if ("A".equals(workSpace)) {
                this.workSpaceVisible(false);
                this.clearData();
            } else if ("B".equals(workSpace)) {
                this.workSpaceVisible(true);
                this.clearData();
            }
        }
    }

    private boolean checkWorkspace() {
        DynamicObject dy = this.getModel().getDataEntity();
        if (null == dy) {
            return true;
        }
        String workspace = dy.getString("workspace");
        Long mobileRuleId = dy.getLong("id");
        if (mobileRuleId == 0L) {
            return false;
        }
        HRBaseServiceHelper schemeServiceHelper = new HRBaseServiceHelper("wtp_mobilescheme");
        String selectFields = "id,workspace,staffmobilerule,teammobilerule";
        QFilter qFilter = new QFilter("staffmobilerule", "=", (Object)mobileRuleId);
        qFilter.or("teammobilerule", "=", (Object)mobileRuleId);
        DynamicObject[] myDyList = schemeServiceHelper.queryOriginalArray(selectFields, qFilter.toArray());
        String errMsg = "";
        if (myDyList != null && myDyList.length != 0) {
            for (DynamicObject object : myDyList) {
                String schemeWorkSpace;
                if (object == null || StringUtils.equals((CharSequence)(schemeWorkSpace = object.getString("workspace")), (CharSequence)workspace)) continue;
                errMsg = ResManager.loadKDString((String)"\u5df2\u7ecf\u88ab\u65b9\u6848\u5173\u8054\u7684\u89c4\u5219\u4e0d\u5141\u8bb8\u4fee\u6539\u4f5c\u4e1a\u7a7a\u95f4\u3002", (String)"MobileRuleEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        if (!StringUtils.isBlank((CharSequence)errMsg)) {
            this.getView().showErrorNotification(errMsg);
            return true;
        }
        return false;
    }

    private void clearData() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String workSpace = dynamicObject.getString("workspace");
        this.getModel().setValue("quotaconfig", null);
        if ("A".equals(workSpace)) {
            this.configEmpty(false);
        } else if ("B".equals(workSpace)) {
            this.configEmpty(true);
        }
    }

    private void workSpaceVisible(Boolean isTeam) {
        this.getView().setVisible(Boolean.valueOf(isTeam == false), new String[]{"persumconfig"});
        this.getView().setVisible(Boolean.valueOf(isTeam == false), new String[]{"dailydetconfig"});
        this.getView().setVisible(isTeam, new String[]{"perstaconfig"});
        this.getView().setVisible(isTeam, new String[]{"dailystaconfig"});
        this.getView().setVisible(isTeam, new String[]{"showboard"});
        FieldEdit selectedBill = (FieldEdit)this.getControl("selectedbill");
        selectedBill.setMustInput(isTeam == false);
        this.getView().setVisible(Boolean.valueOf(isTeam == false), new String[]{"labelap1"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"fieldsetpanelap"});
        this.getView().setVisible(Boolean.valueOf(isTeam == false), new String[]{"problempanelap"});
        FieldEdit perSumConfig = (FieldEdit)this.getControl("persumconfig");
        FieldEdit dailyDetConfig = (FieldEdit)this.getControl("dailydetconfig");
        perSumConfig.setMustInput(isTeam == false);
        dailyDetConfig.setMustInput(isTeam == false);
        FieldEdit perStaConfig = (FieldEdit)this.getControl("perstaconfig");
        FieldEdit dailyStaConfig = (FieldEdit)this.getControl("dailystaconfig");
        perStaConfig.setMustInput(isTeam.booleanValue());
        dailyStaConfig.setMustInput(isTeam.booleanValue());
        this.getView().setVisible(Boolean.valueOf(isTeam == false), new String[]{"a"});
        this.getView().setVisible(Boolean.valueOf(isTeam == false), new String[]{"b"});
        this.getView().setVisible(Boolean.valueOf(isTeam == false), new String[]{"d"});
        this.getView().setVisible(Boolean.valueOf(isTeam == false), new String[]{"e"});
        this.getView().setVisible(Boolean.valueOf(isTeam == false), new String[]{"c"});
        this.getView().setVisible(isTeam, new String[]{"f"});
        this.getView().setVisible(isTeam, new String[]{"i"});
        this.getView().setVisible(isTeam, new String[]{"g"});
        this.getView().setVisible(isTeam, new String[]{"h"});
        this.getView().setVisible(isTeam, new String[]{"j"});
    }

    private void configEmpty(Boolean isTeam) {
        if (isTeam.booleanValue()) {
            this.getModel().setValue("persumconfig", null);
            this.getModel().setValue("dailydetconfig", null);
            this.getModel().setValue("selectedbill", null);
            this.getModel().setValue("showboard", (Object)true);
            this.getModel().setValue("showproblem", (Object)false);
            this.getModel().setValue("attcommproblem", null);
            this.getModel().setValue("a", (Object)false);
            this.getModel().setValue("b", (Object)false);
            this.getModel().setValue("d", (Object)false);
            this.getModel().setValue("e", (Object)false);
            this.getModel().setValue("c", (Object)false);
        } else {
            this.getModel().setValue("perstaconfig", null);
            this.getModel().setValue("dailystaconfig", null);
            this.getModel().setValue("showboard", (Object)false);
            this.getModel().setValue("f", (Object)false);
            this.getModel().setValue("i", (Object)false);
            this.getModel().setValue("g", (Object)false);
            this.getModel().setValue("h", (Object)false);
            this.getModel().setValue("j", (Object)false);
        }
        this.getModel().setValue("selectedbill", null);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    private void isShowProblem() {
        boolean showProblem = (Boolean)this.getModel().getValue("showproblem");
        this.getView().setVisible(Boolean.valueOf(showProblem), new String[]{"attcommproblem"});
        BasedataEdit control = (BasedataEdit)this.getControl("attcommproblem");
        control.setMustInput(showProblem);
        if (!showProblem) {
            this.getModel().setValue("attcommproblem", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        String name = evt.getProperty().getName();
        List customQFilters = evt.getCustomQFilters();
        if (HRStringUtils.equals((String)name, (String)"persumconfig")) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u671f\u95f4\u6c47\u603b\u7ec4\u5408", (String)"MobileRuleEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        } else if (HRStringUtils.equals((String)name, (String)"dailydetconfig")) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u65e5\u660e\u7ec6\u7ec4\u5408", (String)"MobileRuleEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        } else if (HRStringUtils.equals((String)name, (String)"attcommproblem")) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, F7_CLOSE_CALLBACK);
            formShowParameter.setCloseCallBack(closeCallBack);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5e38\u89c1\u95ee\u9898", (String)"MobileRuleEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        } else if (HRStringUtils.equals((String)name, (String)"quotaconfig")) {
            String showTeam = this.getModel().getDataEntity().getString("workspace");
            if (HRStringUtils.isEmpty((String)showTeam)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u4f5c\u4e1a\u7a7a\u95f4", (String)"MobileRuleEdit_01", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            customQFilters.add(new QFilter("workspace", "=", (Object)this.getModel().getDataEntity().getString("workspace")));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            return;
        }
        if (listSelectedRows.size() > 4) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u90094\u4e2a\u5e38\u7528\u95ee\u9898\u3002", (String)"MobileRuleEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] primaryKeyValues = listSelectedRows.getPrimaryKeyValues();
        this.getModel().setValue("attcommproblem", (Object)primaryKeyValues);
    }
}

