/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.mobile.scheme;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;

public class MobileRuleRangeEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(MobileRuleRangeEdit.class);
    private static HRBaseServiceHelper schemeServiceHelper = new HRBaseServiceHelper("wtp_mobilescheme");

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit staffMobileRule = (BasedataEdit)this.getControl("staffmobilerule");
        staffMobileRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit teamMobileRule = (BasedataEdit)this.getControl("teammobilerule");
        teamMobileRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit adminOrgEdit = (MulBasedataEdit)this.getView().getControl("adminorg");
        adminOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        if ("staffmobilerule".equals(name)) {
            customQFilters.add(new QFilter("workspace", "=", (Object)"A"));
        } else if ("teammobilerule".equals(name)) {
            customQFilters.add(new QFilter("workspace", "=", (Object)"B"));
        } else if ("adminorg".equals(name)) {
            customQFilters.add(new QFilter("id", "not in", this.getEntryAdminOrg()));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String controlKey = args.getProperty().getName();
        if ("workspace".equals(controlKey)) {
            this.getModel().setValue("attfilebaserange", null);
            this.setMetaShow();
            this.getModel().deleteEntryData("adminorgentry");
        } else if ("adminorg".equals(controlKey)) {
            Set<Long> ids = this.getAdminOrg();
            this.addEntry(ids);
        }
    }

    private Set<Long> getEntryAdminOrg() {
        DynamicObjectCollection adminOrgs = this.getModel().getEntryEntity("adminorgentry");
        if (!CollectionUtils.isEmpty((Collection)adminOrgs)) {
            return adminOrgs.stream().map(ob -> ob.getLong("adminorgname.id")).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Set<Long> getAdminOrg() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        DynamicObjectCollection adminOrgs = dynamicObject.getDynamicObjectCollection("adminorg");
        if (!CollectionUtils.isEmpty((Collection)adminOrgs)) {
            return adminOrgs.stream().map(ob -> ob.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private void addEntry(Set<Long> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            int count = ids.size();
            DynamicObjectCollection adminOrgs = this.getModel().getEntryEntity("adminorgentry");
            int curNum = adminOrgs.size();
            this.getModel().batchCreateNewEntryRow("adminorgentry", count);
            for (Long id : ids) {
                this.getModel().setValue("adminorgname", (Object)id, curNum);
                ++curNum;
            }
            this.getModel().endInit();
            this.getModel().setValue("adminorg", null);
            this.getView().updateView("adminorgentry");
        }
    }

    private void setMetaShow() {
        String showTeam = this.getModel().getDataEntity().getString("workspace");
        if (HRStringUtils.equals((String)"B", (String)showTeam)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"staffmobilerule"});
            this.getModel().setValue("staffmobilerule", null);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"teammobilerule"});
            ((FieldEdit)this.getControl("teammobilerule")).setMustInput(true);
            ((FieldEdit)this.getControl("staffmobilerule")).setMustInput(false);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"staffmobilerule"});
            this.getModel().setValue("teammobilerule", null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"teammobilerule"});
            ((FieldEdit)this.getControl("teammobilerule")).setMustInput(false);
            ((FieldEdit)this.getControl("staffmobilerule")).setMustInput(true);
        }
        FormShowParameter formShowParameter = this.getShowContainerView("wtp_mobileschemefilter");
        String pageId = formShowParameter.getPageId();
        this.getPageCache().put("childpageId", pageId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String showTeam = this.getModel().getDataEntity().getString("workspace");
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (HRStringUtils.equals((String)"B", (String)showTeam)) {
            if (HRStringUtils.equals((String)"addbatch", (String)operateKey)) {
                MulBasedataEdit basedataEdit = (MulBasedataEdit)this.getView().getControl("adminorg");
                basedataEdit.click();
                return;
            }
            return;
        }
        switch (operateKey) {
            case "save": 
            case "submit": 
            case "audit": {
                TargetCondition targetCondition = this.getTargetCondition();
                this.getModel().setValue("attfilebaserange", (Object)targetCondition.getValue());
                RuleValidateInfo info = RuleValidateUtil.validCondition((String)targetCondition.getValue());
                if (!info.isSuccess()) {
                    args.setCancel(true);
                    args.setCancelMessage(info.getMsgList().toString());
                    this.getView().showErrorNotification(info.getMsgList().toString());
                    break;
                }
                String value = targetCondition.getValue();
                if (!HRStringUtils.isNotEmpty((String)value) || !value.contains("is_or_isSub")) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u201c\u7b49\u4e8e/...\u7684\u4e0b\u7ea7\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u9009\u9879\u3002", (String)"MobileRuleRangeEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String pageId = this.getPageCache().get("childpageId");
        IFormView view = this.getView().getView(pageId);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        view.setStatus(this.getFormStatus(operateKey));
        this.setFormStatus(this.getFormStatus(operateKey).getValue());
        this.getView().sendFormAction(view);
        this.getView().updateView(pageId);
    }

    private void setFormStatus(int status) {
        TargetCondition targetCondition = this.getTargetCondition();
        if (this.isLock(status, targetCondition.getLock())) {
            targetCondition.setPageState("VIEW");
        } else {
            targetCondition.setPageState("EDIT");
        }
    }

    public boolean isLock(int status, String lock) {
        if (StringUtils.isEmpty((String)lock)) {
            return false;
        }
        return BillOperationStatus.ADDNEW.getValue() == status && lock.contains("new") || BillOperationStatus.EDIT.getValue() == status && lock.contains("edit") || BillOperationStatus.VIEW.getValue() == status && lock.contains("view") || BillOperationStatus.SUBMIT.getValue() == status && lock.contains("submit") || BillOperationStatus.AUDIT.getValue() == status && lock.contains("audit");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMetaShow();
        String attFileBaseRange = this.getModel().getDataEntity().getString("attfilebaserange");
        if (attFileBaseRange != null) {
            this.getTargetCondition().setValue(attFileBaseRange);
        }
    }

    private FormShowParameter getShowContainerView(String formId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(this.getFormStatus());
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setTargetKey("targetconditionflex");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        this.getView().showForm(formShowParameter);
        return formShowParameter;
    }

    private TargetCondition getTargetCondition() {
        String pageId = this.getPageCache().get("childpageId");
        return (TargetCondition)this.getView().getView(pageId).getControl("targetconditionap");
    }

    private OperationStatus getFormStatus(String operation) {
        OperationStatus operationStatus;
        String status = this.getModel().getDataEntity().getString("status");
        String fromPage = (String)this.getView().getFormShowParameter().getCustomParams().get("fromPage");
        switch (status) {
            case "A": {
                operationStatus = OperationStatus.EDIT;
                break;
            }
            case "B": {
                operationStatus = OperationStatus.VIEW;
                break;
            }
            case "C": {
                operationStatus = OperationStatus.VIEW;
                break;
            }
            default: {
                operationStatus = OperationStatus.ADDNEW;
            }
        }
        if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
            operationStatus = OperationStatus.EDIT;
        }
        if (HRStringUtils.equals((String)fromPage, (String)"revise") && operation.equals("save")) {
            operationStatus = OperationStatus.VIEW;
        }
        return operationStatus;
    }

    private OperationStatus getFormStatus() {
        OperationStatus operationStatus;
        String status = this.getModel().getDataEntity().getString("status");
        String fromPage = (String)this.getView().getFormShowParameter().getCustomParams().get("fromPage");
        switch (status) {
            case "A": {
                operationStatus = OperationStatus.EDIT;
                break;
            }
            case "B": {
                operationStatus = OperationStatus.VIEW;
                break;
            }
            case "C": {
                operationStatus = OperationStatus.VIEW;
                break;
            }
            default: {
                operationStatus = OperationStatus.ADDNEW;
            }
        }
        if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
            operationStatus = OperationStatus.EDIT;
        }
        return operationStatus;
    }
}

