/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.mobileattself;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.mobile.MobileSchemaHelper;
import kd.wtc.wtp.common.enums.daista.ShowDimenEnum;
import kd.wtc.wtp.utils.PerSumCommUtils;

public class DaiPerStaSourceEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private final List<ComboItem> dataTypeList = Stream.of(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6b21\u6570", (String)"DaiPerStaSourceEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), "0"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u65f6\u957f", (String)"DaiPerStaSourceEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), "1")).collect(Collectors.toList());
    private final List<ComboItem> comboItemList = Stream.of(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5929", (String)"PerSumSourceEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), "day"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"PerSumSourceEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), "hour"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5206\u949f", (String)"PerSumSourceEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), "minute"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79d2", (String)"PerSumSourceEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), "second"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6b21", (String)"PerSumSourceEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), "time")).collect(Collectors.toList());

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("attitem");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Label label = (Label)this.getView().getControl("newentry");
        label.addClickListener((ClickListener)this);
        if (this.isDailyConfig()) {
            BasedataEdit teamHomeKpiBasedata = (BasedataEdit)this.getView().getControl("teamhomekpi");
            teamHomeKpiBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String showDimen = (String)this.getModel().getValue("showdimen");
        this.setDataTypePullDown(showDimen, 0);
        String dataType = (String)this.getModel().getValue("datatype");
        this.renderUnitPullDown(dataType, 0);
        this.setDataSourceVis();
    }

    private QFilter getTeamHomeKpiQFilter(String appScope) {
        QFilter qFilter = new QFilter("appscope", "like", (Object)("%" + appScope + "%"));
        qFilter.and(new QFilter("metrics", "like", (Object)"%1%"));
        qFilter.and(new QFilter("id", "!=", (Object)this.getModel().getDataEntity().getLong("teamhomekpi.id")));
        return qFilter;
    }

    private boolean checkAppScope(String appScope) {
        if (WTCStringUtils.isEmpty((String)appScope)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9002\u7528\u5e03\u5c40\u5b57\u6bb5\u3002", (String)"DaiPerStaSourceEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object dataType = this.getView().getModel().getDataEntity().get("datatype");
        Object unit = this.getView().getModel().getDataEntity().get("unit");
        if (dataType == null || unit == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8003\u52e4\u9879\u76ee\u6570\u636e\u7c7b\u578b\u4e0e\u5355\u4f4d\u3002", (String)"DaiPerStaSourceEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showAttItemList();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldName = args.getProperty().getName();
        if (ArrayUtils.isEmpty((Object[])args.getChangeSet())) {
            return;
        }
        switch (fieldName) {
            case "showdimen": {
                ChangeData data = args.getChangeSet()[0];
                this.showDimenChanged(data);
                this.setDataTypePullDown((String)data.getNewValue(), 1);
                break;
            }
            case "valtakmethod": {
                this.setDataSourceVis();
                break;
            }
            case "datatype": {
                this.renderUnitPullDown((String)args.getChangeSet()[0].getNewValue(), 1);
                this.getModel().deleteEntryData("entryentity");
                break;
            }
            case "unit": {
                this.getModel().deleteEntryData("entryentity");
                break;
            }
            case "applylayout": {
                if (!this.isDailyConfig()) break;
                this.getModel().setValue("teamhomekpi", null);
                break;
            }
        }
    }

    private void showDimenChanged(ChangeData data) {
        Object oldValue = data.getOldValue();
        Object newValue = data.getNewValue();
        if (ShowDimenEnum.SUMBYDATAINDICATORS.getCode().equals(oldValue) && !ShowDimenEnum.SUMBYDATAINDICATORS.getCode().equals(newValue)) {
            this.getModel().setValue("teamhomekpi", null);
            this.getModel().setValue("teamhomekpi", null);
        } else if (!ShowDimenEnum.SUMBYDATAINDICATORS.getCode().equals(oldValue) && ShowDimenEnum.SUMBYDATAINDICATORS.getCode().equals(newValue)) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().setValue("datatype", null);
            this.getModel().setValue("unit", null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        if (closedCallBackEvent.getActionId().equals("addattitem")) {
            if (null == closedCallBackEvent.getReturnData()) {
                return;
            }
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            DynamicObjectCollection dynObjColl = this.getModel().getEntryEntity("entryentity");
            int size = returnData.size() + dynObjColl.size();
            if (size > 99) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u6700\u591a\u652f\u6301\u6dfb\u52a099\u6761\u6570\u636e\u3002", (String)"DaiPerStaSourceEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                return;
            }
            PerSumCommUtils.duplicateParamToList((ListSelectedRowCollection)returnData, (AbstractFormDataModel)dataModel, (String)"attitem", (String)"entryentity");
            if (dynObjColl.size() > 0 && ((DynamicObject)dynObjColl.get(0)).getDynamicObject("attitem") == null) {
                this.getModel().deleteEntryRow("entryentity", 0);
            }
            this.getView().updateView("entryentity");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        this.openAttItemDetails(arg0);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        QFilter qFilter = null;
        if ("attitem".equals(name)) {
            qFilter = this.getAttItemFilter();
        } else if ("teamhomekpi".equals(name)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String appScope = dataEntity.getString("applylayout");
            if (!this.checkAppScope(appScope)) {
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            qFilter = this.getTeamHomeKpiQFilter(appScope);
        }
        if (qFilter == null) {
            return;
        }
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private QFilter getAttItemFilter() {
        String entityId = this.getView().getEntityId();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (null == entryEntity) {
            return null;
        }
        List attItemParam = PerSumCommUtils.filterParamToList((DynamicObjectCollection)entryEntity, (String)"attitem");
        QFilter qFilter = new QFilter("id", "not in", (Object)attItemParam);
        ArrayList<String> itemTypeValue = new ArrayList<String>(2);
        itemTypeValue.add("2");
        if ("wtp_perstasource".equals(entityId)) {
            itemTypeValue.add("3");
        } else {
            itemTypeValue.add("1");
        }
        qFilter.and(new QFilter("itemtype", "in", itemTypeValue));
        Object dataType = this.getView().getModel().getDataEntity().get("datatype");
        Object unit = this.getView().getModel().getDataEntity().get("unit");
        if (dataType == null || unit == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8003\u52e4\u9879\u76ee\u6570\u636e\u7c7b\u578b\u4e0e\u5355\u4f4d\u3002", (String)"DaiPerStaSourceEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return null;
        }
        qFilter.and(new QFilter("datatype", "=", dataType));
        qFilter.and(new QFilter("unit", "=", unit));
        return qFilter;
    }

    private void showAttItemList() {
        QFilter qFilter;
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setLookUp(true);
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("wtbd_attitem");
        listShowParameter.setMultiSelect(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setHasRight(true);
        StyleCss style = new StyleCss();
        style.setWidth("960");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        listShowParameter.setCustomParam("multiType", (Object)Boolean.TRUE);
        Object orgId = this.getView().getModel().getDataEntity().getDynamicObject("createorg").get("id");
        if (orgId != null) {
            listShowParameter.setUseOrgId(Long.parseLong(orgId.toString()));
        }
        if ((qFilter = this.getAttItemFilter()) != null) {
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setFilter(qFilter);
            listShowParameter.setListFilterParameter(listFilterParameter);
        }
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addattitem"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void renderUnitPullDown(String newValue, int type) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("unit");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(16);
        if (HRStringUtils.isNotEmpty((String)newValue)) {
            if ("0".equals(newValue)) {
                data.add(this.comboItemList.get(this.comboItemList.size() - 1));
                this.getModel().setValue("unit", (Object)"time");
            } else {
                data.addAll(new ArrayList<ComboItem>(this.comboItemList.subList(0, this.comboItemList.size() - 1)));
                if (type == 1) {
                    this.getModel().setValue("unit", (Object)"day");
                }
            }
        } else {
            data.addAll(this.comboItemList);
        }
        comboEdit.setComboItems(data);
    }

    private void openAttItemDetails(HyperLinkClickEvent arg0) {
        EntryGrid entryGrid = (EntryGrid)arg0.getSource();
        DynamicObject[] attItemArr = entryGrid.getEntryData().getDataEntitys();
        int rowIndex = arg0.getRowIndex();
        long attItemId = 0L;
        if (attItemArr[rowIndex].getDynamicObject("attitem") != null) {
            attItemId = attItemArr[rowIndex].getDynamicObject("attitem").getLong("id");
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("wtbd_attitem");
        showParameter.setPkId((Object)attItemId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        MobileSchemaHelper.getInstance().cacheAttItemPageId(attItemId, showParameter, this.getView());
    }

    private void setDataTypePullDown(String newValue, int type) {
        ComboEdit dataType = (ComboEdit)this.getControl("datatype");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(16);
        if (HRStringUtils.isEmpty((String)newValue)) {
            data.addAll(this.dataTypeList);
            dataType.setComboItems(data);
            return;
        }
        if (ShowDimenEnum.SUMBYTIME.getCode().equals(newValue)) {
            this.getModel().setValue("valtakmethod", (Object)"1");
            data.add(this.dataTypeList.get(1));
            if (type == 1) {
                this.getModel().setValue("datatype", (Object)"1");
            }
        } else if (ShowDimenEnum.SUMBYFREQUENCY.getCode().equals(newValue)) {
            this.getModel().setValue("valtakmethod", (Object)"1");
            data.add(this.dataTypeList.get(0));
            if (type == 1) {
                this.getModel().setValue("datatype", (Object)"0");
            }
        } else if (ShowDimenEnum.SUMBYNUMBEROFPEOPLE.getCode().equals(newValue)) {
            this.getModel().setValue("valtakmethod", (Object)"1");
            data.addAll(this.dataTypeList);
            if (type == 1) {
                this.getModel().setValue("datatype", (Object)"1");
            }
        } else {
            this.getModel().setValue("valtakmethod", (Object)"2");
        }
        dataType.setComboItems(data);
    }

    private void setDataSourceVis() {
        Object valTakMethod = this.getModel().getDataEntity().get("valtakmethod");
        this.getView().setVisible(Boolean.FALSE, new String[]{"attitemflex", "entityflex", "extypeflex", "plugflex", "teamhomekpi"});
        if ("1".equals(valTakMethod)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"attitemflex", "entityflex"});
        } else if ("2".equals(valTakMethod)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"teamhomekpi"});
        }
        if (this.isDailyConfig()) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("teamhomekpi");
            basedataEdit.setMustInput("2".equals(valTakMethod));
        }
        this.attFlexMustInput("1".equals(valTakMethod));
    }

    private void attFlexMustInput(boolean flag) {
        ComboEdit dataTypeEdit = (ComboEdit)this.getView().getControl("datatype");
        dataTypeEdit.setMustInput(flag);
        ComboEdit unitEdit = (ComboEdit)this.getView().getControl("unit");
        unitEdit.setMustInput(flag);
        ComboEdit treEdit = (ComboEdit)this.getView().getControl("treatmentmeth");
        treEdit.setMustInput(flag);
    }

    private boolean isDailyConfig() {
        return "wtp_dailystasource".equals(this.getView().getEntityId());
    }
}

