/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.mobileattself;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtp.business.mobile.MobileSchemaHelper;
import kd.wtc.wtp.utils.PerSumCommUtils;

public class PerSumSourceEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private final List<ComboItem> comboItemList = Stream.of(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5929", (String)"PerSumSourceEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), "day"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"PerSumSourceEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), "hour"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5206\u949f", (String)"PerSumSourceEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), "minute"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79d2", (String)"PerSumSourceEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), "second"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6b21", (String)"PerSumSourceEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0])), "time")).collect(Collectors.toList());

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("attitem");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Label label = (Label)this.getView().getControl("newentry");
        label.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String dataType = (String)this.getModel().getValue("datatype");
        this.renderUnitPullDown(dataType, 0);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("newentry".equals(key)) {
            this.showAttItemList();
        }
    }

    private void showAttItemList() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setLookUp(true);
        listShowParameter.setHasRight(true);
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("wtbd_attitem");
        listShowParameter.setMultiSelect(true);
        listShowParameter.setShowTitle(false);
        StyleCss style = new StyleCss();
        style.setWidth("960");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        listShowParameter.setCustomParam("multiType", (Object)Boolean.TRUE);
        QFilter qFilter = this.getAttItemFilter();
        if (qFilter != null) {
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setFilter(qFilter);
            listShowParameter.setListFilterParameter(listFilterParameter);
        }
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addattitem"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        if (closedCallBackEvent.getActionId().equals("addattitem")) {
            if (null == closedCallBackEvent.getReturnData()) {
                return;
            }
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            PerSumCommUtils.duplicateParamToList((ListSelectedRowCollection)returnData, (AbstractFormDataModel)dataModel, (String)"attitem", (String)"entryentity");
            DynamicObjectCollection dynObjColl = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            if (dynObjColl.size() > 0 && ((DynamicObject)dynObjColl.get(0)).getDynamicObject("attitem") == null) {
                this.getModel().deleteEntryRow("entryentity", 0);
            }
            this.getView().updateView("entryentity");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        this.openAttItemDetails(arg0);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter qFilter = this.getAttItemFilter();
        if (qFilter == null) {
            return;
        }
        formShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private QFilter getAttItemFilter() {
        String entityId = this.getView().getEntityId();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (null == entryEntity) {
            return null;
        }
        List attItemParam = PerSumCommUtils.filterParamToList((DynamicObjectCollection)entryEntity, (String)"attitem");
        QFilter qFilter = new QFilter("id", "not in", (Object)attItemParam);
        ArrayList<String> itemTypeValue = new ArrayList<String>(2);
        itemTypeValue.add("2");
        if ("wtp_persumsource".equals(entityId)) {
            itemTypeValue.add("3");
        } else {
            itemTypeValue.add("1");
        }
        qFilter.and(new QFilter("itemtype", "in", itemTypeValue));
        Object dataType = this.getView().getModel().getDataEntity().get("datatype");
        Object unit = this.getView().getModel().getDataEntity().get("unit");
        qFilter.and(new QFilter("datatype", "=", dataType));
        qFilter.and(new QFilter("unit", "=", unit));
        return qFilter;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldName = args.getProperty().getName();
        if (ArrayUtils.isEmpty((Object[])args.getChangeSet())) {
            return;
        }
        if (StringUtils.equals((CharSequence)"datatype", (CharSequence)fieldName)) {
            this.renderUnitPullDown((String)args.getChangeSet()[0].getNewValue(), 1);
            this.getModel().deleteEntryData("entryentity");
        } else if (StringUtils.equals((CharSequence)"unit", (CharSequence)fieldName)) {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    private void renderUnitPullDown(String newValue, int type) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("unit");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(16);
        if (HRStringUtils.isNotEmpty((String)newValue)) {
            if ("0".equals(newValue)) {
                data.add(this.comboItemList.get(this.comboItemList.size() - 1));
                this.getModel().setValue("unit", (Object)"time");
            } else {
                data.addAll(new ArrayList<ComboItem>(this.comboItemList.subList(0, this.comboItemList.size() - 1)));
                if (type == 1) {
                    this.getModel().setValue("unit", null);
                }
            }
        } else {
            data.addAll(this.comboItemList);
        }
        comboEdit.setComboItems(data);
    }

    private void openAttItemDetails(HyperLinkClickEvent arg0) {
        EntryGrid entryGrid = (EntryGrid)arg0.getSource();
        DynamicObject[] attItemArr = entryGrid.getEntryData().getDataEntitys();
        int rowIndex = arg0.getRowIndex();
        long attItemId = 0L;
        if (attItemArr[rowIndex].getDynamicObject("attitem") != null) {
            attItemId = attItemArr[rowIndex].getDynamicObject("attitem").getLong("id");
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("wtbd_attitem");
        showParameter.setPkId((Object)attItemId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        MobileSchemaHelper.getInstance().cacheAttItemPageId(attItemId, showParameter, this.getView());
    }
}

