/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.overtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.rulecontrol.RuleConditionService;
import kd.wtc.wtbs.common.predata.wtbd.PreDataOtTimeSource;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.formplugin.web.WTCDateRangeNohisEdit;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.business.overtime.OtRuleCalculCacheService;
import kd.wtc.wtp.business.overtime.OverworkRuleUtil;
import kd.wtc.wtp.business.ruleenging.RulePreviewUtil;
import kd.wtc.wtp.common.ot.ChildInfo;

public class CalculRuleEditPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(CalculRuleEditPlugin.class);
    private static final String KEY_LIMITFLEX = "limitflex";
    private static final String CONFIRM_CALLBACK_ID = "SaveConfirm";
    private RuleConditionService ruleConditionService = RuleConditionService.getInstance((String)"customcontrolap");
    private RuleConditionService ruleConditionLimitService = RuleConditionService.getInstance((String)"customcontrollimit");
    private static Set<String> propertySet = new HashSet<String>(16);

    public void registerListener(EventObject event) {
        super.registerListener(event);
        Button btnok = (Button)this.getControl("btnok");
        btnok.addClickListener((ClickListener)this);
        OverworkRuleUtil.listenF7(propertySet, (IFormView)this.getView(), (BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "ruledate": {
                Date ruledate = (Date)this.getModel().getValue("ruledate");
                if (ruledate == null) break;
                break;
            }
            case "datasource": {
                this.setIsEmpChoice();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        AccessDto accessDto;
        List conditionList;
        LOG.info("CalculRuleEditPlugin_afterBindData begin beforeBindData");
        super.afterBindData(e);
        boolean collapse = true;
        Container infoContainer = (Container)this.getView().getControl(KEY_LIMITFLEX);
        String limitConditionJson = (String)this.getModel().getValue("limitscope");
        if (HRStringUtils.isNotEmpty((String)limitConditionJson) && !CollectionUtils.isEmpty((Collection)(conditionList = (accessDto = (AccessDto)SerializationUtils.fromJsonString((String)limitConditionJson, AccessDto.class)).getConditionList()))) {
            collapse = false;
        }
        infoContainer.setCollapse(collapse);
    }

    private void updateCustomControlDate(Date ruledate) {
        this.ruleConditionLimitService.setView(this.getView()).setDate(HRDateTimeUtils.format((Date)ruledate, (String)"yyyy-MM-dd"));
        this.ruleConditionService.setView(this.getView()).setDate(HRDateTimeUtils.format((Date)ruledate, (String)"yyyy-MM-dd"));
        this.getModel().setValue("ruledate", null);
    }

    public void beforeBindData(EventObject event) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        Map map = (Map)formShowParameter.getCustomParam("singleInfo");
        Object effStartDate = formShowParameter.getCustomParam("bsed");
        if (effStartDate != null) {
            this.getModel().setValue("bsed", formShowParameter.getCustomParam("bsed"));
        }
        boolean isEmpChoice = false;
        Long dataSourceId = null;
        if (map != null) {
            if (!OperationStatus.ADDNEW.equals((Object)status)) {
                this.getModel().setValue("ottype", map.get("ottype"));
            }
            this.getModel().setValue("calculname", map.get("calculname"));
            this.getModel().setValue("calculdes", map.get("calculdes"));
            this.getModel().setValue("otbaseset", map.get("otbaseset"));
            this.getModel().setValue("otsystem", map.get("otsystem"));
            this.getModel().setValue("datasource", map.get("datasource"));
            this.getModel().setValue("limitscope", map.get("limitscope"));
            this.getModel().setValue("daterangecondition", map.get("daterangecondition"));
            this.getModel().setValue("originalprj", map.get("originalprj"));
            this.getModel().setValue("createorg", map.get("createorg"));
            this.getModel().setValue("bsed", map.get("bsed"));
            isEmpChoice = Boolean.TRUE.equals(map.get("isempchoice"));
            dataSourceId = Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("datasource")).map(dy -> (Long)dy.getPkValue()).orElseGet(() -> null);
        } else {
            this.getModel().setValue("createorg", (Object)RequestContext.get().getOrgId());
        }
        HashMap replaceMap = Maps.newHashMapWithExpectedSize((int)2);
        replaceMap.put("daterange.wtp_otdaterangestd", "daterange.wtbd_stddaterange");
        this.ruleConditionService.setView(this.getView()).setReplaceText((Map)replaceMap);
        HashMap replaceLimitMap = Maps.newHashMapWithExpectedSize((int)2);
        replaceLimitMap.put("limitscope.wtp_limitscope.age", "pernontsprop.hrpi_pernontsprop.age");
        replaceLimitMap.put("limitscope.wtp_limitscope.gender.id", "pernontsprop.hrpi_pernontsprop.gender.id");
        replaceLimitMap.put("limitscope.wtp_limitscope.beginservicedate", "perserlen.hrpi_perserlen.beginservicedate");
        replaceLimitMap.put("limitscope.wtp_limitscope.entrydate", "trialperiod.hrpi_trialperiod.entrydate");
        replaceLimitMap.put("limitscope.wtp_limitscope.regulardate", "trialperiod.hrpi_trialperiod.realregulardate");
        replaceLimitMap.put("limitscope.wtp_limitscope.laborrelstatus.id", "empentrel.hrpi_empentrel.laborrelstatus.id");
        replaceLimitMap.put("limitscope.wtp_limitscope.joblevel.id", "empjobrel.hrpi_empjobrel.joblevel.id");
        replaceLimitMap.put("limitscope.wtp_limitscope.jobgrade.id", "empjobrel.hrpi_empjobrel.jobgrade.id");
        replaceLimitMap.put("limitscope.wtp_limitscope.obseq.id", "empjobrel.hrpi_empjobrel.jobseq.id");
        replaceLimitMap.put("limitscope.wtp_limitscope.dependencytype.id", "attfilebase.wtp_attfilebase.dependencytype.id");
        replaceLimitMap.put("limitscope.wtp_limitscope.workplace.id", "attfilebase.wtp_attfilebase.workplace.id");
        this.ruleConditionLimitService.setView(this.getView()).setReplaceText((Map)replaceLimitMap);
        this.ruleConditionLimitService.setView(this.getView()).setValue((String)this.getModel().getValue("limitscope"));
        this.ruleConditionService.setView(this.getView()).setValue((String)this.getModel().getValue("daterangecondition"));
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus()) && PreDataOtTimeSource.PD_1030_S.equals(dataSourceId) && !isEmpChoice) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isempchoice"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        AbstractOperate op;
        String operateKey;
        if (evt.getSource() instanceof AbstractOperate && "save".equals(operateKey = (op = (AbstractOperate)evt.getSource()).getOperateKey())) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            returnData.put("ottype", this.getModel().getValue("ottype"));
            returnData.put("calculname", this.getModel().getValue("calculname"));
            returnData.put("calculdes", this.getModel().getValue("calculdes"));
            returnData.put("otbaseset", this.getModel().getValue("otbaseset"));
            returnData.put("otsystem", this.getModel().getValue("otsystem"));
            returnData.put("datasource", this.getModel().getValue("datasource"));
            returnData.put("limitscope", this.getModel().getValue("limitscope"));
            returnData.put("daterangecondition", this.getModel().getValue("daterangecondition"));
            returnData.put("isempchoice", this.getModel().getValue("isempchoice"));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Integer rowIndex = (Integer)formShowParameter.getCustomParam("rowIndex");
            returnData.put("rowIndex", rowIndex);
            Boolean cus = (Boolean)this.getModel().getValue("isempchoice");
            ArrayList<ChildInfo> childInfos = new ArrayList<ChildInfo>(10);
            OtRuleCalculCacheService cacheService = new OtRuleCalculCacheService(this.getView());
            boolean lock = cacheService.getLock();
            if (!lock) {
                this.getView().showTipNotification(cacheService.getTip());
                return;
            }
            try {
                if (!cus.booleanValue()) {
                    ChildInfo childInfo = new ChildInfo();
                    OverworkRuleUtil.synViewValToChildInfo((IFormView)this.getView(), (ChildInfo)childInfo);
                    childInfos.add(childInfo);
                } else {
                    List childInfosList = cacheService.getChildInfoListWithLock();
                    for (ChildInfo childInfo : childInfosList) {
                        IFormView childView = this.getView().getView(childInfo.getPageId());
                        OverworkRuleUtil.synViewValToChildInfo((IFormView)childView, (ChildInfo)childInfo);
                        childInfos.add(childInfo);
                    }
                }
                returnData.put("CHILD_PARAM", childInfos);
                this.getView().returnDataToParent(returnData);
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            }
            finally {
                cacheService.unLock();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        AbstractOperate op;
        String operateKey;
        if (evt.getSource() instanceof AbstractOperate && "save".equals(operateKey = (op = (AbstractOperate)evt.getSource()).getOperateKey())) {
            String conditionJson = this.ruleConditionLimitService.setView(this.getView()).getValue();
            String dateConditionJson = this.ruleConditionService.setView(this.getView()).getValue();
            if (dateConditionJson != null && dateConditionJson.contains("is_or_isSub")) {
                this.getView().showTipNotification(ExKDStringHelper.gradeDateError());
                evt.setCancel(true);
                return;
            }
            if (!WTCDateRangeNohisEdit.validCondition((IFormView)this.getView(), (BeforeDoOperationEventArgs)evt, (String)dateConditionJson)) {
                return;
            }
            if (conditionJson != null && conditionJson.contains("is_or_isSub")) {
                this.getView().showTipNotification(ExKDStringHelper.gradeLimitError());
                evt.setCancel(true);
                return;
            }
            String limitScopeTip = ResManager.loadKDString((String)"\u9650\u5b9a\u6761\u4ef6\uff1a", (String)"CalculRuleEditPlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            String dateRangeTip = ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\uff1a", (String)"OverWorkRuleEdit_12", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            this.synToJsonCondition(conditionJson, evt, limitScopeTip, "limitscope", "calculdes");
            this.synToJsonCondition(dateConditionJson, evt, dateRangeTip, "daterangecondition", "calculname");
            Long dataSourceId = Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("datasource")).map(dy -> (Long)dy.getPkValue()).orElseGet(() -> null);
            if (!"1".equals(this.getView().getPageCache().get(CONFIRM_CALLBACK_ID)) && OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus()) && PreDataOtTimeSource.PD_1030_S.equals(dataSourceId) && Boolean.TRUE.equals(this.getModel().getValue("isempchoice"))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u3010\u52a0\u73ed\u65f6\u6570\u6765\u6e90\u3011\u4e3a\u201c\u6253\u5361\u201d\uff0c\u4f1a\u9ed8\u8ba4\u5173\u95ed\u5458\u5de5\u53ef\u81ea\u9009\u8865\u507f\u65b9\u5f0f\uff0c\u53ea\u4fdd\u75591\u6761\u8865\u507f\u65b9\u5f0f\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"CalculRuleEditPlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_ID, (IFormPlugin)this));
                evt.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CONFIRM_CALLBACK_ID.equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            this.getModel().setValue("isempchoice", (Object)Boolean.FALSE);
            this.getView().setEnable(Boolean.FALSE, new String[]{"isempchoice"});
            this.getView().getPageCache().put(CONFIRM_CALLBACK_ID, "1");
            this.getView().invokeOperation("save");
        }
    }

    private void synToJsonCondition(String conditionJson, BeforeDoOperationEventArgs evt, String showTip, String keyJson, String keyDesc) {
        if (!HRStringUtils.isEmpty((String)conditionJson)) {
            RuleValidateInfo info = RuleValidateUtil.validCondition((String)conditionJson, (boolean)true);
            if (this.showErrorNotification(this.getView(), evt, info, showTip)) {
                String conditionPreviewStr = RulePreviewUtil.getConditionPreviewStr((String)conditionJson);
                this.getModel().setValue(keyDesc, (Object)conditionPreviewStr);
                this.getModel().setValue(keyJson, (Object)conditionJson);
            }
        } else {
            this.getModel().setValue(keyDesc, (Object)"");
        }
    }

    private boolean showErrorNotification(IFormView view, BeforeDoOperationEventArgs args, RuleValidateInfo info, String tipFix) {
        if (!info.isSuccess()) {
            List msgList = info.getMsgList();
            if (args != null) {
                args.setCancel(true);
            }
            view.showTipNotification(tipFix + String.join((CharSequence)",", msgList));
        }
        return info.isSuccess();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((Control)beforeF7SelectEvent.getSource()).getKey();
        if (propertySet.contains(key)) {
            OverworkRuleUtil.setFilter(propertySet, (IFormView)this.getView(), (BeforeF7SelectEvent)beforeF7SelectEvent);
        }
    }

    private void setIsEmpChoice() {
        Long pkValue = Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("datasource")).map(dy -> (Long)dy.getPkValue()).orElseGet(() -> null);
        if (PreDataOtTimeSource.PD_1030_S.equals(pkValue)) {
            this.getModel().setValue("isempchoice", (Object)Boolean.FALSE);
            this.getView().setEnable(Boolean.FALSE, new String[]{"isempchoice"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isempchoice"});
        }
    }

    static {
        propertySet.add("otbaseset");
    }
}

