/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.overtime;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.business.rulecontrol.RuleConditionService;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;

public class OtBaseSetDataRangeEdit
extends HRDataBaseEdit {
    private RuleConditionService ruleConditionService = RuleConditionService.getInstance((String)"customcontrolap");

    public void propertyChanged(PropertyChangedArgs evt) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String hisAction = (String)customParams.get("his_action");
        if (HRStringUtils.isEmpty((String)hisAction) || HRStringUtils.equals((String)"open_insert_new_data_page", (String)hisAction)) {
            this.ruleConditionService.setView(this.getView()).setValue("");
            this.getModel().setValue("daterangecondition", null);
        }
    }

    private void updateDateRangeDate() {
        Date bsed = (Date)this.getModel().getValue("bsed");
        if (bsed != null) {
            this.ruleConditionService.setView(this.getView()).setDate(HRDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"));
        } else {
            this.ruleConditionService.setView(this.getView()).setDate(null);
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        HashMap replaceMap = Maps.newHashMapWithExpectedSize((int)2);
        replaceMap.put("otsimpledaterange.wtp_otsimpledaterangestd", "otsimpledaterange.wtbd_stddaterange");
        this.ruleConditionService.setView(this.getView()).setReplaceText((Map)replaceMap);
        String shiftConditionJson = this.getModel().getDataEntity().getString("daterangecondition");
        if (StringUtils.isNotBlank((CharSequence)shiftConditionJson)) {
            this.ruleConditionService.setView(this.getView()).setValue(shiftConditionJson);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockCondition();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (WTCFormUtils.isSave((BeforeDoOperationEventArgs)args)) {
            String shiftConditionJson = this.ruleConditionService.setView(this.getView()).getValue();
            if (shiftConditionJson != null && shiftConditionJson.contains("is_or_isSub")) {
                this.getView().showTipNotification(ExKDStringHelper.gradeError());
                args.setCancel(true);
                return;
            }
            RuleValidateInfo info = RuleValidateUtil.validCondition((String)shiftConditionJson, (boolean)false);
            if (!info.isSuccess()) {
                args.setCancel(true);
                this.getView().showTipNotification(String.join((CharSequence)",", info.getMsgList()));
                return;
            }
            this.getModel().setValue("daterangecondition", (Object)shiftConditionJson);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            String operateKey = afterDoOperationEventArgs.getOperateKey();
            if (Lists.newArrayList((Object[])new String[]{"submit", "unsubmit", "audit", "unaudit", "confirmchange"}).contains(operateKey)) {
                this.lockCondition();
            }
        }
    }

    private void lockCondition() {
        String pageState = WTCHisService.isLock((IFormView)this.getView()) ? "view" : "edit";
        this.ruleConditionService.setView(this.getView()).setPageState(pageState);
    }
}

