/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.overtime;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.common.predata.wtbd.PreDataOtType;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.overtime.OtRuleCalculCacheService;
import kd.wtc.wtp.business.overtime.OverworkRuleUtil;
import kd.wtc.wtp.common.ot.ChildInfo;
import kd.wtc.wtp.utils.WTCSheetUtil;

public class OtCalculRuleAttItemFlexPlugin
extends HRDynamicFormBasePlugin
implements AfterF7SelectListener {
    private static final Log LOG = LogFactory.getLog(OtCalculRuleAttItemFlexPlugin.class);
    private static final Set<String> ATTITEM_SET = Sets.newHashSet((Object[])new String[]{"otcompenmode", "originalprj", "originalconf", "originalcalprj", "overtimesub", "subprj", "bfroundingrule", "resultprj"});
    private static final String KEY_ATTITEMFLEXDEFAULT = "attitemflexdefault";
    private static final String KEY_ATTITEMFLEXX = "attitemflex";
    private static final String KEY_ADDITEM = "additem";
    private static final String BUTTON_ADDITEM = "additem";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = (Map)formShowParameter.getCustomParam("singleInfo");
        OtRuleCalculCacheService cacheService = new OtRuleCalculCacheService(this.getView());
        boolean lock = cacheService.getLock();
        if (!lock) {
            this.getView().showTipNotification(cacheService.getTip());
            return;
        }
        try {
            if (CollectionUtils.isEmpty((Map)map)) {
                cacheService.setChildInfoWithLock(new ArrayList(10));
                return;
            }
            Boolean choice = (Boolean)map.get("isempchoice");
            this.getModel().setValue("isempchoice", (Object)choice);
            String customParamJson = (String)map.get("CHILD_PARAM");
            if (HRStringUtils.isEmpty((String)customParamJson)) {
                cacheService.setChildInfoWithLock(new ArrayList(10));
                return;
            }
            List childInfoList = JSON.parseArray((String)customParamJson, ChildInfo.class);
            this.fixIndex(childInfoList);
            for (ChildInfo childInfo : childInfoList) {
                childInfo.setPageId(UUID.randomUUID().toString());
            }
            cacheService.setChildInfoWithLock(childInfoList);
            if (!choice.booleanValue()) {
                OverworkRuleUtil.synChildInfoToView((IDataModel)this.getModel(), (ChildInfo)((ChildInfo)childInfoList.get(0)));
            }
        }
        finally {
            cacheService.unLock();
        }
    }

    private void fixIndex(List<ChildInfo> childInfoList) {
        if (CollectionUtils.isEmpty(childInfoList)) {
            return;
        }
        Set indexSet = childInfoList.stream().map(ChildInfo::getIndex).collect(Collectors.toSet());
        if (indexSet.size() == 1) {
            for (int i = 0; i < childInfoList.size(); ++i) {
                childInfoList.get(i).setIndex(i);
            }
        } else {
            for (ChildInfo childInfo : childInfoList) {
                childInfo.setIndex(childInfo.getIndex() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterBindData(EventObject e) {
        OtRuleCalculCacheService cacheService = new OtRuleCalculCacheService(this.getView());
        List childInfoList = cacheService.getChildInfoListWithLock();
        boolean lock = cacheService.getLock();
        if (!lock) {
            this.getView().showTipNotification(cacheService.getTip());
            return;
        }
        try {
            if (CollectionUtils.isEmpty((Collection)childInfoList)) {
                return;
            }
            Boolean cus = (Boolean)this.getModel().getValue("isempchoice");
            this.getView().setVisible(cus, new String[]{"additem"});
            this.getView().setVisible(Boolean.valueOf(cus == false), new String[]{KEY_ATTITEMFLEXDEFAULT});
            if (cus.booleanValue()) {
                for (int i = 0; i < childInfoList.size(); ++i) {
                    this.initAttItemFlex((ChildInfo)childInfoList.get(i), i);
                }
            }
        }
        finally {
            cacheService.unLock();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        super.propertyChanged(args);
        switch (name = args.getProperty().getName()) {
            case "isempchoice": {
                this.handleCustomCompentChange(args);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChangeOtType(Long otTypeId) {
        OtRuleCalculCacheService cacheService = new OtRuleCalculCacheService(this.getView());
        boolean lock = cacheService.getLock();
        if (!lock) {
            this.getView().showTipNotification(cacheService.getTip());
            return;
        }
        try {
            if (PreDataOtType.PRESET_ARR.contains(otTypeId)) {
                Boolean cus = (Boolean)this.getModel().getValue("isempchoice");
                if (!cus.booleanValue()) {
                    OverworkRuleUtil.setDefaultVal((IFormView)this.getView(), (Long)otTypeId);
                } else {
                    Set childKeySet = cacheService.getChildInfoListWithLock().stream().map(ChildInfo::getPageId).collect(Collectors.toSet());
                    for (String childKey : childKeySet) {
                        IFormView childView = this.getView().getView(childKey);
                        OverworkRuleUtil.setDefaultVal((IFormView)childView, (Long)otTypeId);
                        this.getView().sendFormAction(childView);
                    }
                }
            }
        }
        finally {
            cacheService.unLock();
        }
    }

    private void handleCustomCompentChange(PropertyChangedArgs args) {
        Boolean cus = (Boolean)this.getModel().getValue("isempchoice");
        this.getView().setVisible(cus, new String[]{"additem"});
        this.getView().setVisible(Boolean.valueOf(cus == false), new String[]{KEY_ATTITEMFLEXDEFAULT});
        this.cleanAttItem();
        if (cus.booleanValue()) {
            this.addNewAttItem();
        } else {
            DynamicObject otType = (DynamicObject)this.getModel().getValue("ottype");
            Long otTypeId = otType == null ? 0L : otType.getLong("id");
            OverworkRuleUtil.setDefaultVal((IFormView)this.getView(), (Long)otTypeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAttItem() {
        for (String attItem : ATTITEM_SET) {
            this.getModel().setValue(attItem, null);
        }
        Container flexPanel = (Container)this.getView().getControl(KEY_ATTITEMFLEXX);
        OtRuleCalculCacheService cacheService = new OtRuleCalculCacheService(this.getView());
        boolean lock = cacheService.getLock();
        if (!lock) {
            this.getView().showTipNotification(cacheService.getTip());
            return;
        }
        try {
            Set<String> childKey = cacheService.getChildInfoListWithLock().stream().map(ChildInfo::getPageId).collect(Collectors.toSet());
            flexPanel.deleteControls(childKey.toArray(new String[0]));
            this.getView().updateView(KEY_ATTITEMFLEXX);
            ArrayList childInfos = new ArrayList(10);
            cacheService.setChildInfoWithLock(childInfos);
        }
        finally {
            cacheService.unLock();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"additem"});
        BasedataEdit ottype = (BasedataEdit)this.getControl("ottype");
        ottype.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (HRStringUtils.equals((String)key, (String)"additem")) {
            this.addNewAttItem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        OtRuleCalculCacheService cacheService = new OtRuleCalculCacheService(this.getView());
        boolean lock = cacheService.getLock();
        if (!lock) {
            this.getView().showTipNotification(cacheService.getTip());
            return;
        }
        try {
            List childInfoList = cacheService.getChildInfoListWithLock();
            int index = 0;
            Iterator iterator = childInfoList.iterator();
            while (iterator.hasNext()) {
                ChildInfo childInfo = (ChildInfo)iterator.next();
                IFormView childView = this.getView().getView(childInfo.getPageId());
                if (childView != null && !HRStringUtils.equals((String)childInfo.getPageId(), (String)actionId)) {
                    childInfo.setIndex(index);
                    childView.getModel().setValue("index", (Object)index);
                    this.getView().sendFormAction(childView);
                    ++index;
                    continue;
                }
                iterator.remove();
                Container flexPanel = (Container)this.getView().getControl(KEY_ATTITEMFLEXX);
                flexPanel.deleteControls(new String[]{childInfo.getPageId()});
            }
            cacheService.setChildInfoWithLock(childInfoList);
        }
        finally {
            cacheService.unLock();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        AbstractOperate op;
        String operateKey;
        if (evt.getSource() instanceof AbstractOperate && "save".equals(operateKey = (op = (AbstractOperate)evt.getSource()).getOperateKey())) {
            this.validateAttItem(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAttItem(BeforeDoOperationEventArgs evt) {
        Boolean cus = (Boolean)this.getModel().getValue("isempchoice");
        boolean result = true;
        OtRuleCalculCacheService cacheService = new OtRuleCalculCacheService(this.getView());
        boolean lock = cacheService.getLock();
        if (!lock) {
            this.getView().showTipNotification(cacheService.getTip());
            evt.setCancel(true);
            return;
        }
        try {
            if (!cus.booleanValue()) {
                result = OverworkRuleUtil.vailMustInputAttItem((String)"", (IFormView)this.getView(), Collections.emptySet());
            } else {
                List childInfoList = cacheService.getChildInfoListWithLock();
                if (CollectionUtils.isEmpty((Collection)childInfoList)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5458\u5de5\u81ea\u9009\u65f6\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u8865\u507f\u65b9\u5f0f\u3002", (String)"OtCalculRuleAttItemFlexPlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                for (ChildInfo childInfo : childInfoList) {
                    String title = ResManager.loadKDString((String)"\u8865\u507f\u65b9\u5f0f{0}\uff1a", (String)"OtCalculRuleAttItemFlexPlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
                    IFormView view = this.getView().getView(childInfo.getPageId());
                    title = MessageFormat.format(title, childInfo.getIndex() + 1);
                    result = OverworkRuleUtil.vailMustInputAttItem((String)title, (IFormView)view, (Set)Sets.newHashSet((Object[])new String[]{"otcompenmode"}));
                    if (result) continue;
                    this.getView().sendFormAction(view);
                    break;
                }
            }
            if (!result) {
                evt.setCancel(true);
            }
        }
        finally {
            cacheService.unLock();
        }
    }

    private void initAttItemFlex(ChildInfo childInfo, int index) {
        this.dynamicFlex(childInfo, index);
        HashMap param = Maps.newHashMapWithExpectedSize((int)16);
        String otRuleAttItemParamJson = JSON.toJSONString((Object)childInfo);
        param.put("CHILD_PARAM", otRuleAttItemParamJson);
        FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.InContainer, (String)childInfo.getPageId(), (String)"wtp_otcalculruleitem", (CloseCallBack)new CloseCallBack((IFormPlugin)this, childInfo.getPageId()), (HashMap)param, (OperationStatus)this.getView().getFormShowParameter().getStatus());
        parameter.setPageId(childInfo.getPageId());
        this.getView().showForm(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewAttItem() {
        OtRuleCalculCacheService cacheService = new OtRuleCalculCacheService(this.getView());
        boolean lock = cacheService.getLock();
        if (!lock) {
            this.getView().showTipNotification(cacheService.getTip());
            return;
        }
        try {
            List childInfoList = cacheService.getChildInfoListWithLock();
            int index = childInfoList.size();
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
            Long orgId = createOrg == null ? 0L : createOrg.getLong("id");
            Date bsed = (Date)this.getModel().getValue("bsed");
            ChildInfo childInfo = new ChildInfo(UUID.randomUUID().toString(), index, orgId.longValue(), bsed);
            this.setDefaultValForNew(childInfo);
            this.dynamicFlex(childInfo, index);
            childInfoList.add(childInfo);
            cacheService.setChildInfoWithLock(childInfoList);
            HashMap param = Maps.newHashMapWithExpectedSize((int)16);
            String otRuleAttItemParamJson = JSON.toJSONString((Object)childInfo);
            param.put("CHILD_PARAM", otRuleAttItemParamJson);
            FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.InContainer, (String)childInfo.getPageId(), (String)"wtp_otcalculruleitem", (CloseCallBack)new CloseCallBack((IFormPlugin)this, childInfo.getPageId()), (HashMap)param, (OperationStatus)this.getView().getFormShowParameter().getStatus());
            parameter.setPageId(childInfo.getPageId());
            this.getView().showForm(parameter);
        }
        finally {
            cacheService.unLock();
        }
    }

    private void setDefaultValForNew(ChildInfo childInfo) {
        DynamicObject otTypeDy = (DynamicObject)this.getModel().getValue("ottype");
        if (otTypeDy == null) {
            return;
        }
        Long otTypeId = otTypeDy.getLong("id");
        if (PreDataOtType.PRESET_ARR.contains(otTypeId)) {
            Map attendItem = OverworkRuleUtil.getOtTypeMapping((Long)otTypeId);
            childInfo.setOriginalPrj(((Long)attendItem.get("originalprj")).longValue());
            childInfo.setOriginalCalPrj(((Long)attendItem.get("originalcalprj")).longValue());
            childInfo.setSubPrj(((Long)attendItem.get("subprj")).longValue());
            childInfo.setResultPrj(((Long)attendItem.get("resultprj")).longValue());
        }
    }

    public void dynamicFlex(ChildInfo childInfo, int index) {
        Container flexPanel = (Container)this.getView().getControl(KEY_ATTITEMFLEXX);
        FlexPanelAp childFlex = new FlexPanelAp();
        childFlex.setKey(childInfo.getPageId());
        Margin margin = new Margin();
        margin.setBottom("0px");
        Style style = new Style();
        style.setMargin(margin);
        childFlex.setStyle(style);
        flexPanel.insertControls(index, Collections.singletonList(childFlex.createControl()));
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        BasedataEdit basedataEdit = (BasedataEdit)event.getSource();
        String fieldKey = basedataEdit.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"ottype")) {
            ListSelectedRow listSelectedRow = event.getListSelectedRow();
            String inputValue = (String)event.getInputValue();
            if (HRStringUtils.isNotEmpty((String)inputValue) || listSelectedRow != null) {
                Long pk = (Long)(listSelectedRow != null ? listSelectedRow.getPrimaryKeyValue() : Long.valueOf(Long.parseLong((String)event.getInputValue())));
                if (this.getTypeSet().contains(pk)) {
                    this.getModel().setValue("ottype", null);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u52a0\u73ed\u7c7b\u578b\u7684\u89c4\u5219\u3002", (String)"OtCalculRuleAttItemFlexPlugin_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                } else {
                    this.handleChangeOtType(pk);
                }
            }
        }
    }

    private Set<Long> getTypeSet() {
        IFormView parentView = this.getView().getParentView();
        DynamicObjectCollection entryEntity = parentView.getModel().getEntryEntity("overworkcalentry");
        Integer rowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("rowIndex");
        Set<Long> seq = rowIndex != null ? entryEntity.stream().filter(e -> e.getInt("seq") - 1 != rowIndex).map(e -> e.getLong("ottype.id")).collect(Collectors.toSet()) : entryEntity.stream().map(e -> e.getLong("ottype.id")).collect(Collectors.toSet());
        return seq;
    }
}

