/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.overtime;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.overtime.OtRuleCalculCacheService;
import kd.wtc.wtp.business.overtime.OverworkRuleUtil;
import kd.wtc.wtp.common.ot.ChildInfo;

public class OtCalculRuleAttItemPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    protected static final String KEY_INDEX = "index";
    protected static final String KEY_PAGEID = "pageid";
    private static final String KEY_LABEL_TITLE = "title";
    private static final String KEY_SUBENTRYID = "subentryid";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String otRuleAttItemParamJson = (String)this.getView().getFormShowParameter().getCustomParam("CHILD_PARAM");
        if (HRStringUtils.isNotEmpty((String)otRuleAttItemParamJson)) {
            ChildInfo param = (ChildInfo)WTCSerializationUtils.fromJsonString((String)otRuleAttItemParamJson, ChildInfo.class);
            this.getModel().setValue(KEY_INDEX, (Object)param.getIndex());
            this.getModel().setValue(KEY_PAGEID, (Object)param.getPageId());
            this.getModel().setValue("createorg", (Object)param.getCreateOrg());
            this.getModel().setValue("bsed", (Object)param.getBsed());
            this.getModel().setValue(KEY_SUBENTRYID, (Object)param.getSubEntryId());
            OverworkRuleUtil.synChildInfoToView((IDataModel)this.getModel(), (ChildInfo)param);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeTitle();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)KEY_INDEX)) {
            this.changeTitle();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("otcompenmode");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void changeTitle() {
        int index = (Integer)this.getModel().getValue(KEY_INDEX);
        Label titleLabel = (Label)this.getView().getControl(KEY_LABEL_TITLE);
        String title = ResManager.loadKDString((String)"\u8865\u507f\u65b9\u5f0f{0}:", (String)"OtCalculRuleAttItemPlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        title = MessageFormat.format(title, index + 1);
        titleLabel.setText(title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        OtRuleCalculCacheService cacheService = new OtRuleCalculCacheService(this.getView().getParentView());
        boolean lock = cacheService.getLock();
        if (!lock) {
            this.getView().showTipNotification(cacheService.getTip());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "=", (Object)0L));
            return;
        }
        try {
            List childInfos = cacheService.getChildInfoListWithLock();
            Set pageIds = childInfos.stream().map(ChildInfo::getPageId).collect(Collectors.toSet());
            HashSet compenSets = Sets.newHashSetWithExpectedSize((int)childInfos.size());
            String currentView = this.getView().getPageId();
            for (String pageId : pageIds) {
                IFormView childView;
                DynamicObject comDy;
                if (HRStringUtils.equals((String)pageId, (String)currentView) || (comDy = (DynamicObject)(childView = this.getView().getView(pageId)).getModel().getValue("otcompenmode")) == null) continue;
                compenSets.add(comDy.getLong("id"));
            }
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", (Object)compenSets));
        }
        finally {
            cacheService.unLock();
        }
    }
}

