/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.overtime;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.business.web.applybill.ruleengine.PlanRuleEngineHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.overtime.OverworkRuleUtil;
import kd.wtc.wtp.business.ruleenging.RuleEngingHelper;
import kd.wtc.wtp.constants.timecut.TimeCutConstants;
import kd.wtc.wtp.formplugin.web.ex.common.ExConfigViewService;
import kd.wtc.wtp.formplugin.web.filter.WTPValidate;
import kd.wtc.wtp.utils.AttPlanUtils;

public class OtPlanEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(OtPlanEdit.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("overworkrule");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit otTimeCut = (BasedataEdit)this.getView().getControl("timecut");
        otTimeCut.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        if ("setruleway".equals(name)) {
            String newValue = (String)args.getChangeSet()[0].getNewValue();
            boolean isEngineSetWay = StringUtils.equals((CharSequence)"2", (CharSequence)newValue);
            this.getView().setVisible(Boolean.valueOf(!isEngineSetWay), new String[]{"overworkrule"});
            if ("1".equals(newValue)) {
                if (OverworkRuleUtil.otPlanDisPlay((IFormView)this.getView())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"otscene"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"timecut"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"otscene"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"timecut"});
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"otscene"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"timecut"});
            }
            ((FieldEdit)this.getView().getControl("overworkrule")).setMustInput(!isEngineSetWay);
            if (isEngineSetWay) {
                this.getModel().setValue("overworkrule", null);
                this.getModel().setValue("otscene", null);
                this.getModel().setValue("timecut", null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (WTPValidate.validateSave(operateKey)) {
            Set<Long> otTimeCutId;
            if (!AttPlanUtils.validateBesd((DynamicObject)this.getModel().getDataEntity(), null, (String)"overworkrule")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u6700\u65e9\u751f\u6548\u65f6\u95f4\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"OtPlanEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject timeCutDy = this.getModel().getDataEntity(true).getDynamicObject("timecut");
            if (timeCutDy != null && (otTimeCutId = this.getOtTimeCutId(timeCutDy.getLong("id"))).isEmpty()) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if ("unsubmit".equals(operateKey) && !OverworkRuleUtil.isNewTimeCut((IFormView)this.getView())) {
            this.getView().updateView();
        }
    }

    public void afterBindData(EventObject object) {
        this.openTimeCutUpgradeRemind();
        if ("1".equals(this.getView().getModel().getValue("setruleway"))) {
            if (OverworkRuleUtil.otPlanDisPlay((IFormView)this.getView())) {
                this.getView().getModel().setValue("otscene", null);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"otscene"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"timecut"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"otscene"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"timecut"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"otscene"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"timecut"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        if ("open_timecut_list".equals(actionId) && returnData != null && Boolean.TRUE.equals(returnData.get("open_timecut_list"))) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("wtp_timecut");
            listShowParameter.setFormId("bos_list");
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Date besd = (Date)this.getModel().getValue("bsed");
        if (besd == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"OtPlanEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)"overworkrule", (String)fieldKey)) {
            Date beSd = (Date)this.getModel().getValue("bsed");
            beforeF7SelectEvent.addCustomQFilter(new QFilter("firstbsed", "<=", (Object)beSd));
        } else if (HRStringUtils.equals((String)"timecut", (String)fieldKey)) {
            Set<Long> otTimeCutIdSet = this.getOtTimeCutId(null);
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", otTimeCutIdSet));
        }
    }

    private Set<Long> getOtTimeCutId(Long timeCutId) {
        QFilter[] qFilters;
        Date beSd = this.getModel().getDataEntity(true).getDate("bsed");
        if (beSd == null) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_timecut");
        if (timeCutId != null) {
            qFilters = new QFilter[]{new QFilter("id", "=", (Object)timeCutId)};
        } else {
            QFilter dateTypeTime = new QFilter("timecutentry.datetypetime.firstbsed", "<=", (Object)beSd);
            qFilters = new QFilter[]{dateTypeTime};
        }
        DynamicObject[] result = serviceHelper.query("id,timecutentry.datetypetime,timecutentry.cutattitem,timecutentry.iscutattitem", qFilters);
        if (result == null || result.length == 0) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)result.length);
        for (DynamicObject timeCutDy : result) {
            boolean haveErrorDate = false;
            DynamicObjectCollection entry = timeCutDy.getDynamicObjectCollection("timecutentry");
            for (DynamicObject dy : entry) {
                Date cutAttItemBsEd;
                Date dateTypeTimeBsEd;
                DynamicObject dateTypeTimeDy = dy.getDynamicObject("datetypetime");
                if (dateTypeTimeDy != null && (dateTypeTimeBsEd = dateTypeTimeDy.getDate("firstbsed")) != null && dateTypeTimeBsEd.compareTo(beSd) > 0) {
                    haveErrorDate = true;
                    if (timeCutId == null) break;
                    String dateTypeTimeError = ResManager.loadKDString((String)"\u52a0\u73ed\u65b9\u6848\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u9009\u5de5\u65f6\u5207\u5206\u914d\u7f6e\u7684\u201c\u65e5\u671f\u7c7b\u578b\u65f6\u6bb5\u201d\u751f\u6548\u65e5\u671f\u3002", (String)"OtPlanEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(dateTypeTimeError);
                    break;
                }
                DynamicObject cutAttItemDy = dy.getDynamicObject("cutattitem");
                if (cutAttItemDy == null || !dy.getBoolean("iscutattitem") || (cutAttItemBsEd = cutAttItemDy.getDate("firstbsed")) == null || cutAttItemBsEd.compareTo(beSd) <= 0) continue;
                haveErrorDate = true;
                if (timeCutId == null) break;
                String dateTypeTimeError = ResManager.loadKDString((String)"\u52a0\u73ed\u65b9\u6848\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u9009\u5de5\u65f6\u5207\u5206\u914d\u7f6e\u7684\u201c\u73ed\u6b21\u5185\u65f6\u957f\u201d\u8003\u52e4\u9879\u76ee\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"OtPlanEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(dateTypeTimeError);
                break;
            }
            if (haveErrorDate) continue;
            idSet.add(timeCutDy.getLong("id"));
        }
        return idSet;
    }

    public void beforeBindData(EventObject ee) {
        super.beforeBindData(ee);
        Map<String, String> promptMap = ExConfigViewService.getPromptMap(this.getView(), "wtp_otplan");
        this.getView().getPageCache().put("tips", promptMap.get("tipslabelap"));
    }

    private void openTimeCutUpgradeRemind() {
        if (WTCHisService.isLock((IFormView)this.getView())) {
            return;
        }
        List<Object> oldScenes = new ArrayList();
        List defaultOldScenes = new ArrayList<Integer>();
        boolean useRuleEngine = "2".equals(this.getModel().getDataEntity().getString("setruleway"));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long planId = this.getModel().getDataEntity().getLong("id");
        if (0L == planId) {
            Object isCopy = customParams.get("iscopy");
            if (isCopy != null && ((Boolean)isCopy).booleanValue()) {
                try {
                    Object pkId = ((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
                    if (pkId != null) {
                        planId = (Long)pkId;
                    }
                }
                catch (RuntimeException e) {
                    LOGGER.warn("OtPlanEdit.openTimeCutUpgradeRemind.isCopyFail");
                }
            }
            if (customParams.get("currentDataId") != null) {
                planId = (Long)customParams.get("currentDataId");
            }
        }
        if (0L == planId) {
            return;
        }
        if (useRuleEngine) {
            DynamicObject policyDy;
            List policyDys = PlanRuleEngineHelper.getPolicyByPlanIds(Collections.singleton(planId));
            if (WTCCollections.isNotEmpty((Collection)policyDys) && (policyDy = RuleEngingHelper.queryRuleEngingByPlanId((Object)((DynamicObject)policyDys.get(0)).getLong("policyid"))) != null) {
                boolean returnDefault = policyDy.getBoolean("retrundefault");
                String defaultResultStr = policyDy.getString("results");
                if (returnDefault && HRStringUtils.isNotEmpty((String)defaultResultStr)) {
                    defaultOldScenes.addAll(this.getOtSceneByRuleStr(defaultResultStr));
                }
                DynamicObjectCollection entryDys = policyDy.getDynamicObjectCollection("entryrulelist");
                for (DynamicObject entryDy : entryDys) {
                    List<Integer> entryScenes = this.getOtSceneByRuleStr(entryDy.getString("filterresult"));
                    if (entryScenes.size() <= oldScenes.size()) continue;
                    oldScenes = entryScenes;
                }
            }
        } else {
            DynamicObject otPlanDy = HRBaseServiceHelper.create((String)"wtp_otplan").queryOne((Object)planId);
            String oldScene = otPlanDy.getString("otscene");
            if (WTCStringUtils.isNotEmpty((String)oldScene)) {
                String[] oldSceneValues = oldScene.split(",");
                oldScenes.addAll(Arrays.stream(oldSceneValues).filter(WTCStringUtils::isNotEmpty).map(scene -> Integer.valueOf(scene)).collect(Collectors.toList()));
                if (oldScenes.size() == 1 && TimeCutConstants.OLD_AND_NEW_MAP.containsKey(oldScenes.get(0))) {
                    Long timeCutId = (Long)TimeCutConstants.OLD_AND_NEW_MAP.get(oldScenes.get(0));
                    this.getModel().setValue("timecut", (Object)timeCutId);
                }
            }
        }
        if (oldScenes.size() + defaultOldScenes.size() > 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("wtp_timecutupgrade");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            if (oldScenes.size() == 0 || oldScenes.size() == 1 && defaultOldScenes.size() > 1) {
                oldScenes = defaultOldScenes;
                defaultOldScenes = Collections.EMPTY_LIST;
                parameter.getCustomParams().put("unShowDefTips", true);
            }
            StyleCss styleCss = new StyleCss();
            if (oldScenes.size() > 1) {
                styleCss.setHeight("673px");
            }
            parameter.getOpenStyle().setInlineStyleCss(styleCss);
            parameter.getCustomParams().put("oldTimeCutType", oldScenes);
            parameter.getCustomParams().put("oldTimeCutTypeDef", defaultOldScenes);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "open_timecut_list"));
            this.getView().showForm(parameter);
        }
    }

    private List<Integer> getOtSceneByRuleStr(String ruleJsonStr) {
        ArrayList<Integer> oldOtScenes = new ArrayList<Integer>(6);
        try {
            JSONArray resultList = JSONObject.parseObject((String)ruleJsonStr).getJSONArray("resultList");
            for (Object ruleEntryResult : resultList) {
                if (!"otscene".equals(((JSONObject)ruleEntryResult).getString("param"))) continue;
                String oldScene = ((JSONObject)ruleEntryResult).getString("value");
                String[] oldSceneValues = oldScene.split(",");
                oldOtScenes.addAll(Arrays.stream(oldSceneValues).filter(WTCStringUtils::isNotEmpty).map(scene -> Integer.valueOf(scene)).collect(Collectors.toList()));
            }
        }
        catch (JSONException | ClassCastException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u5f15\u64ce\u89e3\u6790\u5931\u8d25\u3002", (String)"OtPlanEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        }
        return oldOtScenes;
    }
}

