/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.overtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.grid.DataGrid;
import kd.bos.form.control.grid.DataGridRow;
import kd.bos.form.control.grid.DataGridRowBuilder;
import kd.bos.form.control.grid.events.DataGridBindDataEvent;
import kd.bos.form.control.grid.events.DataGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.MultiLangEnumBridge;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtp.business.ruleenging.RulePreviewUtil;
import kd.wtc.wtp.common.kdstring.TimeCutKDString;
import kd.wtc.wtp.constants.timecut.TimeCutConstants;

public class OtPlanTimeCutUpgradePlugin
extends HRDataBaseEdit
implements DataGridBindDataListener {
    public void initialize() {
        DataGrid dataGrid = (DataGrid)this.getControl("datagridap");
        dataGrid.addBindDataListener((DataGridBindDataListener)this);
        DataGrid dataGridDef = (DataGrid)this.getControl("datagridapdef");
        dataGridDef.addBindDataListener((DataGridBindDataListener)this);
    }

    public void dataGridBindData(DataGridBindDataEvent evt) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object oldCtType = null;
        String oldCtName = null;
        DataGrid source = (DataGrid)evt.getSource();
        if ("datagridap".equals(source.getKey())) {
            oldCtType = customParams.get("oldTimeCutType");
            oldCtName = "oldtimecutname";
        } else if ("datagridapdef".equals(source.getKey())) {
            oldCtType = customParams.get("oldTimeCutTypeDef");
            oldCtName = "oldtimecutname1";
        }
        if (oldCtType != null) {
            HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtp_timecut");
            DynamicObjectCollection entryDys = this.getView().getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            int step = entryDys.size() + 1;
            ArrayList<List> list = new ArrayList<List>();
            if (oldCtType instanceof List) {
                List oldCtTypes = oldCtType;
                ArrayList<Long> timeCutIds = new ArrayList<Long>(oldCtTypes.size());
                DataGridRowBuilder builder = evt.getDataGridRowBuilder();
                for (int i = 0; i < oldCtTypes.size(); ++i) {
                    Object ctType = oldCtTypes.get(i);
                    if (TimeCutConstants.OLD_AND_NEW_MAP.containsKey(ctType)) {
                        Long timeCutId = (Long)TimeCutConstants.OLD_AND_NEW_MAP.get((Integer)ctType);
                        timeCutIds.add(timeCutId);
                    }
                    if (!TimeCutConstants.OLD_TC_NAME.containsKey(ctType)) continue;
                    String oldTimeCutName = ((MultiLangEnumBridge)TimeCutConstants.OLD_TC_NAME.get((Integer)ctType)).loadKDString();
                    DataGridRow row = builder.buildRow();
                    row.setValue("rk", (Object)i);
                    row.setValue("seq", (Object)(i + 1));
                    row.setValue(oldCtName, (Object)oldTimeCutName);
                    list.add(row.get());
                }
                if ("datagridap".equals(source.getKey())) {
                    DynamicObject[] timeCuts = serviceHelper.loadDynamicObjectArray(new QFilter("id", "in", timeCutIds).toArray());
                    for (int i = 0; i < timeCuts.length; ++i) {
                        DynamicObject timeCutDy = timeCuts[i];
                        DynamicObject timeCutEntry = (DynamicObject)timeCutDy.getDynamicObjectCollection("timecutentry").get(0);
                        DynamicObject dynamicObject = entryDys.addNew();
                        dynamicObject.set("integerfield", (Object)(i + step));
                        dynamicObject.set("textfield", (Object)"\u221a");
                        dynamicObject.set("timecutname", timeCutDy.get("name"));
                        dynamicObject.set("timecutcond", (Object)this.setConditionStr((DynamicObject)timeCutDy.getDynamicObjectCollection("timecutentry").get(0)));
                        dynamicObject.set("ctdatetypetime", timeCutEntry.get("datetypetime.name"));
                    }
                }
                evt.setData(list);
            }
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        List oldCtType = customParams.getOrDefault("oldTimeCutType", Collections.EMPTY_LIST);
        List oldCtTypeDef = customParams.getOrDefault("oldTimeCutTypeDef", Collections.EMPTY_LIST);
        if (oldCtType.size() < 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"datagridap"});
        }
        if (oldCtTypeDef.size() < 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexdatagridapdef"});
        }
        if (oldCtType.size() > 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"step21"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"step211"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"step31"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"step311"});
            Label entryCount = (Label)this.getView().getControl("entrycount");
            entryCount.setText(String.valueOf(oldCtType.size()));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"step22"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"step221"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"step32"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"step321"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"step421"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok"});
        }
        Object unShowDefTips = this.getView().getFormShowParameter().getCustomParam("unShowDefTips");
        if (unShowDefTips != null && ((Boolean)unShowDefTips).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"step3112", "labelap5211"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if ("donothing".equals(operateKey)) {
            HashMap<String, Boolean> returnData = new HashMap<String, Boolean>(1);
            returnData.put("open_timecut_list", Boolean.TRUE);
            this.getView().returnDataToParent(returnData);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private String setConditionStr(DynamicObject entry) {
        String beforeStr = null;
        String dayStr = null;
        String afterStr = null;
        Object beforeCond = entry.get("beforedaycond");
        Object dayCond = entry.get("daycond");
        Object afterCond = entry.get("afterdaycond");
        if (beforeCond != null && WTCStringUtils.isNotEmpty((String)((String)beforeCond))) {
            beforeStr = TimeCutKDString.getBeforeDayStr() + RulePreviewUtil.getConditionPreviewStr((String)((String)beforeCond));
        }
        if (dayCond != null && WTCStringUtils.isNotEmpty((String)((String)dayCond))) {
            dayStr = TimeCutKDString.getDayStr() + RulePreviewUtil.getConditionPreviewStr((String)((String)dayCond));
        }
        if (afterCond != null && WTCStringUtils.isNotEmpty((String)((String)afterCond))) {
            afterStr = TimeCutKDString.getAfterDayStr() + RulePreviewUtil.getConditionPreviewStr((String)((String)afterCond));
        }
        ArrayList<String> conditionStr = new ArrayList<String>();
        if (WTCStringUtils.isNotEmpty(beforeStr)) {
            conditionStr.add(beforeStr);
        }
        if (WTCStringUtils.isNotEmpty(dayStr)) {
            conditionStr.add(dayStr);
        }
        if (WTCStringUtils.isNotEmpty(afterStr)) {
            conditionStr.add(afterStr);
        }
        return String.join((CharSequence)WTCSymbolMultiLanguageUtil.getCommonSymbol(), conditionStr);
    }
}

