/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.overtime;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtp.business.overtime.OtSubService;
import kd.wtc.wtp.business.overtime.WTPTipsEnum;

public class OtSubEdit
extends HRDataBaseEdit {
    private static final Set<String> SAVE_MODIFY_OP = Sets.newHashSet((Object[])new String[]{"save", "submit", "submitandaudit"});
    private Boolean changeBySys = Boolean.FALSE;
    private boolean changeNum = false;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (Arrays.asList("submit", "audit").contains(operate.getOperateKey()) && !OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            operate.getOption().setVariableValue("param_is_submit_directly", "false");
        }
        if (Arrays.asList("submit", "save", "saveandnew", "confirmchange").contains(operate.getOperateKey())) {
            BigDecimal fixtimes = this.getModel().getDataEntity(true).getBigDecimal("fixtimes");
            BigDecimal destimes = this.getModel().getDataEntity(true).getBigDecimal("destimes");
            BigDecimal satisfyhours = this.getModel().getDataEntity(true).getBigDecimal("satisfyhours");
            BigDecimal deducthours = this.getModel().getDataEntity(true).getBigDecimal("deducthours");
            if (fixtimes == null) {
                this.getModel().getDataEntity(true).set("fixtimes", (Object)0L);
            }
            if (destimes == null) {
                this.getModel().getDataEntity(true).set("destimes", (Object)0L);
            }
            if (satisfyhours == null) {
                this.getModel().getDataEntity(true).set("satisfyhours", (Object)0L);
            }
            if (deducthours == null) {
                this.getModel().getDataEntity(true).set("deducthours", (Object)0L);
            }
        }
        this.checkSaveAndModifyEntry(args, operate);
        this.checkDeleteAndNewEntryRow(args, operate);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propertyName = args.getProperty().getName();
        if (args.getChangeSet() == null || args.getChangeSet().length <= 0) {
            return;
        }
        Object val = args.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "subtype": {
                this.handleDataByChangeSubType(args);
                break;
            }
            case "selectsub": {
                this.changeNum = true;
                this.getModel().setValue("destimes", null);
                ((FieldEdit)this.getView().getControl("destimes")).setMustInput("1".equals(this.getModel().getValue("selectsub")));
                break;
            }
            case "endtime": 
            case "starttime": {
                if (this.changeBySys.booleanValue()) break;
                this.changeBySys = Boolean.TRUE;
                this.handleSubTimeChange(args);
                break;
            }
            case "satisfyhours": 
            case "deducthours": {
                if (val == null || this.changeNum) break;
                this.changeNum = true;
                WTCFormUtils.showIllegalNumTipAndClean((IFormView)this.getView(), (String)propertyName, (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("24"), (boolean)false, (boolean)true, (BigDecimal)new BigDecimal(val + ""));
                break;
            }
            case "fixtimes": {
                if (val == null || this.changeNum) break;
                this.changeNum = true;
                WTCFormUtils.showIllegalNumTipAndClean((IFormView)this.getView(), (String)propertyName, (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("9999"), (boolean)false, (boolean)true, (BigDecimal)new BigDecimal(val + ""));
                break;
            }
            case "destimes": {
                if (val == null || this.changeNum) break;
                this.changeNum = true;
                WTCFormUtils.showIllegalNumTipAndClean((IFormView)this.getView(), (String)propertyName, (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("999"), (boolean)false, (boolean)true, (BigDecimal)new BigDecimal(val + ""));
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String subType = this.getModel().getDataEntity().getString("subtype");
        if ("D".equals(subType)) {
            ((FieldEdit)this.getView().getControl("satisfyhours")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("deducthours")).setMustInput(true);
        }
        ((FieldEdit)this.getView().getControl("selectsub")).setMustInput(WTPTipsEnum.DEDUCTION_RESTRERIOD.getType().equals(subType));
        ((FieldEdit)this.getView().getControl("fixtimes")).setMustInput(WTPTipsEnum.DEDUCTION_FIXED_DURATION.getType().equals(subType));
        ((FieldEdit)this.getView().getControl("destimes")).setMustInput(WTPTipsEnum.DEDUCTION_RESTRERIOD.getType().equals(subType) && "1".equals(this.getModel().getValue("selectsub")));
        Container attPolicyFlex = (Container)this.getView().getControl("flexpanelap");
        attPolicyFlex.setCollapse(false);
    }

    private void dealFixTimesChange() {
        String subType = this.getModel().getDataEntity().getString("subtype");
        ((FieldEdit)this.getView().getControl("satisfyhours")).setMustInput("D".equals(subType));
        ((FieldEdit)this.getView().getControl("deducthours")).setMustInput("D".equals(subType));
    }

    private void handleDataByChangeSubType(PropertyChangedArgs changedArgs) {
        this.changeNum = true;
        this.cleanEntry();
        this.getModel().setValue("fixtimes", null);
        this.getModel().setValue("destimes", null);
        this.getModel().setValue("satisfyhours", null);
        this.getModel().setValue("deducthours", null);
        String type = (String)changedArgs.getChangeSet()[0].getNewValue();
        WTPTipsEnum enumByType = WTPTipsEnum.getEnumByType((String)type);
        if (enumByType == WTPTipsEnum.DEDUCTION_FIXED_PERIOD_TIME) {
            this.getModel().createNewEntryRow("entryentity");
        }
        ((FieldEdit)this.getView().getControl("selectsub")).setMustInput(WTPTipsEnum.DEDUCTION_RESTRERIOD.getType().equals(type));
        ((FieldEdit)this.getView().getControl("destimes")).setMustInput(WTPTipsEnum.DEDUCTION_RESTRERIOD.getType().equals(type) && "1".equals(this.getModel().getValue("selectsub")));
        ((FieldEdit)this.getView().getControl("fixtimes")).setMustInput(WTPTipsEnum.DEDUCTION_FIXED_DURATION.getType().equals(type));
        this.dealFixTimesChange();
    }

    private void cleanEntry() {
        String type = this.getModel().getDataEntity().getString("subtype");
        if (!"E".equals(type) && !this.getModel().getEntryEntity("entryentity").isEmpty()) {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    private void handleSubTimeChange(PropertyChangedArgs propertyChangedArgs) {
        int index;
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        if (!OtSubService.checkEachEntryRowStartAndEndTime((DynamicObjectCollection)collection, (int)(index = propertyChangedArgs.getChangeSet()[0].getRowIndex()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"OtSubEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            this.setOriValByIndex(index, "starttime", "endtime");
            return;
        }
        if (!OtSubService.checkNotRepeat((DynamicObjectCollection)collection, (int)index)) {
            this.setOriValByIndex(index, "starttime", "endtime");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0e\u73b0\u6709\u65f6\u95f4\u6bb5\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OtSubEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        }
    }

    private void cleanEntryByIndex(int index, String ... keys) {
        for (String key : keys) {
            this.getModel().setValue(key, null, index);
        }
    }

    private void setOriValByIndex(int index, String ... keys) {
        for (String key : keys) {
            this.getModel().setValue(key, (Object)-1, index);
        }
    }

    private void checkSaveAndModifyEntry(BeforeDoOperationEventArgs args, AbstractOperate operate) {
        String opKey = operate.getOperateKey();
        if (SAVE_MODIFY_OP.contains(opKey)) {
            DynamicObjectCollection entry;
            String type = (String)this.getModel().getValue("subtype");
            WTPTipsEnum enumByType = WTPTipsEnum.getEnumByType((String)type);
            boolean passCheck = true;
            String tip = "";
            if (enumByType == WTPTipsEnum.DEDUCTION_FIXED_PERIOD_TIME && (entry = this.getModel().getEntryEntity("entryentity")).size() == 1 && (((DynamicObject)entry.get(0)).getInt("starttime") == -1 || ((DynamicObject)entry.get(0)).getInt("endtime") == -1)) {
                passCheck = false;
                tip = ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtSubEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            }
            if (!passCheck) {
                this.getView().showTipNotification(tip);
                args.setCancel(true);
            }
        }
    }

    private void checkDeleteAndNewEntryRow(BeforeDoOperationEventArgs args, AbstractOperate operate) {
        switch (operate.getOperateKey()) {
            case "newentry": {
                this.checkEntryRow(args, "entryentity", ResManager.loadKDString((String)"\u6700\u591a\u53ea\u5141\u8bb8\u65b0\u589e10\u6761\u5206\u5f55\u6570\u636e\u3002", (String)"OtSubEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                break;
            }
            case "deleteentry": {
                this.checkDeleteRow(args, "entryentity", ResManager.loadKDString((String)"\u6700\u5c11\u9700\u8981\u4fdd\u7559\u4e00\u6761\u65f6\u6bb5\u3002", (String)"OtSubEdit_7", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void checkEntryRow(BeforeDoOperationEventArgs args, String entryentity, String tip) {
        DynamicObjectCollection fixTime = this.getModel().getEntryEntity(entryentity);
        if (fixTime.size() == 10) {
            this.getView().showTipNotification(tip);
            args.setCancel(true);
        }
    }

    public void checkDeleteRow(BeforeDoOperationEventArgs args, String entryEntity, String tip) {
        DynamicObjectCollection fixTime = this.getModel().getEntryEntity(entryEntity);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryEntity);
        int[] selectRows = entryGrid.getSelectRows();
        if (fixTime.size() == selectRows.length) {
            this.getView().showTipNotification(tip);
            args.setCancel(true);
        }
    }
}

