/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.overtime;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.overtime.OverworkRuleUtil;
import kd.wtc.wtp.common.ot.ChildInfo;

public class OverworkRuleEdit
extends HRCoreBaseBillEdit
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(OverworkRuleEdit.class);
    private final Set<String> SET_UN_CHANGE_FIELD = Sets.newHashSet((Object[])new String[]{"daterangecondition", "limitscope"});
    private static Set<String> propertySet = new HashSet<String>(16);

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addItemClickListeners(new String[]{"toolbar"});
        EntryGrid formulaEntryGrid = (EntryGrid)this.getView().getControl("overworkcalentry");
        formulaEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        OverworkRuleUtil.listenF7(propertySet, (IFormView)this.getView(), (BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        LOG.info("OverworkRuleEdit_afterBindData");
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String hisAction = (String)customParams.get("his_action");
        boolean isNewVersion = HRStringUtils.equals((String)"open_insert_new_data_page", (String)hisAction);
        if (isNewVersion) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData("overworkcalentry");
            model.endInit();
            this.getView().updateView("overworkcalentry");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String name = evt.getOperateKey();
        if ("copyrow".equals(name) || "addrow".equals(name) || "editrow".equals(name)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("overworkcalentry");
            int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
            if (("copyrow".equals(name) || "editrow".equals(name)) && ObjectUtils.isEmpty((Object)selectedRows)) {
                return;
            }
            if ("copyrow".equals(name)) {
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("overworkcalentry").get(selectedRows[0]);
                FormShowParameter formShowParameter = this.getFormShowCustom(dynamicObject, null);
                this.getRespectFormShowCustom(formShowParameter, null);
                this.openCalculRule(formShowParameter, null);
            }
            if ("addrow".equals(name)) {
                FormShowParameter respectFormShowCustom = this.getRespectFormShowCustom(null, null);
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
                if (org != null) {
                    map.put("createorg", org.getPkValue());
                }
                map.put("bsed", this.getModel().getValue("bsed"));
                respectFormShowCustom.setCustomParam("singleInfo", map);
                this.openCalculRule(respectFormShowCustom, null);
            }
            if ("editrow".equals(name)) {
                int rowIndex = entryGrid.getEntryState().getFocusRow();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("overworkcalentry");
                if (entryEntity.size() < rowIndex + 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u5f55\u4fe1\u606f\u53d1\u751f\u53d8\u5316\uff0c\u91cd\u65b0\u6253\u5f00\u9875\u9762\u540e\u518d\u7f16\u8f91\u3002", (String)"OverWorkRuleEdit_15", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
                FormShowParameter formShowParameter = this.getFormShowCustom(dynamicObject, rowIndex);
                this.getRespectFormShowCustom(formShowParameter, dynamicObject);
                this.openCalculRule(formShowParameter, OperationStatus.EDIT);
            }
        }
    }

    private boolean checkEffDate(BeforeDoOperationEventArgs args) {
        if (this.getModel().getValue("bsed") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"OverWorkRuleEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl("overworkcalentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (("copyrow".equals(operateKey) || "editrow".equals(operateKey)) && ObjectUtils.isEmpty((Object)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OverWorkRuleEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "copyrow": {
                this.checkSelectOne(args);
            }
            case "addrow": 
            case "editrow": {
                this.checkEffDate(args);
                break;
            }
            case "save": 
            case "submit": 
            case "confirmchange": 
            case "submitandaudit": {
                DynamicObjectCollection entity = this.getView().getModel().getEntryEntity("overworkcalentry");
                if (!CollectionUtils.isEmpty((Collection)entity)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u884c\u6570\u636e\u5230\u8ba1\u7b97\u89c4\u5219\u4e2d\u3002", (String)"OverWorkRuleEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    private void checkSelectOne(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("overworkcalentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (selectedRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"OverWorkRuleEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private boolean judgeBsed(LocalDate rulesBsedLocalDate, LocalDate configBsedLocalDate, BeforeDoOperationEventArgs args) {
        if (rulesBsedLocalDate.isBefore(configBsedLocalDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52a0\u73ed\u57fa\u7840\u914d\u7f6e\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u8be5\u89c4\u5219\u751f\u6548\u65e5\u671f\u3002", (String)"OverWorkRuleEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OverWorkRuleEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
    }

    private FormShowParameter getRespectFormShowCustom(FormShowParameter formShowParameter, DynamicObject dynamicObject) {
        if (formShowParameter == null) {
            formShowParameter = new FormShowParameter();
            formShowParameter.setCustomParam("bsed", this.getModel().getValue("bsed"));
        }
        return formShowParameter;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String hisAction = (String)customParams.get("his_action");
        Object pkValue = this.getModel().getDataEntity(true).getPkValue();
        if (pkValue != null && (Long)pkValue != 0L || HRStringUtils.isNotEmpty((String)hisAction)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"createorg"});
        }
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("btnok".equals(actionId)) {
            Integer rowIndex = (Integer)returnData.get("rowIndex");
            if (rowIndex != null) {
                this.updateEntryRow(returnData, rowIndex);
            } else {
                this.addEntryRow(returnData);
            }
        }
    }

    private void addEntryRow(Map<String, Object> returnData) {
        this.getModel().beginInit();
        IDataModel entryOperate = this.getModel();
        int newEntryRow = entryOperate.createNewEntryRow("overworkcalentry");
        this.getModel().setValue("ottype", ((DynamicObject)returnData.get("ottype")).getPkValue(), newEntryRow);
        this.getModel().setValue("ottype", returnData.get("ottype"), newEntryRow);
        this.getModel().setValue("calculname", returnData.get("calculname"), newEntryRow);
        this.getModel().setValue("calculdes", returnData.get("calculdes"), newEntryRow);
        this.getModel().setValue("otbaseset", ((DynamicObject)returnData.get("otbaseset")).getPkValue(), newEntryRow);
        DynamicObject otsystem = (DynamicObject)returnData.get("otsystem");
        this.getModel().setValue("otsystem", Objects.nonNull(otsystem) ? otsystem.getPkValue() : null, newEntryRow);
        this.getModel().setValue("datasource", ((DynamicObject)returnData.get("datasource")).getPkValue(), newEntryRow);
        this.getModel().setValue("limitscope", returnData.get("limitscope"), newEntryRow);
        this.getModel().setValue("daterangecondition", returnData.get("daterangecondition"), newEntryRow);
        this.getModel().setValue("isempchoice", returnData.get("isempchoice"), newEntryRow);
        this.getView().updateView("overworkcalentry");
        List childInfoList = (List)returnData.get("CHILD_PARAM");
        DynamicObject entryDyn = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("overworkcalentry").get(newEntryRow);
        if (!CollectionUtils.isEmpty((Collection)childInfoList)) {
            DynamicObjectCollection limitSubColl = entryDyn.getDynamicObjectCollection("overworkcaldetail");
            limitSubColl.clear();
            for (ChildInfo childInfo : childInfoList) {
                DynamicObject limitSubDy = limitSubColl.addNew();
                this.setProject(childInfo, limitSubDy);
            }
        }
        this.getModel().endInit();
        this.getView().updateView("overworkcalentry");
        this.getView().updateView("overworkcaldetail");
    }

    private void updateEntryRow(Map<String, Object> returnData, Integer rowIndex) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection entries = this.getModel().getEntryEntity("overworkcalentry");
        model.setValue("ottype", returnData.get("ottype"), rowIndex.intValue());
        model.setValue("otbaseset", returnData.get("otbaseset"), rowIndex.intValue());
        model.setValue("otsystem", returnData.get("otsystem"), rowIndex.intValue());
        model.setValue("datasource", returnData.get("datasource"), rowIndex.intValue());
        model.setValue("limitscope", returnData.get("limitscope"), rowIndex.intValue());
        model.setValue("daterangecondition", returnData.get("daterangecondition"), rowIndex.intValue());
        model.setValue("isempchoice", returnData.get("isempchoice"), rowIndex.intValue());
        String calculdes = (String)returnData.get("calculdes");
        String calculname = (String)returnData.get("calculname");
        if (entries != null && entries.size() > rowIndex) {
            DynamicObject entryDy = (DynamicObject)entries.get(rowIndex.intValue());
            String oriCalculdes = entryDy.getString("calculdes");
            String oriCalculname = entryDy.getString("calculname");
            if (!HRStringUtils.equals((String)calculdes, (String)oriCalculdes)) {
                if (HRStringUtils.isEmpty((String)calculdes)) {
                    this.setConditionLocalEmptyStr("calculdes", model);
                }
                model.setValue("calculdes", (Object)calculdes, rowIndex.intValue());
            }
            if (!HRStringUtils.equals((String)calculname, (String)oriCalculname)) {
                if (HRStringUtils.isEmpty((String)calculdes)) {
                    this.setConditionLocalEmptyStr("calculname", model);
                }
                model.setValue("calculname", (Object)calculname, rowIndex.intValue());
            }
        } else {
            model.setValue("calculdes", (Object)calculdes, rowIndex.intValue());
            model.setValue("calculname", (Object)calculname, rowIndex.intValue());
        }
        this.getView().updateView("overworkcalentry");
        List childInfoList = (List)returnData.get("CHILD_PARAM");
        DynamicObject entryDyn = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("overworkcalentry").get(rowIndex.intValue());
        if (!CollectionUtils.isEmpty((Collection)childInfoList)) {
            DynamicObjectCollection limitSubColl = entryDyn.getDynamicObjectCollection("overworkcaldetail");
            Set subEntryIdSet = childInfoList.stream().map(ChildInfo::getSubEntryId).collect(Collectors.toSet());
            subEntryIdSet.remove(0L);
            limitSubColl.removeIf(dynamicObject -> !subEntryIdSet.contains(dynamicObject.getLong("id")));
            for (ChildInfo childInfo : childInfoList) {
                DynamicObject limitSubDy = null;
                long subEntryId = childInfo.getSubEntryId();
                if (subEntryId == 0L) {
                    limitSubDy = limitSubColl.addNew();
                } else {
                    for (DynamicObject subEntryDy : limitSubColl) {
                        if (subEntryDy.getLong("id") != subEntryId) continue;
                        limitSubDy = subEntryDy;
                        break;
                    }
                }
                if (limitSubDy == null) {
                    LOG.warn("OverworkRuleEdit_updateEntryRow \u65e0\u6cd5\u5339\u914d\u5b50\u5206\u5f55id={}", (Object)subEntryId);
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u5b50\u5206\u5f55ID\u3002", (String)"OverWorkRuleEdit_13", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                }
                this.setProject(childInfo, limitSubDy);
            }
            limitSubColl.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    return o1.getInt("seq") - o2.getInt("seq");
                }
            });
        }
        this.getView().updateView("overworkcalentry");
        this.getView().updateView("overworkcaldetail");
    }

    private void setConditionLocalEmptyStr(String key, AbstractFormDataModel model) {
        Object localeValueObj = model.getValue(key);
        if (localeValueObj instanceof OrmLocaleValue) {
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)localeValueObj;
            String defaultItem = ormLocaleValue.getDefaultItem();
            HashSet removeKey = new HashSet(16);
            Set entries = ormLocaleValue.entrySet();
            for (Map.Entry entry : entries) {
                removeKey.add(entry.getKey());
            }
            for (String rk : removeKey) {
                ormLocaleValue.setItem(rk, " ");
            }
        }
    }

    private void setProject(ChildInfo childInfo, DynamicObject limitSubDy) {
        limitSubDy.set("otcompenmode_id", (Object)childInfo.getoTCompenMode());
        limitSubDy.set("originalprj_id", (Object)childInfo.getOriginalPrj());
        limitSubDy.set("originalconf", (Object)childInfo.getOriginalConf());
        limitSubDy.set("originalcalprj_id", (Object)childInfo.getOriginalCalPrj());
        limitSubDy.set("overtimesub_id", (Object)childInfo.getOverTimeSub());
        limitSubDy.set("subprj_id", (Object)childInfo.getSubPrj());
        limitSubDy.set("bfroundingrule_id", (Object)childInfo.getBfRoundingRule());
        limitSubDy.set("resultprj_id", (Object)childInfo.getResultPrj());
        limitSubDy.set("seq", (Object)(childInfo.getIndex() + 1));
    }

    private void openCalculRule(FormShowParameter formShowParameter, OperationStatus operationStatus) {
        if (formShowParameter == null) {
            formShowParameter = new FormShowParameter();
        }
        formShowParameter.setFormId("wtp_otcalculrule");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(operationStatus == null ? OperationStatus.ADDNEW : operationStatus);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btnok"));
        this.getView().showForm(formShowParameter);
    }

    private FormShowParameter getFormShowCustom(DynamicObject dynamicObject, Integer rowIndex) {
        FormShowParameter formShowParameter = new FormShowParameter();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        List<ChildInfo> childInfos = this.convertSubEntry(dynamicObject);
        map.put("CHILD_PARAM", JSON.toJSONString(childInfos));
        map.put("ottype", dynamicObject.get("ottype.id"));
        map.put("calculname", dynamicObject.get("calculname"));
        map.put("calculdes", dynamicObject.get("calculdes"));
        map.put("otbaseset", dynamicObject.get("otbaseset.id"));
        map.put("otsystem", dynamicObject.get("otsystem.id"));
        map.put("datasource", dynamicObject.get("datasource.id"));
        map.put("limitscope", dynamicObject.get("limitscope"));
        map.put("daterangecondition", dynamicObject.get("daterangecondition"));
        map.put("isempchoice", dynamicObject.get("isempchoice"));
        DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
        if (org != null) {
            map.put("createorg", org.getPkValue());
        }
        map.put("bsed", this.getModel().getValue("bsed"));
        formShowParameter.setCustomParam("singleInfo", map);
        formShowParameter.setCustomParam("rowIndex", (Object)rowIndex);
        if (rowIndex == null) {
            formShowParameter.setCustomParam("copy", (Object)Boolean.TRUE);
        }
        return formShowParameter;
    }

    private List<ChildInfo> convertSubEntry(DynamicObject entryDy) {
        DynamicObjectCollection subColl = entryDy.getDynamicObjectCollection("overworkcaldetail");
        if (subColl == null || subColl.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList childInfos = Lists.newArrayListWithExpectedSize((int)subColl.size());
        DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
        Date bsed = (Date)this.getModel().getValue("bsed");
        for (DynamicObject subDy : subColl) {
            ChildInfo childInfo = new ChildInfo();
            childInfo.setoTCompenMode(subDy.getLong("otcompenmode.id"));
            childInfo.setOriginalPrj(subDy.getLong("originalprj.id"));
            childInfo.setOriginalConf(subDy.getBigDecimal("originalconf"));
            childInfo.setOriginalCalPrj(subDy.getLong("originalcalprj.id"));
            childInfo.setOverTimeSub(subDy.getLong("overtimesub.id"));
            childInfo.setSubPrj(subDy.getLong("subprj.id"));
            childInfo.setBfRoundingRule(subDy.getLong("bfroundingrule.id"));
            childInfo.setResultPrj(subDy.getLong("resultprj.id"));
            childInfo.setCreateOrg(org.getLong("id"));
            childInfo.setBsed(bsed);
            childInfo.setSubEntryId(subDy.getLong("id"));
            childInfo.setIndex(subDy.getInt("seq"));
            childInfos.add(childInfo);
        }
        return childInfos;
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String name = args.getFieldName();
        if ("ottype".equals(name)) {
            int rowIndex = args.getRowIndex();
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("overworkcalentry").get(rowIndex);
            FormShowParameter formShowParameter = this.getFormShowCustom(dynamicObject, rowIndex);
            this.getRespectFormShowCustom(formShowParameter, dynamicObject);
            this.openCalculRule(formShowParameter, OperationStatus.VIEW);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Date startDate = this.getModel().getDataEntity().getDate("bsed");
        if (Objects.isNull(startDate)) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"OverWorkRuleEdit_11", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return;
        }
        OverworkRuleUtil.setFilter(propertySet, (IFormView)this.getView(), (BeforeF7SelectEvent)beforeF7SelectEvent);
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        beforeClosedEvent.setSkipNoField(true);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        List collectionProperties = properties.getCollectionProperties(false);
        for (ICollectionProperty collectionProperty : collectionProperties) {
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(collectionProperty.getName());
            DataEntityPropertyCollection treeEntryProperties = entryColl.getDynamicObjectType().getProperties();
            for (String propKey : this.SET_UN_CHANGE_FIELD) {
                IDataEntityProperty property = (IDataEntityProperty)treeEntryProperties.get((Object)propKey);
                if (property == null) continue;
                entryColl.forEach(entry -> entry.getDataEntityState().setBizChanged(property.getOrdinal(), false));
            }
        }
    }

    static {
        propertySet.add("otbaseset");
    }
}

