/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.privacy;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.privacy.rule.IPrivacyRule;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.lang.WTCBizException;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class WTCAnonymousService {
    private static final Log logger = LogFactory.getLog(WTCAnonymousService.class);

    public static WTCAnonymousService getInstance() {
        return WTCAnonymousServiceInstance.singleton;
    }

    private Map<String, List<DynamicObject>> getPrivacySaveConfig(String bizAppId, Map<Long, DynamicObject> anonymousRuleMap, String dataSubjectIdType) {
        HashMap entity2ConfigMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject[] colls = HRCSMServiceImpl.getInstance().getPrivacyRelation(bizAppId, dataSubjectIdType);
        if (colls == null || colls.length == 0) {
            logger.warn("\u9690\u79c1\u5bf9\u8c61\u6ca1\u6709\u914d\u7f6e");
            return entity2ConfigMap;
        }
        for (DynamicObject mainDy : colls) {
            DynamicObjectCollection entityentry = mainDy.getDynamicObjectCollection("entityentry");
            DynamicObject anonymousRule = mainDy.getDynamicObject("anonymousid");
            for (DynamicObject dynamicObject : entityentry) {
                String entity = dynamicObject.getDynamicObject("entity").getString("number");
                List configList = entity2ConfigMap.computeIfAbsent(entity, k -> new ArrayList(10));
                anonymousRuleMap.put((Long)dynamicObject.getPkValue(), anonymousRule);
                configList.add(dynamicObject);
            }
        }
        return entity2ConfigMap;
    }

    public void anonymize(List<Long> dataSubjectIds, String bizAppId, String dataSubjectIdType) {
        HashMap anonymousRuleMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, List<DynamicObject>> privacySaveConfig = this.getPrivacySaveConfig(bizAppId, anonymousRuleMap, dataSubjectIdType);
        HashSet errorSubjectIds = Sets.newHashSetWithExpectedSize((int)16);
        HashMap succeedMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, List<DynamicObject>> entry : privacySaveConfig.entrySet()) {
            List<DynamicObject> privacySaveConfigList = entry.getValue();
            if (CollectionUtils.isEmpty(privacySaveConfigList)) continue;
            String personFieldIdType = privacySaveConfigList.get(0).getString("personfieldtype");
            String personField = privacySaveConfigList.get(0).getString("personField");
            if ("wtp_attfilebase".equals(entry.getKey())) {
                personField = personField + ".id";
            } else if ("wtp_vafilebase".equals(entry.getKey())) {
                personField = personField + ".id";
            }
            DynamicObject[] data = this.getData(dataSubjectIds, entry, personField, personFieldIdType, dataSubjectIdType);
            DynamicObjectCollection dynamicObjects = this.doAnonymize(data, privacySaveConfigList, personField, anonymousRuleMap, errorSubjectIds);
            succeedMap.put(entry.getKey(), dynamicObjects);
        }
        this.updateData(succeedMap);
        this.completedCallback(bizAppId, dataSubjectIds, errorSubjectIds, dataSubjectIdType);
    }

    private void updateData(Map<String, DynamicObjectCollection> succeedMap) {
        try (TXHandle h = TX.required();){
            try {
                for (Map.Entry<String, DynamicObjectCollection> entry : succeedMap.entrySet()) {
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entry.getKey());
                    serviceHelper.save(entry.getValue());
                }
            }
            catch (Throwable throwable) {
                h.markRollback();
                logger.error("updateData error");
                throw new KDBizException(throwable, new ErrorCode("", throwable.getMessage()), new Object[0]);
            }
        }
    }

    private DynamicObjectCollection doAnonymize(DynamicObject[] data, List<DynamicObject> privacySaveConfigList, String personField, Map<Long, DynamicObject> anonymousRuleMap, Set<Long> errorSubjectIds) {
        DynamicObjectCollection succeedData = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : data) {
            long dataSubjectId = dynamicObject.getLong(personField);
            try {
                this.anonymizeColumn(dynamicObject, privacySaveConfigList, anonymousRuleMap);
                succeedData.add((Object)dynamicObject);
            }
            catch (Exception e) {
                errorSubjectIds.add(dataSubjectId);
                logger.warn("doAnonymize error,dataSubjectId={}", (Object)e, (Object)dataSubjectId);
            }
        }
        return succeedData;
    }

    private void anonymizeColumn(DynamicObject dynamicObject, List<DynamicObject> privacySaveConfigList, Map<Long, DynamicObject> anonymousRuleMap) {
        for (DynamicObject privacySaveConfig : privacySaveConfigList) {
            String privacyField = privacySaveConfig.getString("privacyField");
            dynamicObject.set(privacyField, this.handleValue(anonymousRuleMap, privacySaveConfig, dynamicObject));
        }
    }

    private Object handleValue(Map<Long, DynamicObject> anonymousRuleMap, DynamicObject privacySaveConfig, DynamicObject dynamicObject) {
        DynamicObject anonymousRule = anonymousRuleMap.get(privacySaveConfig.getPkValue());
        IPrivacyRule handler = this.getHandler(anonymousRule);
        if (handler == null) {
            logger.warn("handler is null");
            throw new WTCBizException("handler is null");
        }
        return handler.getPrivacyRuleResult(anonymousRule.getString("params"), (Object)dynamicObject);
    }

    private IPrivacyRule getHandler(DynamicObject anonymousRule) {
        String handleClass = anonymousRule.getString("handleclass");
        return (IPrivacyRule)TypesContainer.createInstance((String)handleClass);
    }

    private DynamicObject[] getData(List<Long> dataSubjectIds, Map.Entry<String, List<DynamicObject>> entry, String personField, String personFieldIdType, String dataSubjectIdType) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entry.getKey());
        QFilter[] qFilterArr = new QFilter[]{new QFilter(personField, "in", this.idTransformation(dataSubjectIds, dataSubjectIdType, personFieldIdType))};
        Set columnSet = entry.getValue().stream().map(e -> e.getString("privacyfield")).collect(Collectors.toSet());
        StringBuilder selectFields = new StringBuilder(personField);
        for (String column : columnSet) {
            selectFields.append(',').append(column);
        }
        return serviceHelper.query(selectFields.toString(), qFilterArr);
    }

    private List<Long> idTransformation(List<Long> dataSubjectIds, String dataSubjectIdType, String personFieldIdType) {
        return dataSubjectIds;
    }

    private void completedCallback(String bizAppId, List<Long> dataSubjectIds, Set<Long> errorSubjectIds, String dataSubjectIdType) {
        List<Long> succeedSubjectIds = dataSubjectIds;
        if (!errorSubjectIds.isEmpty()) {
            succeedSubjectIds = dataSubjectIds.stream().filter(e -> !errorSubjectIds.contains(e)).collect(Collectors.toList());
            logger.warn("\u533f\u540d\u5316\u5931\u8d25\u7684\u4e3b\u4f53id={}", (Object)errorSubjectIds.toString());
        }
        Object[] result = null;
        try {
            result = HRCSMServiceImpl.getInstance().setExecStatueCompletedBatch(bizAppId, dataSubjectIdType, succeedSubjectIds.stream().map(String::valueOf).collect(Collectors.toList()), new Date());
        }
        catch (RuntimeException e2) {
            logger.warn("completedCallback error,dataSubjectIds = {}", dataSubjectIds, (Object)e2);
        }
        if (result == null || result.length == 0) {
            logger.error("completedCallback failed!");
        } else if (result.length != dataSubjectIds.size()) {
            logger.error("setExecStatueCompleted partial success");
        }
    }

    private static class WTCAnonymousServiceInstance {
        private static final WTCAnonymousService singleton = new WTCAnonymousService();

        private WTCAnonymousServiceInstance() {
        }
    }
}

