/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.enums.quota.QTTypleUnitEnum;
import kd.wtc.wtp.formplugin.web.quota.QTRuleConstants;

public class QTCalRulePlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Map<String, String> QT_RULE_ENTRY_COLUMN_NAME_MAP = Maps.newHashMap();

    public void registerListener(EventObject object) {
        super.registerListener(object);
        QTRuleConstants.QT_RULE_ENTRY.forEach(item -> ((BasedataEdit)this.getControl((String)item)).addBeforeF7SelectListener((BeforeF7SelectListener)this));
        QTRuleConstants.QT_RULE_ENTRY.forEach(item -> ((BasedataEdit)this.getControl((String)item)).addAfterF7SelectListener((AfterF7SelectListener)this));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Long value;
        Object object;
        String fieldKey = evt.getProperty().getName();
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && !QTRuleConstants.F7_CUSTOM_QFILTER_EXCLUDE.contains(fieldKey)) {
            Date bsed = parentView.getModel().getDataEntity().getDate("bsed");
            QFilter filter = new QFilter("firstbsed", "<=", (Object)bsed);
            evt.addCustomQFilter(filter);
        }
        if ((object = this.getModel().getValue(fieldKey)) != null && (value = Long.valueOf(((DynamicObject)object).getLong("id"))) != null) {
            evt.addCustomQFilter(new QFilter("id", "!=", (Object)value));
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
    }

    public void beforeBindData(EventObject event) {
        Object createOrg;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = (Map)formShowParameter.getCustomParam("entryRow");
        String operation = (String)formShowParameter.getCustomParam("operation");
        if (HRStringUtils.equals((String)operation, (String)"editrow") || HRStringUtils.equals((String)operation, (String)"viewrow") || HRStringUtils.equals((String)operation, (String)"copyrow")) {
            QTRuleConstants.QT_RULE_ENTRY.forEach(sign -> this.getModel().setValue(sign, map.get(sign)));
            this.getModel().setValue("ruledesc", map.get("ruledesc"));
        }
        if ((createOrg = map.get("createorg")) == null) {
            this.getModel().setValue("createorg", (Object)RequestContext.get().getOrgId());
        } else {
            this.getModel().setValue("createorg", createOrg);
        }
        if (HRStringUtils.equals((String)operation, (String)"copyrow")) {
            this.getModel().setValue("qttype", null);
            this.getModel().setValue("qtgenconfig", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject genConfig = this.getModel().getDataEntity().getDynamicObject("qtgenconfig");
            DynamicObject carryDwon = this.getModel().getDataEntity().getDynamicObject("qtcarrydown");
            DynamicObject useConfig = this.getModel().getDataEntity().getDynamicObject("qtuseconfig");
            if (genConfig == null || carryDwon == null || useConfig == null) {
                args.setCancel(true);
                return;
            }
            if (this.checkAttItemUnit(this.getModel().getDataEntity(), this.getView())) {
                args.setCancel(true);
            }
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        AbstractOperate op;
        String operateKey;
        if (evt.getSource() instanceof AbstractOperate && "save".equals(operateKey = (op = (AbstractOperate)evt.getSource()).getOperateKey())) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            QTRuleConstants.QT_RULE_ENTRY.forEach(sign -> returnData.put((String)sign, model.getValue(sign)));
            returnData.put("ruledesc", model.getValue("ruledesc"));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            returnData.put("rowIndex", formShowParameter.getCustomParam("rowIndex"));
            this.getView().returnDataToParent(returnData);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        Object newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).map(ChangeData::getNewValue).orElse(null);
        if (newValue == null) {
            return;
        }
        if ("qtgenconfig".equals(propertyName)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_qtgenconfig");
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", ((DynamicObject)newValue).get("id"))};
            DynamicObject dynamicObject = helper.queryOne("qttype", qFilters);
            DynamicObject qtType = dynamicObject.getDynamicObject("qttype");
            this.getModel().setValue("qttype", (Object)qtType);
            if ("B".equals(qtType.getString("gentype"))) {
                this.getModel().setValue("inconvert", null);
                this.getModel().setValue("toconvert", null);
            }
        } else if ("qttype".equals(propertyName) && this.getTypeSet().contains(((DynamicObject)newValue).getLong("id"))) {
            this.getModel().setValue("qtgenconfig", null);
            this.getModel().setValue("qttype", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u5b9a\u989d\u7c7b\u578b\u7684\u89c4\u5219\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"QTCalRulePlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        }
    }

    private Set<Long> getTypeSet() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return Collections.emptySet();
        }
        DynamicObjectCollection entryEntity = parentView.getModel().getEntryEntity("entryentity");
        Integer rowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("rowIndex");
        Set<Long> seq = rowIndex != null ? entryEntity.stream().filter(e -> e.getInt("seq") - 1 != rowIndex).map(e -> e.getLong("qttype.id")).collect(Collectors.toSet()) : entryEntity.stream().map(e -> e.getLong("qttype.id")).collect(Collectors.toSet());
        return seq;
    }

    private boolean checkAttItemUnit(DynamicObject dataEntity, IFormView view) {
        DynamicObject[] attItems;
        HashSet itemIds = Sets.newHashSetWithExpectedSize((int)16);
        HashMap pageIds = Maps.newHashMapWithExpectedSize((int)16);
        pageIds.put("qtuseconfig", QTRuleConstants.QT_USE_CONFIG_ITEM_FILE);
        pageIds.put("qtoverdraw", QTRuleConstants.QT_OVERDRAW_ITEM_FILE);
        pageIds.put("qtcarrydown", QTRuleConstants.QT_CARRY_DOWN_ITEM_FILE);
        pageIds.put("toconvert", QTRuleConstants.TO_CONVERT_ITEM_FILE);
        DynamicObject qtType = dataEntity.getDynamicObject("qttype");
        HashMap itemName = new HashMap();
        for (Map.Entry entry : pageIds.entrySet()) {
            String fileKey = (String)entry.getKey();
            for (String attItemFile : (List)entry.getValue()) {
                long attItemId = dataEntity.getLong(fileKey + "." + attItemFile + "." + "id");
                String attItemName = dataEntity.getString(fileKey + "." + attItemFile + "." + "name");
                if (0L == attItemId) continue;
                itemIds.add(attItemId);
                HashMap<String, String> map = itemName.get(attItemId) == null ? new HashMap<String, String>() : (Map)itemName.get(attItemId);
                map.put(fileKey, attItemName);
                itemName.put(attItemId, map);
            }
        }
        DynamicObject genConfig = dataEntity.getDynamicObject("qtgenconfig");
        DynamicObjectCollection genConfigEntry = genConfig.getDynamicObjectCollection("entryentity");
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject dynamicObject : genConfigEntry) {
            for (String attItemFile : QTRuleConstants.QT_GEN_CONFIG_ITEM_FILE) {
                long attItemId = dynamicObject.getLong(attItemFile + "." + "id");
                String attItemName = dynamicObject.getString(attItemFile + "." + "name");
                if (0L == attItemId) continue;
                itemIds.add(attItemId);
                map.put("qtgenconfig", attItemName);
                itemName.put(attItemId, map);
            }
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_attitem");
        for (DynamicObject attItem : attItems = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)itemIds)})) {
            Map nameMap;
            String qtTypleUnit = qtType.getString("unit");
            QTTypleUnitEnum qtTypleUnitEnum = QTTypleUnitEnum.getEnumByCode((String)qtTypleUnit);
            String ItemTypleUnit = attItem.getString("unit");
            if (qtTypleUnitEnum == null || qtTypleUnitEnum.getItemCode().equals(ItemTypleUnit) || (nameMap = (Map)itemName.get(attItem.getLong("id"))) == null) continue;
            for (Map.Entry entry : nameMap.entrySet()) {
                String configName = QT_RULE_ENTRY_COLUMN_NAME_MAP.get(entry.getKey());
                String itemNameTemp = (String)entry.getValue();
                String qtTypleName = qtType.getString("name");
                view.showErrorNotification(ResManager.loadKDString((String)"{0}\u201c{1}\u201d\u9879\u76ee\u7684\u5355\u4f4d\u548c\u201c{2}\u201d\u5b9a\u989d\u7c7b\u578b\u7684\u5355\u4f4d\u201c{3}\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u7edf\u4e00\u540e\u518d\u4fdd\u5b58\u3002", (String)"QTCalRulePlugin_7", (String)"wtc-wtp-formplugin", (Object[])new Object[]{configName, itemNameTemp, qtTypleName, qtTypleUnitEnum.getDesc()}));
            }
            return true;
        }
        return false;
    }

    static {
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("qtgenconfig", ResManager.loadKDString((String)"\u751f\u6210\u914d\u7f6e", (String)"QTCalRulePlugin_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("qtuseconfig", ResManager.loadKDString((String)"\u4f7f\u7528\u914d\u7f6e", (String)"QTCalRulePlugin_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("qtoverdraw", ResManager.loadKDString((String)"\u900f\u652f\u914d\u7f6e", (String)"QTCalRulePlugin_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("qtcarrydown", ResManager.loadKDString((String)"\u7ed3\u8f6c\u914d\u7f6e", (String)"QTCalRulePlugin_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("toconvert", ResManager.loadKDString((String)"\u79bb\u804c\u6298\u7b97", (String)"QTCalRulePlugin_6", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
    }
}

