/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.util.WTCOrgUtils;
import kd.wtc.wtbs.business.web.file.AttFileBusiness;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.DateRange;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailDBService;
import kd.wtc.wtp.business.quota.QTLineDetailNumHelper;

public class QTLineDetailListPlugin
extends HRDataBaseList {
    private static final Map<String, String> FORMID_MAP = Maps.newHashMapWithExpectedSize((int)10);
    private static final String DISCARD_OP = "discard";
    private static final String QTENABLE_OP = "qtenable";
    private static final String AFTER_CONFIRM = "afterconfirm";
    private static final String DATE_FORMAT_YYYY = "yyyy";
    private static final String SELECTED_YEAR = "selectYear";
    private FilterContainerInitArgs initArgs;

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        super.setEnableCustomSum(args);
        args.setEnableCustomSum(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        String operateKey = ((FormOperate)source).getOperateKey();
        ListSelectedRowCollection selectedIds = this.getSelectedRows();
        if (DISCARD_OP.equals(operateKey)) {
            if (selectedIds.size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"QTLineDetailListPlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dy = QTLineDetailDBService.lineDetailDao.queryOne(selectedIds.get(0).getPrimaryKeyValue());
            BigDecimal usedValue = dy.getBigDecimal("usedvalue");
            BigDecimal freezeValue = dy.getBigDecimal("freezevalue");
            BigDecimal useOdValue = dy.getBigDecimal("useodvalue");
            if (BigDecimal.ZERO.compareTo(usedValue) != 0 || BigDecimal.ZERO.compareTo(freezeValue) != 0 || BigDecimal.ZERO.compareTo(useOdValue) != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u660e\u7ec6\u5df2\u88ab\u6d88\u8d39\uff0c\u65e0\u6cd5\u53d8\u66f4\u72b6\u6001\u3002", (String)"QTLineDetailListPlugin_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String status = dy.getString("busstatus");
            if (!"0".equals(status)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5e9f\u5f03\u201c\u751f\u6548\u201d\u7684\u5b9a\u989d\u660e\u7ec6\u6570\u636e\u3002", (String)"QTLineDetailListPlugin_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                return;
            }
            this.discardConfirm(args);
        } else if (QTENABLE_OP.equals(operateKey)) {
            if (selectedIds.size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"QTLineDetailListPlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dy = QTLineDetailDBService.lineDetailDao.queryOne(selectedIds.get(0).getPrimaryKeyValue());
            String status = dy.getString("busstatus");
            if (!"1".equals(status)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u542f\u7528\u201c\u5931\u6548\u201d\u7684\u5b9a\u989d\u660e\u7ec6\u6570\u636e\u3002", (String)"QTLineDetailListPlugin_6", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void discardConfirm(BeforeDoOperationEventArgs args) {
        RefObject afterConfirm = new RefObject();
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOption().tryGetVariableValue(AFTER_CONFIRM, afterConfirm)) {
            return;
        }
        args.setCancel(true);
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(DISCARD_OP, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5e9f\u5f03\u6570\u636e\u540e\uff0c\u72b6\u6001\u5c06\u53d8\u66f4\u4e3a\u65e0\u6548\u3002\u65e0\u6548\u6570\u636e\u5c06\u4e0d\u518d\u4f7f\u7528\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"QTLineDetailListPlugin_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        int result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (DISCARD_OP.equals(callBackId) && (result = event.getResult().getValue()) == MessageBoxResult.Yes.getValue()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(AFTER_CONFIRM, "true");
            this.getView().invokeOperation(DISCARD_OP, operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        List selectedMainOrgIds = this.getSelectedMainOrgIds();
        Long orgId = 0L;
        if (!selectedMainOrgIds.isEmpty()) {
            orgId = (Long)selectedMainOrgIds.get(0);
        }
        if ("qtadd".equals(operateKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("wtte_qtadd");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setCustomParam("org", (Object)orgId);
            this.getView().showForm(formShowParameter);
        }
        if (DISCARD_OP.equals(operateKey) || QTENABLE_OP.equals(operateKey)) {
            ListView listView = (ListView)this.getView();
            BillList billListAp = (BillList)listView.getControl("billlistap");
            String successMsg = DISCARD_OP.equals(operateKey) ? ResManager.loadKDString((String)"\u6240\u9009\u660e\u7ec6\u6570\u636e\u5df2\u5e9f\u5f03\u3002", (String)"QTLineDetailListPlugin_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6240\u9009\u660e\u7ec6\u6570\u636e\u5df2\u751f\u6548\u3002", (String)"QTLineDetailListPlugin_7", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(successMsg);
            billListAp.refresh();
            billListAp.clearSelection();
            billListAp.getSelectedRows().clear();
            listView.sendFormAction((IFormView)listView);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List list = args.getListColumns();
        for (IListColumn next : list) {
            String listFieldKey;
            if (next == null || !"attfileid.name".equals(listFieldKey = next.getListFieldKey()) && !"attfileid.attperson.number".equals(listFieldKey)) continue;
            next.setFixed(true);
        }
        args.setListColumns(list);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        BillListHyperLinkClickEvent billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        if (billListHyperLinkClickEvent == null || billListHyperLinkClickEvent.getCurrentRow() == null || billListHyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"QTLineDetailListPlugin_10", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return;
        }
        Object primaryKeyValue = billListHyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue();
        DynamicObject dynamicObject = QTLineDetailDBService.lineDetailDao.queryOne(primaryKeyValue);
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"QTLineDetailListPlugin_10", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.equals((CharSequence)"attfileid_name", (CharSequence)fieldName)) {
            long attfileid = dynamicObject.getLong("attfileid.id");
            args.setCancel(true);
            this.genShowAttFilePage((IFormPlugin)this, attfileid, this.getView());
        } else {
            args.setCancel(true);
            this.viewQTDetail(dynamicObject, fieldName);
        }
    }

    private void viewQTDetail(DynamicObject rowData, String fieldName) {
        FormConfig formConfig;
        long invalidValueId;
        ArrayList detailIds = Lists.newArrayListWithExpectedSize((int)1);
        HashMap lineToDetailMap = Maps.newHashMapWithExpectedSize((int)1);
        long id = rowData.getLong(fieldName + "id.id");
        if (0L == id) {
            id = Long.MIN_VALUE;
        }
        detailIds.add(id);
        lineToDetailMap.put(rowData.getLong("id"), id);
        BigDecimal fieldValue = rowData.getBigDecimal(fieldName);
        if ("pastvalue".equals(fieldName)) {
            invalidValueId = rowData.getLong("invalidvalueId.id");
            detailIds.add(invalidValueId);
            fieldValue = fieldValue.add(rowData.getBigDecimal("invalidvalue"));
        }
        if ("cdedvalue".equals(fieldName)) {
            invalidValueId = rowData.getLong("slementvalueid.id");
            detailIds.add(invalidValueId);
            fieldValue = fieldValue.add(rowData.getBigDecimal("settlementvalue"));
        }
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        int compare = fieldValue.compareTo(new BigDecimal(0));
        if (compare == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97\u672a\u751f\u6210\u6b64\u6570\u636e\uff0c\u65e0\u6cd5\u8df3\u8f6c\u3002", (String)"QTLineDetailListPlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return;
        }
        params.put("detailIds", detailIds);
        params.put("fieldName", fieldName);
        params.put("lineToDetailMap", lineToDetailMap);
        Date date = rowData.getDate("genstartdate");
        params.put("year", date);
        params.put("querytype", "1");
        FormShowParameter formShowParameter = new FormShowParameter();
        String formId = this.getFormId(fieldName);
        formShowParameter.setFormId(formId);
        if (HRStringUtils.isNotEmpty((String)formId) && (formConfig = FormMetadataCache.getFormConfig((String)formId)) != null) {
            formShowParameter.setCaption(formConfig.getCaption().getLocaleValue() + "-" + rowData.getString("attfilebo.name"));
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCustomParams((Map)params);
        formShowParameter.setPageId(this.getView().getPageId() + rowData.getPkValue() + fieldName);
        formShowParameter.setAppId("wtte");
        this.getView().showForm(formShowParameter);
    }

    private String getFormId(String fieldName) {
        return FORMID_MAP.get(fieldName);
    }

    private void genShowAttFilePage(IFormPlugin formplugin, long attFileVid, IFormView view) {
        List dynamicObjects = AttFileQueryServiceImpl.getInstance().queryAttFileByIds(AttFileQueryParam.usuallyProperties, Collections.singletonList(attFileVid));
        if (WTCCollections.isNotEmpty((Collection)dynamicObjects)) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            if (dynamicObject == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6c47\u603b\u8bb0\u5f55\u4eba\u5458\u7684\u5386\u53f2\u6863\u6848\u3002", (String)"AttRecordService_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            } else {
                Long attFileId = dynamicObject.getLong("id");
                AttFileBusiness.showAttFileDetailForm((IFormView)view, (IFormPlugin)formplugin, null, (Object)attFileId);
            }
        }
    }

    public void setFilter(SetFilterEvent event) {
        List qFilters = event.getQFilters();
        List filters = event.getQFilters();
        Iterator it = filters.iterator();
        QFilter qfilter = null;
        boolean init = false;
        while (it.hasNext()) {
            QFilter filter = (QFilter)it.next();
            if (filter == null || !filter.getProperty().equals("usedate")) continue;
            it.remove();
            Date startDate = (Date)filter.getValue();
            Date endDate = WTCCollectionIndexUtil.getEleFromList((List)filter.getNests(true), (int)0).map(QFilter.QFilterNest::getFilter).map(QFilter::getValue).orElse(null);
            if (startDate == null || endDate == null) continue;
            init = true;
            endDate = WTCDateUtils.addDays((Date)endDate, (int)-1);
            qfilter = DateRange.range((Date)startDate, (Date)endDate).getFilterIntersectionLCRC("usestartdate", "useenddate");
        }
        if (init) {
            event.getQFilters().add(qfilter);
        }
        qFilters.add(new QFilter("source", "!=", (Object)"DT-006"));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter")) {
            List customfilter = (List)args.getSearchClickEvent().getFilterValues().get("customfilter");
            for (Map filterItem : customfilter) {
                if (CollectionUtils.isEmpty((Collection)((Collection)filterItem.get("FieldName")))) continue;
                String fieldName = ((List)filterItem.get("FieldName")).get(0).toString();
                List item = (List)filterItem.get("Value");
                if (!fieldName.startsWith("org")) continue;
                if (!item.isEmpty() && !"".equals(item.get(0))) {
                    String fieldValue = item.get(0).toString();
                    this.getPageCache().put(fieldName, fieldValue);
                    continue;
                }
                this.getPageCache().remove(fieldName);
            }
            this.filterContainerInit(this.initArgs);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        String selectedYear = (String)this.getView().getFormShowParameter().getCustomParam(SELECTED_YEAR);
        Date defaultDate = StringUtils.isEmpty((CharSequence)selectedYear) ? new Date() : WTCDateUtils.str2Date((String)selectedYear, (String)DATE_FORMAT_YYYY);
        Date startDate = WTCDateUtils.getBeginDayOfYear((Date)defaultDate);
        Date endDate = WTCDateUtils.getEndDayOfYear((Date)defaultDate);
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            if ("usedate".equals(fieldName)) {
                filterColumn.setDefaultValues(new Object[]{WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd"), WTCDateUtils.date2Str((Date)endDate, (String)"yyyy-MM-dd")});
            }
            if (!fieldName.startsWith("org")) continue;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            if (this.getPageCache().get("org.id") != null) {
                commonFilterColumn.setDefaultValue(String.valueOf(this.getPageCache().get("org.id")));
                continue;
            }
            ListView view = (ListView)this.getView();
            long defaultOrgId = WTCOrgUtils.getDefaultOrgIdOfList((ListView)view);
            if (defaultOrgId == 0L) continue;
            commonFilterColumn.setDefaultValue(String.valueOf(defaultOrgId));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                DynamicSimpleProperty number = new DynamicSimpleProperty("number", String.class, null);
                Set collect = rows.stream().map(ele -> ele.getLong("id")).collect(Collectors.toSet());
                DynamicObject[] query = QTLineDetailDBService.lineDetailDao.query("id,invalidvalue,settlementvalue", new QFilter("id", "in", collect).toArray());
                HashMap<Long, BigDecimal> tmp = new HashMap<Long, BigDecimal>(query.length);
                HashMap<Long, BigDecimal> cdTmp = new HashMap<Long, BigDecimal>(query.length);
                for (DynamicObject line : query) {
                    tmp.put(line.getLong("id"), line.getBigDecimal("invalidvalue"));
                    cdTmp.put(line.getLong("id"), line.getBigDecimal("settlementvalue"));
                }
                rows.getDynamicObjectType().registerSimpleProperty(number);
                for (DynamicObject row : rows) {
                    long id = row.getLong("id");
                    String num = QTLineDetailNumHelper.convertNum((Long)id);
                    row.set("number", (Object)num);
                    BigDecimal invalidValue = tmp.getOrDefault(id, BigDecimal.ZERO);
                    BigDecimal pastValue = row.getBigDecimal("pastvalue");
                    row.set("pastvalue", (Object)invalidValue.add(pastValue));
                    BigDecimal settlementValue = cdTmp.getOrDefault(id, BigDecimal.ZERO);
                    BigDecimal cdValue = row.getBigDecimal("cdedvalue");
                    row.set("cdedvalue", (Object)cdValue.add(settlementValue));
                }
                return rows;
            }
        });
    }

    static {
        FORMID_MAP.put("usablevalue", "wtte_usabledetail");
        FORMID_MAP.put("freezevalue", "wtte_freezedetail");
        FORMID_MAP.put("usedvalue", "wtte_useddetail");
        FORMID_MAP.put("useodvalue", "wtte_useoddetail");
        FORMID_MAP.put("pastvalue", "wtte_pastdetail");
        FORMID_MAP.put("cdedvalue", "wtte_cdeddetail");
        FORMID_MAP.put("ownvalue", "wtte_owndetail");
    }
}

