/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.formplugin.web.quota.QTRuleConstants;

public class QTRuleEdit
extends HRDataBaseEdit
implements HyperLinkClickListener {
    private static final String WTP_QTCALRULE = "wtp_qtcalrule";
    private static final String DOT_ID = ".id";
    private static final Map<String, String> QT_RULE_ENTRY_COLUMN_NAME_MAP = Maps.newHashMap();

    public void registerListener(EventObject object) {
        super.registerListener(object);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        super.addClickListeners(new String[]{"bar_save", "bar_submit", "bar_saveandnew"});
        super.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey) || "bar_submit".equals(itemKey) || "confirmchange".equals(itemKey) || "bar_saveandnew".equals(itemKey)) {
            DynamicObjectCollection entity = this.getView().getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)entity)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u884c\u6570\u636e\u5230\u8ba1\u7b97\u89c4\u5219\u4e2d\u3002", (String)"QTRuleEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (this.checkPrjValite()) {
                evt.setCancel(true);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object hisAction = customParams.get("his_action");
        if ("open_insert_new_data_page".equals(hisAction)) {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "copyrow": 
            case "editrow": 
            case "addrow": {
                this.checkEffDate(args);
                break;
            }
            case "save": 
            case "submit": 
            case "confirmchange": 
            case "submitandaudit": {
                DynamicObjectCollection entity = this.getView().getModel().getEntryEntity("entryentity");
                if (CollectionUtils.isEmpty((Collection)entity)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u884c\u6570\u636e\u5230\u8ba1\u7b97\u89c4\u5219\u4e2d\u3002", (String)"QTRuleEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (!this.checkPrjValite()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private void checkEffDate(BeforeDoOperationEventArgs args) {
        if (this.getModel().getValue("bsed") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"QTRuleEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if ("copyrow".equals(operateKey) || "editrow".equals(operateKey)) {
            if (ObjectUtils.isEmpty((Object)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QTRuleEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (selectedRows.length > 1 && "copyrow".equals(operateKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"QTRuleEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operation = evt.getOperateKey();
        if ("copyrow".equals(operation) || "addrow".equals(operation) || "editrow".equals(operation)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
            if (("copyrow".equals(operation) || "editrow".equals(operation)) && ObjectUtils.isEmpty((Object)selectedRows)) {
                return;
            }
            switch (operation) {
                case "copyrow": {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectedRows[0]);
                    FormShowParameter formShowParameter = this.getFormShowCustom(dynamicObject, null, operation);
                    this.openCalculRule(formShowParameter, null);
                    break;
                }
                case "addrow": {
                    this.openCalculRule(this.getFormShowCustom(null, null, operation), null);
                    break;
                }
                case "editrow": {
                    int rowIndex = entryGrid.getEntryState().getFocusRow();
                    DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
                    FormShowParameter formShowParameter = this.getFormShowCustom(dynamicObject, rowIndex, operation);
                    this.openCalculRule(formShowParameter, OperationStatus.EDIT);
                    break;
                }
            }
        }
    }

    private boolean checkPrjValite() {
        return StringUtils.isNotBlank((CharSequence)this.getErrMsg());
    }

    private String getErrMsg() {
        Date firstDate = (Date)this.getModel().getValue("bsed");
        if (firstDate == null) {
            return null;
        }
        StringBuilder errMsg = new StringBuilder();
        String separater = ResManager.loadKDString((String)"\u3001", (String)"OverWorkRuleEdit_9", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        Map<String, HRBaseServiceHelper> helperMap = this.getHelper();
        for (DynamicObject entryrow : entity) {
            for (String sign : QTRuleConstants.QT_RULE_ENTRY_HIS) {
                Date firstBsed;
                HRBaseServiceHelper serviceHelper = helperMap.get(sign);
                DynamicObject dynamicObject = serviceHelper.queryOne("firstbsed,name", new QFilter[]{new QFilter("id", "=", entryrow.get(sign + "." + "id"))});
                if (dynamicObject == null || (firstBsed = dynamicObject.getDate("firstbsed")) == null || !firstBsed.after(firstDate)) continue;
                errMsg.append(QT_RULE_ENTRY_COLUMN_NAME_MAP.get(sign));
                errMsg.append(dynamicObject.getString("name")).append(separater);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            errMsg.replace(errMsg.lastIndexOf(separater), errMsg.length(), "");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8c03\u6574\u201c\u5b9a\u989d\u89c4\u5219\u201d\u4e0b\u7684\u201c\u8ba1\u7b97\u89c4\u5219\u201d\u4e2d{0}\u7684\u751f\u6548\u65e5\u671f\uff0c\u4f7f\u5176\u65e9\u4e8e\u5f53\u524d\u521b\u5efa\u7684\u201c\u5b9a\u989d\u89c4\u5219\u201d\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"QTRuleEdit_18", (String)"wtc-wtp-formplugin", (Object[])new Object[]{errMsg.toString()}));
        }
        return errMsg.toString();
    }

    private Map<String, HRBaseServiceHelper> getHelper() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)QTRuleConstants.QT_RULE_ENTRY_HIS.size());
        HRBaseServiceHelper qcServiceHelper = new HRBaseServiceHelper("wtp_qtqualification");
        map.put("qtgenconfig", new HRBaseServiceHelper("wtp_qtgenconfig"));
        map.put("genqc", qcServiceHelper);
        map.put("qtuseconfig", new HRBaseServiceHelper("wtp_qtuseconfig"));
        map.put("useqc", qcServiceHelper);
        map.put("qtoverdraw", new HRBaseServiceHelper("wtp_qtoverdraw"));
        map.put("overqc", qcServiceHelper);
        map.put("qtcarrydown", new HRBaseServiceHelper("wtp_qtcarrydown"));
        map.put("carryqc", qcServiceHelper);
        return map;
    }

    private void openCalculRule(FormShowParameter formShowParameter, OperationStatus operationStatus) {
        if (formShowParameter == null) {
            formShowParameter = new FormShowParameter();
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219", (String)"QTRuleEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        formShowParameter.setFormId(WTP_QTCALRULE);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(operationStatus == null ? OperationStatus.ADDNEW : operationStatus);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btnok"));
        this.getView().showForm(formShowParameter);
    }

    private FormShowParameter getFormShowCustom(DynamicObject dynamicObject, Integer rowIndex, String operation) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("datastatus", this.getModel().getValue("datastatus"));
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
        map.put("bsed", this.getModel().getValue("bsed"));
        formShowParameter.setCustomParam("entryRow", map);
        formShowParameter.setCustomParam("status", this.getModel().getValue("status"));
        formShowParameter.setCustomParam("operation", (Object)operation);
        if (org != null) {
            map.put("createorg", org.getPkValue());
        }
        if (dynamicObject == null) {
            return formShowParameter;
        }
        QTRuleConstants.QT_RULE_ENTRY.forEach(sign -> map.put((String)sign, dynamicObject.get(sign + DOT_ID)));
        map.put("ruledesc", dynamicObject.get("ruledesc"));
        formShowParameter.setCustomParam("rowIndex", (Object)rowIndex);
        return formShowParameter;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.getView().setEnable(Boolean.FALSE, new String[]{"createorg"});
        String actionId = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("btnok".equals(actionId)) {
            Integer rowIndex = (Integer)returnData.get("rowIndex");
            if (rowIndex != null) {
                this.updateEntryRow(returnData, rowIndex);
            } else {
                this.addEntryRow(returnData);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String name = args.getFieldName();
        if ("qttype".equals(name)) {
            int rowIndex = args.getRowIndex();
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
            FormShowParameter formShowParameter = this.getFormShowCustom(dynamicObject, rowIndex, "viewrow");
            this.openCalculRule(formShowParameter, OperationStatus.VIEW);
        }
    }

    private void addEntryRow(Map<String, Object> returnData) {
        int rowIndex = this.getModel().createNewEntryRow("entryentity");
        this.updateEntryRow(returnData, rowIndex);
    }

    private void updateEntryRow(Map<String, Object> returnData, Integer rowIndex) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        QTRuleConstants.QT_RULE_ENTRY.forEach(sign -> model.setValue(sign, returnData.get(sign), rowIndex.intValue()));
        model.setValue("ruledesc", returnData.get("ruledesc"), rowIndex.intValue());
    }

    static {
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("qtgenconfig", ResManager.loadKDString((String)"\u201c\u751f\u6210\u914d\u7f6e\u201d\uff1a", (String)"QTRuleEdit_10", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("genqc", ResManager.loadKDString((String)"\u201c\u751f\u6210\u9650\u5b9a\u201d\uff1a", (String)"QTRuleEdit_11", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("qtuseconfig", ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u914d\u7f6e\u201d\uff1a", (String)"QTRuleEdit_12", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("useqc", ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u9650\u5b9a\u201d\uff1a", (String)"QTRuleEdit_13", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("qtoverdraw", ResManager.loadKDString((String)"\u201c\u900f\u652f\u914d\u7f6e\u201d\uff1a", (String)"QTRuleEdit_14", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("overqc", ResManager.loadKDString((String)"\u201c\u900f\u652f\u9650\u5b9a\u201d\uff1a", (String)"QTRuleEdit_15", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("qtcarrydown", ResManager.loadKDString((String)"\u201c\u7ed3\u8f6c\u914d\u7f6e\u201d\uff1a", (String)"QTRuleEdit_16", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        QT_RULE_ENTRY_COLUMN_NAME_MAP.put("carryqc", ResManager.loadKDString((String)"\u201c\u7ed3\u8f6c\u9650\u5b9a\u201d\uff1a", (String)"QTRuleEdit_17", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
    }
}

