/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.constants.quota.QuotaConstants;
import kd.wtc.wtp.constants.quota.QuotaKDString;

public class QuotaDeducRuleEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
QuotaConstants {
    HRBaseServiceHelper qttypeHelper = new HRBaseServiceHelper("wtp_qttype");

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        String operateKey = ((FormOperate)source).getOperateKey();
        if (source instanceof SaveAndNew) {
            SaveAndNew opSource = (SaveAndNew)source;
            operateKey = opSource.getOriOperateKey();
        }
        switch (operateKey) {
            case "save": 
            case "saveandnew": 
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                if (args.isCancel()) break;
                if (!this.isLegalQTTypeEntries()) {
                    args.setCancel(true);
                    return;
                }
                if (!this.isExistQTTypeEntries()) {
                    args.setCancel(true);
                    return;
                }
                if (this.isLegalOrderEntries()) break;
                args.setCancel(true);
                return;
            }
        }
    }

    private boolean isLegalOrderEntries() {
        DynamicObjectCollection orderEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("orderentity");
        List selectedSortField = orderEntries.stream().filter(Objects::nonNull).map(row -> row.getString("sortfield")).filter(WTCStringUtils::isNotEmpty).collect(Collectors.toList());
        if (selectedSortField.size() == new HashSet(selectedSortField).size()) {
            return true;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u6392\u5e8f\u5b57\u6bb5\u9700\u4fdd\u6301\u552f\u4e00\u3002", (String)"QuotaDeducRuleEdit_01", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        return false;
    }

    private boolean isLegalQTTypeEntries() {
        DynamicObjectCollection qtTypeEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        List selectedTypeIdList = qtTypeEntries.stream().map(row -> row.getLong(QTTYPE_ID)).collect(Collectors.toList());
        if (selectedTypeIdList.size() == new HashSet(selectedTypeIdList).size()) {
            return true;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0d\u540c\u7684\u5b9a\u989d\u7c7b\u578b\u3002", (String)"QuotaDeducRuleEdit_02", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        return false;
    }

    private boolean isExistQTTypeEntries() {
        DynamicObjectCollection qtTypeEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Set selectedTypeIdList = qtTypeEntries.stream().map(row -> row.getLong(QTTYPE_ID)).collect(Collectors.toSet());
        DynamicObject[] dys = this.qttypeHelper.queryOriginalArray("id", new QFilter[]{new QFilter("id", "in", selectedTypeIdList)});
        if (selectedTypeIdList.size() == dys.length) {
            return true;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b9a\u989d\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u5931\u6548\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"QuotaDeducRuleEdit_03", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        return false;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object hisAction = customParams.get("his_action");
        if ("open_insert_new_data_page".equals(hisAction)) {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit qtType = (BasedataEdit)this.getControl("qttype");
        qtType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit qtTypeF7 = (BasedataEdit)this.getControl("qttypef7");
        qtTypeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("qttype".equals(name) || "qttypef7".equals(name)) {
            beforeF7SelectEvent.getCustomQFilters().addAll(this.getCustomQFilters());
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "qttype"));
            listShowParameter.setMultiSelect(true);
            DynamicObjectCollection entries = this.getView().getModel().getEntryEntity("entryentity");
            if (WTCCollections.isNotEmpty((Collection)entries)) {
                Set<Object> qtTypeIdSet = entries.stream().filter(Objects::nonNull).map(row -> row.getLong(QTTYPE_ID)).filter(id -> id != 0L).collect(Collectors.toSet());
                listShowParameter.setSelectedRows(qtTypeIdSet.toArray(new Object[0]));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("entry_add".equals(itemKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String qtCategory = dataEntity.getString("category");
            String qtUnit = dataEntity.getString("unit");
            if (HRStringUtils.isEmpty((String)qtCategory) || HRStringUtils.isEmpty((String)qtUnit)) {
                this.getView().showTipNotification(QuotaKDString.mustCategoryUnit());
            } else {
                BasedataEdit qtTypeEdit = (BasedataEdit)this.getControl("qttypef7");
                qtTypeEdit.click();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("qttype".equals(actionId)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                return;
            }
            IDataModel model = this.getModel();
            AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
            dataModel.beginInit();
            TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"qttype"});
            for (ListSelectedRow selectedRow : selectedRows) {
                tableValueSetter.addRow(new Object[]{selectedRow.getPrimaryKeyValue()});
            }
            dataModel.deleteEntryData("entryentity");
            dataModel.batchCreateNewEntryRow("entryentity", tableValueSetter);
            dataModel.endInit();
            this.getView().updateView("conentpanel");
        }
    }

    private List<QFilter> getCustomQFilters() {
        QFilter qFilter;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String qtCategory = dataEntity.getString("category");
        String qtUnit = dataEntity.getString("unit");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        if (HRStringUtils.isNotEmpty((String)qtCategory)) {
            qFilter = new QFilter("category", "=", (Object)qtCategory);
            qFilters.add(qFilter);
        }
        if (HRStringUtils.isNotEmpty((String)qtUnit)) {
            qFilter = new QFilter("unit", "=", (Object)qtUnit);
            qFilters.add(qFilter);
        }
        return qFilters;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        DynamicObjectCollection dynamicObjectCollection;
        super.beforePropertyChanged(args);
        String name = args.getProperty().getName();
        String checkChange = this.getPageCache().get("check_change");
        if (HRStringUtils.isEmpty((String)checkChange) && ("category".equals(name) || "unit".equals(name)) && !CollectionUtils.isEmpty((Collection)(dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity")))) {
            String displayName = args.getProperty().getDisplayName().getLocaleValue();
            String tipMsg = MessageFormat.format(QuotaKDString.changeClear(), displayName);
            this.getView().showConfirm(tipMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(name));
            ChangeData changeData = args.getChangeSet()[0];
            this.getPageCache().put("change_key", name);
            this.getPageCache().put("old_value", String.valueOf(changeData.getOldValue()));
            this.getPageCache().remove("check_change");
        }
        this.getPageCache().remove("check_change");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("category".equals(callBackId) || "unit".equals(callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("entryentity");
            } else {
                this.getPageCache().put("check_change", "1");
                String changeKey = this.getPageCache().get("change_key");
                String oldValue = this.getPageCache().get("old_value");
                this.getModel().setValue(changeKey, (Object)oldValue);
                this.getView().updateView(changeKey);
            }
        }
    }
}

