/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota.carrydown;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.cumulate.calculate.util.CheckUtils;
import kd.wtc.wtp.formplugin.web.quota.QTAttItemFilterUtils;
import kd.wtc.wtp.formplugin.web.quota.QTAttitemService;

public class QTCarryDownEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final QTAttItemFilterUtils.QTControlInfo[] ctrlArr1 = new QTAttItemFilterUtils.QTControlInfo[3];
    private static final QTAttItemFilterUtils.QTControlInfo[] ctrlArr2;
    private static final QTAttItemFilterUtils.QTControlInfo[] ctrlArr3;
    private static final String false_str = "0";

    public void registerListener(EventObject evt) {
        ((BasedataEdit)this.getControl("pastduration")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("cdduration")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("cdpastduration")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("departduration")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit slmentAttItem = (BasedataEdit)this.getView().getControl("slmentattitem");
        if (slmentAttItem != null) {
            slmentAttItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject evt) {
        int cdsDelayValue = this.getModel().getDataEntity().getInt("cdsdelayvalue");
        this.getModel().setValue("scdsdelayvalue", (Object)(cdsDelayValue == 0 ? null : Integer.valueOf(cdsDelayValue)));
        int cdeDelayValue = this.getModel().getDataEntity().getInt("cdedelayvalue");
        this.getModel().setValue("scdedelayvalue", (Object)(cdeDelayValue == 0 ? null : Integer.valueOf(cdeDelayValue)));
        BigDecimal cdValue = this.getModel().getDataEntity().getBigDecimal("cdvalue");
        this.getModel().setValue("scdvalue", (Object)(CheckUtils.isZero((BigDecimal)cdValue) ? null : cdValue));
        BigDecimal scdVdelayValue = this.getModel().getDataEntity().getBigDecimal("cdvdelayvalue");
        this.getModel().setValue("scdvdelayvalue", (Object)(CheckUtils.isZero((BigDecimal)scdVdelayValue) ? null : scdVdelayValue));
        BigDecimal dpvDelayValue = this.getModel().getDataEntity().getBigDecimal("dpvdelayvalue");
        this.getModel().setValue("sdpvdelayvalue", (Object)(CheckUtils.isZero((BigDecimal)dpvDelayValue) ? null : dpvDelayValue));
    }

    public void afterBindData(EventObject evt) {
        this.changViewPDMode();
        this.changeView4CDMode();
        boolean cdsDelay = this.getModel().getDataEntity().getBoolean("cdsdelay");
        this.changeCDSDelayCTRLView(cdsDelay);
        boolean cdeDelay = this.getModel().getDataEntity().getBoolean("cdedelay");
        this.changeCDEDelayCTRLView(cdeDelay);
        boolean cdvDelay = this.getModel().getDataEntity().getBoolean("cdvdelay");
        this.changViewCDVMode(cdvDelay);
        this.changeView4CDType();
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propertyName = evt.getProperty().getName();
        if ("pastduration".equals(propertyName) || "cdduration".equals(propertyName) || "cdpastduration".equals(propertyName) || "departduration".equals(propertyName) || "slmentattitem".equals(propertyName)) {
            Date startDate = this.getModel().getDataEntity().getDate("bsed");
            if (startDate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"QTCarryDownEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qFilter = QTAttItemFilterUtils.getQTConfigItemFilter(startDate);
            evt.setCustomQFilters(Collections.singletonList(qFilter));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        if ("cdmode".equals(propertyName)) {
            this.changeView4CDMode();
        }
        if ("dpvdelay".equals(propertyName)) {
            this.changViewPDMode();
        }
        if ("cdvdelay".equals(propertyName)) {
            boolean cdvDelay = this.getModel().getDataEntity().getBoolean("cdvdelay");
            this.changViewCDVMode(cdvDelay);
        } else if ("cdsdelay".equals(propertyName)) {
            boolean cdsDelay = this.getModel().getDataEntity().getBoolean("cdsdelay");
            this.changeCDSDelayCTRLView(cdsDelay);
        } else if ("cdedelay".equals(propertyName)) {
            boolean cdeDelay = this.getModel().getDataEntity().getBoolean("cdedelay");
            this.changeCDEDelayCTRLView(cdeDelay);
        } else if ("cdtype".equals(propertyName)) {
            this.changeView4CDType();
        } else if ("cdpercent".equals(propertyName)) {
            this.changeCDPastPercentIfNeed();
        } else if ("cdpastpercent".equals(propertyName)) {
            this.changeCDPercentIfNeed();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        String operateKey = ((FormOperate)source).getOperateKey();
        if (source instanceof SaveAndNew) {
            SaveAndNew opSource = (SaveAndNew)source;
            operateKey = opSource.getOriOperateKey();
        }
        switch (operateKey) {
            case "save": 
            case "saveandnew": 
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                QTAttItemFilterUtils.QTControlInfo[] ctrlArr;
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String cdType = dataEntity.getString("cdtype");
                if (WTCStringUtils.equals((String)"B", (String)cdType)) {
                    BigDecimal cdPercent = dataEntity.getBigDecimal("cdpercent");
                    BigDecimal cdPastPercent = dataEntity.getBigDecimal("cdpastpercent");
                    if (BigDecimal.ZERO.compareTo(cdPercent) == 0) {
                        args.setCancel(true);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u8f6c\u6bd4\u4f8b\u4e0d\u80fd\u4e3a0\u3002", (String)"QTCarryDownEdit_9", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (cdPastPercent.add(cdPercent).compareTo(BigDecimal.valueOf(100L)) != 0) {
                        args.setCancel(true);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7ed3\u8f6c\u6bd4\u4f8b(%)\u201d\u4e0e\u201c\u8fc7\u671f\u6bd4\u4f8b(%)\u201d\u76f8\u52a0\u9700\u7b49\u4e8e100\u3002", (String)"QTCarryDownEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                ArrayList<String> pros = new ArrayList<String>();
                pros.add("departduration");
                pros.add("slmentattitem");
                if (dataEntity.getString("cdmode").equals("A")) {
                    ctrlArr = ctrlArr1;
                    pros.add("pastduration");
                } else if (dataEntity.getString("cdmode").equals("B")) {
                    ctrlArr = ctrlArr2;
                    pros.add("cdpastduration");
                    pros.add("cdduration");
                } else {
                    ctrlArr = ctrlArr3;
                    pros.add("cdduration");
                }
                if (QTAttitemService.checkAttitemEmpty(dataEntity, this.getView(), pros)) {
                    args.setCancel(true);
                    return;
                }
                String errMsg = QTAttItemFilterUtils.checkFirstBSED(dataEntity, ctrlArr);
                if (errMsg != null) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(errMsg);
                }
                if (QTAttitemService.checkAttitemEqual(dataEntity, this.getView(), pros)) {
                    args.setCancel(true);
                    return;
                }
                Object scdsDelayValue = dataEntity.get("scdsdelayvalue");
                this.getModel().setValue("cdsdelayvalue", scdsDelayValue == null ? Integer.valueOf(0) : scdsDelayValue);
                Object scdeDelayValue = dataEntity.get("scdedelayvalue");
                this.getModel().setValue("cdedelayvalue", scdeDelayValue == null ? Integer.valueOf(0) : scdeDelayValue);
                Object scdValue = dataEntity.get("scdvalue");
                this.getModel().setValue("cdvalue", scdValue == null ? BigDecimal.ZERO : scdValue);
                Object scdvdValue = dataEntity.get("scdvdelayvalue");
                this.getModel().setValue("cdvdelayvalue", scdvdValue == null ? BigDecimal.ZERO : scdvdValue);
                Object sdpValue = dataEntity.get("sdpvdelayvalue");
                this.getModel().setValue("dpvdelayvalue", sdpValue == null ? BigDecimal.ZERO : sdpValue);
                break;
            }
        }
    }

    private void changeCDPastPercentIfNeed() {
        BigDecimal cdPercent = this.getModel().getDataEntity().getBigDecimal("cdpercent");
        String cdType = this.getModel().getDataEntity().getString("cdtype");
        if (WTCStringUtils.equals((String)"B", (String)cdType)) {
            BigDecimal dis = BigDecimal.valueOf(100L).subtract(cdPercent);
            this.getModel().setValue("cdpastpercent", (Object)dis);
        }
    }

    private void changeCDPercentIfNeed() {
        BigDecimal cdPercent = this.getModel().getDataEntity().getBigDecimal("cdpastpercent");
        String cdType = this.getModel().getDataEntity().getString("cdtype");
        if (WTCStringUtils.equals((String)"B", (String)cdType)) {
            BigDecimal dis = BigDecimal.valueOf(100L).subtract(cdPercent);
            this.getModel().setValue("cdpercent", (Object)dis);
        }
    }

    private void changeView4CDType() {
        String cdType = this.getModel().getDataEntity().getString("cdtype");
        if (cdType == null) {
            this.changeCDValueView(false);
            this.changeCDPercentView(false);
        } else if ("A".equals(cdType)) {
            this.changeCDValueView(true);
            this.changeCDPercentView(false);
        } else if ("B".equals(cdType)) {
            this.changeCDValueView(false);
            this.changeCDPercentView(true);
        }
    }

    private void changViewPDMode() {
        String pdMode = this.getModel().getDataEntity().getString("dpvdelay");
        if ("1".equals(pdMode)) {
            ((FieldEdit)this.getControl("sdpvdelayvalue")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"sdpvdelayvalue"});
            ((FieldEdit)this.getControl("dpvdelayunit")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"dpvdelayunit"});
        } else {
            ((FieldEdit)this.getControl("sdpvdelayvalue")).setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"sdpvdelayvalue"});
            this.getModel().setValue("sdpvdelayvalue", null);
            ((FieldEdit)this.getControl("dpvdelayunit")).setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"dpvdelayunit"});
            this.getModel().setValue("dpvdelayunit", null);
        }
    }

    private void changViewCDVMode(boolean show) {
        if (show) {
            ((FieldEdit)this.getControl("scdvdelayvalue")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"scdvdelayvalue"});
            ((FieldEdit)this.getControl("cdvdelayunit")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdvdelayunit"});
        } else {
            ((FieldEdit)this.getControl("scdvdelayvalue")).setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"scdvdelayvalue"});
            this.getModel().setValue("scdvdelayvalue", null);
            ((FieldEdit)this.getControl("cdvdelayunit")).setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdvdelayunit"});
            this.getModel().setValue("cdvdelayunit", null);
        }
    }

    private void changeView4CDMode() {
        String cdMode = this.getModel().getDataEntity().getString("cdmode");
        if (cdMode == null) {
            this.changePastDurationView(false);
            this.changeCDDateView(false);
            this.changeCDSDelayView(false);
            this.changeCDEDelayView(false);
            this.changeCDView(false);
            this.changeCDVDelayView(false);
            this.changeOffsetMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"attitemconf"});
        } else if ("A".equals(cdMode)) {
            this.changePastDurationView(true);
            this.changeCDDateView(false);
            this.changeCDSDelayView(false);
            this.changeCDEDelayView(false);
            this.changeCDView(false);
            this.changeCDVDelayView(false);
            this.changeOffsetMustInput(false);
            this.getView().setVisible(Boolean.TRUE, new String[]{"attitemconf"});
        } else if ("B".equals(cdMode)) {
            this.changePastDurationView(false);
            this.changeCDDateView(true);
            this.changeCDSDelayView(true);
            this.changeCDEDelayView(true);
            this.changeCDVDelayView(false);
            this.changeCDView(true);
            this.changeOffsetMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"attitemconf"});
        } else if ("C".equals(cdMode)) {
            this.changeCDSDelayView(false);
            this.changeCDEDelayView(false);
            this.changeCDVDelayView(true);
            this.changePastDurationView(false);
            this.changeOffsetMustInput(false);
            ((FieldEdit)this.getControl("cdpastduration")).setMustInput(false);
            this.cleanStringValueIfExist("cdpastduration");
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdpastduration"});
            ((FieldEdit)this.getControl("cdduration")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdduration"});
            boolean cdvDelay = this.getModel().getDataEntity().getBoolean("cdvdelay");
            this.changViewCDVMode(cdvDelay);
            this.getView().setVisible(Boolean.TRUE, new String[]{"attitemconf"});
        }
    }

    private void changeCDValueView(boolean show) {
        if (show) {
            ((FieldEdit)this.getControl("scdvalue")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"scdvalue"});
        } else {
            ((FieldEdit)this.getControl("scdvalue")).setMustInput(false);
            this.getModel().setValue("scdvalue", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"scdvalue"});
        }
    }

    private void changeCDPercentView(boolean show) {
        if (show) {
            ((FieldEdit)this.getControl("cdpercent")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdpercent"});
            ((FieldEdit)this.getControl("cdpastpercent")).setMustInput(true);
        } else {
            ((FieldEdit)this.getControl("cdpercent")).setMustInput(false);
            this.cleanBigDecimalValueIfExist("cdpercent");
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdpercent"});
            ((FieldEdit)this.getControl("cdpastpercent")).setMustInput(false);
            this.cleanBigDecimalValueIfExist("cdpastpercent");
        }
    }

    private void changeCDSDelayCTRLView(boolean show) {
        if (show) {
            ((FieldEdit)this.getControl("scdsdelayvalue")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"scdsdelayvalue"});
            ((FieldEdit)this.getControl("cdsdelayunit")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdsdelayunit"});
        } else {
            ((FieldEdit)this.getControl("scdsdelayvalue")).setMustInput(false);
            this.getModel().setValue("scdsdelayvalue", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"scdsdelayvalue"});
            ((FieldEdit)this.getControl("cdsdelayunit")).setMustInput(false);
            this.cleanStringValueIfExist("cdsdelayunit");
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdsdelayunit"});
        }
    }

    private void changeCDEDelayCTRLView(boolean show) {
        if (show) {
            ((FieldEdit)this.getControl("scdedelayvalue")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"scdedelayvalue"});
            ((FieldEdit)this.getControl("cdedelayunit")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdedelayunit"});
        } else {
            ((FieldEdit)this.getControl("scdedelayvalue")).setMustInput(false);
            this.getModel().setValue("scdedelayvalue", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"scdedelayvalue"});
            ((FieldEdit)this.getControl("cdedelayunit")).setMustInput(false);
            this.cleanStringValueIfExist("cdedelayunit");
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdedelayunit"});
        }
    }

    private void changeCDView(boolean show) {
        if (show) {
            ((FieldEdit)this.getControl("cdtype")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdtype"});
            ((FieldEdit)this.getControl("cdduration")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdduration"});
            ((FieldEdit)this.getControl("cdpastduration")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdpastduration"});
        } else {
            ((FieldEdit)this.getControl("cdtype")).setMustInput(false);
            this.cleanStringValueIfExist("cdtype");
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdtype"});
            ((FieldEdit)this.getControl("cdduration")).setMustInput(false);
            this.cleanStringValueIfExist("cdduration");
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdduration"});
            ((FieldEdit)this.getControl("cdpastduration")).setMustInput(false);
            this.cleanStringValueIfExist("cdpastduration");
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdpastduration"});
        }
    }

    private void changeCDSDelayView(boolean show) {
        if (show) {
            ((FieldEdit)this.getControl("cdsdelay")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdsdelay"});
        } else {
            ((FieldEdit)this.getControl("cdsdelay")).setMustInput(false);
            this.getModel().setValue("cdsdelay", (Object)false_str);
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdsdelay"});
        }
    }

    private void changeCDVDelayView(boolean show) {
        if (show) {
            ((FieldEdit)this.getControl("cdvdelay")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdvdelay"});
            ((FieldEdit)this.getControl("cdvestday")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdvestday"});
        } else {
            ((FieldEdit)this.getControl("cdvdelay")).setMustInput(false);
            this.getModel().setValue("cdvdelay", (Object)false_str);
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdvdelay"});
            ((FieldEdit)this.getControl("cdvestday")).setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdvestday"});
        }
    }

    private void changeCDEDelayView(boolean show) {
        if (show) {
            ((FieldEdit)this.getControl("cdedelay")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdedelay"});
        } else {
            ((FieldEdit)this.getControl("cdedelay")).setMustInput(false);
            this.getModel().setValue("cdedelay", (Object)false_str);
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdedelay"});
        }
    }

    private void changeCDDateView(boolean show) {
        if (show) {
            ((FieldEdit)this.getControl("cdstartdate")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdstartdate"});
            this.getModel().setValue("cdstartdate", (Object)"B");
            ((FieldEdit)this.getControl("cdenddate")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"cdenddate"});
            this.getModel().setValue("cdenddate", (Object)"B");
        } else {
            ((FieldEdit)this.getControl("cdstartdate")).setMustInput(false);
            this.cleanStringValueIfExist("cdstartdate");
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdstartdate"});
            ((FieldEdit)this.getControl("cdenddate")).setMustInput(false);
            this.cleanStringValueIfExist("cdenddate");
            this.getView().setVisible(Boolean.FALSE, new String[]{"cdenddate"});
        }
    }

    private void changePastDurationView(boolean show) {
        if (show) {
            ((FieldEdit)this.getControl("pastduration")).setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"pastduration"});
        } else {
            ((FieldEdit)this.getControl("pastduration")).setMustInput(false);
            this.cleanStringValueIfExist("pastduration");
            this.getView().setVisible(Boolean.FALSE, new String[]{"pastduration"});
        }
    }

    private void changeOffsetMustInput(boolean mustInput) {
        if (mustInput) {
            ((FieldEdit)this.getControl("offsetmode")).setMustInput(true);
            ((FieldEdit)this.getControl("offsetseq")).setMustInput(true);
        } else {
            ((FieldEdit)this.getControl("offsetmode")).setMustInput(false);
            ((FieldEdit)this.getControl("offsetseq")).setMustInput(false);
        }
    }

    private void cleanStringValueIfExist(String ... fieldNames) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        for (String fieldName : fieldNames) {
            if (HRStringUtils.isEmpty((String)dataEntity.getString(fieldName))) continue;
            this.getModel().setValue(fieldName, null);
        }
    }

    private void cleanBigDecimalValueIfExist(String ... fieldNames) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        for (String fieldName : fieldNames) {
            if (HRStringUtils.isEmpty((String)dataEntity.getString(fieldName))) continue;
            this.getModel().setValue(fieldName, (Object)BigDecimal.ZERO);
        }
    }

    static {
        String name1 = ResManager.loadKDString((String)"\u8fc7\u671f\u65f6\u957f", (String)"QTCarryDownEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        QTCarryDownEdit.ctrlArr1[0] = new QTAttItemFilterUtils.QTControlInfo("pastduration", name1);
        String pdName = ResManager.loadKDString((String)"\u79bb\u804c\u65f6\u957f", (String)"QTCarryDownEdit_7", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        QTCarryDownEdit.ctrlArr1[1] = new QTAttItemFilterUtils.QTControlInfo("departduration", pdName);
        String settlementName = ResManager.loadKDString((String)"\u8de8\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u7ed3\u7b97\u65f6\u957f", (String)"QTCarryDownEdit_8", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        QTCarryDownEdit.ctrlArr1[2] = new QTAttItemFilterUtils.QTControlInfo("slmentattitem", settlementName);
        ctrlArr2 = new QTAttItemFilterUtils.QTControlInfo[4];
        String name2 = ResManager.loadKDString((String)"\u7ed3\u8f6c\u65f6\u957f", (String)"QTCarryDownEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        QTCarryDownEdit.ctrlArr2[0] = new QTAttItemFilterUtils.QTControlInfo("cdduration", name2);
        String name3 = ResManager.loadKDString((String)"\u8fc7\u671f\u65f6\u957f", (String)"QTCarryDownEdit_6", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        QTCarryDownEdit.ctrlArr2[1] = new QTAttItemFilterUtils.QTControlInfo("cdpastduration", name3);
        QTCarryDownEdit.ctrlArr2[2] = new QTAttItemFilterUtils.QTControlInfo("departduration", pdName);
        QTCarryDownEdit.ctrlArr2[3] = new QTAttItemFilterUtils.QTControlInfo("departduration", settlementName);
        ctrlArr3 = new QTAttItemFilterUtils.QTControlInfo[3];
        QTCarryDownEdit.ctrlArr3[0] = new QTAttItemFilterUtils.QTControlInfo("cdduration", name2);
        QTCarryDownEdit.ctrlArr3[1] = new QTAttItemFilterUtils.QTControlInfo("departduration", pdName);
        QTCarryDownEdit.ctrlArr3[2] = new QTAttItemFilterUtils.QTControlInfo("departduration", settlementName);
    }
}

