/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota.genconfig;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.business.rulecontrol.RuleConditionService;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.ex.ExConditionFilterService;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.common.constants.QTGenConfigConstants;
import kd.wtc.wtp.common.enums.QtTypeUnitEnum;
import kd.wtc.wtp.formplugin.web.ex.common.ExConfigViewService;
import kd.wtc.wtp.formplugin.web.quota.genconfig.QTGenConfigService;

public class QTDyGenConfigDetailPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener,
QTGenConfigConstants {
    private RuleConditionService ruleConditionService = RuleConditionService.getInstance((String)"conditionfilterlap");

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        boolean isView = OperationStatus.VIEW == status;
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{"close"});
        this.getView().setVisible(Boolean.valueOf(!isView), new String[]{"cancel", "sure"});
        String unit = (String)this.getView().getFormShowParameter().getCustomParam("unit");
        Label unitLabel = (Label)this.getView().getControl("unit");
        unitLabel.setText(QtTypeUnitEnum.getRetDesc((String)unit));
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            this.getModel().setValue("createorg", parentView.getModel().getValue("createorg"));
        }
        JSONObject customObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("configdetail");
        QTGenConfigService.fillSomeAttItem(this.getView(), this.getModel());
        if (customObject != null) {
            this.customObject(customObject);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        if (HRStringUtils.equals((String)"wtp_qtgenconfig", (String)parentView.getFormShowParameter().getFormId()) && WTCHisService.isLock((IFormView)parentView)) {
            this.ruleConditionService.setView(this.getView()).setPageState("VIEW");
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        Container conFlex = (Container)this.getView().getControl("confitionflex");
        if (conFlex != null) {
            JSONObject customObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("configdetail");
            boolean isCollapse = true;
            if (customObject != null) {
                String condition = customObject.getString("conditionfilter");
                boolean haveCondition = HRStringUtils.isNotEmpty((String)condition) && !HRStringUtils.equals((String)condition, (String)ExConditionFilterService.getUnLimitStr());
                isCollapse = !haveCondition;
            }
            conFlex.setCollapse(isCollapse);
        }
    }

    private void customObject(JSONObject customObject) {
        boolean haveCondition;
        JSONObject roundRule = customObject.getJSONObject("roundrule");
        this.getModel().setValue("roundrule", roundRule != null ? roundRule.getLong("id") : null);
        JSONObject resAttItem = customObject.getJSONObject("resultattitem");
        this.getModel().setValue("resultattitem", resAttItem != null ? resAttItem.getLong("id") : null);
        JSONObject enjoyAttItem = customObject.getJSONObject("enjoyattitem");
        this.getModel().setValue("enjoyattitem", enjoyAttItem != null ? enjoyAttItem.getLong("id") : null);
        JSONObject usableAttItem = customObject.getJSONObject("usableattitem");
        this.getModel().setValue("usableattitem", usableAttItem != null ? usableAttItem.getLong("id") : null);
        BigDecimal value = customObject.getBigDecimal("itemvalue") != null ? customObject.getBigDecimal("itemvalue") : customObject.getBigDecimal("value");
        this.getModel().setValue("itemvalue", (Object)value);
        JSONObject qualification = customObject.getJSONObject("qualification");
        this.getModel().setValue("qualification", qualification != null ? qualification.getLong("id") : null);
        JSONObject attItem = customObject.getJSONObject("attitem");
        this.getModel().setValue("attitem", attItem != null ? attItem.getLong("id") : null);
        JSONObject maxAttItem = customObject.getJSONObject("maxattitem");
        this.getModel().setValue("maxattitem", maxAttItem != null ? maxAttItem.getLong("id") : null);
        this.getModel().setValue("percent", (Object)customObject.getBigDecimal("percent"));
        this.getModel().setValue("roundpriority", (Object)customObject.getString("roundpriority"));
        String condition = customObject.getString("conditionfilter");
        boolean bl = haveCondition = HRStringUtils.isNotEmpty((String)condition) && !HRStringUtils.equals((String)condition, (String)ExConditionFilterService.getUnLimitStr());
        if (haveCondition) {
            HashMap replaceMap = Maps.newHashMapWithExpectedSize((int)16);
            replaceMap.put("\"companyage\"", "\"CT_1300_S.hrpi_pernontsprop.entservicelen\"");
            replaceMap.put("\"age\"", "\"CT_1300_S.hrpi_pernontsprop.age\"");
            replaceMap.put("\"workage\"", "\"CT_1300_S.hrpi_pernontsprop.servicelen\"");
            this.ruleConditionService.setView(this.getView()).setReplaceText((Map)replaceMap);
            this.ruleConditionService.setView(this.getView()).setValue(condition);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (("maxattitem".equals(name) || "resultattitem".equals(name)) && this.checkAttItem()) {
            return;
        }
        super.propertyChanged(args);
    }

    private boolean checkAttItem() {
        DynamicObject attmId = (DynamicObject)this.getModel().getValue("maxattitem");
        DynamicObject maxAttmId = (DynamicObject)this.getModel().getValue("resultattitem");
        if (attmId != null && maxAttmId != null && attmId.getLong("id") == maxAttmId.getLong("id")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u201c\u6807\u51c6\u65f6\u957f\u201d\u4e0e\u201c\u989d\u5916\u751f\u6210\u65f6\u957f\u201d\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"QTDyGenConfigDetailPlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void registerListener(EventObject evt) {
        BasedataEdit enjoyAttItem;
        BasedataEdit qulification;
        BasedataEdit usableAttItem;
        BasedataEdit maxAttItem;
        BasedataEdit attItem;
        BasedataEdit resultAttItem;
        super.registerListener(evt);
        Button button = (Button)this.getView().getControl("sure");
        if (button != null) {
            button.addClickListener((ClickListener)this);
        }
        if ((resultAttItem = (BasedataEdit)this.getView().getControl("resultattitem")) != null) {
            resultAttItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((attItem = (BasedataEdit)this.getView().getControl("attitem")) != null) {
            attItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((maxAttItem = (BasedataEdit)this.getView().getControl("maxattitem")) != null) {
            maxAttItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((usableAttItem = (BasedataEdit)this.getView().getControl("usableattitem")) != null) {
            usableAttItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((qulification = (BasedataEdit)this.getView().getControl("qualification")) != null) {
            qulification.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((enjoyAttItem = (BasedataEdit)this.getView().getControl("enjoyattitem")) != null) {
            enjoyAttItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((Control)beforeF7SelectEvent.getSource()).getKey();
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"resultattitem", "attitem", "maxattitem", "enjoyattitem", "usableattitem"})) {
            beforeF7SelectEvent.addCustomQFilter(QTGenConfigService.getAttItemQFilter(this.getView()));
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"qualification")) {
            beforeF7SelectEvent.addCustomQFilter(QTGenConfigService.getQualificationQFilter(this.getView()));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"sure")) {
            boolean conditionCheck;
            boolean checkResult = this.check();
            if (!checkResult) {
                return;
            }
            if (QTGenConfigService.checkAttitemEqual(this.getModel().getDataEntity(), this.getView(), "B", null)) {
                return;
            }
            if (this.checkAttItem()) {
                return;
            }
            String conditionFilter = this.ruleConditionService.setView(this.getView()).getValue();
            boolean emptyJudge = ExConditionFilterService.emptyConditionJsonDeal((String)conditionFilter);
            if (emptyJudge && !(conditionCheck = QTGenConfigService.checkConditionJson(conditionFilter, this.getView()))) {
                return;
            }
            boolean isEquale = this.dyConditionAndAttiemIsOnly(emptyJudge, conditionFilter);
            if (!isEquale) {
                String param = "";
                param = emptyJudge ? ExConditionFilterService.getStrOfSettingCondition((String)conditionFilter) : ExConditionFilterService.getUnLimitStr();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u573a\u666f\u6761\u4ef6\u4e0b{0}\uff0c{1}\u7684\u5df2\u5b58\u5728\u76f8\u540c\u7684\u8ba1\u7b97\u89c4\u5219\uff0c\u8bf7\u66f4\u6362\u52a8\u6001\u751f\u6210\u7684\u8003\u52e4\u9879\u76ee\u6216\u4fee\u6539\u573a\u666f\u6761\u4ef6\u3002", (String)"QTDyGenConfigDetailPlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[]{param, this.getModel().getDataEntity().getString("attitem.name")}));
                return;
            }
            this.returnData(emptyJudge, conditionFilter, this.getView());
        }
    }

    private boolean dyConditionAndAttiemIsOnly(boolean emptyJudge, String conditionFilter) {
        DynamicObjectCollection dynamicObjects = this.getView().getParentView().getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return true;
        }
        JSONObject customObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("configdetail");
        List<List<String>> newConditionStr = this.splitCondition(conditionFilter);
        for (DynamicObject dy : dynamicObjects) {
            List<String> strs;
            Long newAttitemId;
            Long attitemId;
            Long newSeq;
            Long seq;
            if (customObject != null && (seq = customObject.getLong("seq")).equals(newSeq = Long.valueOf(dy.getLong("seq"))) || !(attitemId = Long.valueOf(dy.getLong("attitem.id"))).equals(newAttitemId = Long.valueOf(this.getModel().getDataEntity().getLong("attitem.id")))) continue;
            String conditionStr = dy.getString("conditionfilter");
            if (StringUtils.isEmpty((CharSequence)conditionStr) && !emptyJudge) {
                return false;
            }
            if (!emptyJudge) continue;
            List<List<String>> oldConditionStr = this.splitCondition(conditionStr);
            if (newConditionStr.size() != oldConditionStr.size()) continue;
            boolean isEqual = true;
            Iterator<List<String>> iterator = newConditionStr.iterator();
            while (iterator.hasNext() && (isEqual = this.isEqualCondition(strs = iterator.next(), oldConditionStr))) {
            }
            if (!isEqual) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualCondition(List<String> strs, List<List<String>> oldConditionStr) {
        boolean tag = true;
        for (List<String> oldStrs : oldConditionStr) {
            tag = true;
            if (oldStrs.size() != strs.size()) {
                tag = false;
                continue;
            }
            for (String str : strs) {
                if (oldStrs.contains(str)) continue;
                tag = false;
                break;
            }
            if (!tag) continue;
            break;
        }
        return tag;
    }

    private List<List<String>> splitCondition(String conditionFilter) {
        List<List<String>> expressList = new ArrayList<List<String>>();
        if (HRStringUtils.isEmpty((String)conditionFilter)) {
            return expressList;
        }
        RuleConditionInfo accessDto = (RuleConditionInfo)WTCSerializationUtils.fromJsonString((String)conditionFilter, RuleConditionInfo.class);
        List conditionList = accessDto.getConditionList();
        if (conditionList == null || conditionList.isEmpty()) {
            return expressList;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)conditionList.size());
        for (ConditionInfo dto : conditionList) {
            String part1 = dto.getParam();
            String part2 = dto.getOperators();
            String string = " \"" + dto.getDisplayValue() + "\"";
            String str = "";
            str = RuleOperatorEnum.IS_NULL.getValue().equals(dto.getOperators()) || RuleOperatorEnum.IS_NOT_NULL.getValue().equals(dto.getOperators()) ? part1 + part2 : part1 + part2 + string;
            map.put(dto.getName(), str);
        }
        if (map.isEmpty()) {
            return expressList;
        }
        List expressInfos = accessDto.getConditionExpressList();
        expressList.add(new ArrayList());
        ArrayList<List<String>> bracketList = new ArrayList<List<String>>();
        boolean isBracket = false;
        for (ConditionExpressInfo conditionExpressInfo : expressInfos) {
            boolean isCloseBracket = false;
            if (conditionExpressInfo.getLeftBracket() != null && "(".equals(conditionExpressInfo.getLeftBracket().trim())) {
                bracketList = new ArrayList();
                bracketList.add(new ArrayList());
                isBracket = true;
            }
            if (conditionExpressInfo.getRightBracket() != null && ")".equals(conditionExpressInfo.getRightBracket().trim())) {
                isCloseBracket = true;
                isBracket = false;
            }
            if (conditionExpressInfo.getLogical() != null && "or".equals(conditionExpressInfo.getLogical().trim())) {
                this.splitOrCondition(isBracket, isCloseBracket, bracketList, expressList, (String)map.get(conditionExpressInfo.getName()));
                continue;
            }
            this.splitAndCondition(isBracket, isCloseBracket, bracketList, expressList, (String)map.get(conditionExpressInfo.getName()));
        }
        for (List list : expressList) {
            List conditionStrs = list.stream().distinct().collect(Collectors.toList());
            list.clear();
            list.addAll(conditionStrs);
        }
        expressList = expressList.stream().distinct().collect(Collectors.toList());
        return expressList;
    }

    private void splitAndCondition(boolean isBracket, boolean isCloseBracket, List<List<String>> bracketList, List<List<String>> expressList, String conditionStr) {
        if (isBracket) {
            bracketList.get(bracketList.size() - 1).add(conditionStr);
        } else if (isCloseBracket) {
            bracketList.get(bracketList.size() - 1).add(conditionStr);
            if (bracketList.size() == 1) {
                expressList.get(expressList.size() - 1).addAll((Collection<String>)bracketList.get(0));
            } else {
                Collections.sort(bracketList.get(bracketList.size() - 1));
                bracketList = bracketList.stream().sorted(Comparator.comparing(v -> (String)v.get(0))).collect(Collectors.toList());
                for (List<String> list : bracketList) {
                    List conditionStrs = list.stream().distinct().collect(Collectors.toList());
                    list.clear();
                    list.addAll(conditionStrs);
                }
                if ((bracketList = bracketList.stream().distinct().collect(Collectors.toList())).size() == 1) {
                    expressList.get(expressList.size() - 1).addAll((Collection<String>)bracketList.get(0));
                } else {
                    String str = JSON.toJSONString(bracketList);
                    expressList.get(expressList.size() - 1).add(str);
                }
            }
        } else {
            expressList.get(expressList.size() - 1).add(conditionStr);
        }
    }

    private void splitOrCondition(boolean isBracket, boolean isCloseBracket, List<List<String>> bracketList, List<List<String>> expressList, String conditionStr) {
        ArrayList lists = new ArrayList();
        if (isBracket) {
            List<String> tempList = bracketList.get(bracketList.size() - 1);
            tempList.add(conditionStr);
            Collections.sort(bracketList.get(bracketList.size() - 1));
            bracketList.add(lists);
        } else if (isCloseBracket) {
            bracketList.get(bracketList.size() - 1).add(conditionStr);
            if (bracketList.size() == 1) {
                expressList.get(expressList.size() - 1).addAll((Collection<String>)bracketList.get(0));
                expressList.add(lists);
            } else {
                Collections.sort(bracketList.get(bracketList.size() - 1));
                bracketList = bracketList.stream().sorted(Comparator.comparing(v -> (String)v.get(0))).collect(Collectors.toList());
                for (List<String> list : bracketList) {
                    List conditionStrs = list.stream().distinct().collect(Collectors.toList());
                    list.clear();
                    list.addAll(conditionStrs);
                }
                if ((bracketList = bracketList.stream().distinct().collect(Collectors.toList())).size() == 1) {
                    expressList.get(expressList.size() - 1).addAll((Collection<String>)bracketList.get(0));
                } else {
                    String str = JSON.toJSONString(bracketList);
                    expressList.get(expressList.size() - 1).add(str);
                }
                expressList.add(lists);
            }
        } else {
            expressList.get(expressList.size() - 1).add(conditionStr);
            expressList.add(lists);
        }
    }

    private void returnData(boolean emptyJudge, String conditionFilter, IFormView view) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject dataEntity = view.getModel().getDataEntity();
        map.put("resultattitem", this.getModel().getValue("resultattitem"));
        map.put("attitem", this.getModel().getValue("attitem"));
        map.put("maxattitem", this.getModel().getValue("maxattitem"));
        map.put("roundrule", this.getModel().getValue("roundrule"));
        BigDecimal value = this.getModel().getValue("itemvalue") != null ? (BigDecimal)this.getModel().getValue("itemvalue") : (BigDecimal)this.getModel().getValue("value");
        map.put("value", value);
        map.put("percent", this.getModel().getValue("percent"));
        map.put("roundpriority", this.getModel().getValue("roundpriority"));
        map.put("enjoyattitem", this.getModel().getValue("enjoyattitem"));
        map.put("usableattitem", this.getModel().getValue("usableattitem"));
        String unitCode = (String)view.getFormShowParameter().getCustomParam("unit");
        map.put("resultshow", QTGenConfigService.getDyResultStr(dataEntity, unitCode));
        map.put("attitemshow", QTGenConfigService.getDyAttItemStr(dataEntity));
        map.put("qualification", this.getModel().getValue("qualification"));
        if (emptyJudge) {
            map.put("conditionfiltershow", ExConditionFilterService.getStrOfSettingCondition((String)conditionFilter));
            map.put("conditionfilter", conditionFilter);
        } else {
            map.put("conditionfiltershow", ExConditionFilterService.getUnLimitStr());
            map.put("conditionfilter", null);
        }
        this.getView().returnDataToParent((Object)map);
        this.getView().close();
    }

    private boolean check() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        List<String> keyList = this.getCheckColumnList();
        boolean tag = true;
        if (!ExConfigViewService.check(keyList, dataEntity, this.getView())) {
            tag = false;
        }
        if (dataEntity.getBigDecimal("itemvalue") == null) {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setSuccess(false);
            fieldTip.setTip(ExKDStringHelper.fillInError());
            fieldTip.setFieldKey("itemvalue");
            fieldTip.setTipsType(FieldTip.FieldTipsTypes.scope);
            fieldTip.setLevel(FieldTip.FieldTipsLevel.Error);
            this.getView().showFieldTip(fieldTip);
            tag = false;
        }
        return tag;
    }

    private List<String> getCheckColumnList() {
        ArrayList keyList = Lists.newArrayListWithCapacity((int)16);
        keyList.add("resultattitem");
        keyList.add("attitem");
        keyList.add("maxattitem");
        keyList.add("roundpriority");
        keyList.add("percent");
        keyList.add("enjoyattitem");
        keyList.add("usableattitem");
        return keyList;
    }
}

