/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota.genconfig;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.business.rulecontrol.RuleConditionService;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.ex.ExConditionFilterService;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.common.constants.QTGenConfigConstants;
import kd.wtc.wtp.common.enums.QtTypeUnitEnum;
import kd.wtc.wtp.formplugin.web.ex.common.ExConfigViewService;
import kd.wtc.wtp.formplugin.web.quota.genconfig.QTGenConfigService;

public class QTGenConfigDetailPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener,
QTGenConfigConstants {
    private RuleConditionService ruleConditionService = RuleConditionService.getInstance((String)"conditionfilterlap");

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        boolean isView = OperationStatus.VIEW == status;
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{"close"});
        this.getView().setVisible(Boolean.valueOf(!isView), new String[]{"cancel", "sure"});
        String unit = (String)this.getView().getFormShowParameter().getCustomParam("unit");
        Label unitLabel = (Label)this.getView().getControl("unit");
        unitLabel.setText(QtTypeUnitEnum.getRetDesc((String)unit));
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            this.getModel().setValue("createorg", parentView.getModel().getValue("createorg"));
        }
        JSONObject customObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("configdetail");
        QTGenConfigService.fillSomeAttItem(this.getView(), this.getModel());
        if (customObject != null) {
            this.customObject(customObject);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        if (HRStringUtils.equals((String)"wtp_qtgenconfig", (String)parentView.getFormShowParameter().getFormId()) && WTCHisService.isLock((IFormView)parentView)) {
            this.ruleConditionService.setView(this.getView()).setPageState("VIEW");
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        Container conFlex = (Container)this.getView().getControl("confitionflex");
        if (conFlex != null) {
            JSONObject customObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("configdetail");
            boolean isCollapse = true;
            if (customObject != null) {
                String condition = customObject.getString("conditionfilter");
                boolean haveCondition = HRStringUtils.isNotEmpty((String)condition) && !HRStringUtils.equals((String)condition, (String)ExConditionFilterService.getUnLimitStr());
                isCollapse = !haveCondition;
            }
            conFlex.setCollapse(isCollapse);
        }
    }

    private void customObject(JSONObject customObject) {
        boolean haveCondition;
        JSONObject resultAttItem = customObject.getJSONObject("resultattitem");
        this.getModel().setValue("resultattitem", resultAttItem != null ? resultAttItem.getLong("id") : null);
        BigDecimal value = customObject.getBigDecimal("itemvalue") != null ? customObject.getBigDecimal("itemvalue") : customObject.getBigDecimal("value");
        this.getModel().setValue("itemvalue", (Object)value);
        JSONObject usableAttItem = customObject.getJSONObject("usableattitem");
        this.getModel().setValue("usableattitem", usableAttItem != null ? usableAttItem.getLong("id") : null);
        JSONObject enjoyAttItem = customObject.getJSONObject("enjoyattitem");
        this.getModel().setValue("enjoyattitem", enjoyAttItem != null ? enjoyAttItem.getLong("id") : null);
        JSONObject roundRule = customObject.getJSONObject("roundrule");
        this.getModel().setValue("roundrule", roundRule != null ? roundRule.getLong("id") : null);
        JSONObject qualification = customObject.getJSONObject("qualification");
        this.getModel().setValue("qualification", qualification != null ? qualification.getLong("id") : null);
        String condition = customObject.getString("conditionfilter");
        boolean bl = haveCondition = HRStringUtils.isNotEmpty((String)condition) && !HRStringUtils.equals((String)condition, (String)ExConditionFilterService.getUnLimitStr());
        if (haveCondition) {
            HashMap replaceMap = Maps.newHashMapWithExpectedSize((int)16);
            replaceMap.put("\"companyage\"", "\"CT_1300_S.hrpi_pernontsprop.entservicelen\"");
            replaceMap.put("\"age\"", "\"CT_1300_S.hrpi_pernontsprop.age\"");
            replaceMap.put("\"workage\"", "\"CT_1300_S.hrpi_pernontsprop.servicelen\"");
            this.ruleConditionService.setView(this.getView()).setReplaceText((Map)replaceMap);
            this.ruleConditionService.setView(this.getView()).setValue(condition);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
    }

    public void registerListener(EventObject evt) {
        BasedataEdit usableAttItem;
        BasedataEdit qulification;
        BasedataEdit enjoyAttItem;
        BasedataEdit attItem;
        super.registerListener(evt);
        Button button = (Button)this.getView().getControl("sure");
        if (button != null) {
            button.addClickListener((ClickListener)this);
        }
        if ((attItem = (BasedataEdit)this.getView().getControl("resultattitem")) != null) {
            attItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((enjoyAttItem = (BasedataEdit)this.getView().getControl("enjoyattitem")) != null) {
            enjoyAttItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((qulification = (BasedataEdit)this.getView().getControl("qualification")) != null) {
            qulification.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((usableAttItem = (BasedataEdit)this.getView().getControl("usableattitem")) != null) {
            usableAttItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((Control)beforeF7SelectEvent.getSource()).getKey();
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"resultattitem", "enjoyattitem", "usableattitem"})) {
            beforeF7SelectEvent.addCustomQFilter(QTGenConfigService.getAttItemQFilter(this.getView()));
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"qualification")) {
            beforeF7SelectEvent.addCustomQFilter(QTGenConfigService.getQualificationQFilter(this.getView()));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"sure")) {
            boolean conditionCheck;
            boolean checkResult = this.check();
            if (!checkResult) {
                return;
            }
            if (QTGenConfigService.checkAttitemEqual(this.getModel().getDataEntity(), this.getView(), "A", null)) {
                return;
            }
            String conditionFilter = this.ruleConditionService.setView(this.getView()).getValue();
            boolean emptyJudge = ExConditionFilterService.emptyConditionJsonDeal((String)conditionFilter);
            if (emptyJudge && !(conditionCheck = QTGenConfigService.checkConditionJson(conditionFilter, this.getView()))) {
                return;
            }
            this.returnData(emptyJudge, conditionFilter, this.getView());
        }
    }

    private void returnData(boolean emptyJudge, String conditionFilter, IFormView view) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject dataEntity = view.getModel().getDataEntity();
        if (emptyJudge) {
            map.put("conditionfiltershow", ExConditionFilterService.getStrOfSettingCondition((String)conditionFilter));
            map.put("conditionfilter", conditionFilter);
        } else {
            map.put("conditionfiltershow", ExConditionFilterService.getUnLimitStr());
            map.put("conditionfilter", null);
        }
        map.put("resultattitem", this.getModel().getValue("resultattitem"));
        map.put("enjoyattitem", this.getModel().getValue("enjoyattitem"));
        map.put("usableattitem", this.getModel().getValue("usableattitem"));
        map.put("roundrule", this.getModel().getValue("roundrule"));
        BigDecimal value = this.getModel().getValue("itemvalue") != null ? (BigDecimal)this.getModel().getValue("itemvalue") : (BigDecimal)this.getModel().getValue("value");
        map.put("value", value);
        String unitCode = (String)view.getFormShowParameter().getCustomParam("unit");
        map.put("resultshow", QTGenConfigService.getResultStr(dataEntity, unitCode));
        map.put("attitemshow", QTGenConfigService.getAttItemStr(dataEntity));
        map.put("qualification", this.getModel().getValue("qualification"));
        this.getView().returnDataToParent((Object)map);
        this.getView().close();
    }

    private boolean check() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        List<String> keyList = this.getCheckColumnList();
        boolean tag = true;
        if (!ExConfigViewService.check(keyList, dataEntity, this.getView())) {
            tag = false;
        }
        if (dataEntity.getBigDecimal("itemvalue") == null) {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setSuccess(false);
            fieldTip.setTip(ExKDStringHelper.fillInError());
            fieldTip.setFieldKey("itemvalue");
            fieldTip.setTipsType(FieldTip.FieldTipsTypes.scope);
            fieldTip.setLevel(FieldTip.FieldTipsLevel.Error);
            this.getView().showFieldTip(fieldTip);
            tag = false;
        }
        return tag;
    }

    private List<String> getCheckColumnList() {
        ArrayList keyList = Lists.newArrayListWithCapacity((int)16);
        keyList.add("resultattitem");
        keyList.add("enjoyattitem");
        keyList.add("usableattitem");
        return keyList;
    }
}

