/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota.genconfig;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.ex.ExConditionFilterService;
import kd.wtc.wtp.business.quota.QTKDStringHelper;
import kd.wtc.wtp.formplugin.web.ex.common.ExCommonViewService;
import kd.wtc.wtp.formplugin.web.quota.genconfig.QTGenConfigService;

public class QTGenConfigEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(QTGenConfigEdit.class);
    private static final String OLD_QT_TYPE = "OLD_QT_TYPE";
    private static final String EXIST_CONFIRM_EVENT = "EXIST_CONFIRM_EVENT";
    private static final String CONVERT = "convert";
    private static final String CONDITIONCONVERT = "conditionconvert";
    private static final String CONVERTIME = "convertime";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
    }

    public void afterBindData(EventObject evt) {
        boolean isNewVersion;
        super.afterBindData(evt);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object hasAction = customParams.get("his_action");
        boolean bl = isNewVersion = null != hasAction && HRStringUtils.equals((String)"open_insert_new_data_page", (String)hasAction.toString());
        if (isNewVersion) {
            this.getModel().deleteEntryData("entryentity");
        }
        String genType = this.getModel().getDataEntity().getString("qttype.gentype");
        this.setDyQtTypleView(HRStringUtils.equals((String)"B", (String)genType));
        QTGenConfigService.setShowValue(this.getModel(), this.getView());
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String changeKey = args.getProperty().getName();
        String genType = "";
        switch (changeKey) {
            case "qttype": {
                if (ArrayUtils.isEmpty((Object[])args.getChangeSet())) break;
                boolean changeByConfirmFail = this.existConfirmEvent();
                if (!changeByConfirmFail) {
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                    if (WTCCollections.isNotEmpty((Collection)entryEntity)) {
                        this.getView().showConfirm(QTKDStringHelper.genConfigClearEntity(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("qttype"));
                        this.getPageCache().put(OLD_QT_TYPE, WTCSerializationUtils.serializeToBase64((Object)args.getChangeSet()[0].getOldValue()));
                        this.launchConfirmEvent();
                    }
                } else {
                    this.finishConfirmEvent();
                }
                genType = this.getModel().getDataEntity().getString("qttype.gentype");
                this.setDyQtTypleView(HRStringUtils.equals((String)"B", (String)genType));
                break;
            }
            case "transferorg": 
            case "gencondition": 
            case "conditionconvert": {
                genType = this.getModel().getDataEntity().getString("qttype.gentype");
                this.setDyQtTypleView(HRStringUtils.equals((String)"B", (String)genType));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if ("qttype".equals(callBackId)) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("entryentity");
                this.finishConfirmEvent();
            } else {
                this.getModel().setValue("qttype", WTCSerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(OLD_QT_TYPE)));
            }
            this.getPageCache().remove(OLD_QT_TYPE);
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit cycSet = (BasedataEdit)this.getView().getControl("cycset");
        if (cycSet != null) {
            cycSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (HRStringUtils.equals((String)"cycset", (String)key)) {
            QFilter cycTypeQFilter = new QFilter("cyctype", "=", (Object)"A");
            beforeF7SelectEvent.addCustomQFilter(cycTypeQFilter);
            QFilter cycUnitQFilter = new QFilter("cycunit", "!=", (Object)"E");
            beforeF7SelectEvent.addCustomQFilter(cycUnitQFilter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"addCallBack", (String)actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            this.closedCallBackOfAdd(returnData);
        } else if (QTGenConfigService.editEntryIndex(actionId) >= 0) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            this.closedCallBackOfEdit(returnData, actionId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                boolean check = this.checkAndSaveData(args);
                if (check) break;
                args.setCancel(true);
                return;
            }
            case "add": {
                boolean checkBeSd = ExCommonViewService.checkBeSd(this.getView());
                if (!checkBeSd) {
                    args.setCancel(true);
                    return;
                }
                DynamicObject qtType = this.getModel().getDataEntity().getDynamicObject("qttype");
                if (null == qtType || 0L == qtType.getLong("id")) {
                    this.getView().showTipNotification(QTKDStringHelper.qtType());
                    args.setCancel(true);
                    return;
                }
                QTGenConfigService.addQtConfigDetail((IFormPlugin)this, this.getModel(), this.getView());
                break;
            }
            case "modifyentry": 
            case "see": {
                boolean checkBesd = ExCommonViewService.checkBeSd(this.getView());
                if (!checkBesd) {
                    args.setCancel(true);
                    return;
                }
                QTGenConfigService.editConfigDetail((IFormPlugin)this, this.getModel(), this.getView(), operateKey);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    private void closedCallBackOfAdd(Map<String, Object> returnData) {
        if (returnData != null && !returnData.isEmpty()) {
            QTGenConfigService.detailClosedCallBack(returnData, this.getModel(), this.getView());
        }
    }

    private void closedCallBackOfEdit(Map<String, Object> returnData, String actionId) {
        if (returnData != null && !returnData.isEmpty()) {
            int row = QTGenConfigService.editEntryIndex(actionId);
            QTGenConfigService.editDetailClosedCallBack(returnData, this.getModel(), this.getView(), row);
        }
    }

    private boolean checkAndSaveData(BeforeDoOperationEventArgs args) {
        String genType = this.getModel().getDataEntity().getString("qttype.gentype");
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return true;
        }
        for (DynamicObject dy : dynamicObjects) {
            if (!QTGenConfigService.checkAttitemEqual(dy, this.getView(), genType, dy.getLong("seq"))) continue;
            return false;
        }
        if ("A".equals(genType)) {
            return true;
        }
        for (DynamicObject dy : dynamicObjects) {
            String conditionStr = dy.getString("conditionfilter");
            Long attitemId = dy.getLong("attitem.id");
            Long seq = dy.getLong("seq");
            boolean isEquale = this.dyConditionAndAttiemIsOnly(StringUtils.isEmpty((CharSequence)conditionStr), conditionStr, attitemId, seq);
            if (isEquale) continue;
            String param = "";
            param = StringUtils.isEmpty((CharSequence)conditionStr) ? ExConditionFilterService.getUnLimitStr() : ExConditionFilterService.getStrOfSettingCondition((String)conditionStr);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u573a\u666f\u6761\u4ef6\u4e0b{0}\uff0c{1}\u7684\u5df2\u5b58\u5728\u76f8\u540c\u7684\u8ba1\u7b97\u89c4\u5219\uff0c\u8bf7\u66f4\u6362\u52a8\u6001\u751f\u6210\u7684\u8003\u52e4\u9879\u76ee\u6216\u4fee\u6539\u573a\u666f\u6761\u4ef6\u3002", (String)"QTDyGenConfigDetailPlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[]{param, dy.getString("attitem.name")}));
            return false;
        }
        return true;
    }

    private boolean dyConditionAndAttiemIsOnly(boolean emptyJudge, String conditionFilter, Long newAttitemId, Long seq) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return true;
        }
        List<List<String>> newConditionStr = this.splitCondition(conditionFilter);
        for (DynamicObject dy : dynamicObjects) {
            List<String> strs;
            Long attitemId;
            Long newSeq = dy.getLong("seq");
            if (newSeq <= seq || !(attitemId = Long.valueOf(dy.getLong("attitem.id"))).equals(newAttitemId)) continue;
            String conditionStr = dy.getString("conditionfilter");
            if (StringUtils.isEmpty((CharSequence)conditionStr) && emptyJudge) {
                return false;
            }
            if (emptyJudge) continue;
            List<List<String>> oldConditionStr = this.splitCondition(conditionStr);
            if (newConditionStr.size() != oldConditionStr.size()) continue;
            boolean isEqual = true;
            Iterator<List<String>> iterator = newConditionStr.iterator();
            while (iterator.hasNext() && (isEqual = this.isEqualCondition(strs = iterator.next(), oldConditionStr))) {
            }
            if (!isEqual) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualCondition(List<String> strs, List<List<String>> oldConditionStr) {
        boolean tag = true;
        for (List<String> oldStrs : oldConditionStr) {
            tag = true;
            if (oldStrs.size() != strs.size()) {
                tag = false;
                continue;
            }
            for (String str : strs) {
                if (oldStrs.contains(str)) continue;
                tag = false;
                break;
            }
            if (!tag) continue;
            break;
        }
        return tag;
    }

    private List<List<String>> splitCondition(String conditionFilter) {
        List<List<String>> expressList = new ArrayList<List<String>>();
        if (HRStringUtils.isEmpty((String)conditionFilter)) {
            return expressList;
        }
        RuleConditionInfo accessDto = (RuleConditionInfo)WTCSerializationUtils.fromJsonString((String)conditionFilter, RuleConditionInfo.class);
        List conditionList = accessDto.getConditionList();
        if (conditionList == null || conditionList.isEmpty()) {
            return expressList;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)conditionList.size());
        for (ConditionInfo dto : conditionList) {
            String part1 = dto.getParam();
            String part2 = dto.getOperators();
            String part3 = " \"" + dto.getDisplayValue() + "\"";
            String str = "";
            str = RuleOperatorEnum.IS_NULL.getValue().equals(dto.getOperators()) || RuleOperatorEnum.IS_NOT_NULL.getValue().equals(dto.getOperators()) ? part1 + part2 : part1 + part2 + part3;
            map.put(dto.getName(), str);
        }
        if (map.isEmpty()) {
            return expressList;
        }
        List expressInfos = accessDto.getConditionExpressList();
        expressList.add(new ArrayList());
        ArrayList<List<String>> bracketList = new ArrayList<List<String>>();
        boolean isBracket = false;
        for (ConditionExpressInfo expressInfo : expressInfos) {
            boolean isCloseBracket = false;
            if (expressInfo.getLeftBracket() != null && "(".equals(expressInfo.getLeftBracket().trim())) {
                bracketList = new ArrayList();
                bracketList.add(new ArrayList());
                isBracket = true;
            }
            if (expressInfo.getRightBracket() != null && ")".equals(expressInfo.getRightBracket().trim())) {
                isCloseBracket = true;
                isBracket = false;
            }
            if (expressInfo.getLogical() != null && "or".equals(expressInfo.getLogical().trim())) {
                this.splitOrCondition(isBracket, isCloseBracket, bracketList, expressList, (String)map.get(expressInfo.getName()));
                continue;
            }
            this.splitAndCondition(isBracket, isCloseBracket, bracketList, expressList, (String)map.get(expressInfo.getName()));
        }
        expressList.forEach(list -> {
            List conditionStrs = list.stream().distinct().collect(Collectors.toList());
            list.clear();
            list.addAll(conditionStrs);
        });
        expressList = expressList.stream().distinct().collect(Collectors.toList());
        return expressList;
    }

    private void splitAndCondition(boolean isBracket, boolean isCloseBracket, List<List<String>> bracketList, List<List<String>> expressList, String conditionStr) {
        if (isBracket) {
            bracketList.get(bracketList.size() - 1).add(conditionStr);
        } else if (isCloseBracket) {
            bracketList.get(bracketList.size() - 1).add(conditionStr);
            if (bracketList.size() == 1) {
                expressList.get(expressList.size() - 1).addAll((Collection<String>)bracketList.get(0));
            } else {
                Collections.sort(bracketList.get(bracketList.size() - 1));
                bracketList = bracketList.stream().sorted(Comparator.comparing(v -> (String)v.get(0))).collect(Collectors.toList());
                for (List<String> list : bracketList) {
                    List conditionStrs = list.stream().distinct().collect(Collectors.toList());
                    list.clear();
                    list.addAll(conditionStrs);
                }
                if ((bracketList = bracketList.stream().distinct().collect(Collectors.toList())).size() == 1) {
                    expressList.get(expressList.size() - 1).addAll((Collection<String>)bracketList.get(0));
                } else {
                    String str = JSON.toJSONString(bracketList);
                    expressList.get(expressList.size() - 1).add(str);
                }
            }
        } else {
            expressList.get(expressList.size() - 1).add(conditionStr);
        }
    }

    private void splitOrCondition(boolean isBracket, boolean isCloseBracket, List<List<String>> bracketList, List<List<String>> expressList, String conditionStr) {
        ArrayList lists = new ArrayList();
        if (isBracket) {
            List<String> tempList = bracketList.get(bracketList.size() - 1);
            tempList.add(conditionStr);
            Collections.sort(bracketList.get(bracketList.size() - 1));
            bracketList.add(lists);
        } else if (!isBracket && isCloseBracket) {
            bracketList.get(bracketList.size() - 1).add(conditionStr);
            if (bracketList.size() == 1) {
                expressList.get(expressList.size() - 1).addAll((Collection<String>)bracketList.get(0));
                expressList.add(lists);
            } else {
                Collections.sort(bracketList.get(bracketList.size() - 1));
                bracketList = bracketList.stream().sorted(Comparator.comparing(v -> (String)v.get(0))).collect(Collectors.toList());
                bracketList = bracketList.stream().sorted(Comparator.comparing(v -> (String)v.get(0))).collect(Collectors.toList());
                for (List<String> list : bracketList) {
                    List conditionStrs = list.stream().distinct().collect(Collectors.toList());
                    list.clear();
                    list.addAll(conditionStrs);
                }
                if ((bracketList = bracketList.stream().distinct().collect(Collectors.toList())).size() == 1) {
                    expressList.get(expressList.size() - 1).addAll((Collection<String>)bracketList.get(0));
                } else {
                    String str = JSON.toJSONString(bracketList);
                    expressList.get(expressList.size() - 1).add(str);
                }
                expressList.add(lists);
            }
        } else {
            expressList.get(expressList.size() - 1).add(conditionStr);
            expressList.add(lists);
        }
    }

    private void launchConfirmEvent() {
        this.getPageCache().put(EXIST_CONFIRM_EVENT, EXIST_CONFIRM_EVENT);
    }

    private boolean existConfirmEvent() {
        return WTCStringUtils.isNotEmpty((String)this.getPageCache().get(EXIST_CONFIRM_EVENT));
    }

    private void finishConfirmEvent() {
        this.getPageCache().remove(EXIST_CONFIRM_EVENT);
    }

    private void setDyQtTypleView(boolean dyQtTyple) {
        boolean convertMustInput = false;
        Boolean convertview = Boolean.FALSE;
        boolean conditionconvertMustInput = false;
        Boolean conditionconvertview = Boolean.FALSE;
        boolean convertimeMustInput = false;
        this.getView().setVisible(Boolean.valueOf(dyQtTyple), new String[]{"isgendetails"});
        if (dyQtTyple) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"transferorg", CONVERT, "gencondition", CONDITIONCONVERT, CONVERTIME});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"transferorg", "gencondition"});
            String transferorg = this.getModel().getDataEntity().getString("transferorg");
            if (HRStringUtils.equals((String)"1", (String)transferorg)) {
                convertview = Boolean.TRUE;
                convertMustInput = true;
            }
            this.getView().setVisible(convertview, new String[]{CONVERT});
            String genCondition = this.getModel().getDataEntity().getString("gencondition");
            if (HRStringUtils.equals((String)"1", (String)genCondition)) {
                conditionconvertMustInput = true;
                conditionconvertview = Boolean.TRUE;
            }
            this.getView().setVisible(conditionconvertview, new String[]{CONDITIONCONVERT});
            if (conditionconvertview.booleanValue()) {
                convertimeMustInput = true;
            }
            this.getView().setVisible(Boolean.valueOf(convertimeMustInput), new String[]{CONVERTIME});
        }
        ComboEdit convertEdit = (ComboEdit)this.getView().getControl(CONVERT);
        convertEdit.setMustInput(convertMustInput);
        ComboEdit conditionconvertEdit = (ComboEdit)this.getView().getControl(CONDITIONCONVERT);
        conditionconvertEdit.setMustInput(conditionconvertMustInput);
        ComboEdit converttimeEdit = (ComboEdit)this.getView().getControl(CONVERTIME);
        converttimeEdit.setMustInput(convertimeMustInput);
    }
}

