/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota.genconfig;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.ext.hr.ruleengine.utils.TypeOperatorsUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.ex.ExConditionFilterService;
import kd.wtc.wtp.business.ex.helper.ExKDStringHelper;
import kd.wtc.wtp.business.quota.QTKDStringHelper;
import kd.wtc.wtp.common.enums.QtTypeUnitEnum;
import kd.wtc.wtp.common.enums.QtVarDateEnum;
import kd.wtc.wtp.enums.quota.QTAttItemDescEnum;
import kd.wtc.wtp.formplugin.web.quota.QTAttItemEnum;
import kd.wtc.wtp.formplugin.web.quota.QTAttItemFilterUtils;
import kd.wtc.wtp.utils.WTCSheetUtil;

public class QTGenConfigService {
    private static final Log LOG = LogFactory.getLog(QTGenConfigService.class);
    private static final int SCALE = 2;
    private static final Set<String> needCheckCondition = Sets.newHashSet((Object[])new String[]{"companyage", "workage", "age"});
    private static final String SELECTED_QT_TYPE = "SELECTED_QT_TYPE";
    private static final HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("brm_scene");
    private static final Long GENCONFIG_SCENE = 1639863226462150656L;

    public static void fillSomeAttItem(IFormView view, IDataModel model) {
        QTAttItemEnum tmp;
        Object customParam = view.getFormShowParameter().getCustomParam(SELECTED_QT_TYPE);
        if (customParam != null && (tmp = QTAttItemEnum.getByQTTypeId(Long.parseLong(customParam.toString()))) != null) {
            model.setValue("resultattitem", (Object)tmp.genValueItemId);
            model.setValue("enjoyattitem", (Object)tmp.ownValueItemId);
            model.setValue("usableattitem", (Object)tmp.usableValueItemId);
            if (tmp.maxAttItemId > 0L) {
                model.setValue("maxattitem", (Object)tmp.maxAttItemId);
            }
        }
    }

    public static void addQtConfigDetail(IFormPlugin plugin, IDataModel model, IFormView view) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject dataEntity = model.getDataEntity();
        String genType = dataEntity.getString("qttype.gentype");
        String formId = "";
        if ("A".equals(genType)) {
            formId = "wtp_qtgenconfigdetail";
        } else if ("B".equals(genType)) {
            formId = "wtp_qtdygenconfigdetail";
        }
        map.put("unit", dataEntity.getString("qttype.unit"));
        map.put(SELECTED_QT_TYPE, model.getDataEntity().getLong("qttype.id"));
        FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.Modal, null, (String)formId, (CloseCallBack)new CloseCallBack(plugin, "addCallBack"), map, (OperationStatus)view.getFormShowParameter().getStatus());
        view.showForm(parameter);
    }

    public static void detailClosedCallBack(Map<String, Object> returnData, IDataModel model, IFormView view) {
        if (returnData == null) {
            return;
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        int row = 0;
        if (entryEntity != null) {
            row = entryEntity.size();
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", 1);
        QTGenConfigService.setValue(returnData, model, row);
        model.endInit();
        view.updateView("entryentity");
    }

    private static void setValue(Map<String, Object> returnData, IDataModel model, int row) {
        model.setValue("conditionfiltershow", returnData.get("conditionfiltershow"), row);
        model.setValue("conditionfilter", returnData.get("conditionfilter"), row);
        model.setValue("resultshow", returnData.get("resultshow"), row);
        model.setValue("attitemshow", returnData.get("attitemshow"), row);
        model.setValue("itemvalue", returnData.get("value"), row);
        model.setValue("roundrule", returnData.get("roundrule"), row);
        model.setValue("resultattitem", returnData.get("resultattitem"), row);
        model.setValue("enjoyattitem", returnData.get("enjoyattitem"), row);
        model.setValue("usableattitem", returnData.get("usableattitem"), row);
        model.setValue("qualification", returnData.get("qualification"), row);
        DynamicObject dataEntity = model.getDataEntity();
        if ("B".equals(dataEntity.getString("qttype.gentype"))) {
            model.setValue("maxattitem", returnData.get("maxattitem"), row);
            model.setValue("attitem", returnData.get("attitem"), row);
            model.setValue("percent", returnData.get("percent"), row);
            model.setValue("roundpriority", returnData.get("roundpriority"), row);
        }
    }

    public static String getResultStr(DynamicObject dy, String unitCode) {
        BigDecimal value = dy.getBigDecimal("itemvalue") != null ? dy.getBigDecimal("itemvalue") : dy.getBigDecimal("value");
        String unit = QtTypeUnitEnum.getRetDesc((String)unitCode);
        String baseStr = MessageFormat.format(QTKDStringHelper.getBaseResultStr(), value, unit);
        return baseStr;
    }

    public static String getAttItemStr(DynamicObject dy) {
        String starAttItemName = dy.getString("resultattitem.name");
        String enjoyAttItemName = dy.getString("enjoyattitem.name");
        String avAttItemName = dy.getString("usableattitem.name");
        String baseStr = MessageFormat.format(QTKDStringHelper.getBaseAttItemStr(), starAttItemName, enjoyAttItemName, avAttItemName);
        return baseStr;
    }

    public static String getDyResultStr(DynamicObject dy, String unitCode) {
        String attItemName = dy.getString("attitem.name");
        String baseStr = MessageFormat.format(QTKDStringHelper.getDyBaseResultStr(), attItemName);
        return baseStr;
    }

    public static String getDyAttItemStr(DynamicObject dy) {
        String starAttItemName = dy.getString("attitem.name");
        String enjoyAttItemName = dy.getString("enjoyattitem.name");
        String avAttItemName = dy.getString("usableattitem.name");
        String outAttItemName = dy.getString("maxattitem.name");
        String baseStr = MessageFormat.format(QTKDStringHelper.getDyBaseAttItemStr(), starAttItemName, enjoyAttItemName, avAttItemName, outAttItemName);
        return baseStr;
    }

    public static void editConfigDetail(IFormPlugin plugin, IDataModel model, IFormView view, String opKey) {
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        DynamicObject dy = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("configdetail", dy);
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String genType = dataEntity.getString("qttype.gentype");
        map.put("unit", dataEntity.getString("qttype.unit"));
        String formId = "";
        if ("A".equals(genType)) {
            formId = "wtp_qtgenconfigdetail";
        } else if ("B".equals(genType)) {
            formId = "wtp_qtdygenconfigdetail";
        }
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (HRStringUtils.equals((String)opKey, (String)"see")) {
            status = OperationStatus.VIEW;
        }
        FormShowParameter parameter = WTCSheetUtil.showFormParameter((ShowType)ShowType.Modal, null, (String)formId, (CloseCallBack)new CloseCallBack(plugin, QTGenConfigService.getEditActionId(entryCurrentRowIndex)), map, (OperationStatus)status);
        view.showForm(parameter);
    }

    public static String getEditActionId(int entryCurrentRowIndex) {
        return "editconfiguredetail" + entryCurrentRowIndex;
    }

    public static int editEntryIndex(String actionId) {
        if (actionId.startsWith("editconfiguredetail")) {
            return Integer.parseInt(actionId.substring("editconfiguredetail".length()));
        }
        return -1;
    }

    public static void editDetailClosedCallBack(Map<String, Object> returnData, IDataModel model, IFormView view, int row) {
        if (returnData == null) {
            return;
        }
        model.beginInit();
        QTGenConfigService.setValue(returnData, model, row);
        model.endInit();
        view.updateView("entryentity");
    }

    public static void setShowValue(IDataModel model, IFormView view) {
        DynamicObject dataEntity = model.getDataEntity();
        String genType = dataEntity.getString("qttype.gentype");
        String unit = dataEntity.getString("qttype.unit");
        DynamicObjectCollection entryData = model.getEntryEntity("entryentity");
        model.beginInit();
        if (entryData != null && !entryData.isEmpty()) {
            for (int index = 0; index < entryData.size(); ++index) {
                String attItemStr;
                String resultStr;
                DynamicObject eachDy = (DynamicObject)entryData.get(index);
                String condition = ExConditionFilterService.getStrOfSettingCondition((String)eachDy.getString("conditionfilter"));
                model.setValue("conditionfiltershow", (Object)condition, index);
                if ("A".equals(genType)) {
                    resultStr = QTGenConfigService.getResultStr(eachDy, unit);
                    attItemStr = QTGenConfigService.getAttItemStr(eachDy);
                    model.setValue("resultshow", (Object)resultStr, index);
                    model.setValue("attitemshow", (Object)attItemStr, index);
                    continue;
                }
                if (!"B".equals(genType)) continue;
                resultStr = QTGenConfigService.getDyResultStr(eachDy, unit);
                attItemStr = QTGenConfigService.getDyAttItemStr(eachDy);
                model.setValue("resultshow", (Object)resultStr, index);
                model.setValue("attitemshow", (Object)attItemStr, index);
            }
        }
        model.endInit();
        view.updateView("entryentity");
    }

    public static void dealWithCondition(IFormView view, String controlKey) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)1);
        Map comparisonOperatorsMap = TypeOperatorsUtil.getComparisonOperatorsMap();
        ArrayList needList = Lists.newArrayListWithCapacity((int)4);
        ArrayList operatorEnums = Lists.newArrayList((Object[])new RuleOperatorEnum[]{RuleOperatorEnum.GREATER_THAN, RuleOperatorEnum.GREATER_OR_EQUAL, RuleOperatorEnum.LESS_THAN, RuleOperatorEnum.LESS_OR_EQUAL});
        for (RuleOperatorEnum operatorEnum : operatorEnums) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("name", operatorEnum.getName());
            map.put("value", operatorEnum.getValue());
            needList.add(map);
        }
        comparisonOperatorsMap.put("enum", needList);
        data.put("comparisonOpt", TypeOperatorsUtil.getComparisonOperatorsMap());
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.invokeControlMethod(controlKey, "updateData", new Object[]{data});
    }

    public static boolean checkConditionJson(String conditions, IFormView view) {
        if (HRStringUtils.isEmpty((String)conditions)) {
            return true;
        }
        if (conditions.contains("is_or_isSub")) {
            view.showTipNotification(ExKDStringHelper.gradeError());
            return false;
        }
        RuleConditionInfo accessDto = (RuleConditionInfo)WTCSerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        List conditionList = accessDto.getConditionList();
        if (conditionList.size() > 10) {
            view.showTipNotification(ExKDStringHelper.getMaxConditionNum());
            return false;
        }
        for (Object conditionDto : conditionList) {
            String param = conditionDto.getParam();
            String value = conditionDto.getValue();
            String operators = conditionDto.getOperators();
            boolean noNeedSetValue = ExConditionFilterService.isNoNeedSetValue((String)operators);
            if (!noNeedSetValue && (HRStringUtils.isEmpty((String)value) || HRStringUtils.isEmpty((String)param) || HRStringUtils.isEmpty((String)operators))) {
                view.showTipNotification(ExKDStringHelper.conditionDtoError());
                return false;
            }
            if (!needCheckCondition.contains(param) || QTGenConfigService.isDouble(value, 2)) continue;
            view.showTipNotification(ResManager.loadKDString((String)"{0}\u7684\u503c\u8bf7\u8f93\u5165[0\uff0c9999]\u8303\u56f4\u5185\u7684\u5c0f\u6570\u70b9\u540e\u4e24\u4f4d\u6570\u503c\u3002", (String)"QTGenConfigService_1", (String)"wtc-wtp-formplugin", (Object[])new Object[]{QtVarDateEnum.getRetDesc((String)param)}));
            return false;
        }
        List conditionExpressList = accessDto.getConditionExpressList();
        for (ConditionExpressInfo expressType : conditionExpressList) {
            String leftBracket = expressType.getLeftBracket();
            if (HRStringUtils.isNotEmpty((String)leftBracket) && !"(".equals(WTCStringUtils.trim((String)leftBracket))) {
                view.showTipNotification(ExKDStringHelper.expressTypeError());
                return false;
            }
            String rightBracket = expressType.getRightBracket();
            if (!HRStringUtils.isNotEmpty((String)rightBracket) || ")".equals(WTCStringUtils.trim((String)rightBracket))) continue;
            view.showTipNotification(ExKDStringHelper.expressTypeError());
            return false;
        }
        RuleValidateInfo info = RuleValidateUtil.validCondition((String)conditions, (boolean)true);
        if (!info.isSuccess()) {
            view.showTipNotification(String.join((CharSequence)",", info.getMsgList()));
            return false;
        }
        return true;
    }

    public static boolean checkAttitemEqual(DynamicObject dynamicObject, IFormView view, String genType, Long seq) {
        ArrayList<String> pros = new ArrayList<String>();
        pros.add("enjoyattitem");
        pros.add("usableattitem");
        pros.add("resultattitem");
        if ("B".equals(genType)) {
            pros.add("maxattitem");
        }
        boolean tag = false;
        HashMap map = Maps.newHashMapWithExpectedSize((int)pros.size());
        for (String string : pros) {
            String pro = string + "." + "id";
            Long itemId = dynamicObject.getLong(pro);
            List<String> proList = map.get(itemId) != null ? (List)map.get(itemId) : new ArrayList();
            String msg = WTCSymbolMultiLanguageUtil.getOpenQuotaSymbol() + QTAttItemDescEnum.getEnumDesc((String)string) + WTCSymbolMultiLanguageUtil.getCloseQuotaSymbol();
            proList.add(msg);
            map.put(itemId, proList);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            String itemMsg = String.join((CharSequence)WTCSymbolMultiLanguageUtil.getCaesuraSymbol(), (Iterable)entry.getValue());
            String msg = seq == null ? ResManager.loadKDString((String)"{0}\u4e0d\u80fd\u4e3a\u540c\u4e00\u4e2a\u8003\u52e4\u9879\u76ee\u3002", (String)"QTGenConfigService_2", (String)"wtc-wtp-formplugin", (Object[])new Object[]{itemMsg}) : ResManager.loadKDString((String)"\u5206\u5f55\u4e2d#{0},{1}\u4e0d\u80fd\u4e3a\u540c\u4e00\u4e2a\u8003\u52e4\u9879\u76ee\u3002", (String)"QTGenConfigService_3", (String)"wtc-wtp-formplugin", (Object[])new Object[]{seq, itemMsg});
            view.showErrorNotification(msg);
            tag = true;
        }
        return tag;
    }

    public static QFilter getAttItemQFilter(IFormView view) {
        IFormView parentView = view.getParentView();
        QFilter qFilter = parentView != null ? QTAttItemFilterUtils.getQTConfigItemFilter(parentView.getModel().getDataEntity().getDate("bsed")) : QTAttItemFilterUtils.getQTConfigItemFilter(new Date());
        String unit = (String)view.getFormShowParameter().getCustomParam("unit");
        qFilter.and(QTGenConfigService.getAttItemUnitQFilter(unit));
        qFilter.and(new QFilter("issave", "=", (Object)Boolean.TRUE));
        return qFilter;
    }

    public static QFilter getQualificationQFilter(IFormView view) {
        IFormView parentView = view.getParentView();
        Date date = new Date();
        if (parentView != null) {
            date = parentView.getModel().getDataEntity().getDate("bsed");
        }
        QFilter qFilter = new QFilter("firstbsed", "<=", (Object)date);
        return qFilter;
    }

    private static boolean isNumber(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isDouble(String value, int scale) {
        try {
            String doubleStr;
            String[] args = value.split("\\.");
            if (args.length > 1 && (doubleStr = args[1]).length() > scale) {
                return false;
            }
            BigDecimal bValue = new BigDecimal(value);
            return bValue.compareTo(BigDecimal.ZERO) >= 0 && bValue.compareTo(BigDecimal.valueOf(9999L)) <= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static QFilter getAttItemUnitQFilter(String qtTypeUnit) {
        return new QFilter("unit", "=", (Object)QtTypeUnitEnum.getAttItemUnit((String)qtTypeUnit));
    }
}

