/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.quota.overdraw;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtp.business.cumulate.calculate.util.CheckUtils;
import kd.wtc.wtp.formplugin.web.quota.QTAttItemFilterUtils;
import kd.wtc.wtp.formplugin.web.quota.QTAttitemService;

public class QTOverdrawEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final QTAttItemFilterUtils.QTControlInfo[] ctrlArr;
    private static final List<String> pros;

    public void registerListener(EventObject e) {
        BasedataEdit rawOdValue = (BasedataEdit)this.getControl("rawodvalue");
        rawOdValue.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit odValue = (BasedataEdit)this.getControl("odvalue");
        odValue.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit canOdValue = (BasedataEdit)this.getControl("canodvalue");
        canOdValue.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        BigDecimal value = this.getModel().getDataEntity().getBigDecimal("value");
        this.getModel().setValue("svalue", (Object)(CheckUtils.isZero((BigDecimal)value) ? null : value));
        BigDecimal percent = this.getModel().getDataEntity().getBigDecimal("percent");
        this.getModel().setValue("spercent", (Object)(CheckUtils.isZero((BigDecimal)percent) ? null : percent));
    }

    public void afterBindData(EventObject evt) {
        String overdrawType = this.getModel().getDataEntity().getString("overdrawtype");
        if ("A".equals(overdrawType)) {
            this.showValueControl();
        } else if ("B".equals(overdrawType)) {
            this.showPercentControl();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propertyName = evt.getProperty().getName();
        if ("rawodvalue".equals(propertyName) || "odvalue".equals(propertyName) || "canodvalue".equals(propertyName)) {
            Date startDate = this.getModel().getDataEntity().getDate("bsed");
            if (startDate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"QTOverdrawEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qFilter = QTAttItemFilterUtils.getQTConfigItemFilter(startDate);
            evt.setCustomQFilters(Collections.singletonList(qFilter));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        if ("overdrawtype".equals(propertyName)) {
            String overdrawType = this.getModel().getDataEntity().getString("overdrawtype");
            if ("A".equals(overdrawType)) {
                this.hidePercentControl();
                this.showValueControl();
            } else if ("B".equals(overdrawType)) {
                this.hideValueControl();
                this.showPercentControl();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        String operateKey = ((FormOperate)source).getOperateKey();
        if (source instanceof SaveAndNew) {
            SaveAndNew opSource = (SaveAndNew)source;
            operateKey = opSource.getOriOperateKey();
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (operateKey) {
            case "save": 
            case "saveandnew": 
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                Object sValue = dataEntity.get("svalue");
                this.getModel().setValue("value", sValue == null ? Integer.valueOf(0) : sValue);
                Object sPercent = dataEntity.get("spercent");
                this.getModel().setValue("percent", sPercent == null ? Integer.valueOf(0) : sPercent);
                if (QTAttitemService.checkAttitemEmpty(dataEntity, this.getView(), pros)) {
                    args.setCancel(true);
                    return;
                }
                String errMsg = QTAttItemFilterUtils.checkFirstBSED(dataEntity, ctrlArr);
                if (errMsg != null) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(errMsg);
                }
                if (!QTAttitemService.checkAttitemEqual(dataEntity, this.getView(), pros)) break;
                args.setCancel(true);
                return;
            }
        }
    }

    private void showValueControl() {
        ((FieldEdit)this.getControl("svalue")).setMustInput(true);
        this.getView().setVisible(Boolean.TRUE, new String[]{"svalue"});
    }

    private void hideValueControl() {
        ((FieldEdit)this.getControl("svalue")).setMustInput(false);
        this.getModel().setValue("svalue", null);
        this.getView().setVisible(Boolean.FALSE, new String[]{"svalue"});
    }

    private void showPercentControl() {
        ((FieldEdit)this.getControl("spercent")).setMustInput(true);
        this.getView().setVisible(Boolean.TRUE, new String[]{"spercent"});
    }

    private void hidePercentControl() {
        ((FieldEdit)this.getControl("spercent")).setMustInput(false);
        this.getModel().setValue("spercent", null);
        this.getView().setVisible(Boolean.FALSE, new String[]{"spercent"});
    }

    static {
        pros = new ArrayList<String>(){
            {
                this.add("rawodvalue");
                this.add("canodvalue");
                this.add("odvalue");
            }
        };
        ctrlArr = new QTAttItemFilterUtils.QTControlInfo[3];
        String name1 = ResManager.loadKDString((String)"\u5b9a\u989d\u6807\u51c6\u900f\u652f\u65f6\u957f", (String)"QTOverdrawEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        QTOverdrawEdit.ctrlArr[0] = new QTAttItemFilterUtils.QTControlInfo("rawodvalue", name1);
        String name2 = ResManager.loadKDString((String)"\u5b9a\u989d\u900f\u652f\u65f6\u957f", (String)"QTOverdrawEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        QTOverdrawEdit.ctrlArr[1] = new QTAttItemFilterUtils.QTControlInfo("odvalue", name2);
        String name3 = ResManager.loadKDString((String)"\u5b9a\u989d\u53ef\u900f\u652f\u65f6\u957f", (String)"QTOverdrawEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        QTOverdrawEdit.ctrlArr[2] = new QTAttItemFilterUtils.QTControlInfo("canodvalue", name3);
    }
}

